<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
if (empty($_POST)) $_POST = $_GET;
if (isset($_POST["start"])) $start = $_POST["start"];
if (isset($_POST["end"])) $end = $_POST["end"];
$st = formatDateWebtoDB($start);
$et = formatDateWebtoDB($end);
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=\"PW-Results-" . str_replace(" ", "", "$st-$et") . ".xls\"");

$sql = "select pwr.end_time, concat(emp.first_name, ' ', emp.last_name) as full_name, pwr.notes, j.item_id, ol.item_id as parent_part, j.quantity_scheduled, pwr.duration_hours, pwr.duration_minutes, sum(pwr.quantity_good) as quantity_good, pwr.complete, pwr.batch_id, pwr.job_id, ol.order_id from order_lines ol, piece_work_results pwr, employees emp, jobs j where pwr.employee_id=emp.card_number and j.job_id=pwr.job_id and ol.line_id=j.line_id and pwr.start_time between ? and ? group by concat(pwr.start_time,pwr.end_time,pwr.job_id) order by pwr.start_time";
list($rs,$err) = runIQuery($db, $sql, ["ss", $st, $et]);

print "Employee Name\tTime\tHours\tMinutes\tComplete\tNotes\tBatch\tJob\tOrder\tItem\tParent Item\tQuantity Good\tTotal Scheduled";

foreach ($rs as $result) {
    print "\n";
    print $result["full_name"] . "\t";
    print date("m/d/Y h:i A", strtotime($result["end_time"])) . "\t";
    print $result["duration_hours"] . "\t";
    print $result["duration_minutes"] . "\t";
    print ($result["complete"] ? "Yes" : "No") . "\t";
    print $result["notes"] . "\t";
    print $result["batch_id"] . "\t";
    print $result["job_id"] . "\t";
    print $result["order_id"] . "\t";
    print $result["item_id"] . "\t";
    print $result["parent_part"] . "\t";
    print $result["quantity_good"] . "\t";
    print $result["quantity_scheduled"] . "\t";
}
?>