<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');

if (empty($_POST)) $_POST = $_GET;
$employee = $_POST["employee"];
$color = $_POST["color"];

$complete = 0;
$needed = 0;
$scheduled = 0;
$good = 0;
$noGo = 0;
print renderPanel("Piece Work Brackets");

$colorCodesStr = "RAPISTAN GREEN #064A25
SAFETY YELLOW #F9D210
BASALT GREY #555B60
LIGHT GREY #C6C8C5
GRAPHITE BLACK #27292b
EXPORT SHIP LIGHT GREY #c5c7c4
SEMI GLOSS BLACK #080808
CAPRI BLUE #005e83
DELL BLUE #007cb0
ACADEMY BLUE #005b8c
GRAINGER GREY #B3B3B3
HK TAN #eae7e1
EXPORT SHIP SAFETY YELLOW #f7b500
RAPISTAN STANDARD FINISH #064A25
ULTRAMARINE BLUE #182D7E
LASER BLUE #4E83B8
LOWES BLUE #004792
SIGNAL WHITE #ECEBE0
GENTIAN BLUE #004f7c
REPOSE GREY #e6e6e6";

$colorCodes = [
    "00" => "#064A25",
    "04" => "#F9D210",
    "93" => "#555B60",
    "98" => "#C6C8C5",
    "A1" => "#27292b",
    "E9" => "#c5c7c4",
    "02" => "#080808",
    "08" => "#005e83",
    "15" => "#007cb0",
    "20" => "#005b8c",
    "N1" => "#B3B3B3",
    "T3" => "#eae7e1",
    "EY" => "#F9D210",
    "NL" => "#064A25",
    "1C" => "#182D7E",
    "69" => "#4E83B8",
    "28" => "#004792",
    "1K" => "#ECEBE0",
    "12" => "#004f7c",
    "HB" => "#e6e6e6"
];

if ($employee) {
    $sql = "select first_name, last_name from employees where card_number=?";
    list($rs,$err) = runIQuery($db, $sql, ["i", $employee]);

    if (count($rs)) {
        $name = $rs[0]["first_name"] . " " . $rs[0]["last_name"];
        print "<center><h3>$name</h3></center>";
    }


    if ($color) {
        $measure=$_POST["measure"];
        print "<input type='hidden' name='color' value='$color'>";
        $sql = "select color_name from dematic_colors where color_code=?";
        list($rs)=runIQuery($db,$sql,["s",$color]);
        $color_name = $rs[0]["color_name"];
        $sql = "
        select
            (bom.quantity_per * ol.quantity) as qty,
            coalesce(pwr.quantity_good,0) as good,
            j.quantity_scheduled,
            j.item_id,
            j.job_id,
            j.description,
            ol.item_id as parent_item,
            ol.order_id,
            pwp.measure
                from order_lines ol,
                piece_work_parents pwp,
                piece_work_parts pwprt,
                billofmaterial bom,
                jobs j
            left join piece_work_results pwr
                on pwr.job_id=j.job_id
            where
                pwprt.part_number=j.item_id
                and pwprt.part_type='BRACKET'
                and ol.line_id=j.line_id
                and j.status=1
                and j.start_date < DATE_ADD(NOW(), INTERVAL 60 DAY)
                and bom.parent_item=ol.item_id
                and bom.child_item=j.item_id
                and bom.parent_item=pwp.item_id
                and ol.item_id in (
                    select item_id from piece_work_parents where item_id like ? and measure=?
                )
        group by j.job_id order by ol.order_id
        ";

        list($rs)=runIQuery($db,$sql,["ss","%$color",$measure]);

        if (count($rs)) {
            $total_sched = 0;
            $total_good = 0;
            $hasMetric=0;
            $hasStandard=0;
            foreach ($rs as $job) {
                $total_sched += $job["quantity_scheduled"];
                $total_good += $job["good"];
                if ($job["measure"] == "metric") {
                    $hasMetric=1;
                } else {
                    $hasStandard=1;
                }
            }

            $complete = 0;
            $total_needed = $total_sched - $total_good;

            if ($total_needed < 1) {
                $complete = 1;
            }

            if ($complete) { //? may be redundant but avoids any potential issues
                print "<h2>Selected color and measurement does not need any brackets</h2>";
                print renderButton("Return", "red", "window.location = 'pieceWorkBrackets.php'");
            } else {
                $hex = $colorCodes[$color];
                $reg = "/#([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})/";
                preg_match_all($reg, $hex, $matches);
                $inverted = "#";
                foreach ($matches as $code) {
                    if (strlen($code[0]) == 7) {
                        continue;
                    }
                    $num = base_convert($code[0], 16, 10);
                    $inverted .= str_pad(base_convert(255 - $num, 10, 16), 2, '0', STR_PAD_LEFT);
                }

                print "<h3>You can make up to <b>$total_needed</b> brackets for this color <div class='btn' style='background-color: " . $colorCodes[$color] . "; color: $inverted;'>$color_name</div><br></h3>";

                print "<h4>If you are taking a break, just fill out the quantity you have finished along with any notes and press Submit. You will be able to get back to this later</h4>";

                $message = "<br><h4><b>These brackets require ";
                if ($hasMetric && $hasStandard) {
                    $message .= "both <a style='color:blue;'>METRIC</a> and <a style='color:red;'>STANDARD</a>";
                } else if ($hasMetric) {
                    $message .= "<a style='color:blue;'>METRIC</a>";
                } else {
                    $message .= "<a style='color:red;'>STANDARD</a>";
                }

                $message .= " nuts and bolts";

                if ($hasMetric && $hasStandard) {
                    $message .= ", be sure to check the individual work orders!";
                }
                $message .= "</b></h4><br>";
                print $message;

                print "<form name='subform' id='subform' method='POST' action='pieceWorkSubmit.php'>";
                print "<input type='hidden' name='color' value='$color' id='color'>";
                print "<input type='hidden' name='employee' value='$employee' id='employee'>";
                print "<input type='hidden' name='start' value='" . date("Y-m-d H:i:s") . "' id='start'>";
                print renderTextArea(TRUE,"notes","","Notes", "100%");

                print "<br>Time Taken: <h3 id='timetaken'>0 Hours 0 Minutes</h3><br>";
                print renderStartItem(true,"","‎");
                print " " . renderButton("Submit", "blue");
                print " " . renderButton("Return", "red", "window.location = 'pieceWorkBrackets.php';");
                print " " . renderButton("Add Employee", "green", "window.open('pieceWorkBrackets.php', '_blank');");
                print renderEndItem();

                print "<table class='table table-bordered table-striped'>
                    <thead>
                        <tr>
                            <th>Work Order</th>
                            <th>Part</th>
                            <th>Fastener Type</th>
                            <th>Quantity Needed</th>
                            <th>Quantity Good</th>
                            <th>Parent Part</th>
                            <th>Description</th>
                        </tr>
                    </thead>
                <tbody>";

                foreach ($rs as $job) {
                    $type = strtoupper($job["measure"]);
                    $color = "error";
                    $jneeded = $job["qty"] - $job["good"];
                    if ($type == "METRIC") {
                        $color = "info";
                    }

                    print "<input type='hidden' name='needed-" . $job["job_id"] . "' value='$jneeded'>";

                    print "<tr class='$color'>
                        <td>" . $job["order_id"] . "</td>
                        <td>" . $job["item_id"] . "</td>
                        <td>" . $type . "</td>
                        <td>" . $jneeded . "</td>
                        <td><input type='number' class='form-control' min='0' max='$jneeded' name='good-" . $job["job_id"] . "' value='0' style='background-color: white;' " . ($jneeded == 0 ? "readonly" : "") . "></td>
                        <td>" . $job["parent_item"] . "</td>
                        <td>" . $job["description"] . "</td>
                    </tr>";
                }
            }
        } else {
            print "<h2>Selected color and measurement does not need any brackets</h2>";
            print renderButton("Return", "red", "window.location = 'pieceWorkBrackets.php'");
        }
    } else {
        print "<form name='colorform' id='colorform' method='POST' action='pieceWorkBrackets.php'>";
        print "<input type='hidden' name='employee' value='$employee'>";
            print "<h3>Please select which color and measurement you plan to work on</h3>";
            $sql = "select color_code, color_name from dematic_colors";
            list($rs)=runIQuery($db,$sql);

            print renderStartItem(true,"","Color");
            print "<select class='form-control' name='color'>";
                foreach ($rs as $data) {
                    $color_name = $data["color_name"];
                    $color_code = $data["color_code"];
                    $hex = $colorCodes[$color_code];
                    $reg = "/#([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})/";
                    preg_match_all($reg, $hex, $matches);
                    $inverted = "#";
                    foreach ($matches as $code) {
                        if (strlen($code[0]) == 7) {
                            continue;
                        }
                        $num = base_convert($code[0], 16, 10);
                        $inverted .= str_pad(base_convert(255 - $num, 10, 16), 2, '0', STR_PAD_LEFT);
                    }
                    print "<option style='background-color: $hex; color: $inverted;' value='$color_code'>$color_name</option>";
                }
            print "</select>";
            print renderEndItem();

            print renderStartItem(true,"","Measurement");
                print "<select class='form-control' name='measure'>
                    <option value='metric'>Metric</option>
                    <option value='standard'>Standard</option>
                </select>";
            print renderEndItem();

            print renderStartItem(true,"","‎");
            print renderButton("Select","green");
            print renderEndItem();

        print "</form>";
    }
} else {
    print "<h2>Please scan or enter your employee ID and press start</h2><br><br>";

    print "<form name='editForm' id='editForm' method='POST' action='pieceWorkBrackets.php'>";
    print "<input type='hidden' name='job' value='$job'>";
    print renderTextBox(TRUE,"employee","","Employee", "");
    print renderStartItem(true,"","‎");
    print " " . renderButton("Start", "blue");
    print " " . renderButton("Return", "red", "window.location = 'pieceWorkSelect.php';");
    print " " . renderButton("Add Employee", "green", "window.open('pieceWorkBrackets.php?job=$job', '_blank');");
    print renderEndItem();
    print "</form>";
}

print renderClosePanel();
include('footer.php');
?>
<script>
function updateQuery(key, val) {
    var searchParams = new URLSearchParams(window.location.search);
    searchParams.set(key, val);
    window.location.search = searchParams.toString();
}

<?php
    if ($job && $employee) {
        print "var start = new Date($('#start').val()).getTime();

        setInterval(function() {
            var now = Date.now();
            var diff = (now - start)/1000;

            var minutes = diff/60;
            var hours = Math.floor(minutes/60);
            minutes = Math.abs(Math.floor((hours*60) - minutes))-1;

            $('#timetaken').text(hours + ' Hour' + (hours > 1 || hours == 0 ? 's' : '') + ' ' + minutes + ' Minute' + (minutes > 1 || minutes == 0 ? 's' : ''));
        }, 5000);";
    }

    if ($employee && !isset($name)) { //completely prevent any invalid employee numbers from submitting results
        print "alert('Invalid Employee Number');
        window.location.href = 'pieceWorkBrackets.php?job=$job';";
    }
?>