<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');

if (empty($_POST)) $_POST = $_GET;
$employee = $_POST["employee"];
$qtygood = $_POST["good"];
$batch = $_POST["batch"];

$complete = 0;
$needed = 0;
$scheduled = 0;
$good = 0;
$noGo = 0;
$exists = 1;

if ($employee) {
    $sql = "select first_name, last_name from employees where card_number=?";
    list($rs,$err) = runIQuery($db, $sql, ["i", $employee]);

    if (count($rs)) {
        $name = $rs[0]["first_name"] . " " . $rs[0]["last_name"];
    }
}

if ($batch) {

    $sql = "
    select sum(j.quantity_scheduled) as quantity_scheduled from jobs_batch_orders jbo
        inner join jobs j
            on jbo.job_id=j.job_id
        inner join piece_work_parts pwp
            on j.item_id=pwp.part_number
        inner join order_lines ol
            on j.line_id=ol.line_id
        where jbo.batch_id=?
        and j.status=1
        and pwp.part_type='BOOT'
        and ol.item_id in (select item_id from piece_work_parents)
    ";
    list($rs,$err) = runIQuery($db, $sql, ["i", $batch]);

    if (!count($rs)) {
        $noGo = 1;
        $exists = 0;
    }

    $scheduled = $rs[0]["quantity_scheduled"];

    $sql = "select coalesce(sum(pwr.quantity_good),0) as good from piece_work_results pwr where pwr.batch_id=?";
    list($rs,$err) = runIQuery($db, $sql, ["i", $batch]);
    $good = $rs[0]["good"];

    $needed = $scheduled - $good;

    if ($needed < 1) {
        $complete = 1;
    }
}

if ($batch) { //show batch and have them scan their employee ID
    print renderPanel("Piece Work Boots: Batch #$batch");
    if ($noGo) {
        print "<h2><center>Selected Batch does not need any boots</center></h2>";
        print "<center>" . renderButton("Return", "red", "window.location = 'pieceWorkBoots.php';") . "</center>";
    } else {
        if ($complete) { //? may be redundant but avoids any potential issues
            print "<h2>Selected Batch does not need any boots</h2>";
            print renderButton("Return", "red", "window.location = 'pieceWorkBoots.php'");
        } else {
            if ($name) {
                print "<center><h3>$name</h3></center>";
            }
            print "<h3>You can make up to <b>$needed</b> boots for this batch<br></h3>";
            if ($employee) { //show batch and the employee name
                print "<h4>If you are taking a break, just fill out the quantity you have finished along with any notes and press Submit. You will be able to get back to this batch later</h4>";

                $fastenerType = "STANDARD";

                $sql = "
                select j.item_id, pwp.measure from jobs j, piece_work_parents pwp, order_lines ol
                    where ol.line_id in
                        (select line_id from jobs_batch_orders jbo, jobs j
                            where jbo.batch_id=? and jbo.job_id=j.job_id and j.status=1)
                    and pwp.item_id=ol.item_id
                ";
                list($rs,$err) = runIQuery($db, $sql, ["i", $batch]);
                $metric = 0;
                $standard = 0;

                foreach ($rs as $item) {
                    if ($item["measure"] == "metric") $metric++;
                    else $standard++;
                }

                $message = "<br><h4><b>This batch requires ";
                if ($metric && $standard) {
                    $message .= "both <a style='color:blue;'>METRIC</a> and <a style='color:red;'>STANDARD</a>";
                } else if ($metric) {
                    $message .= "<a style='color:blue;'>METRIC</a>";
                } else {
                    $message .= "<a style='color:red;'>STANDARD</a>";
                }

                $message .= " nuts and bolts";

                if ($metric && $standard) {
                    $message .= ", be sure to check the individual work orders!";
                }

                $message .= "</b></h4><br>";

                print $message;

                print "<form name='editForm' id='editForm' method='POST' action='pieceWorkSubmit.php'>";
                print "<input type='hidden' name='batch' value='$batch' id='batch'>";
                print "<input type='hidden' name='employee' value='$employee' id='employee'>";
                print "<input type='hidden' name='start' value='" . date("Y-m-d H:i:s") . "' id='start'>";
                print renderTextArea(TRUE,"notes","","Notes", "100%");

                $sql = "select (bom.quantity_per * ol.quantity) as qty, coalesce(sum(pwr.quantity_good),0) as good, j.item_id, j.quantity_scheduled, ol.item_id as olitem, j.description, ol.order_id, j.job_id, pwp.measure from jobs_batch_orders jbo, order_lines ol, billofmaterial bom, piece_work_parents pwp, jobs j left join piece_work_results pwr on pwr.job_id=j.job_id where ol.line_id=j.line_id and jbo.batch_id=? and jbo.job_id=j.job_id and j.status=1 and bom.parent_item=ol.item_id and bom.parent_item=pwp.item_id and bom.child_item=j.item_id group by j.job_id order by ol.item_id";
                list($rs,$err) = runIQuery($db, $sql, ["i", $batch]);

                print "<br>Time Taken: <h3 id='timetaken'>0 Hours 0 Minutes</h3><br>";
                print renderStartItem(true,"","‎");
                print " " . renderButton("Submit", "blue");
                print " " . renderButton("Return", "red", "window.location = 'pieceWorkBoots.php';");
                print " " . renderButton("Add Employee", "green", "window.open('pieceWorkBoots.php?batch=$batch', '_blank');");
                print renderEndItem();

                print "<table class='table table-striped'>
                    <thead>
                        <tr>
                            <th>Work Order</th>
                            <th>Part</th>
                            <th>Fastener Type</th>
                            <th>Quantity Needed</th>
                            <th>Quantity Good</th>
                            <th>Parent Part</th>
                            <th>Description</th>
                        </tr>
                    </thead>
                <tbody>
            ";
            foreach ($rs as $item) {
                $type = strtoupper($item["measure"]);
                $color = "error";
                $jneeded = $item["qty"] - $item["good"];
                if ($type == "METRIC") {
                    $color = "info";
                }

                print "<input type='hidden' name='needed-" . $item["job_id"] . "' value='$jneeded'>";

                print "<tr class='$color'>
                    <td>" . $item["order_id"] . "</td>
                    <td>" . $item["item_id"] . "</td>
                    <td>" . $type . "</td>
                    <td>" . $jneeded . "</td>
                    <td><input type='number' class='form-control' min='0' max='$jneeded' name='good-" . $item["job_id"] . "' value='0' style='background-color: white;' " . ($jneeded == 0 ? "readonly" : "") . "></td>
                    <td>" . $item["olitem"] . "</td>
                    <td>" . $item["description"] . "</td>
                </tr>";
            }

                print "</tbody></table></form>";
            } else {
                print "<h2>Please scan or enter your employee ID and press start</h2><br><br>";

                print "<form name='editForm' id='editForm' method='POST' action='pieceWorkBoots.php'>";
                print "<input type='hidden' name='batch' value='$batch' id='batch'>";
                print renderTextBox(TRUE,"employee","","Employee", "");
                print " " . renderButton("Start", "blue");
                print " " . renderButton("Return", "red", "window.location = 'pieceWorkBoots.php';");
                print " " . renderButton("Add Employee", "green", "window.open('pieceWorkBoots.php?batch=$batch', '_blank');");
                print "</form>";
            }
        }
    }
} else { //show batch selection
    $noGo = 0;
    print renderPanel("Batch Selection");
    $sql = "select job_id from piece_work_results where complete=1 and job_id in (";
    $jobs = [];

    $bosql = "
    select j.job_id, jbo.batch_id from jobs_batch_orders jbo
        inner join jobs j
            on jbo.job_id=j.job_id
        inner join piece_work_parts pwp
            on j.item_id=pwp.part_number
        inner join order_lines ol
            on j.line_id=ol.line_id
        where j.status=1
        and pwp.part_type='BOOT'
        and ol.item_id in (select item_id from piece_work_parents)
    ";

    list($bors,$err) = runIQuery($db, $bosql);

    if (count($bors) > 0) {
        $batch_counts = [];
        foreach($bors as $boot) {
            $jobs[] = $boot["job_id"];
            if (!isset($batch_counts[$boot["batch_id"]])) $batch_counts[$boot["batch_id"]] = 0;
            $batch_counts[$boot["batch_id"]]++;
        }

        $sql .= implode(", ", $jobs);
        $sql .= ")";

        list($crs,$err) = runIQuery($db, $sql);

        $complete = [];

        foreach($crs as $completed) {
            $complete[] = $completed["job_id"];
        }

        $batches = [];
        foreach ($bors as $boot) {
            if (in_array($boot["job_id"], $complete)) continue;

            $sql = "select batch_id from jobs_batch_orders where batch_id=?";
            list($rs,$err) = runIQuery($db, $sql, ["i", $boot["batch_id"]]);
            if (count($rs) != $batch_counts[$boot["batch_id"]]) continue;

            if (!in_array($boot["batch_id"], $batches)) $batches[] = $boot["batch_id"];
        }

        if (count($batches) == 0) {
            $noGo = 1;
        }
    } else {
        $noGo = 1;
    }

    if ($noGo) {
        print "<h3>No Boots need to be made</h3>";
        print renderButton("Return", "red", "window.location = 'pieceWorkSelect.php';");
    } else {
        print "<h3>Please scan Batch barcode and press start</h3><form action='pieceWorkBoots.php' method='GET'>";
        print renderTextBox(1,"batch","","Batch #") .  "<div class='span3'>
        <div class='control-group span11'>
            <label class='control-label' for=''>‎</label>
            <div class='controls'>
                " . renderButton('Start', 'green', "updateQuery('batch', $('#batch').val())") . " " . renderButton("Return", "red", "window.location = 'pieceWorkSelect.php';") . "
            </div>
        </div>
    </div></form><br><br><br><br>";
        $blue = true;
        foreach ($batches as $batch) {
            //print renderButton("Batch #$batch", $blue ? "blue" : "grey", "updateQuery('batch', '$batch')");
            $blue = !$blue;
        }
    }
}

print renderClosePanel();
include('footer.php');
?>
<script>
function updateQuery(key, val) {
    var searchParams = new URLSearchParams(window.location.search);
    searchParams.set(key, val);
    window.location.search = searchParams.toString();
}

<?php
    if ($batch && $employee) {
        print "var start = new Date($('#start').val()).getTime();

        setInterval(function() {
            var now = Date.now();
            var diff = (now - start)/1000;

            var minutes = diff/60;
            var hours = Math.floor(minutes/60);
            minutes = Math.abs(Math.floor((hours*60) - minutes))-1;

            $('#timetaken').text(hours + ' Hour' + (hours > 1 || hours == 0 ? 's' : '') + ' ' + minutes + ' Minute' + (minutes > 1 || minutes == 0 ? 's' : ''));
        }, 5000);";
    }

    if ($employee && !isset($name)) { //completely prevent any invalid employee numbers from submitting results
        print "alert('Invalid Employee Number');
        window.location.href = 'pieceWorkBoots.php?batch=$batch';";
    }
?>

$("#batch").focus();

$('#employee, input[type=number], textarea').keypress(function(event) { return event.keyCode != 13; });
$('#employee').on("change",function() {
    if ($('#employee').val() != '') {
        url='validateEmployee.php?code=8383&id='+$("#employee").val()+'&rand='+Math.random();
        $.ajax({url: url, success:
            function(data) {
                if (data != 'OK-Employee Found') {
                    alert('Invalid Employee Number');
                    $('#employee').focus();
                }
        }});
    }
});
$('#employee').focus();

if (window.history.replaceState) { //prevent refresh from resubmitting POST requets with formdata
    window.history.replaceState(null, null, window.location.href);
}
</script>