<?php 
include('dbConnection.php');
include('security.php');
include('functions.php');
$pageTitle="Pending Points";
include('header.php');
print renderPanel("Pending Points");

print "<p>If an employee's points at time of activity are under 4, the line will be red to indicate that they must manually sign these.</p>";

## gathering data to fill out table, filtering by who needs to sign
$sql = "SELECT activity_date, last_name, first_name, full_name, employee_signed_date, manager_signed_date, point_id, point_log.employee_id, points_remaining FROM point_log 
INNER JOIN employees ON employees.employee_id=point_log.employee_id
INNER JOIN site_admins ON site_admins.user_id=point_log.manager_id
WHERE (employee_signed_date IS NULL OR manager_signed_date IS NULL) AND coalesce(refused_to_sign,0) = 0 AND coalesce(manually_signed,0) = 0 ORDER BY activity_date DESC";
list($rs,$err)=runIQuery($db,$sql);

## table head
print "<table class='table table-striped'><thead><tr><th>Activity Date</th><th>Employee</th><th>Employee Signed</th><th>Manager</th><th>Manager Signed</th><th>Send Email Again</th><th>Update</th></tr></thead><tbody>";
foreach ($rs as $data) {
    $eSignature=1;
    $mSignature=1;
    $dt=date("m/d/Y", strtotime($data['activity_date']));
    $employeeName=$data['first_name'] . " " . $data['last_name'];
    $manager=$data['full_name'];
    $pointID=$data['point_id'];
    $employeeID=$data['employee_id'];
    $points=$data['points_remaining'];

    //adding code to change color if points are below 4 so it can be seen at a glance which ones must be manually signed
    $color='black';
    if ($points < 4) {
        $color='red';
    }
    
    if ($data['employee_signed_date'] == NULL) {
        $edt="Not Signed";
    } else {
        $edt=date("m/d/Y", strtotime($data['employee_signed_date']));
        $eSignature=0;
    }
    if ($data['manager_signed_date'] == NULL) {
        $mdt="Not Signed";
    } else {
        $mdt=date("m/d/Y", strtotime($data['manager_signed_date']));
        $mSignature=0;
    }
    $rbutton=renderButton("Refused to Sign","blue","refusedSign($pointID);");
    $mbutton=renderButton("Manually Signed","blue","manualSign($pointID);");
    $sbutton=renderButton("Send Email","blue","resendEmail($pointID,$eSignature,$mSignature);");

    print "<tr style='color: $color' id='tr$pointID'><td>$dt</td>\n<td><a href='employeePoints.php?employee=$employeeID' target='_blank'>$employeeName</a></td>\n<td>$edt</td>\n<td>$manager</td>\n<td>$mdt</td>\n<td>$sbutton</td>\n<td>$rbutton $mbutton</td></tr>";
}
print "</tbody></table>";   
print renderClosePanel();
include('footer.php');
?>

<script>

    function refusedSign(id) {
        $.ajax({
                url:`updateSigned.php?id=${id}&update=refused`,    
                type: "post",    
                success:function(result){
                    //console.log(result);
                    $("#tr" + id).hide();
                }
            });
    }
    function manualSign(id) {
        $.ajax({
                url:`updateSigned.php?id=${id}&update=manual`,    
                type: "post",    
                success:function(result){
                    //console.log(result);
                    $("#tr" + id).hide();
                }
            });
    }

    function resendEmail(id,eSignature,mSignature) {
        $.ajax({
                url:`sendReminderPointsEmail.php?id=${id}&emp=${eSignature}&man=${mSignature}`,    
                type: "post",    
                success:function(result){
                    $.gritter.add('Email sent');
                }
            });
    }

</script>