<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
$pageTitle="Preferred Delivery Shipping";
include('header.php');

$shiptotal = 0;
$pdshiptotal = 0;

$start_date=Date("m/d/Y");
if (isset($_GET['start_date'])) {
	$start_date=$_GET['start_date'];
}

$end_date=$start_date;
if (isset($_GET['end_date'])) {
	$end_date=$_GET['end_date'];
}

$cust=null;
if (isset($_GET['cust'])) {
	$cust=$_GET['cust'];
}

$vendor=null;
if (isset($_GET['vendor'])) {
	$vendor=$_GET['vendor'];
}
$sql="update customers set standard_shipping=5 where standard_shipping > 0 and standard_shipping < 5 ";
list($rs,$err)=runIQuery($db,$sql);

$sql="update customer_shiptos set shipping_cost=5 where shipping_cost > 0 and shipping_cost < 5 ";
list($rs,$err)=runIQuery($db,$sql);

$sql="update vendors set shipping_cost=5 where shipping_cost > 0 and shipping_cost < 5 ";
list($rs,$err)=runIQuery($db,$sql);

print "<div>";
print "<form name='searchform' method='GET' action='pdShipments.php'>\n";
print renderDateBox(TRUE, "start_date", $start_date, "Start Date");
print renderDateBox(TRUE, "end_date", $end_date, "End Date");
print "<select class='form-control chosen-select' name='cust' id='cust'><option value=''>All Customers</option>";
    // add inactive customers code -Josh 02/20/2023
    $sql = "select customer_id, name from customers where inactive_customer=0 OR (customer_id=? and inactive_customer=1) order by name";
    list($rs,$err)=runIQuery($db,$sql,["i",$cust]);
    print renderOptions($rs,$cust);
print "</select>";
## Adding vendor select bdoss 8/18/22
print "<select class='form-control chosen-select' name='vendor' id='vendor'><option value=''>All Vendors</option>";
$sql="select vendor_id, vendor_name from vendors order by vendor_name";
$rs=mysqli_query($db,$sql);
print renderOptions($rs,$vendor);
print "</select>";
print "<input type='submit' class='btn btn-primary green' style='margin: 20px' value='Find' style='float: right;'>";
print "</form>\n";
print "</div>";
if (!$vendor) {
print "<table class='table table-bordered table-striped'>";
print "<thead>";
print "<tr>";
print "<th valign='top'>Packing Slip</th>";
print "<th valign='top'>Customer</th>";
print "<th valign='top'>Ship Name</th>";
print "<th valign='top'>Ship Address</th>";
print "<th valign='top'>Date Shipped</th>";
print "<th valign='top'>PO Number</th>";
print "<th valign='top'>Order</th>";
print "<th valign='top'>Shipping Cost</th>";
print "<th valign='top'>PD Shipping Cost</th>";
print "<th valign='top'>BOL</th>";
print "</tr>\n";
print "</thead><tbody>";

$sql="SELECT DISTINCT packing_slip.packing_slip_id, packing_slip.date_shipped, packing_slip_lines.po_number, packing_slip_lines.order_id,
customers.name, COALESCE(customer_shiptos.shipping_cost, customers.standard_shipping) AS shipping, bol_skids.bol_id, packing_slip.ship_name, packing_slip.ship_address
FROM packing_slip INNER JOIN packing_slip_lines ON packing_slip.packing_slip_id=packing_slip_lines.packing_list_id
INNER JOIN customers ON packing_slip.customer_id = customers.customer_id
LEFT OUTER JOIN customer_shiptos ON packing_slip.ship_name = customer_shiptos.ship_name AND packing_slip.ship_address = customer_shiptos.ship_address AND packing_slip.customer_id = customers.customer_id
LEFT OUTER JOIN bol_skids ON packing_slip.packing_slip_id = bol_skids.packing_slip
WHERE date_shipped >= ? AND date_shipped <= ?";
if ($cust != null) {
    $sql.=" AND customers.customer_id = ? ORDER BY date_shipped DESC, name, packing_slip_id";
    list($rs,$err) = runIQuery($db,$sql,array("ssi", formatDateWebtoDB($start_date), formatDateWebtoDB($end_date), $cust));
} else {
    $sql.=" ORDER BY date_shipped DESC, name, packing_slip_id";
    list($rs,$err) = runIQuery($db,$sql,array("ss", formatDateWebtoDB($start_date), formatDateWebtoDB($end_date)));
}

foreach ($rs as $data) {
    $pslip=$data['packing_slip_id'];
    $customer=$data['name'];
    $date=formatDateDBToWeb($data['date_shipped']);
    $po=$data['po_number'];
    $order=$data['order_id'];
    $shipping=$data['shipping'];
    $pdshipping=number_format(($shipping * .75), 2);
    $bol=$data['bol_id'];
    $shipname=$data['ship_name'];
    $shipaddress=$data['ship_address'];
    $shiptotal += $shipping;
    $pdshiptotal += $pdshipping;

    print "<tr><td><a href='editSlips.php?ordernumber=$order' target='_blank'>$pslip</a></td><td>$customer</td><td>$shipname</td><td>$shipaddress</td><td>$date</td><td>$po</td><td>$order</td><td>$shipping</td><td>$pdshipping</td><td>$bol</td></tr>";
}

$shiptotal = number_format($shiptotal, 2);
$pdshiptotal = number_format($pdshiptotal, 2);

print "<tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td><b>Total Shipping: $shiptotal</b></td><td><b>Total PD Shipping: $pdshiptotal</b></td><td></td></tr>";
print "</tbody></table>\n";
}

## Brittany 8/12/22 adding in transfers
$totalPDShip=0;

if (!$cust) {
print "<h3>Transfers</h3>";
print "<table class='table table-bordered table-striped'>";
print "<thead>";
print "<tr>";
print "<th valign='top'>Packing Slip</th>";
print "<th valign='top'>Vendor</th>";
//print "<th valign='top'>Ship Name</th>";
print "<th valign='top'>Ship Address</th>";
print "<th valign='top'>Date Shipped</th>";
print "<th valign='top'>PO Number</th>";
print "<th valign='top'>Order</th>";
//print "<th valign='top'>Shipping Cost</th>";
print "<th valign='top'>PD Shipping Cost</th>";
print "<th valign='top'>BOL</th>";
print "</tr>\n";
print "</thead><tbody>";

$sql="SELECT DISTINCT packing_slip_lines.packing_list_id, transfers.transfer_date, packing_slip_lines.po_number, packing_slip_lines.order_id,
transfers.ship_name, bol_skids.bol_id, transfers.ship_address, vendors.shipping_cost
FROM packing_slip_lines INNER JOIN transfers ON transfers.packing_slip=packing_slip_lines.packing_list_id
LEFT OUTER JOIN vendors ON vendors.vendor_id=transfers.vendor_id
LEFT OUTER JOIN bol_skids ON packing_slip_lines.packing_list_id = bol_skids.packing_slip
WHERE transfer_date >= ? AND transfer_date <= ?";
if ($vendor) {
    $sql.=" AND vendors.vendor_id=?";
    list($rs,$err)=runIQuery($db,$sql,array('ssi', formatDateWebtoDB($start_date), formatDateWebtoDB($end_date), $vendor));
} else {
    list($rs,$err)=runIQuery($db,$sql,array('ss', formatDateWebtoDB($start_date), formatDateWebtoDB($end_date)));
}
foreach($rs as $data) {
    $pack=$data['packing_list_id'];
    $date=formatDateDBtoWeb($data['transfer_date']);
    $po=$data['po_number'];
    $order=$data['order_id'];
    $vendor=$data['ship_name'];
    $bol=$data['bol_id'];
    $shipAddress=$data['ship_address'];
    $shippingCost=$data['shipping_cost'];
    $totalPDShip+=$shippingCost;

    print "<tr>";
    print "<td><a href='editSlips.php?ordernumber=$order' target='_blank'>$pack</a></td>";
    print "<td>$vendor</td>";
    print "<td>$shipAddress</td>";
    print "<td>$date</td>";
    print "<td>$po</td>";
    print "<td>$order</td>";
    //print "<td>Shipping Cost</td>";
    print "<td>$shippingCost</td>";
    print "<td>$bol</td>";
    print "</tr>";
}
$totalPDShip=number_format($totalPDShip,2);
print "<tr><td></td><td></td><td></td><td></td><td></td><td></td><td><b>Total PD Shipping: $totalPDShip</b></td><td></td></tr>";
print "</tbody></table>";
}
?>

<script>
function page_init() {
	$('.datepicker').datepicker();
}
</script>
<?php
print renderClosePanel();
include('footer.php');
?>