<?php
$expanded=1;
$locked=0;
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');
$part="";
$order="";
if (isset($_GET['part'])) {
	$part=$_GET['part'];
}
if (isset($_GET['order'])) {
	$order=$_GET['order'];
}
print renderPanel("Part History","Part History","primary","span11");
print "<p>Enter Part Number to see history for this part.  If there are multiple orders, you will need to select the order.</p>";
print "<form action='partHistory.php' name='findform' method='GET'>";
print renderTextBox(TRUE,"part",$part,"Part");
if ($part) {
	if (! $order) {
		$sql="select distinct l.order_id, folder_number from order_lines l, orders o where l.order_id=o.order_id and item_id=? and o.status not in (3,4,5,10,13) ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$part));
		if (count($rs)>1) {
			print renderSelect(TRUE,"order","","Order","N",$rs);			
		} else {
			if (count($rs)==1) {
				$data=$rs[0];
				$order=$data[0];
			}
		}
	} else {
		print renderStartItem(TRUE,"Order","Order#");
		print $order;
		print renderEndItem();
	}
}
print renderButton("Find","success",'document.findform.submit();');
print "</form>\n";
print "<div style='clear: both;'></div>";
if ($part and $order) {
	$sql="select folder_number, item_description, l.quantity, shipped_quantity, nesting_name, nesting_date, due_date, nested_quantity from order_lines l inner join nesting n on l.line_id=n.line_id inner join orders o on l.order_id=o.order_id where o.order_id=? and item_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("is",$order,$part));  
	if (count($rs)>0) {
		print "<center><h3>Nesting</h3></center>\n";
		print "<table class='table table-striped table-hover'>";
		print "<thead><tr><th>Folder</th><th>Description</th><th>Due Date</th><th>Quantity</th><th>Shipped</th><th>Nest</th><th>Nested</th></thead>\n<tbody>\n";
		$holdFolder="";
		foreach ($rs as $data) {
			$folder=$data['folder_number'];
			if ($folder != $holdFolder) {
				if ($holdFolder) {
					print "<tr><td style-'background=color: black; color: white;'>$holdFolder</td><td></td><td style='background-color: black; color: white;'>Total Nest Qty</td><td style='background-color: black; color: white;'>";
					print $totalQuantity;
					print "</td><td colspan='3'></td></tr>\n";
				}
				$holdFolder=$folder;
				$totalQuantity=0;
			}
			$description=$data['item_description'];
			$nq=$data['nested_quantity'];
			if ($nq > 0) {
				$quantity=$nq;
			} else {
				$quantity=$data['quantity'];
			}
			$totalQuantity+=$quantity;
			$shipped=$data['shipped_quantity'];
			$nest=$data['nesting_name'];
			$due=formatDateDBToWeb($data['due_date']);
			$dt=formatDateDBToWeb($data['nesting_date']);
			print "<tr><td>$folder</td><td>$description</td><td>$due</td><td>$quantity</td><td>$shipped</td><td>$nest</td><td>$dt</td><tr>\n";
		}
		if ($holdFolder) {
			print "<tr><td style-'background=color: black; color: white;'>$holdFolder</td><td></td><td style='background-color: black; color: white;'>Total Nest Qty</td><td style='background-color: black; color: white;'>";
			print $totalQuantity;
			print "</td><td colspan='3'></td></tr>\n";
		}
print "</tbody></table>\n";
	}
	$folder=$order;
	print "<center><h3>Folder Progress</h3></center>";
	include('folderProgressSub.php');
	$sql="select bay_name, c.quantity, full_name, date_loaded from staging_bay_contents c, site_admins a, staging_bays b, order_lines l where  c.item_id=? and c.user_id=a.user_id and c.bay_id=b.bay_id and c.line_id=l.line_id and order_id=? ";
	list($rs,$err)=runIQuery($db,$sql,array("si",$part,$order));
	$totalQuantity=0;
	if (count($rs) > 0 ) {
		print "<center><h3>STAGING (CURRENT)</h3></center>\n";
		print "<table class='table table-striped table-hover'>";
		print "<thead><tr><th>Bay</th><th>Who</th><th>Quantity</th><th>Date Loaded</th></thead>\n<tbody>\n";
		foreach ($rs as $data) {
			$bay=$data['bay_name'];
			$quantity=$data['quantity'];
			$totalQuantity+=$quantity;
			$who=$data['full_name'];
			$dt=formatDateDBToWeb($data['date_loaded']);
			print "<tr><td>$bay</td><td>$who</td><td>$quantity</td><td>$dt</td></tr>\n";
		}
		if ($totalQuantity > 0) {
			print "<tr><td colspan=2></td><td style='background-color: black; color: white;'>$totalQuantity</td><td></td></tr>\n";
		}
		print "</tbody></table>\n";
	}
	$sql="select bay_name, date_loaded, quantity, folder_number, action, full_name from staging_bay_history h left outer join site_admins a on h.user_id=a.user_id where item_id=? and folder_number=? ";
	list($rs,$err)=runIQuery($db,$sql,array("si",$part,$order));
	$totalQuantity=0;
	if (count($rs)>0) {
		print "<center><h3>STAGING (HISTORY)</h3></center>\n";
		print "<table class='table table-striped table-hover'>";
		print "<thead><tr><th>Bay</th><th>Who</th><th>Quantity</th><th>Date Loaded</th><th>Action</th></thead>\n<tbody>\n";
		foreach ($rs as $data) {
			$bay=$data['bay_name'];
			$quantity=$data['quantity'];
			$totalQuantity+=$quantity;
			$who=$data['full_name'];
			$dt=formatDateDBToWeb($data['date_loaded']);
			$action=$data['action'];
			print "<tr><td>$bay</td><td>$who</td><td>$quantity</td><td>$dt</td><td>$action</td></tr>\n";
		}		
		print "<tr><td colspan=2></td><td style='background-color: black; color: white;'>$totalQuantity</td><td></td></tr>\n";
		print "</tbody></table>\n";
	}
	
}
print renderClosePanel();
include('footer.php');
