<?php
date_default_timezone_set("America/Detroit");
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');


print renderPanel("Powder Quoting","Quote","green","col-md-12");

print "<table class='table table-condensed notif'></table>";

// inputs and buttons stuff

print "<p>Remember, if this is a weldment, calculate total Surface Area, enter .5 in the length, total surface area in the width.</p>";
print "<p><b>Surface Area includes ALL sides of a part.  BOTH SIDES if it is a flat part.</b></p>";

// add inactive customers code -Josh 02/20/2023
$sql = "select customer_id, name from customers where inactive_customer=0 OR (customer_id=? and inactive_customer=1) order by name";
list($rs,$err)=runIQuery($db,$sql,["i",$customer]);
print renderSelect(TRUE,"customer",$customer,"Customer","N",$rs,1);

print renderStartItem(TRUE,"","‎");
    print renderButton("Create Items, Orders, and Lines", "green", "createOrder();");
print renderEndItem();

print renderStartItem(TRUE,"","‎");
    print renderButton("Recalculate Cost","blue","calculatePrices()");
print renderEndItem();

print "<br><br><br><br>";

$sql="select vc_id, concat(color_code, '-', vendor_name) as name  from vendor_colors c, vendors v where c.vendor_id=v.vendor_id order by vendor_name, color_code ";
list($vrs,$err)=runIQuery($db,$sql);

print renderStartItem(TRUE,"color","Color");
    print "<select name='color' id='color' style='width: 400px;' onchange='if ($(\".lineitem\").length == 0) { addLine(); }'>";
        print renderOptions($vrs,$color,1,0);
    print "</select>";
print renderEndItem();

$sql="select vc_id, concat(color_code, '-', vendor_name) as name  from vendor_colors c, vendors v where c.vendor_id=v.vendor_id order by vendor_name, color_code ";
list($vrs,$err)=runIQuery($db,$sql);

print renderStartItem(TRUE,"primer","Primer");
    print "<select name='primer' id='primer' style='width: 400px;' onchange='calculatePrices();'>";
        print "<option value='0'>No Primer</option>";
        print renderOptions($vrs,$primer,1,0);
    print "</select>";
print renderEndItem();

print renderStartItem(TRUE,"usebatch","Use Batch Pricing");
    print "<input type='checkbox' id='usebatch' class='form-control' name='usebatch' value='0' onchange='calculatePrices()'>";
print renderEndItem();

print renderCheckBox(TRUE,"classa",0,"Class A Finish",0,"calculatePrices()");
// end inputs and buttons

print "<br><br><br><br>";
print renderStartItem(TRUE,"ordertotal","Total for Order");
    print "<input type='text' id='ordertotal' readonly>";
    print "<input type='hidden' id='minlot' value='0'>";
    print "<input type='hidden' id='orderid' value='0'>";
print renderEndItem();
print "<br><br><br><br>";

// lines
print "<table style='width: 75%;' class='table table-striped'>";

    print "<thead>";
        print "<tr>";
            print "<th>Part</th>";
            print "<th>Color</th>";
            print "<th>Quantity</th>";
            print "<th>Width</th>";
            print "<th>Length</th>";
            print "<th>#Plugs (Taps)</th>";
            print "<th>Masking (SQ IN)</th>";
            print "<th>Price</th>";
            print "<th>Extended</th>";
        print "</tr>";
    print "</thead>";

    print "<tbody></tbody>";

print "</table>";

// end lines

print renderClosePanel();
?>
<script>
    var linecount = 0;
    var working = false;
    function addLine() {
        var line_html =
        `<tr id="lineitem-${linecount}" class="lineitem" data-index="${linecount}">
            <td>
                <input onclick="if (this.value=='' && linecount == (+this.getAttribute('data-index'))+1) addLine();" type="text" id="part-${linecount}" class="part" data-index="${linecount}" onchange="calculatePrice(${linecount})">
            </td>
            <td>
                <select id="itemcolor-${linecount}" class="itemcolor" data-index="${linecount}" onchange="calculatePrice(${linecount})">
                    ${$("#color").html()}
                </select>
            </td>
            <td>
                <input type="text" id="quantity-${linecount}" class="quantity" data-index="${linecount}" style="width: 50px;" value="0" onchange="calculatePrice(${linecount})">
            </td>
            <td>
                <input type="text" id="xdimension-${linecount}" class="xdimension" data-index="${linecount}" style="width: 50px;" value="0" onchange="calculatePrice(${linecount})">
            </td>
            <td>
                <input type="text" id="ydimension-${linecount}" class="ydimension" data-index="${linecount}" style="width: 50px;" value="0" onchange="calculatePrice(${linecount})">
            </td>
            <td>
                <input type="text" id="plugs-${linecount}" class="plugs" data-index="${linecount}" style="width: 50px;" value="0" onchange="calculatePrice(${linecount})">
            </td>
            <td>
                <input type="text" id="masking-${linecount}" class="masking" data-index="${linecount}" style="width: 50px;" value="0" onchange="calculatePrice(${linecount})">
            </td>
            <td>
                <input type="text" id="price-${linecount}" class="price" data-index="${linecount}" value="0" style="width: 50px;" onchange="calculatePrice(${linecount})" readonly>
            </td>
            <td>
                <input type="text" id="extened-${linecount}" class="extended" data-index="${linecount}" value="0" style="width: 50px;" onchange="calculatePrice(${linecount})" readonly>
            </td>
        </tr>`;

        $(".table tbody").append(line_html);
        $("#itemcolor-" + linecount).val($("#color").val());
        linecount++;
    }

    function calculatePrices(lines=false, index=0, createitems=false) {
        return new Promise(function(res, rej) {
            working = true;
            $("#ordertotal").val(0);
            if (!lines) {
                lines = $(".lineitem");
            }

            var line = lines[index];
            calculatePrice(line.getAttribute("data-index"), false, createitems).then(function() {
                index++;
                if (lines[index]) {
                    res(calculatePrices(lines, index, createitems));
                } else {
                    calculateTotal();
                    if (createitems) {
                        var total = +$("#ordertotal").val();
                        var minlot = +$("#minlot").val();
                        if (minlot > total) {
                            var diff = minlot - total;
                            var orderid = $("#orderid").val();

                            var url = `calculatePaintCost.php?orderid=${orderid}&addminlot=1&minlot=${diff}`;

                            $.ajax({
                                url,
                                success: function() {
                                    $(".notif").append("<tr><td>Min Lot Charge added to order ($" + diff + ")</td></tr>");
                                    $(".notif").append("<tr><td>Done!</td></tr>");
                                    $("#ordertotal").val(minlot);
                                    working = false;
                                }
                            });
                        } else {
                            $(".notif").append("<tr><td>Done!</td></tr>");
                            working = false;
                        }
                    }

                    working = false;
                    res();
                }
            });
        });
    }

    function calculateTotal() {
        var prices = $(".lineitem .extended");

        var total = 0;
        for (var i = 0; prices.length > i; i++) {
            total += +prices[i].value;
        }

        $("#ordertotal").val(total.toFixed(2));
    }

    function calculatePrice(line,addtotal=true,createitems=false) {
        return new Promise(function(res, rej) {
            var color = $(".itemcolor[data-index=" + line + "]").val();
            var primer = $("#primer").val();
            var part = $(".part[data-index=" + line + "]").val();
            var quantity = $(".quantity[data-index=" + line + "]").val();
            var xdimension = $(".xdimension[data-index=" + line + "]").val();
            var ydimension = $(".ydimension[data-index=" + line + "]").val();
            var plugs = $(".plugs[data-index=" + line + "]").val();
            var masking = $(".masking[data-index=" + line + "]").val();
            var usebatch = $("#usebatch").is(":checked") ? 1 : 0;
            var orderid = $("#orderid").val();
            var classa = $('#classa').val();
            var customer = $('#customer').val();

            $(".lineitem[data-index=" + line + "]").removeClass("warning").removeClass("info");

            if (part != "" && color != "0" && quantity != "0" && xdimension != "0" && ydimension != "0") {
                $(".lineitem[data-index=" + line + "]").addClass("info");

                var url = 'calculatePaintCost.php?customer='+customer+'&classa='+classa+'&part='+part+'&color='+color+'&primer='+primer+'&quantity='+quantity;
                url = url + '&xdimension='+xdimension+'&ydimension='+ydimension+'&plugs='+plugs+'&masking='+masking+'&usebatch='+usebatch+'&orderid='+orderid;
                if (createitems) {
                    url += "&makeit=1";
                }
                $.ajax({
                    url,
                    success: function(resp) {
                        if (resp.replace("|","").replace("|","") != "") {
                            var data = resp.split("|");
                            var price = +data[0];
                            var ext = +data[1];
                            var minlot = data[2];
                            $("#minlot").val(minlot);
                            var total = +$("#ordertotal").val();

                            $(".price[data-index=" + line + "]").val(price);
                            $(".extended[data-index=" + line + "]").val(ext);

                            if (createitems) {
                                $(".notif").append("<tr><td>Item \"" + part + "\" created and added to order</td></tr>");
                            }

                            if (addtotal) {
                                calculateTotal();
                            }
                        } else {
                            $(".lineitem[data-index=" + line + "]").addClass("warning");
                        }
                        $(".lineitem[data-index=" + line + "]").removeClass("info");
                        res();
                    }
                });
            } else {
                if (color != "0") {
                    $(".lineitem[data-index=" + line + "]").addClass("warning");
                }
                res();
            }
        });
    }

    function createOrder() {
        if (working) return;
        // create order then items
        var customer = $("#customer").val();

        if (customer != "0") {
            $(".lineitem").addClass("info");
            var url = "createOrderForCustomer.php?customer=" + customer;

            $.ajax({
                url,
                success: function(orderid) {
                    if (orderid) {
                        $("#orderid").val(orderid);
                        $(".notif").append("<tr><td>Order <a href='editOrders.php?id=" + orderid + "'>#" + orderid + "</a> created</td></tr>");
                        calculatePrices(false,0,true);
                    }
                }
            });
        } else {
            $.gritter.add("No customer selected");
        }
    }
<?php
$sql="select item_name, item_description, status_name from items left outer join item_status on items.status=status_id where coalesce(under_review,0)=0  ";
$sql.=" order by item_name ";
list($rs,$err)=runIQuery($db,$sql);
$itemlist=array();
$itemcount=0;
foreach ($rs as $data) {
	if ($data['status_name'] != 'Active') {
		$itemlist[]=$data['item_name'] . "-" . $data['status_name'];
	} else {
		$itemlist[]=$data['item_name'];
	}
	$itemcount++;
}
$itemcount=count($itemlist);
?>
var itemList=<?=json_encode($itemlist)?>;

    function page_init() {
        	$('[id^="part"]').autocomplete
                ({source: itemList, minLength: 4, messages: {noResults: '', results: function() {}}});
    }
</script>
<?php
include('footer.php');
?>
