<?php
$expanded=1;
$locked=0;
error_reporting(E_ERROR);
ini_set('display_errors','on');

include('dbConnection.php');
## session start is now in dbconnection.php
include('security.php');
include('functions.php');
$pageTitle="Orders Due";
include('header.php');
$debug=0;
if ($isCustomer) {
	$userName="Shipping";
}
function setOptionForPowderOD($db,$order,$bu) {
	$sqty=0;
	$tqty=0;
    $lineList=array();
    ## this is  for any that have transferred
    if ($bu == 1) {
        $sql=" select  distinct l.line_id from order_lines l
        inner join  routing r on l.item_id=r.parent_part and operation_id in (3138, 3109, 3113, 3139, 3106) and r.notes not like 'PURCHASE To Print' 
        left outer join transfer_lines tl on l.order_id=so_number and l.item_id=tl.part_number and tl.quantity >= l.quantity 
        left outer join staging_bay_contents c on l.line_id=c.line_id 
        where order_id=?  and so_number is not null and c.line_id is null and l.quantity - coalesce(shipped_quantity,0) > 0 ";
        list($rs,$err)=runIQuery($db,$sql,array("i",$order));
        foreach ($rs as $data) {
            $lineList[]=$data[0];
        }    
    } else {
        $sql=" select  distinct l.line_id from order_lines l
        inner join  routing r on l.item_id=r.parent_part and operation_id in (3106) and r.notes not like 'PURCHASE To Print' 
        left outer join transfer_lines tl on l.order_id=so_number and l.item_id=tl.part_number and tl.quantity >= l.quantity 
        left outer join staging_bay_contents c on l.line_id=c.line_id 
        where order_id=?  and so_number is not null and c.line_id is null and l.quantity - coalesce(shipped_quantity,0) > 0 ";
        list($rs,$err)=runIQuery($db,$sql,array("i",$order));
        foreach ($rs as $data) {
            $lineList[]=$data[0];
        }
    
    }
    ## this is  for any that do not need a transfer
    ## need to omit every single powder coat step
    if ($bu ==1) {
        $sql=" select  distinct l.line_id from order_lines l
        inner join  routing r on l.item_id=r.parent_part and operation_id not in (3138, 3109, 3113, 3139, 3106,  3110, 3116, 3090, 3119)
        and r.vendor_id not in (select vendor_id from vendors where vendor_name like 'Preferred%') 
        left outer join staging_bay_contents c on l.line_id=c.line_id 
        where order_id=?  and c.line_id is null  and l.quantity - coalesce(shipped_quantity,0) > 0 ";
        list($rs,$err)=runIQuery($db,$sql,array("i",$order));
        foreach ($rs as $data) {
            if (! in_array($data[0],$lineList)) {
                $lineList[]=$data[0];
            }
        }  
    } else {
        $sql=" select  distinct l.line_id from order_lines l
        inner join  routing r on l.item_id=r.parent_part and operation_id not in (3138, 3109, 3113, 3139, 3106,  3110, 3116, 3090, 3119)
        and r.vendor_id not in (select vendor_id from vendors where vendor_name like 'Preferred%') 
        left outer join staging_bay_contents c on l.line_id=c.line_id 
        where order_id=?  and c.line_id is null  and l.quantity - coalesce(shipped_quantity,0) > 0 ";
        list($rs,$err)=runIQuery($db,$sql,array("i",$order));
        foreach ($rs as $data) {
            if (! in_array($data[0],$lineList)) {
                $lineList[]=$data[0];
            }
        }  
    }
    if (count($lineList)> 0) {
        $sql="select sum(quantity - coalesce(shipped_quantity,0)) from order_lines where line_id in (" . implode(",",$lineList) . ") ";
        list($rs,$err)=runIQuery($db,$sql);
        $sqty=$rs[0][0];
    }
	if ($bu == 1) {
		## check for Powder and Outsource  and not a purchase
		$sql="select distinct l.line_id from order_lines l
			inner join  routing r on l.item_id=r.parent_part and operation_id in (3138, 3109, 3113, 3139, 3106) and r.notes not like 'PURCHASE To Print' 
				left outer join transfer_lines tl on l.order_id=so_number and l.item_id=tl.part_number and tl.quantity >= l.quantity 
				left outer join staging_bay_contents c on l.line_id=c.line_id 
			where order_id=?  and so_number is null and c.line_id is null ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$order));
        $tList=[];
        foreach ($rs as $data) {
            $tList[]=$data[0];
        }
        if (count($tList)>0 ) {
            $sql="select sum(l.quantity - coalesce(tl.quantity,0)) from order_lines l 
                left outer join  transfer_lines tl on l.order_id=so_number and l.item_id=tl.part_number 
                where l.line_id in (" . implode(",",$tList) . ") ";
                list($rs,$err)=runIQuery($db,$sql);
                $tqty=$rs[0][0];
        }
	}
	if ($bu == 2) {
		## check for  Outsource  and not a purchase

		$sql="select distinct l.line_id from order_lines l
			inner join  routing r on l.item_id=r.parent_part and operation_id =3106 and r.notes not like 'PURCHASE To Print' 
                and r.vendor_id not in (select vendor_id from vendors where vendor_name like 'Preferred%') 
            left outer join transfer_lines tl on l.order_id=so_number and l.item_id=tl.part_number and tl.quantity >= l.quantity 
				left outer join staging_bay_contents c on l.line_id=c.line_id 
			where order_id=?  and so_number is null and c.line_id is null ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$order));
        $tList=[];
        foreach ($rs as $data) {
            $tList[]=$data[0];
        }
        if (count($tList)>0 ) {
            $sql="select sum(l.quantity - coalesce(tl.quantity,0)) from order_lines l 
                left outer join  transfer_lines tl on l.order_id=so_number and l.item_id=tl.part_number 
                where l.line_id in (" . implode(",",$tList) . ") ";
                list($rs,$err)=runIQuery($db,$sql);
                $tqty=$rs[0][0];
        }
    }
    return array($tqty,$sqty);
}
$start_date="";
if (isset($_GET['start_date'])) {
	$start_date=$_GET['start_date'];
}
if (! $start_date) {
	$start_date=date("01/01/Y");
}

$end_date="";
if (isset($_GET['end_date'])) {
	$end_date=$_GET['end_date'];
}
$seq="";
if (isset($_GET['seq'])) {
	$seq=$_GET['seq'];
}
if (! $end_date) {
		$end_date=Date("m/d/Y");
}
$status="";
if (isset($_GET['status'])) {
	$status=$_GET['status'];
}
if (isset($_GET['customer'])) {

	$customer=$_GET['customer'];

	$_SESSION['customer']=$customer;

} else {

	$customer=$_SESSION['customer'];

}

if ($isCustomer) {
	$customer=$isCustomer;
	$_SESSION['customer']=$customer;
}

if (isset($_GET['searchclass'])) {

	$searchClass=$_GET['searchclass'];
}

$so="";

if (isset($_GET['salesorder'])) {

	$so=$_GET['salesorder'];

}

$owner=0;
if (isset($_GET['owner'])) {
	$owner=$_GET['owner'];
	$_SESSION['owner']=$owner;
} else {
	if (isset($_SESSION['owner'])) {
		$owner=$_SESSION['owner'];
	}
}
$searchjob="";
if (isset($_GET['searchjob'])) {
	$searchjob=$_GET['searchjob'];
}

$jobstatus=array();

$sql="select * from job_status order by status_name";

$rs=mysqli_query($db,$sql);

while ($data=mysqli_fetch_array($rs)) {

	$i=$data['status_id'];

	$n=$data['status_name'];

	$jobstatus[$i]=$n;

}

$customerlist=array();

$sql="select * from customers ";
if ($isCustomer) {
	$sql.=" where customer_id=$isCustomer";
}

$rs=mysqli_query($db,$sql);

while ($data=mysqli_fetch_array($rs)) {

	$i=$data['customer_id'];

	$n=$data['name'];

	$customerlist[$i]=$n;

}
$part="";
if (isset($_GET['part'])) {
	$part=$_GET['part'];
}
$sql="update order_lines l,  orders o  set line_status=status where line_status=8 and l.order_id=o.order_id and o.status in (3,4,5, 9, 10) ";
list($rs,$err)=runIQuery($db,$sql);

print renderPanel("Orders Due");

print "<form name='listform' method='GET' action='ordersDue.php'>\n";
print "<input type='hidden' name='clicked' value='1'>";
print "<div class='span2 '>\n";
print renderDateBox(TRUE,'start_date',$start_date,"Start Date");
print "</div>";

print "<div class='span2 '>\n";
print renderDateBox(TRUE,'end_date',$end_date,"End Date");
print "</div>";


$sql="select class_id, class_name from order_classes order by display_sequence ";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"searchclass",$searchClass,"Order Class","N",$rs,1);
print "<div class='span3 '>\n";

print "<div class='control-group'>\n";

print "<label class='control-label' for='status'>Status</label>\n";

print "<div class='controls'>\n";

print "<select name='status' id='status'><option value=''>All</option>";

$sql="select status_id, status_name from order_status order by status_name ";

$rs=mysqli_query($db,$sql);

print renderOptions($rs,$status);
reset($rs);
$statusList=array();
foreach ($rs as $data) {
	$sid=$data['status_id'];
	$sname=$data['status_name'];
	$statusList[$sid]=$sname;
}

print "</select>";

print "</div></div></div>";

print "<div class='span3 '>\n";

print "<div class='control-group'>\n";

print "<label class='control-label' for='customer'>Customer</label>\n";

print "<div class='controls'>\n";

print "<select name='customer' id='customer'><option value=''>All</option>";
// add inactive customers code -Josh 02/20/2023
$sql="select customer_id, name from customers where (inactive_customer=0 OR (customer_id=? and inactive_customer=1)) ";
if ($isCustomer) {
	$sql.=" AND customer_id=$isCustomer";
}
$sql.= " order by name";

list($rs,$err)=runIQuery($db,$sql,["i",$customer]);

print renderOptions($rs,$customer);

print "</select>";

print "</div></div></div>";

print "<div class='span2 '>\n";

print "<div class='control-group'>\n";

print "<label class='control-label' for='part'>Part</label>\n";

print "<div class='controls'>\n";

$itemlist=array();
$sql = "select item_name from items"; // added missing query -Josh 02-20-2023
list($rs,$err)=runIQuery($db,$sql);
foreach ($rs as $data) {

	$itemlist[]=$data['item_name'];

}

$itemcount=count($itemlist);
$reportType=$_GET['report_type'];

print "<input type='text' class='span11' name='part' id='part' value='$part' placeholder='Enter Part Prefix' data-provide='typeahead' data-min-length='4' autocomplete='off' data-items='$itemcount' data-source=\"" . str_replace('"','&quot;',json_encode($itemlist)) . "\"  >";

print "</div></div></div>";

print "<div class='span2 '>\n";

print "<div class='control-group'>\n";
print "<label class='control-label' for='salesorder'>Job-Step/PO/SO</label>\n";
print "<div class='controls'>\n";

print "<input type='text' class='span11' name='salesorder' id='salesorder' value='$so'>";
print "</div></div></div>";

print "<div class='span2 '>\n";
print "<div class='control-group'>\n";
print "<label class='control-label' for='report_type'>Report Type</label>\n";
print "<div class='controls'>\n";
print "<select name='report_type' id='report_type'>";
print "<option value='basic' ";
print ">Basic Report</option>";
print "<option value='basicnodematic' ";
if ($reportType=='basicnodematic') {
    print "selected";
}
print ">Basic No Dematic</option>";
print "<option value='detail' ";
if ($reportType=='detail') {
    print "selected";
}
print ">Detail Report</option>";
print "<option value='dematic' ";
if ($reportType=='dematic') {
    print "selected";
}
print ">Dematic Only</option>";
print "<option value='nodematic' ";
if ($reportType=='nodematic') {
    print "selected";
}
print ">No Dematic</option>";
print "</select>";
print "</div></div></div>";

print "<div class='btn green' onclick='document.listform.submit();'>Find</div>";

print "<div class='btn blue' onclick='exportReport();'>Export</div>";

if (!	$customer==$isCustomer) {
	print "<div class='btn blue' onclick='exportReportShipping();'>Export Shipping Format</div>";
}

if (! isset($_GET['clicked'])) {
    include('footer.php');
    exit;
}

print "<div style='clear: both;'></div>\n";
print "<div id='totals'></div>\n";
print "<div style='clear: both;'></div>\n";
print "<table class='table-bordered table-striped table-condensed'>";

print "<thead>";

print "<tr>";

print "<th valign='top'>";
print "<span onclick=\"sortby('date_order');\" style='cursor: pointer;'>";
print "Date Entered";
print "</span>";
print "</th>";
print "<th valign='top'>";
print "<span onclick=\"sortby('due_date');\" style='cursor: pointer;'>";
print "Date Due";
print "</span>";
print "</th>";

print "<th valign='top'>";
print "<span onclick=\"sortby('name');\" style='cursor: pointer;'>";
print "Customer";
print "</span>";
print "</th>";
print "<th>Ship To</th>";
print "<th valign='top'>";
print "<span onclick=\"sortby('l.order_id');\" style='cursor: pointer;'>";
print "Sales Order";
print "</span>";
print "</th>";

print "<th valign='top'>";
print "<span onclick=\"sortby('type_name');\" style='cursor: pointer;'>";
print "Type";
print "</span>";
print "</th>";

print "<th valign='top'>";
print "<span onclick=\"sortby('status_name');\" style='cursor: pointer;'>";
print "Status";
print "</span>";
print "</th>";

print "<th valign='top'>";
print "<span onclick=\"sortby('po_number');\" style='cursor: pointer;'>";
print "Customer PO";
print "</span>";
print "</th>";

print "<th valign='top'>";

if (substr($reportType,0,5) != "basic") {
	print "<th valign='top'>";
print "PO Line";

print "</th>";

print "<th valign='top' align='right'>";

print "On Hand";

print "</th>";

print "<th valign='top'>";
	print "<span onclick=\"sortby('l.item_id');\" style='cursor: pointer;'>";

print "Part";
print "</span>";
print "</th>";

print "<th valign='top'>";

print "Description";
	print "</th>";
} else {
	print "<th valign='top'># Lines</th>";
}
print "<th valign='top'>";
print "Notes";
print "</th>";

print "<th valign='top' align='right'>";

print "Quantity Open";

print "</th>";

if (substr($reportType,0,5) != "basic") {
print "<th valign='top'>";

print "Job(s)";

print "</th>";
print "<th valign='top'>";
print "PO(s)";
print "</th>";
    print "<th valign='top'>";
    print "Received";
    print "</th>";
}
print "<th>Action</th>";
print "</tr>\n";

print "</thead>";

print "<tbody>";


include('ordersDueSub.php');

$solist=array();

$totalLines=0;
$msg="";
while ($data=mysqli_fetch_array($rs)) {
	$line=$data['ol_id'];
	$soLineCount=$data['line_count'];
    if (substr($reportType,0,5) != "basic") {
		$totalLines++;
	} else {
		$totalLines+=$soLineCount;
	}
	$order=$data['order_id'];
	$sql="select l.powder_color, i.powder_color as item_color, l.line_id from order_lines l, items i where l.order_id=? and l.item_id=i.item_name 
	and l.powder_color <> i.powder_color and l.powder_color = 0 ";
	list($crs,$err)=runIQuery($db,$sql,array("i",$order));
	foreach ($crs as $cdata ){
		$line_id=$cdata['line_id'];
		$color=$cdata['item_color'];
		$sql="update order_lines set powder_color=$color where line_id=$line_id";
		list($updrs,$err)=runIQuery($db,$sql);
	}

	if (! in_array($order,$solist)) {
		$solist[]=$order;
	}
	$qbid=$data['quickbooks_order_number'];
	$priority=$data['priority'];
    $priorityColor=$data['priority_color'];
    $priorityName=$data['priority_name'];
	$item=$data['item_id'];
	$sql="select * from routing where parent_part=? and workcenter_id=173";
	list($prs,$err)=runIQuery($db,$sql,array("s",$item));
	$usesPowder=count($prs);
	$status=$data['status_name'];
	if ($status == "At Processor") {
		$status="";
		## in racking or line load
		$sql="select * from jobs j, production_results pr, routing r where j.line_id=?
			and j.job_id=pr.job_id and pr.routing_id=r.routing_id and r.operation_id in (3138, 3113) ";
		list($prs,$err)=runIQuery($db,$sql,array("i",$line));
		if (count($prs)>0) {
			## not in cure or line unload
			$sql="select * from jobs j, production_results pr, routing r where j.line_id=?
			and j.job_id=pr.job_id and pr.routing_id=r.routing_id and r.operation_id not in (3139, 3112) ";
			list($prs,$err)=runIQuery($db,$sql,array("i",$line));
			if (count($prs)==0) {
				$status = "At Paint";
			}
		}

	}
	$orderType=$data['type_name'];

	$description=$data['item_description'];
	$notes=$data['notes_to_self'];
	if (substr($notes,0,8)=="TAX CODE") {
		## cma 9/30/22 do not clear the dang notes
		#$notes="";
	}
	$dt=formatDateDBToWeb($data['due_date']);
    if (substr($reportType,0,5) == "basic") {
		$dt=formatDateDBToWeb($data['date_due']);
	}
	$dte=formatDateDBToWeb($data['date_order']);
	$ol=$data['ol_id'];
    if (substr($reportType,0,5) != "basic") {
	$line=$data['po_line'];

	$lineStatus=$data['line_status'];
		$lineStatusName=$statusList[$lineStatus];

		if ($status != $lineStatusName) {
			if ($status == "Ordered" and $lineStatusName == "Open") {
			} else {
				$status=$lineStatusName;
			}
		}
	}
	$qty=$data['quantity_open'];

	$cust=$data['customer_id'];

	$po=$data['po_number'];
	$shipTO=$data['ship_name'];
	$mt="";
	if (strstr($customerlist[$cust],"Preferred")) {
		$mt=file_get_contents("https://preferredwelderp1.com/listSignature.php?code=8383&orders=$po");
	}
	$orcpt="";
	$sql="select full_name, date_received from order_receipts, site_admins  where order_id=$order and `who_received` = `user_id` ";
	list($ors,$err)=runIQuery($db,$sql);
	if (count($ors)>0) {
		$odata=$ors[0];
		$orcpt="<b>Order RCVD By " . $odata['full_name'] . " on " . formatDateDBToWeb($odata['date_received']) . "</b>";
	}
	$sql=" select full_name, date_received from order_lines l, po_lines pl, receipt_lines rl, receipts r, site_admins
		where  l.order_id=$order and  l.line_id=pl.order_line and pl.line_id=rl.line_id and rl.receipt_id=r.receipt_id and r.who_received=user_id ";
		list($ors,$err)=runIQuery($db,$sql);
		if (count($ors)>0) {
			$odata=$ors[0];
			$orcpt.="<b>PO RCVD By " . $odata['full_name'] . " on " . formatDateDBToWeb($odata['date_received']) . "</b>";
		}

	print "<tr>";

print "<td>";
print $dte;
print "</td>";
	print "<td valign='top'>";

	if ($userName!="Shipping") {
		print "<a target='_blank' href='productionResults.php?order=$order'>";
	}

	print $dt;

	if ($userName!="Shipping") {

		print "</a>";

	}

	print "</td>";

	print "<td valign='top'>";

	if ($userName!="Shipping") {

		print "<a target='_blank' href='folderProgress.php?id=$order'>";

	}

	print $customerlist[$cust];

	if ($userName!="Shipping") {

		print "</a>";

	}

	print "</td>";
	print "<td valign='top'>$shipTO</td>";
	print "<td valign='top'>";

	if ($userName!="Shipping") {

		print "<a target='_blank' href='salesOrderProgress.php?order=$order'>";

	}


	print $order;

	if ($userName!="Shipping") {

		print "</a>";

	}

	print "</td>";
	print "<td style='font-size: 10px;' valign='top'>$orderType</td>";
	print "<td style='font-size: 10px;' valign='top'>";
    if (substr($reportType,0,5) != "basic") {
		$joblist="(-1";
		$comma=",";

		if ($ol) {
			$sql="select * from jobs where line_id=$ol ";
			$lrs=mysqli_query($db,$sql);
			while ($ldata=mysqli_fetch_array($lrs)) {
				$job=$ldata['job_id'];
				$joblist.=$comma;
				$joblist.=$job;
			}
		}
		$joblist.=")";
		if ($ol) {
			$sql="select * from po_lines l, purchase_orders p, transfer_lines t where l.job_id in $joblist and l.po_id=t.po_number and l.po_id=p.po_id ";
			list($prs,$err)=runIQuery($db,$sql);
			if (count($prs)>0) {
				$pdata=$prs[0];
				$thispoi=$pdata[1];
				print "At Processor <br>";
				print "<a href='editPO.php?id=$thispoi' target='_blank'>";
				print formatDateDBToWeb($data['date_on_po']);
				print "</a>";					
			} else {
				print $status;
			}
		} else {
			print $status;
		}
		if ($status == "At Weld") {
			$sql="select start_time from production_results p, routing r, workcenters w where p.routing_id=r.routing_id and r.workcenter_id=w.workcenter_id and workcenter_name='Weld' and job_id in $joblist order by start_time LIMIT 1";
			list($jrs,$err)=runIQuery($db,$sql);
			$jdata=$jrs[0];
			print "<br>";
			print formatDateDBToWeb($jdata['start_time']);
		}
		if ($status == "At Assembly") {
			$sql="select start_time from production_results p, routing r, workcenters w where p.routing_id=r.routing_id and r.workcenter_id=w.workcenter_id and workcenter_name='Assembly' and job_id in $joblist order by start_time LIMIT 1";
			list($jrs,$err)=runIQuery($db,$sql);
			$jdata=$jrs[0];
			print "<br>";
			print formatDateDBToWeb($jdata['start_time']);
		}
    } else {
		if ($ol) {
			$sql="select l.po_id from po_lines l, purchase_orders p, transfer_lines t where l.job_id in (select job_id from jobs where line_id=$ol)  and l.po_id=t.po_number and l.po_id=p.po_id ";
			list($prs,$err)=runIQuery($db,$sql);
			if (count($prs)>0) {
				$pdata=$prs[0];
				$thispoi=$pdata[0];
				print "At Processor <br>";
				print "<a href='editPO.php?id=$thispoi' target='_blank'>";
				print formatDateDBToWeb($data['date_on_po']);
				print "</a>";					
			} else {
				print $status;
			}
		} else {
			print $status;
		}

	}
	print "</td>";

	print "<td valign='top' title='$priorityName' >";

	if ($userName!="Shipping") {
		print "<a target='_blank' style='color: $priorityColor' href='editOrders.php?table=orders&key=order_id&id=$order'>";
	}

	print $po;

	if ($userName!="Shipping") {

		print "</a>";

	}

	print "</td>";

	print "<td valign='top'>";

	if (substr($reportType,0,5) != "basic") {
		print "<td valign='top'>";
	if ($userName!="Shipping") {
			print "<a target='_blank' href='folderProgress.php?id=$order'>";
	}

	print $line;

	if ($userName!="Shipping") {

		print "</a>";

	}

	print "</td>";

	print "<td valign='top' align='right'>";

	$sql="select quantity_on_hand from items where item_name='$item' and item_name != 'Miscellaneous'";

	$irs=mysqli_query($db,$sql);

	$idata=mysqli_fetch_array($irs);

	print $idata['quantity_on_hand'];

	print "&nbsp;";

	print "</td>";

	print "<td valign='top'>";

	if ($userName!="Shipping") {

		print "<a target='_blank' href='folderProgress.php?id=$order'>";

	}

	print $item;

	print "</a>";
	if ($usesPowder) {
		print "<i class='icon-tag' title='Uses Powder' alt='Uses Powder'></i>";
	}
	print "</td>";

	print "<td valign='top'>";

	if ($userName!="Shipping") {

		print "<a target='_blank' href='folderProgress.php?id=$order'>";

	}

	print $description;

	if ($userName!="Shipping") {

		print "</a>";

	}

	print "</td>";
	} else {
		print "<td>$soLineCount</td>";
	}
		print "<td valign='top' align='right'>";
		print $notes;
		if ($mt) {
			list($so,$dt,$sb)=explode("|",$mt);
			if ($notes) {
				print "<BR>";
			}
			if ($sb or $dt) {
				print "<b>MT DLVD $sb on $dt</b>";
			}
			}
		if ($orcpt) {
			if ($notes) {
				print "<BR>";
			}
			print $orcpt;
		}
		print "</td>";

	print "<td valign='top' align='right'>";

	if ($userName!="Shipping") {

		print "<a target='_blank' href='folderProgress.php?id=$order'>";

	}

	print $qty;

	print "&nbsp;";

	if ($userName!="Shipping") {

		print "</a>";

	}

	print "</td>";

    if (substr($reportType,0,5) != "basic") {
	print "<td valign='top' align='center'>";

	if ($ol) {

		$sql="select * from jobs where line_id=$ol";

		$lrs=mysqli_query($db,$sql);
		while ($ldata=mysqli_fetch_array($lrs)) {
			$job=$ldata['job_id'];
			$s=$ldata['status'];
			print "<a href='editJob.php?table=jobs&key=job_id&id=$job' target='_blank'>$job</a><BR>";

		}

	}

	print "</td>";
	print "<td valign='top'>";
		if ($ol) {
			$sql="select distinct p.po_id, status_name, po_date from po_lines l, purchase_orders p, transfer_lines t, po_status s where l.job_id in $joblist and l.po_id=t.po_number and l.po_id=p.po_id and p.status=s.status_id ";
			list($prs,$err)=runIQuery($db,$sql);
			foreach ($prs as $pdata) {
				$pdata=$prs[0];
				$thispoi=$pdata['po_id'];
				$status=$pdata['status_name'];
				print "<br>";
				print "<a href='editPO.php?id=$thispoi' target='_blank'>";
				print formatDateDBToWeb($pdata['po_date']);
				print " ($status)";
				print "</a>";
			}
		}
			print "</td>";

	    print "<td valign='top'>";
            if ($ol) {
                $sql="select distinct date_received  from po_lines l, purchase_orders p, receipt_lines rl, receipts r  where l.job_id in $joblist and l.po_id=p.po_id  ";
				$sql.=" and l.line_id=rl.line_id and rl.receipt_id=r.receipt_id ";
                list($prs,$err)=runIQuery($db,$sql);
				$comma="";
                foreach ($prs as $pdata) {
                    $pdata=$prs[0];
					print $comma;
                    print formatDateDBToWeb($pdata['date_received']);
					$comma="<BR>";
                }
            }
        print "</td>";
    }
	print "<td valign='top'>";
	if (strtolower($userEmail) != "coating") {
		if (! $isCustomer) {
            $sql="select line_id from order_lines where order_id=$order";
            list($okrs,$err)=runIQuery($db,$sql);
            $ok=1;
            foreach ($okrs as $okdata) {
                if (! OKToShip($db,$okdata[0]))  {
                    $ok=0;
                }
            }
            ## if even one line needs inspection, cannot ship
			if ($ok) {
				list($tqty,$sqty)=setOptionForPowderOD($db,$order,$businessUnit);
				if ($sqty > 0 ) {
                    ### Check if in Staging
                    $sql="select * from staging_bays where order_id=? ";
                    list($prs,$err)=runIQuery($db,$sql,array("i",$order));
                    if (count($prs)>0) {
                        print "<div class='btn red' onclick=\"shipOrder('$order','$ol');\">Ship $sqty</div> (SO $order in Staging)";
                    } else {
                        print "<div class='btn green' onclick=\"shipOrder('$order','$ol');\">Ship $sqty</div>";
                    }
				}
				if ($tqty > 0 ) {
                    ### Check if in Staging
                    $sql="select * from staging_bays where order_id=? ";
                    list($prs,$err)=runIQuery($db,$sql,array("i",$order));
                    if (count($prs)>0) {
                        print "<div class='btn red' onclick=\"transferOrder('$order','$ol');\">Transfer $tqty</div>";
                        print "SO $order In Staging";
                    } else {
                        print "<div class='btn green' onclick=\"transferOrder('$order','$ol');\">Transfer $tqty</div>";
                    }
				}
			} else {
				print "Needs Inspection";
			}
		}
	}

	print "</td>";
	print "<td><a href='ordersDueNew.php?salesorder=$order&report_type=basic&clicked=1' target='_blank'>View Detail</a></td>";
	print "</tr>\n";

}

print "</tbody>";

print "</table>";

print "<input type='hidden' name='seq' value='$seq'>";
print "</form>\n";

?>
<form name='exportform' action='ordersDueNewExport.php' target='exporter' method='post'>
<input type='hidden' name='report_type' value='<?=$reportType?>'>
<input type='hidden' name='start_date' value='<?=$start_date?>'>
<input type='hidden' name='end_date' value='<?=$end_date?>'>
<input type='hidden' name='customer' value='<?=$customer?>'>
<input type='hidden' name='part' value='<?=$part?>'>
<input type='hidden' name='searchclass' value='<?=$searchclass?>'>
<input type='hidden' name='owner' value='<?=$owner?>'>
</form>
<script>

function editRecord(section,id,targetWindow)

{

	url='editJob.php?section=Jobs&action=edit&id='+id;

	if (targetWindow!='self') {

		window.open(url,targetWindow);

	} else {

		document.location.href=url;

	}

}

document.getElementById('totals').innerHTML='Total SOs: <?=count($solist)?><br>Total Lines: <?=$totalLines?><BR>';

var delkey=0;

var delkeyfield='';

var deltable='';

function partialShip(order) {
	var url = "ordersDueNew.php?salesorder=" + order + "&clicked=1&start_date=<?=$start_date?>&end_date=<?=$end_date?>";
	window.open(url, "_blank");
}

function shipOrder(ordernumber,oline) {

	url='selectOrderLines.php?id=0&oline='+oline+'&ordernumber='+ordernumber;

	window.open(url,'shipit');

}

function transferOrder(ordernumber,oline) {

	url='newTransfer.php?id=0&scan='+ordernumber;

	window.open(url,'shipit');

}


function printPage() {

	document.listform.action='printOrdersDue.php';

	document.listform.target='_blank';

	document.listform.submit();

	document.listform.target='_self';

	document.listform.action='ordersDue.php';

}





var currentObj;

	function exportReport() {
		document.exportform.submit();
	}


</script>

</div>

</div>
<script>
	function sortby(byval) {
		if ('<?=$seq?>' == byval) {
			document.listform.seq.value=byval + ' desc';
		} else {
			document.listform.seq.value=byval;
		}
		document.listform.submit();
	}
</script>
<?php

include('footer.php');

?>