<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');


$start=Date("m/d/Y");
$end=$start;

if (isset($_GET['start'])) {
	$start=$_GET['start'];
	$end=$_GET['end'];
	
}

print renderPanel("Order Status Update Report","Order Status Update Report","primary","span11");

print "<form name='datefilterform' method='GET' action='orderStatusUpdateReport.php'>\n";
print renderDateBox(TRUE,"start",$start,"Start Date");
print renderDateBox(TRUE,"end",$end,"End Date");
print renderButton("Find","success","document.datefilterform.submit();");
print "</form><br>";


$s=formatDateWebtoDB($start);
$e=formatDateWebtoDB($end);

$sql = "SELECT order_id, date_changed, full_name 
    FROM order_status_update 
    INNER JOIN site_admins ON site_admins.user_id=order_status_update.changed_by 
    WHERE new_status=1 AND date_changed>? AND date_changed<DATE_ADD(?, INTERVAL 1 DAY)
    ORDER BY date_changed ASC";
list($rs,$err)=runIQuery($db,$sql,array("ss",$s,$e));
$totalRows=count($rs);

print "<h3>Orders Updated to Open</h3>";

print "Total Rows $totalRows<BR>";
print "<BR>";
print "<table class='table table-striped'>";
print "<thead><tr><th>Order</th><th>Updated On</th><th>Updated By</th></tr></thead><tbody>";

foreach($rs as $data) {
    $order=$data['order_id'];
    $who=$data['full_name'];
    $when=formatDateDBtoWeb($data['date_changed']);

    print "<tr><td><a href='editOrders.php?id=$order' target='_blank' >$order</a></td><td>$when</td><td>$who</td></tr>\n";
}

print "<tr><td>Total</td><td></td><td>$totalRows</td></tr>\n";
print "</tbody></table>";
?>
<script>
function page_init() {
	$('.datepicker').datepicker();
}

</script>
<?php
include('footer.php');
?>