<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
$activePanel='openpo';
$pageTitle="Open RMAs";
include('header.php');
print renderPanel("Open QIR","Open QIR","danger");
$department=0;
if (isset($_GET['department'])) {
	$department=cleanText($_GET['department']);
}
if (! $department) {
	$department=0;
}
if (in_array(strtolower($userEmail),array("corywind@preferredmachinellc.com","justin@preferredmachinellc.com","callen@preferredmachinellc.com","shaynh@preferredmachinellc.com"))) {
	$sql="select department_id, department_name from departments order by department_name";
	list($rs,$err)=runIQuery($db,$sql);
	print "<form name='findform' action='openRMA.php' method='GET'>";
	print renderSelect(TRUE,"department",$department,"Department","N",$rs,1);
	print renderButton("Find","danger","document.findform.submit();");
	print "</form>";
} else {
	$sql="select department_id, department_name from departments where lead_email=? order by department_name='ISA' DESC";
	list($rs,$err)=runIQuery($db,$sql,array("s",$userEmail));
	if (count($rs)>0) {
		$data=$rs[0];
		$department=$data['department_id'];
		$departmentName=$data['department_name'];
		print "<hr>Department: $departmentName</h4>";
	}
}
print "<p>Click on Folder to view the RMA Order.  Click on the RMA Reason to update the RMA or print the QIR.</p>";
$sql="select distinct date_order, date_due, ship_name, folder_number, o.order_id, reason_description, department_name ";
$sql.=" from orders o inner join order_lines l on o.order_id=l.order_id left outer join rma_update u on l.line_id=u.line_id ";
$sql.="  inner join rma_reasons r on coalesce(true_reason,o.rma_reason)=reason_id ";
$sql.=" inner join  departments d  on coalesce(assigned_department, reason_department)=department_id ";
$sql.=" left outer join qir on o.order_id=qir.order_id where date_order > '2021-08-01' ";
if ($department)  {
	if ($department == 17) {
		$sql.=" and department_id in (3, 15, 17)  ";
	} else {
		$sql.=" and department_id=$department ";
	}
}
$sql.=" and o.rma_reason > 0 and employee_reviewed is null order by d.department_name, date_order ";
if (in_array(strtolower($userEmail),array("corywind@preferredmachinellc.com","justin@preferredmachinellc.com","callen@preferredmachinellc.com"))) {
	$sql="select distinct date_order, date_due, ship_name, folder_number, o.order_id,  reason_description, department_name from orders o ";
	$sql.=" inner join order_lines l on o.order_id=l.order_id left outer join rma_update u on l.line_id=u.line_id ";
	$sql.=" inner join rma_reasons r on coalesce(true_reason,o.rma_reason)=reason_id ";
	$sql.=" inner join  departments d  on coalesce(assigned_department, reason_department)=department_id left outer join qir on o.order_id=qir.order_id ";
	$sql.=" where date_order > '2021-08-01'  and o.rma_reason > 0  and employee_reviewed is null";
	if ($department)  {
		if ($department == 17) {
			$sql.=" and department_id in (3, 15, 17)  ";
		} else {
			$sql.=" and department_id=$department ";
		}
	}
	$sql.=" order by d.department_name, date_order ";
}
print "<table class='table table-striped'>";
print "<thead><tr><th>Department</th><th>Folder</th><th>RMA Date</th><th>RMA Reason</th><th>Customer</th></thead><tbody>";
list($rs,$err)=runIQuery($db,$sql);
foreach ($rs as $data) {
	$order=$data['order_id'];
	$folder=$data['folder_number'];
	$reason=$data['reason_description'];
	$customer=$data['ship_name'];
	$dt=formatDateDBToWeb($data['date_order']);
	$departmentName=$data['department_name'];
	print "<tr><td>";
	print "$departmentName</td><td>";
	print "<a href='editOrders.php?id=$order' target='_blank' rel='opener'>";
	print $folder;
	print "</a>";
	print "</td>";
	print "<td>$dt</td>";
	print "<td>";
	print "<a href='editRMA.php?id=$order' target='_blank' rel='opener'>";
	print $reason;
	print "</td>";
	print "<td>";
	print $customer;
	print "</td>";
	print "</tr>\n";
}
print "</tbody></table>\n";
print renderClosePanel();
include('footer.php');
