<?php
include('dbConnection.php');
include('functions.php');
include('security.php');
header("Content-type: application/octet-stream");
header("Content-Disposition: attachment; filename=OnTimeDelivery.xls");
header("Pragma: no-cache");
header("Expires: 0");
$start_date=$_GET['start_date'];
$end_date=$_GET['end_date'];
$customer=$_GET['customer'];
$part=$_GET['part'];
$searchjob=$_GET['searchjob'];
print "Customer\tSales Order\tCustomer PO\tPO Line\tOrder Date\tPart\tOrder Qty\tDate Due\tLast Shipped\tOTD\n";
include('onTimeDeliverySub.php');
foreach ($rs as $data) {
	$order=$data['order_id'];
	$item=$data['item_id'];
	$customerID=$data['customer_id'];
	$customerName=$data['name'];
	$poNumber=$data['po_number'];
	$due=$data['due_date'];
	$poLine=$data['po_line'];
	$status=$data['status'];
	$qty=$data['quantity'];
	$odt=formatDateDBToWeb($data['date_order']);
	$shipped=0;
	$orderLine=$data['line_id'];
	$totqty+=$qty;
	## change this to fnd=0 in order to only show late order line
	$fnd=1;
	$dt="";
	## if the line is overdue, just count it, not shipments.
	$shipments="<table><tr><td>Date</td><td align='right'>Quantity</td><td align='right'>Days Late</td></tr>";
	$sql="select DATE(date_shipped) as dc, sum(quantity) as sumqty from packing_slip p, packing_slip_lines l where order_line = ? and packing_list_id=packing_slip_id and shipped=1 group by DATE(date_shipped)  ";
	list($srs,$err)=runIQuery($db,$sql,array("i",$orderLine));
	$onTime=1;
	$dl=0;
	if (count($srs) > 0) {
		## count the additional shipments - but already counted first one
		$totalShipments+=count($srs)-1;
		foreach ($srs as $sdata) {
			$sqty=$sdata['sumqty'];
			$shipped+=$sqty;
			$dt=$sdata['dc'];
			if ($dt=="0000-00-00") {
				$sql="select DATE(date_printed) from packing_slip_lines l, packing_slip p where order_line = ? and l.packing_list_id=p.packing_slip_id";
				list($prs,$err)=runIQuery($db,$sql,array("i",$orderLine));
				$pdata=$prs[0];
				$dt=$pdata[0];
			}
			if ($dt > $due) {
				$onTime=0;
				$dl=BusinessDaysDifferent($due,$dt);
				$daysLate+=$dl;
				$totalLateShipments++;					
			} else {
				$onTimeQty+=$sqty;				
			}
			if ($showdetail) {
				$shipments.="<tr><td>";
				$shipments.=formatDateDBToWeb($dt);
				$shipments.="</td>";
				$shipments.="<td>";
				$shipments.=$sqty;
				$shipments.="</td>";
				$shipments.="<td align='right'>";
				if($dt > $due) {
					$shipments.="<font color='red'>";
					$shipments.=abs($dl);
					$shipments.="</font>";
				} else {
					$shipments.="On Time";
				}
				$shipments.="</td></tr>";
			}
		}
	} else {
		$sql="select DATE(date_printed) from packing_slip_lines l, packing_slip p where order_line = ? and l.packing_list_id=p.packing_slip_id";
		list($prs,$err)=runIQuery($db,$sql,array("i",$orderLine));
		$pdata=$prs[0];
		$dt=$pdata[0];
	}
	if ($shipped < $qty ) {
		$dl=BusinessDaysDifferent($due, Date("Y-m-d"));
		if ($dl < 0) {
			$diff=$qty - $shipped;
			$daysLate+=BusinessDaysDifferent($due, Date("Y-m-d"));
			$totalShipments++;
			$totalLateShipments++;					
			if ($showdetail) {
				$shipments.="<tr><td>";
				$shipments.="Not Shipped";
				$shipments.="</td>";
				$shipments.="<td>";
				$shipments.=$diff;
				$shipments.="</td>";
				$shipments.="<td align='right'>";
				if ($status == 3) {
					$shipments.= "Order Closed";
				} else {
					$shipments.="<font color='red'>";
					$shipments.=abs($dl);
					$shipments.="</font>";
				}
				$shipments.="</td></tr>";
				$fnd=1;
			}
		}
	}
	$shipments.="</table>";
	print "$customerName\t$order\t$poNumber\t$poLine\t$odt\t$item\t$qty\t";
	print formatDateDBToWeb($due);
	print "\t";
	if ($dt) {
		$dt=formatDateDBToWeb($dt);
	}
	print $dt;
	print "\t";
	if ($onTime) {
		if ($dt) {
			print "On Time";
		}
	} else {
		if ($status == 3 and $dl >= 0) {
			print "Closed";
		} else {
			print "Late";
		}
	}
	print "\n";
}
