<?php
$expanded=1;
$locked=0;
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');

$ed=AddBusinessDays(Date("Y-m-d"),35);
$end_date=formatDateDbToWeb($ed);

if (isset($_GET['color'])) {
	$color=$_GET['color'];
	$end_date=$_GET['end_date'];
	$group=$_GET['group'];
}
print renderPanel("MRP- POWDER Option Selection");
print "<form action='mrpPowder.php' name='findform' method='GET'>";
$sql="select vc_id, concat(color_code, '-', color_description, '-', vendor_name) as color_name from vendor_colors vc, vendors v where vc.vendor_id=v.vendor_id order by color_code, vendor_name";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"powder",$color,"Powder","N",$rs,1);
print renderDateBox(TRUE,"end_date",$end_date,"Through Date");
print "<div class='btn green' onclick='document.findform.submit();'>Find</div>";
print "<div class='btn  blue' onclick='exportReport();'>Export</div>";
print "<div class='btn  red' onclick='createPO();'>Create PO For Selected</div>";
print "</form>\n";
print renderClosePanel();

include('mrpPowderSub.php');
$headerWritten=0;
foreach ($missingRS as $data) {
	$item=$data['item_id'];
	$length=$data['length'];
	$width=$data['width'];
	if (! $headerWritten) {
		print renderPanel("Missing X and Y");
		print "<p>The following items have color selected but no length and/or no width.</p>";
		print "<table class='table'><thead><tr><th>Item</th><th>Length</th><th>Width</th></tr></thead><tbody>";
		$headerWritten=1;
	}
	print "<tr><td><a href='editRecipe.php?name=$item' target='_blank'>$item</td><td>$length</td><td>$width</td></tr>\n";
}
if ($headerWritten) {
	print "</tbody></table>\n";
	print renderClosePanel();
}
print renderPanel("MRP POWDER - Results");
print "<p>The short quantity is always moved up to a whole pound figure.</p>";
$coverageNeeded=array();
$codes=array();
$quantityOnHand=array();
foreach ($rs as $data) {
	$item=$data['item_id'];
	$length=$data['length'];
	$width=$data['width'];
	$pc=$data['powder_color'];
	$prc=$data['primer_color'];
	$powder=$data['color_code'];
	$primer=$data['primer_code'];
	$quantity=$data['quantity_scheduled'] - $data['quantity_good'];
	$onhand=$data['quantity_on_hand'];
	if ($onhand < 0) {
		$onhand=0;
	}
	$surfaceArea=$quantity * $length * $width * 2;
	if ($powder) {
		if (isset($coverageNeeded[$powder])) {
			$coverageNeeded[$powder]+=$surfaceArea;
		} else {
			$coverageNeeded[$powder]=$surfaceArea;
		}
		$codes[$powder]=$pc;
		$quantityOnHand[$powder]=$onhand;
	}
	if ($powder) {
		if (isset($coverageNeeded[$primer])) {
			$coverageNeeded[$primer]+=$surfaceArea;
		} else {
			$coverageNeeded[$primer]=$surfaceArea;
		}
		$codes[$primer]=$prc;
		$quantityOnHand[$primer]=$onhand;
	}   
}
ksort($coverageNeeded);
print "<form name='purchaseform' action='createPOFromPowderMRP.php' method='POST' target='_blank'>";
print "<table class='table'><thead><tr><th>Powder</th><th>Surface Area Need (square feet)</th><th>Pound Coverage</th><th>Pounds Needed</th><th>Stocked</th><th>On Hand</th><th>Short</th><th>Vendor Part</th><th>Select</th></tr>\n</thead><tbody>";
$i=0;
foreach ($coverageNeeded as $key => $value) {
	$vc=$codes[$key];
	foreach ($colorRS as $data) {
		if ($data['vc_id'] == $vc) {
			$description=$data['color_description'];
			$gloss=$data['gloss'];
			$texture=$data['texture'];
			$vendorPart=$data['vendor_part'];
			$coverage=$data['pound_coverage'];
			$stocked=$data['stocked'];
			$needed=round($value / 144 / $coverage,2);
			$area=$value / 144;
			print "<tr><td>$key $description $gloss $texture</td><td>$area</td><td>$coverage</td><td>$needed</td><td>";
			if (! $stocked) {
				print "NO";
			}
			print "</td>";
			$onhand=$quantityOnHand[$key];
			$short=$onhand - $needed;
			if ($short > 0) {
				$short="";
			} else {
				$short=floor($short);
				$short=abs($short);
			}
			print "<td>$onhand</td><td style='color: red;'>$short</td>";
			print "</td><td>$vendorPart</td>";
			$i++;
			print "<td><input type='hidden' name='part$i' value='$vendorPart'><input type='hidden' name='vc$i' value='$vc'>";
			if ($short) {
				print "<input type='checkbox' name='sel$i' value='$short'>";
			}
			print "</tr>\n";
		}
	}
}
print "<input type='hidden' name='totalrows' value='$i'>";
print "</form>";
?>
<script>
	function exportReport() {
		window.open('mrpPowderExport.php?end_date=<?=$end_date?>&group=<?=$group?>&negative=<?=$negative?>&part_prefix=<?=$partPrefix?>','exporter');
	}
	function page_init() {
		alert('??');
	  $('.datepicker').datepicker();
	}
    function createPO() {
        document.purchaseform.submit();
    }
</script>
<?php
print closePanel();
include('footer.php');
?>