<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
include('header.php');
$title="Missing Items";
print renderPanel($title,"","green");
print "<p>Below are all items that are on sales orders that are NOT in the inventory master.</p>";
print "<table class='table table-striped'><thead><tr><th>Item Number</th><th>Description</th><th>Sales Order</th><th>Due Date</th><th>Order Status</th><th>Quantity</th><th>Shipped Qty</th></tr>\n";
print "</thead><tbody>";
$sql="select l.*, status_name from order_lines l inner join orders o on l.order_id=o.order_id inner join order_status s on o.status=s.status_id ";
$sql.=" left outer join items i on l.item_id=i.item_name where  i.item_name is null and o.status not in (3,4,5) and coalesce(shipped_quantity,0) < quantity ";
$sql.=" and l.item_id <> 'MISCELLANEOUS' ";
$sql.=" and (o.status <> 6 or due_date > DATE_SUB(CURDATE(),INTERVAL 90 DAY)) ";
$sql.=" order by l.item_id ";
list($rs,$err)=runIQuery($db,$sql);
foreach ($rs as $data) {
    print "<tr>";
    print "<td valign='top'>";
    print $data['item_id'];
    print "</td>";
    print "<td valign='top'>";
    print $data['item_description'];
    print "</td>";
    print "<td valign='top'>";
    print "<a href='editOrders.php?id=" . $data['order_id'] . "' target='_blank'>";
    print $data['order_id'];
    print "</a>";
    print "</td>";
    print "<td valign='top'>";
    print formatDateDBToWeb($data['due_date']);
    print "</td>";
    print "<td valign='top'>";
    print $data['status_name'];
    print "</td>";
    print "<td valign='top'>";
    print $data['quantity'];
    print "</td>";
    print "<td valign='top'>";
    print $data['shipped_quantity'];
    print "</td>";
    print "</tr>\n";
}
print "</tbody></table>\n";
print renderClosePanel();
include('footer.php');