<?php
include("dbConnection.php");
include("functions.php");
include("security.php");
include("header.php");
include("machineDB.php");
$apply=0;
if (isset($_GET["apply"])) {
    $apply=$_GET["apply"];
}

print "<div id='confModal' class='modal fade' role='dialog'>
	<div class='modal-dialog'>
		<div class='modal-content'>
			<div class='modal-header'><h4 class='modal-title confTitle'></h4></div>
			<div class='modal-body'>
				<span class='confBody'></span>
			</div>
			<div class='modal-footer'>
				<button class='btn green' data-dismiss='modal' onclick='confInput(true)'>Yes</button>
				<button class='btn red' data-dismiss='modal' onclick='confInput(false)'>No</button>
			</div>
		</div>
	</div>
</div>";

function highlightQuery($sql) {
    return preg_replace_callback("/(\/\*.*?\*\/)|(\d+|\".*?\"|'.*?')|(=|<>|COUNT|MAX|MIN|DELETE FROM |INSERT INTO | IN|VALUES|UPDATE |SELECT | SET| FROM | LEFT OUTER JOIN | LEFT JOIN | INNER JOIN | ON | WHERE |IS NULL|GROUP BY|ORDER BY)/i", function($str) {
        $color="red";
        $val = $str[0];
        if (preg_match("(\d+|\".*?\"|'.*?')", $val)) {
            $color="orange";
        }
        if (preg_match("(\/\*.*?\*\/)", $val)) {
            $color="gray";
        }
        return "<span style='color: $color;'>$val</span>";
    }, $sql);
}


print renderPanel("PO Changes " . ($apply ? "Applied" : "Preview"));
if (!$apply) print renderButton("Apply", "red", "applyFixes();");

print "<table class='table table-condensed table-bordered'>";

$sql = "select * from purchase_orders where status in (1,3) and date_po_created > '2022-12-20'";
list($prs,$err)=runIQuery($machineDB,$sql);

$sql = "select * from po_lines where po_id in (select po_id from purchase_orders where status in (1,3) and date_po_created > '2022-12-20')";
list($plrs,$err)=runIQuery($machineDB,$sql);

$pos = [];
foreach ($prs as $po) {
    $po["lines"] = [];
    $pos[$po["po_id"]] = $po;
}

foreach ($plrs as $pol) {
    $pos[$pol["po_id"]]["lines"][] = $pol;
}

foreach ($pos as $former_po_id => $po) {
    $vendor = $po["vendor_id"];

    print "<tr><td><b>Merging Machine PO $former_po_id to Weld</b></td></tr>";

    $sql = "select po_id from purchase_orders where former_po_id=$former_po_id";
    list($frs,$err)=runIQuery($db,$sql);
    if (count($frs)) {
        print "<tr><td><b>PO Already merged, Skipping</b></td></tr>";
        continue;
    }

    $sql = "select * from vendors where vendor_id=$vendor";
    list($mvrs,$err)=runIQuery($machineDB,$sql);

    if (count($mvrs)) {
        $vendor_name = $mvrs[0]["vendor_name"];
        $sql = "select * from vendors where vendor_name='$vendor_name'";
        list($wrs,$err)=runIQuery($db,$sql);

        if (count($wrs)) {
            $vendor_id = $wrs[0]["vendor_id"];
        } else {
            print "<tr><td><b>Vendor doesn't exist in Weld, Creating</b></td></tr>";
            // create vendor
            $data = $mvrs[0];
            $vendor_name = $data["vendor_name"];
            $address = $data["address"];
            $city = $data["city"];
            $state = $data["state"];
            $zip = $data["zip"];
            $phone = $data["phone"];
            $email = $data["email"];
            $fax = $data["fax"];
            $terms = $data["terms"];
            $lead_time = $data["lead_time"];
            $paint_vendor = 0; // not sure what to default it to, cannot be null in the DB
            $quickbooks_name = $data["quickbooks_name"];
            $quickbooks_part = $data["quickbooks_part"];
            $transfer_email = $data["transfer_email"];
            $op_vendor = $data["op_vendor"];
            $vendor_mileage = $data["vendor_mileage"];
            $can_see_customer_name = $data["can_see_customer_name"];
            $finish_vendor = $data["finish_vendor"];
            $paint_vendor=$finish_vendor;

            $sql = "INSERT INTO vendors (vendor_name, address, city, state, zip, phone, email, fax, terms, lead_time, quickbooks_name, paint_vendor, quickbooks_part, transfer_email, op_vendor, vendor_mileage, can_see_customer_name, finish_vendor) VALUES (::vendor_name, ::address, ::city, ::state, ::zip, ::phone, ::email, ::fax, ::terms, ::lead_time, ::quickbooks_name, ::paint_vendor, ::quickbooks_part, ::transfer_email, ::op_vendor, ::vendor_mileage, ::can_see_customer_name, ::finish_vendor);";

            if ($apply) {
                list($rs,$err)=runNamedQuery($db,$sql,compact("vendor_name", "address", "city", "state", "zip", "phone", "email", "fax", "terms", "lead_time", "quickbooks_name", "paint_vendor", "quickbooks_part", "transfer_email", "op_vendor", "vendor_mileage", "can_see_customer_name", "finish_vendor"));
                print $err;
            }

            print "<tr><td>";
            print highlightQuery(renderNamedQuery($sql,compact("vendor_name", "address", "city", "state", "zip", "phone", "email", "fax", "terms", "lead_time", "quickbooks_name", "paint_vendor", "quickbooks_part", "transfer_email", "op_vendor", "vendor_mileage", "can_see_customer_name", "finish_vendor")));
            print "</td></tr>";

            if ($apply) {
                $vendor_id = $rs[0]["id"];
            } else {
                $vendor_id = 'tmp';
            }
        }
    }

    $po_date = $po["date_po_created"];
    $who = $po["who"];
    $ship_name = $po["ship_name"];
    $ship_address = $po["ship_address"];
    $ship_city = $po["ship_city"];
    $ship_state = $po["ship_state"];
    $ship_zip = $po["ship_zip"];
    $notes_to_vendor = $po["notes_to_vendor"];
    $notes_to_self = $po["notes_to_self"];
    $status = $po["status"];
    $job_id = $po["job_id"];
    $phone = $po["phone"];
    $terms = "";
    $quickbooks_po_number = 0;
    $date_due = $po["po_date"];
    $reference = $po["sales_order"];
    $sales_order = $po["sales_order"];
    $date_po_created = $po["date_po_created"];

    $sql = "INSERT INTO purchase_orders (vendor_id, po_date, who, ship_name, ship_address, ship_city, ship_state, ship_zip, notes_to_vendor, notes_to_self, status, job_id, phone, terms, quickbooks_po_number, date_due, reference, sales_order, date_po_created, former_po_id) VALUES (::vendor_id, ::po_date, ::who, ::ship_name, ::ship_address, ::ship_city, ::ship_state, ::ship_zip, ::notes_to_vendor, ::notes_to_self, ::status, ::job_id, ::phone, ::terms, ::quickbooks_po_number, ::date_due, ::reference, ::sales_order, ::date_po_created, ::former_po_id);";

    print "<tr><td><b>Creating PO</b></td></tr>";

    if ($apply) {
        list($rs,$err)=runNamedQuery($db,$sql,compact("vendor_id", "po_date", "who", "ship_name", "ship_address", "ship_city", "ship_state", "ship_zip", "notes_to_vendor", "notes_to_self", "status", "job_id", "phone", "terms", "quickbooks_po_number", "date_due", "reference", "sales_order", "date_po_created", "former_po_id"));
        print $err;
    }

    print "<tr><td>";
    print highlightQuery(renderNamedQuery($sql,compact("vendor_id", "po_date", "who", "ship_name", "ship_address", "ship_city", "ship_state", "ship_zip", "notes_to_vendor", "notes_to_self", "status", "job_id", "phone", "terms", "quickbooks_po_number", "date_due", "reference", "sales_order", "date_po_created", "former_po_id")));
    print "</td></tr>";


    $po_id=0;
    if ($apply) {
        $po_id = $rs[0]["id"];
    } else {
        $po_id = "tmpid";
    }

    print "<tr><td><b>Adding PO Lines (if any) to PO $po_id</b></td></tr>";
    foreach ($po["lines"] as $line) {
        $item_id = $line["item_id"];
        $description = $line["description"];
        $quantity = $line["quantity"];
        $price = $line["price"];
        $quantity_received = $line["quantity_received"];
        $date_expected = $line["date_expected"];
        $job_id = NULL;
        $order_line = 0;
        $operation_id = NULL;
        $routing_id = NULL;
        $revision = $line["revision"];
        $folder_number = $line["folder_number"];
        $vendor_part = $line["vendor_part"];
        // TODO: Check if the item exists, if not, create? Not sure
        // if creating we will need to merge the items table as well
        $sql="select item_id from items where item_name=?";
        list($rs,$err)=runIQuery($db,$sql,array("s",$item_id));
        if (count($rs)>0) {
            ## part exists, we can add the line
            $item_id=$rs[0][0];

            $sql = "INSERT INTO po_lines (po_id, item_id, revision, description, quantity, price, quantity_received, date_expected, job_id, order_line, operation_id, routing_id, folder_number, vendor_part) VALUES (::po_id, ::item_id, ::revision, ::description, ::quantity, ::price, ::quantity_received, ::date_expected, ::job_id, ::order_line, ::operation_id, ::routing_id, ::folder_number, ::vendor_part);";
            if ($apply) {
                list($rs,$err)=runNamedQuery($db,$sql,compact("po_id", "item_id", "revision", "description", "quantity", "price", "quantity_received", "date_expected", "job_id", "order_line", "operation_id", "routing_id", "folder_number", "vendor_part"));
                print $err;
            }
            print "<tr><td>";
            print highlightQuery(renderNamedQuery($sql,compact("po_id", "item_id", "revision", "description", "quantity", "price", "quantity_received", "date_expected", "job_id", "order_line", "operation_id", "routing_id", "folder_number", "vendor_part")));
            print "</td></tr>";
    
        } else {
            print "<tr><td>could not find $item_id</td></tr>";
        }

    }
    print "<tr><td></td></tr><tr><td></td></tr>";
}

print "<tr><td><b>Finished</b></td></tr>";

print "</table>";
print renderClosePanel();

include("footer.php");
?>
<script>
function confirmModal(title,body,cb=function(){}) {
	$("#confModal .confTitle").text(title);
	$("#confModal .confBody").html(body);
	window.confInput = cb;
	$("#confModal").modal("show");
}

function applyFixes() {
    confirmModal("Apply PO Changes?", "Are you sure you want to apply these changes?", function(yes) {
        if (yes) {
            window.location.href = "mergePOs.php?apply=1";
        }
    });
}
</script>