<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
include('header.php');

## need to update prices  each time
if (! $isAdmin) {
    exit;
}
$lengths=array();
$widths=array();
$prices=array();
$parts=array();
$parts[]='B00030209A';
$parts[]='B00030209B';
$parts[]='J02501501F';
$parts[]='J02501501G';
$lengths['J02501501F']=145;
$widths['J02501501F']=60;
$prices['J02501501F']=300.684;

$lengths['J02501501G']=145;
$widths['J02501501G']=60;
$prices['J02501501G']=300.684;

$lengths['B00030209A']=145;
$widths['B00030209A']=60;
$prices['B00030209A']=300.684;

$lengths['B00030209B']=145;
$widths['B00030209B']=60;
$prices['B00030209B']=300.684;

function getMaterials($db,$part,$quantityPer) {
    global $lengths, $width, $prices,$parts;
    $price=0;
    $sql="select * from billofmaterial where parent_item=?";
    list($mrs,$err)=runIQuery($db,$sql,array("s",$part));
    foreach ($mrs as $mdata) {
        $child=$mdata['child_item'];
        $qper=$mdata['quantity_per'];
        $sql="select * from  items where item_name=?";
        list($crs,$err)=runIQuery($db,$sql,array("s",$child));
        $cdata=$crs[0];
        $cprice=$cdata['price'];
        $length=$cdata['length'];
        $width=$cdata['width'];
        if ($cdata['item_category']==24) {
            $price+=($cprice * $qper * $quantityPer);
        } else {
            if (strstr($child,"-PURCHASE" and ($length >= 120 or $width >= 120) )) {
                list($base,$purchase)=explode("-",$child);
                $mlength=$lengths[$base];
                $mwidth=$widths[$base];
                $mprice=$prices[$base];
                $marea=$mlength * $mwdith;
                if ($marea > 0) {
                    $area=$length * $width;
                    $price+= ($area / $marea) * $mprice;
                }
            } else {
                $price+=getMaterials($db,$child,$qper*$quantityPer);
            }
        }
    }
    return $price;
}
print renderPanel("Material Price Percent");
print renderButton("Export","blue","window.open('exportMaterialPricePercent.php','_blank');");
print "<center>Material Price Percent - DEMATIC</center>";
print "<table class='table table-striped'>";
print "<thead><tr><th>Finished Good</th><th>Price</th><th>Material Price</th><th>Percentage</th></tr></thead><tbody>";
## get all finished goods for dematic.   Then get the sum of all sheet  stock in the BOM (category 24)
$sql="select * from items where customer_id=693 and item_category = 20 order by item_name";
list($rs,$err)=runIQuery($db,$sql);
foreach ($rs as $data) {
    $fg=$data['item_name'];
    $fgPrice=$data['price'];
    print "<tr><td>$fg</td><td>$fgPrice</td>";
    if ($fgPrice > 0) {
        $materialPrice=getMaterials($db,$fg,1);
        $pct=round($materialPrice/$fgPrice*100,1);
        print "<td>$materialPrice</td><td>$pct</td>";
    } else {
        print "<td colspan=2>Zero FG Price</td>";
    }
    print "</tr>\n";
}
print "</tbody>";
print "</table>";
print renderClosePanel();
include('footer.php');
