<?php
$expanded=1;
$locked=0;
include('dbConnection.php');
include('security.php');
include('functions.php');
$pageTitle="Management Efficiency";
include('header.php');
if (strtolower($userEmail)=="corywind@preferredmachinellc.com") {
	$isAdmin=1;
}
if (! $isAdmin) {
    print "<script>document.location.href='index.php';</script>\n";
    exit;
}
$start_date=Date("m/d/Y");
$end_date=$start_date;
if (isset($_GET['start_date'])) {
	$start_date=$_GET['start_date'];
}
if (isset($_GET['end_date'])) {
	$end_date=$_GET['end_date'];
}

$sql="select count(*) from employees where department_id=5 and inactive=0";
list($lcrs,$err)=runIQuery($db,$sql);
$shippingEmployees=$lcrs[0][0];

$sd=formatDateWebToDB($start_date);
$ed=formatDateWebToDB($end_date);

print renderPanel("Management Efficiency","","primary");
print "<form name='listform' method='GET' action='managementEfficiency.php'>\n";
print renderDateBox(TRUE,"start_date",$start_date,"Start Date");
print renderDateBox(TRUE,"end_date",$end_date,"End Date");
print renderButton("Find","success","document.listform.submit();");
print "<a href='#' id='downloader'>" . renderButton("Export","primary","tableToTab('exportTable','ManagementEfficiency.xls')") . "</a>";
print "</form>";
print "<div style='clear: both;'></div>\n";
print "<table id='exportTable' class='table-bordered table-striped table-condensed flip-content'>";
print "<thead>";
print "<tr>";
print "<th valign='top'>";
print "Department";
print "</th>";
print "<th valign='top'>";
print "Lead Email";
print "</th>";
print "<th valign='top'>";
print "Efficiency %";
print "</th>";
print "<th valign='top'>";
print "% To Plan";
print "</th>";
print "<th valign='top'>";
print "KPI %";
print "</th>";
print "</tr>\n";
print "</thead>";
print "<tbody>";
$sql="select department_id, department_name, lead_email from departments where department_id not in (8,9,10,12,16,17) order by department_name ";
list($rs,$err)=runIQuery($db,$sql);
$departmentCount=0;
$totalKPI=0;
foreach ($rs as $data) {
    set_time_limit(100);
    $departmentCount++;
    $department=$data['department_id'];
    $departmentName=$data['department_name'];
    $lead=$data['lead_email'];
    print "<tr><td>$departmentName</td><td>$lead</td>";
    $sql="select e.last_name, e.first_name, sum(regular_minutes + ot_minutes) as clock_minutes, p.employee_id, ";
    $sql.=" e.card_number from clock_punches p left outer join employees e on p.employee_id=e.employee_id left outer join departments d on e.department_id=d.department_id ";
    $sql.=" where  in_date >= '$sd' and out_date <= '$ed' and e.inactive=0 and e.department_id=$department";
    $sql.= " group by e.last_name, e.first_name, p.employee_id ";
    $sql.=" order by e.last_name, e.first_name ";
    list($ers,$err)=runIQuery($db,$sql);
    $lc=0;
    $totalEffPct=0;
    $totalPlanPct=0;
    foreach ($ers as $edata) {
        set_time_limit(100);
        $lc++;
        $last=$edata['last_name'];
        $first=$edata['first_name'];
        $employee=$edata['employee_id'];
        $clock=$edata['clock_minutes'];
        $sql="select  sum(r.minutes) as production_minutes from production_results r ";
        $sql.=" left outer join employees e on r.employee_id=e.card_number  left outer join operations o on r.operation_id=o.operation_id ";
        $sql.=" where result_date >= '$sd' and result_date <= '$ed' and e.employee_id=$employee ";
        $sql.=" and o.operation_id not in (60,61,79,80,81,83,86,87,91,93) ";
        list($prs,$err)=runIQuery($db,$sql);
        $productionMinutes=$prs[0][0];
        $sql="select  sum(r.minutes) as production_minutes from production_results r ";
        $sql.=" left outer join employees e on r.employee_id=e.card_number  left outer join operations o on r.operation_id=o.operation_id ";
        $sql.=" where result_date >= '$sd' and result_date <= '$ed' and e.employee_id=$employee  ";
        list($prs,$err)=runIQuery($db,$sql);
        $pr=$prs[0][0];
        if ($department == 5) {
            ## shipping
            #print "<script>document.location.href='shippingPerformance.php?start_date=$start_date&end_date=$end_date';</script>\n";
            $sql="select count(*) as document_count from packing_slip p inner join site_admins a on shipped_by=user_id  ";
            $sql.=" where DATE(date_shipped) >= ? and DATE(date_shipped) <= ? ";
            $sql.=" and employee_link=$employee  ";
            list($shiprs,$err)=runIQuery($db,$sql,array("ss",$sd,$ed));
            $qty=$shiprs[0][0];
            $sql="select count(*) as document_count from transfers t inner join site_admins s on coalesce(transferred_by,0)=user_id  ";
            $sql.=" where DATE(coalesce(transfer_date,date_created)) >= ? and DATE(coalesce(transfer_date,date_created)) <= ? ";
            $sql.=" and employee_link=$employee ";
            list($shiprs,$err)=runIQuery($db,$sql,array("ss",$sd,$ed));
            $qty+=$shiprs[0][0];
            $hours=0;
            $pph=0;
            if (is_numeric($clock)) {
                $hours = $clock / 60;
                $pph=round($qty/$hours,1);
            }
            $planpct=round($pph/4*100,1);
        } else {
            if ($department == 4) {
                $sql="select  sum(ABS(quantity)) as dailytotal from staging_bay_history h, site_admins a ";
                $sql.=" where  DATE(h.date_loaded) >= '$sd' and DATE(h.date_loaded) <= '$ed' and h.action ='LOAD' and h.user_id=a.user_id  ";
                $sql.=" and a.employee_link=$employee ";
                list($srs,$err)=runIQuery($db,$sql);
                $qty=$srs[0][0];
                $hours=round($clock/60,2);
                $pph=round($qty/$hours,0);
                $planpct=round($pph/300*100,1);
            } else {
                if ($department == 3 or $department == 15 or $department == 17) {
                    ## step 1 and 2
                    if ($pr == 0) {
                        ## they shut off production results
                        $sql="select sum(elapsed_seconds) as seconds from engineering_activity a ";
                        $sql.=" inner join site_admins sa on sa.user_id=a.user_id and sa.employee_link=$employee ";
                        $sql.=" and date(date_posted) >= ? and date(date_posted) <= ? ";
                        $sql.=" and first_entry=0 and activity <> 'RESUME' ";
                        list($ors,$err)=runIQuery($db,$sql,array("ss",$sd,$ed));
                        $pr=round($ors[0][0]/60);
                    }
                    $sql="select distinct a.notes from engineering_activity a  ";
                    $sql.=" inner join site_admins sa on a.user_id=sa.user_id and sa.employee_link=$employee ";
                    $sql.=" where activity in ('Saved Quoted Part','Add DXF', 'CREATED SO') ";
                    $sql.=" and date(a.date_loaded) >= ? and date(a.date_loaded) <= ? ";
                    list($ors,$err)=runIQuery($db,$sql,array("ss",$sd,$ed));
                    $lines=count($ors);
                    $hours=$pr/60;
                    $pph=round($lines/$hours,1);
                    $factor=16;
                    if ($department == 15) {
                        $factor=30;
                    }
                    $planpct=round($pph/$factor*100,1);
                } else {
                    if ($department == 7 or $department == 14 ) {
                        $sql="select  sum(r.quantity_good + r.scrap) as quantity_sort from production_results r ";
                        $sql.=" left outer join employees e on r.employee_id=e.card_number and e.employee_id=$employee ";
                        $sql.=" where result_date >= '$sd' and result_date <= '$ed' ";
                        $sql.=" and r.operation_id not in (60, 61) ";
                        list($prs,$err)=runIQuery($db,$sql);
                        foreach ($prs as $pdata) {
                            $pqty=$pdata['quantity_sort'];
                            $phours=$clock/60;
                            $pph=$pqty/$phours;
                            $planpct=round($pph/35*100,1);
                        }
                    } else {
                        $sql="select job_id, item_name, setup, per_part,  quantity_good from employees e ";
                        $sql.=" left outer join production_results r on e.card_number=r.employee_id and item_name <> 'ALL' and quantity_good <> 0 ";
                        $sql.=" left outer join operations op on r.operation_id=op.operation_id";
                        $sql.=" left outer join operation_times t on op.operation_name=t.operation and  r.item_name=t.part_number ";
                        $sql.=" where e.employee_id=$employee  ";
                        $sql.=" and date(r.result_date) >= ? and date(r.result_date) <= ?";
                        $sql.=" order by job_id, item_name ";
                        //print "$sql<br>";
                        list($ors,$err)=runIQuery($db,$sql,array("ss",$sd,$ed));
                        //print count($ors);
                        //print "<br>";
                        $planned=0;
                        $holdJob=0;
                        $holdItem="";
                        foreach ($ors as $odata) {
                            $job=$odata['job_id'];
                            $item=$odata['item_name'];
                            if ($job != $holdJob or $item != $holdItem) {
                                $planned+=$odata['setup'];
                                $holdJob=$job;
                                $holdItem=$item;
                            }
                            $qty=$odata['quantity_good'];
                            $pp=$odata['per_part'];
                            $seconds=$qty*$pp;
                            $planned+=$seconds;
                        }
                        //print "planned is $planned <br>";
                        $planned=$planned/60;
                        $planpct=0;
                        if ($planned > 0 and $pr > 0) {
                            $planpct=round($planned / $pr * 100,1);
                        }
                    }
                }
            }
        }
        $eff=0;
        if ($clock) {
            $eff=round($pr/$clock*100,1);
        }
        $totalEffPct+=$eff;
        //print "$departmentName added $eff to total Efficiency<br>";
        $totalPlanPct+=$planpct;
        //print "$departmentName added $planpct to total plan<br>";
     }
     $eff=round($totalEffPct/$lc,1);
     $planpct=round($totalPlanPct/$lc,1);
     $kpi=round(($eff + $planpct)/2);
     print "<td>$eff %</td>";
     print "<td>$planpct %</td>";
     print "<td>$kpi %</td>";
     print "</tr>\n";
}
print "</tbody></table>";
print renderClosePanel();
?>
<script>
function page_init() {
	$('.datepicker').datepicker();
}
function exportForm() {
	document.listform.action='employeeEfficiencyExport.php';
	document.listform.target='_blank';
	document.listform.submit();
	document.listform.action='employeeEfficiency.php';
	document.listform.target='_self';
}

function tableToTab(tableid, filename="download.xls") {
	var csv = "";
	var rows = $("#"+tableid+" tr");

	for(var i = 0; rows.length > i; i++) {
		var row = rows[i].innerText.replace(/\n/g," ");
		csv += row + "\n";
	}

	var a = document.getElementById("downloader");
	var file = new Blob([csv], {type: 'text/plain'});
	a.href = URL.createObjectURL(file);
	a.download = filename;
}
</script>
<?php
include('footer.php');
?>