<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('functions.php');
include('security.php');
$pageTitle="Manage Eagle Skip Jobs";
include('header.php');
print renderPanel("Jobs to Skip Sending to the Eagle");
$days=75;
#push unless status in 3,4,5,6
#  use jobs that have operation laser
# within +75 business days
# width and length must be less than or equal to 120.2
# if material is a cut in house

$skiplist=array();
$sql="select job_id from skip_laser_jobs ";
list($rs,$err)=runIQuery($db,$sql);
foreach($rs as $data) {
    $skiplist[]=$data['job_id'];
}
$materials=array();
$sql="select item_id, item_name from items where item_category=24";
list($rs,$err)=runIQuery($db,$sql);
foreach ($rs as $data) {
    $id=$data['item_id'];
    $material=$data['item_name'];
    $materials[$id]=$material;
}


$sql="select c.customer_id, c.name, j.job_id, j.item_id, j.description, j.start_date, j.quantity_scheduled, i.item_id as material, i.thickness, l.order_id";
$sql.=" from jobs j inner join order_lines l on j.line_id=l.line_id inner join routing r on j.item_id=parent_part and operation_id=3123 ";
$sql.=" inner join customers c on j.customer_id=c.customer_id ";
$sql.=" inner join orders o on l.order_id=o.order_id and o.status  not in (3,4,5,6)";
$sql.=" inner join billofmaterial b on j.item_id=parent_item  and r.routing_id=b.routing_id ";
$sql.=" inner join items i on b.child_item=i.item_name and i.item_category=24 ";
$sql.=" where j.status in (1,2)  ";
$sql.=" and i.width <= 120.2 and i.length <= 120.2 ";
$sql.=" and l.inhouse_decision='INTERNAL' ";
#$sql.=" and j.job_id not in (select job_id from skip_laser_jobs) ";
list($rs,$err)=runIQuery($db,$sql);
print "<table class='table table-striped'><thead><th>Skip</th><th>WO</th><th>Part</th><th>Description</th><th>Date</th><th>Quantity</th><th>Material</th><th>SO</th></thead><tbody>";
foreach ($rs as $data) {
	$job=$data['job_id'];
	$dt=formatDateDBToWeb($data['start_date']);
	$line=$data['line_id'];	
	$folder=$data['order_id'];
	$item=$data['item_id'];	
	$shortItem=$item;
	$desc=$data['description'];
	$qty=$data['quantity_scheduled'];
	$material=$data['material'];
    $checked="";
    if (in_array($job,$skiplist)) {
        $checked="checked";
    }
    print "<tr><td><input type='checkbox' value='$job' id='sel$job' $checked onclick=\"checkSelect(this,'$job');\"><td>$job</td><td>$item</td><td>$desc</td><td>$dt</td><td>$qty</td><td>" . $materials[$material] . "</td><td>$folder</td></tr>\n";
}
print "</tbody></table>\n";
?>
<script>
    function checkSelect(obj,jobno) {
        url='checkEagleJob.php?job='+jobno+'&rand='+Math.random();
        if (obj.checked) {
            url=url+'&skip=1';
        } else {
            url=url+'&skip=0';
        }
        $.ajax(url);
    }
    function page_init() {
    }
</script>
<?php
include('footer.php');