<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
include('header.php');
print renderPanel("Scheduled Maintenance Tasks","","green","span11","calendar");
print "<form name='searchform' method='POST' action='maintenanceTasks.php' class='hidden-print'>\n";
$sd=Date("Y-m-d");
if (isset($_POST['schedule_date'])) {
	$sd=formatDateWebToDB($_POST['schedule_date']);
	if (! $sd or $sd=="0000-00-00") {
		$sd=Date("Y-m-d");
	}
}
createMaintenanceTasks($db,Date("m",strtotime($sd)));
print renderDateBox(TRUE,"schedule_date",$sd,"Date");
$target=0;
if (isset($_POST['target'])) {
	$target=$_POST['target'];
}
$searchAssigned=0;
if ($isEmployee) {
	$searchAssigned=$userEmployeeID;
}
if (isset($_POST['search_assigned'])) {
	$searchAssigned=$_POST['search_assigned'];
}

$sql="select target_id, concat(maintenance_site, '-', location_name, '-', target_name) from maintenance_targets t, maintenance_locations l, maintenance_sites s where t.target_location=l.location_id and l.location_site=s.site_id order by maintenance_site, location_name, target_name";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"target",$target,"Target","N",$rs,1);
$type=0;
if (isset($_POST['type'])) {
	$type=$_POST['type'];
}
#$isAdmin=0;
if ($isAdmin) {
	$sql="select type_id, type_name from maintenance_types order by type_name";
} else {
	$sql="select type_id, type_name from maintenance_types t, maintenance_employee_types e where type_id=task_type and employee_id=$userID order by type_name";
}
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"type",$type,"Task Type","N",$rs,1);
print "<div style='clear: both;'></div>";
$sql="select employee_id, concat(first_name,' ',last_name) as name from employees where department_id=18 order by last_name, first_name";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"search_assigned",$searchAssigned,"Assigned To","Y",$rs,1);
print renderButton("Find","blue","document.searchform.submit();");
print "</form>";
$sql="select task_id, task_name, target_name, date_due, reserved, assigned_to, expected_duration, actual_duration  from maintenance_tasks t left outer join maintenance_targets m on t.target_id=m.target_id  where DATE(date_due) <= ? and coalesce(completed_by,0) = 0 ";
if ($target) {
	$sql.=" and t.target_id=$target";
}
if ($type) {
	$sql.=" and task_type = $type";
}
if ($searchAssigned) {
	$sql.=" and assigned_to = $searchAssigned ";
}
if (! $isAdmin) {
	$sql.=" and task_type in (select task_type from maintenance_employee_types where employee_id=$userID) ";
}
$sql.=" order by date_due ";

print "<table class='table table-striped'><thead><th>Task</th><th>Target</th><th>Date Due</th><th>Reserved</th><th>Assigned</th><th>Expected Duration</th><th>Actual Duration</th><th>Actions</th></thead><tbody>";
list($rs,$err)=runIQuery($db,$sql,array("s",$sd));
foreach($rs as $data) {
	$id=$data['task_id'];
	$task=$data['task_name'];
	$machine=$data['target_name'];
	$due=formatDateDBToWeb($data['date_due']);
	$reserved=$data['reserved'];
	$assigned=$data['assigned_to'];
	$expected=$data['expected_duration'];
	$actual=$data['actual_duration'];
	$sql="select first_name, last_name from employees where employee_id=?";
	list($ers,$err)=runIQuery($db,$sql,array("i",$assigned));
	if (count($ers)>0) {
		$edata=$ers[0];
		$assigned=$edata['first_name'] . " " . $edata['last_name'];
	} else {
		$assigned="";
	}
	print "<tr><td><a href='editMaintenanceTasks.php?table=maintenance_tasks&id=$id' target='_blank'>$task</a></td>";
	print "<td>$machine</td><td>$due</td><td>$reserved</td><td>$assigned</td>";
	print "<td>$expected</td><td>$actual</td>";
	print "<td>";	
	print renderButton("Reserve","blue","reserveTask('$id');");
	print renderButton("Assign","yellow","assignTaskDialog('$id','$assigned');");
	print renderButton("Complete","green","completeTaskDialog('$id','$assigned');");
	print "</td>";
	print "</tr>\n";
}
print "</tbody></table>";
print renderClosePanel();
?>
<div style='clear: both;'></div>
<div id='completeDialog' class='modal fade' role='dialog'>
	<div class='modal-dialog' role='document'>
		<div class='modal-content'>
			<div class='model-header'>
				<h4 class='modal-title'>Complete Task</h4>
			</div>
			<div class='modal-body'>
				<?php
				$sql="select employee_id, concat(first_name,' ',last_name) as name from employees where department_id=18 order by last_name, first_name";
				$rs=mysqli_query($db,$sql);
				print renderSelect(TRUE,"completedBy",0,"Completed By","N",$rs,0,200);
				print renderTextBox(TRUE,"actual",0,"Time to Complete");
				print "<div style='clear: both;'></div>";
				print renderButton("Complete","green","completeTask();");
				?>
				<div style='float: right; cursor: pointer;' onclick="$('#completeDialog').modal('hide');">[Cancel]</div> 
			</div>
		</div>
	</div>
</div>	


<div id='assignDialog' class='modal fade' role='dialog' >
	<div class='modal-dialog' role='document'  >
		<div class='modal-content'>
			<div class='modal-header'>
				<h4 class='modal-title' >Assign Task</h4>
			</div>
			<div class='modal-body'>";
				<?php
				$sql="select employee_id, concat(first_name,' ',last_name) as name from employees where department_id=18 order by last_name, first_name";
				$rs=mysqli_query($db,$sql);
				print renderSelect(TRUE,"assignTo",0,"Assign To","N",$rs,0);
				print "<div style='clear: both;'></div>";
				print renderButton("Assign","yellow","assignTask();");
				?>
				<div style='float: right; cursor: pointer;' onclick="$('#assignDialog').modal('hide');">[Cancel]</div> 
			</div>
		</div>
	</div>
</div>
<script>
function page_init() {
	$('#completedBy').val('<?=$userEmployeeID?>');
}

var currentID=0;
function assignTaskDialog(id,assigned){  //load content and open dialog
	currentID=id;
	$('#assignedTo').val(assigned);
	$("#assignDialog").modal("show");             
}

function completeTaskDialog(id,by){  //load content and open dialog
	currentID=id;
	$('#completedBy').val(by);
	$("#completeDialog").modal("show");             
}

function testing(id) {
	alert(id);
}
function reserveTask(id) {
	url='ajax/reserveTask.php?id='+id+'&rand='+Math.random();
	$.ajax({url: url, 
				success: function(data) {
					document.searchform.submit();
				}
			});
}
function assignTask(id) {
	url='ajax/assignTask.php?id='+currentID+'&assign='+$('#assignTo').val()+'&rand='+Math.random();
	$.ajax({url: url, success: function(data) {document.searchform.submit();}});
}
function completeTask(id) {
	url='ajax/completeTask.php?id='+currentID+'&by='+$('#completedBy').val()+actual='+$('#actual').val()+'&rand='+Math.random();
	$.ajax({url: url, success: function(data) {document.searchform.submit();}});
}
function page_init() {
    $('.datepicker').datepicker();
}
</script>
<?php
include('footer.php');
?>