<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
include('header.php');
print renderPanel("Maintenance Tasks Report","","success","span11","calendar");
print "<form name='searchform' method='GET' action='maintenanceTaskReport.php' class='hidden-print'>\n";
if (isset($_GET['start_date'])) {
	$sd=formatDateWebToDB($_GET['start_date']);
	if (! $sd or $sd=="0000-00-00") {
		$sd=Date("Y-m-d");
	}
} else {
	$sd=Date("Y-m-d");
}
if (isset($_GET['end_date'])) {
	$ed=formatDateWebToDB($_GET['end_date']);
	if (! $ed or $ed=="0000-00-00") {
		$ed=Date("Y-m-d");
	}
} else {
	$ed=Date("Y-m-d");
}
print renderDateBox(TRUE,"start_date",$sd,"Start Date");
print renderDateBox(TRUE,"end_date",$ed,"End Date");
$type=0;
$site=0;
$location=0;
$target=0;
$by=0;
if (isset($_GET['type'])) {
	$type=$_GET['type'];
	$site=$_GET['site'];
	$location=$_GET['location'];
	$target=$_GET['target'];
	$by=$_GET['completed_by'];
}
$sql="select target_id, concat(location_name, '-', target_name, '-', maintenance_site) from maintenance_targets t, maintenance_locations l, maintenance_sites s where t.target_location=l.location_id and l.location_site=s.site_id order by maintenance_site, location_name, target_name";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"target_id",$target,"Target","N",$rs);
$sql="select type_id, type_name from maintenance_types order by type_name";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"operation_type",$type,"Type","N",$rs,1);
$sql="select distinct completed_by, concat(first_name, ' ', last_name) as b, last_name, first_name from maintenance_tasks, employees where completed_by=employee_id  order by last_name, first_name ";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"completed_by",$by,"Completed By","N",$rs,1);
print renderButton("Find","green","document.searchform.submit();");
print renderButton("Export","blue","document.exportform.submit();");
print "</form>";
$sql="select task_id, task_name, target_name, location_name, maintenance_site, date_due, reserved, assigned_to, date_completed, last_name, first_name, expected_duration, actual_duration,
DATEDIFF(date_due, date_completed) as difference  from maintenance_tasks t left outer join maintenance_targets m on t.target_id=m.target_id  
left outer join maintenance_locations l on m.target_location=location_id left outer join maintenance_sites s on l.location_site=s.site_id 
left outer join employees e on t.completed_by=e.employee_id where ((date_due >= ? and DATE(date_due) <= ?) or (date_completed >= ? and DATE(date_completed) <= ?)) and date_completed > '0000-00-00'  ";
if ($type) {
	$sql.=" and task_type=$type";
}
if ($site) {
	$sql.=" and s.site_id = $site";
}
if ($site) {
	$sql.=" and l.location_id = $location";
}
if ($target) {
	$sql.=" and t.target_id=$target ";
}
if ($by) {
	$sql.=" and completed_by = '$by' ";
}
$sql.=" order by date_due ";
print "<table class='table table-striped'><thead><th>Task</th><th>Target</th><th>Date Due</th><th>Reserved</th><th>Assigned</th><th>Completed By</th><th>Date Completed</th><th>Difference</th><th>Expected Duration</th><th>Actual Duration</th></thead><tbody>";
list($rs,$err)=runIQuery($db,$sql,array("ssss",$sd,$ed,$sd,$ed));
foreach($rs as $data) {
	$id=$data['task_id'];
	$task=$data['task_name'];
	$site=$data['maintenance_site'];
	$location=$data['location_name'];
	$targetName=$data['target_name'];
	$target="$site-$location-$target";
	$due=formatDateDBToWeb($data['date_due']);
	$completed=formatDateDBToWeb($data['date_completed']);
	$reserved=$data['reserved'];
	$expected=$data['expected_duration'];
	$actual=$data['actual_duration'];
	if ($reserved) {
		$sql="select last_name, first_name from employees where employee_id=?";
		list($ers,$err)=runIQuery($db,$sql,array("i",$reserved));
		$reserved=$ers[0][1] . " " . $ers[0][0];
	} else {
		$reserved="";
	}
	$sql="select last_name, first_name from employees where employee_id=?";
	list($ers,$err)=runIQuery($db,$sql,array("i",$reserved));
	$reserved=$ers[0][0];
	$assigned=$data['assigned_to'];
	if ($assigned) {
		$sql="select last_name, first_name from employees where employee_id=?";
		list($ers,$err)=runIQuery($db,$sql,array("i",$assigned));
		$assigned=$ers[0][1] . " " . $ers[0][0];
	} else {
		$assigned="";
	}
	$completedBy=$data['first_name'] . " " . $data['last_name'];
	$difference = $data['difference'];
	$table=cleanText($_GET['table']);
	print "<tr><td><a href='editMaintenanceTasks.php?table=maintenance_tasks&key=task_id&id=$id' target='_blank'>$task</a></td>";
	print "<td>$targetName</td><td>$due</td><td>$reserved</td><td>$assigned</td>";
	print"<td>";
	print $completedBy;	
	print "</td>";
	print"<td>";	
	print $completed;
	print "</td>";
	print"<td>";
	if ($difference < 0) {
		print "<div style='color: red;'>";
	}
	print $difference;
	if ($difference < 0) {
		print "</div>";
	}
	print "</td>";
	print "<td>$expected</td><td>$actual</td>";
	print "</tr>\n";
}
print "</tbody></table>";
$sql="select task_id, task_name, target_name, location_name, maintenance_site, date_due, concat(r.first_name,' ',r.last_name) as reserved_by, ";
$sql.=" concat(a.first_name, ' ', a.last_name) as assigned, date_completed, concat(e.first_name, ' ',e.last_name) as completed_by, ";
$sql.=" DATEDIFF(date_due, date_completed) as difference, expected_duration, actual_duration  from maintenance_tasks t inner join maintenance_targets m on t.target_id=m.target_id  ";
$sql=" inner join maintenance_locations l on m.target_location=location_id inner join maintenance_sites s on l.location_site=s.site_id ";
$sql.=" inner join employees e on t.completed_by=e.employee_id ";
$sql.=" inner join employees r on t.reserved=r.employee_id ";
$sql.=" inner join employees a on t.assigmed+tp=a.employee_id ";
$sql.=" where ((date_due >= '$sd' and DATE(date_due) <= '$ed') or (date_completed >= '$sd' and DATE(date_completed) <= '$ed')) and date_completed > '0000-00-00'  ";
if ($type) {
	$sql.=" and task_type=$type";
}
if ($site) {
	$sql.=" and s.site_id = $site";
}
if ($site) {
	$sql.=" and l.location_id = $location";
}
if ($target) {
	$sql.=" and t.target_id=$target ";
}
if ($by) {
	$sql.=" and completed_by = '$by' ";
}
$sql.=" order by date_due ";
print "<form name='exportform' action='exportSQL.php' method='POST' target='_blank'>";
print "<input type='hidden' name='sql' value =\"$sql\">";
print "<input type='hidden' name='title' value='Maintenance Tasks " . $sd . " - " . $ed . "'>"; 
print "</form>";
print renderClosePanel();
include('footer.php');
?>