<?php
$expanded=1;
$locked=0;
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
$pageTitle="Machine PO, Powder Processing OTD";
include('header.php');
date_default_timezone_set('America/Detroit');
$sql="SET time_zone = '" .date('P') . "'";
list($rs,$err)=runIQuery($db,$sql);
$start=Date("m/d/Y");
if (isset($_GET['start'])) {
	$start=$_GET['start'];
}
$end=$start;
if (isset($_GET['end'])) {
	$end=$_GET['end'];
}
$order="";
if (isset($_GET['order'])) {
	$order=$_GET['order'];
}
print renderPanel("Machine PO, Powder Processing OTD","","blue","span11","cogs");
print "<form name='findform' action='machinePowderOTD.php' method='GET>";
print renderDateBox(TRUE,"start",$start,"Start Date");
print renderDateBox(TRUE,"end",$end,"End Date");
print renderTextBox(TRUE,"order",$order,"Sales Order");
print "<div class='btn green hidden-print' onclick='document.findform.submit();'>Find</div>";
print renderButton("Export","blue","exportTheForm()");
print "<div style='clear: both;'></div>\n";
print "</form>";
print "<table class='table table-striped' id='dtResults'>";
print "<thead>";
print "<tr>";
print "<th>PC SO</th>";
print "<th>PM PO</th>";
print "<th>PM Packing Slip</th>";
print "<th>When Signed</th>";
print "<th>Signed By</th>";
print "<th>Due Customer</th>";
print "<th># Days</th>";
print "<th>Ultimate Ship Date</th>";
print "</tr>";
print "</thead>";
print "<tbody>";


$polist=array();
$packlist=array();
$whenlist=array();
$bylist=array();
$duelist=array();
$solist=array();
$solist=array();
$shiplist=array();


$start=formatDateWebToDB($start);
$end=formatDateWebToDB($end);
$sql="select distinct orders.order_id, po_number, orders.date_due from orders left outer join order_lines on orders.order_id=order_lines.order_id ";
$sql.=" where status not in (5,6) and date_due >= ? and date_due <= ? and customer_id=706 and powder_color > 0";
if ($order) {
    $sql.=" and (orders.order_id=? or po_number=?) ";
    $sql.=" order by date_due ";
    list($rs,$err)=runIQuery($db,$sql,array("ssis",$start,$end,$order,$order));
} else {
    $sql.=" order by date_due ";
    list($rs,$err)=runIQuery($db,$sql,array("ss",$start,$end));
}


$i=0;

foreach ($rs as $data) {
    $po=trim($data['po_number']);
    if ($po) {
        $polist[]=$po;
        $solist[$po]=$data['order_id'];
    }
    $i++;
    if ($i > 30) {
        $url="http://preferredmachineproduction-env.eba-msgmf3n9.us-east-1.elasticbeanstalk.com/getReceivingInfo.php?code=8384&po=" . implode(",",$polist) . "&rand=" . rand();
        $response=file_get_contents($url);
        foreach(explode("^",$response) as $record) {
            list($so,$packing_slip,$dateSigned, $by,$due,$shipped,$lead)=explode("|",$record);
            $packlist[$so]=$packing_slip;
            $whenlist[$so]=$dateSigned;
            $bylist[$so]=$by;
            $duelist[$so]=$due;
            if ($shipped == "0000-00-00") {
                $shipped="";
            }
            $shiplist[$so]=$shipped;
        }
        $i=0;
        unset($polist);
        $polist=array();
    }
}
if (count($polist)>0) {
    $url="http://preferredmachineproduction-env.eba-msgmf3n9.us-east-1.elasticbeanstalk.com/getReceivingInfo.php?code=8384&po=" . implode(",",$polist) . "&rand=" . rand();
    $response=file_get_contents($url);
    foreach(explode("^",$response) as $record) {
        list($so,$packing_slip,$dateSigned, $by,$due,$shipped,$lead)=explode("|",$record);
        $packlist[$so]=$packing_slip;
        $whenlist[$so]=$dateSigned;
        $bylist[$so]=$by;
        $duelist[$so]=$due;
        if ($shipped == "0000-00-00") {
            $shipped="";
        }
        $shiplist[$so]=$shipped;
    }
}
reset($rs);
$lead=$lead*-1;
foreach ($rs as $data) {
    $po=$data['po_number'];
    $so=$solist[$po];
    $due=$duelist[$po];
    $packingSlip=$packlist[$po];
    $when=$whenlist[$po];
    $by=$bylist[$po];
    $shipped=$shiplist[$po];
    $diff="";
    if ($when) {
        $diff=BusinessDaysDifferent($when,$due);
    }
    print "<tr>";
    print "<td valign='top'>";
    print $so;
    print "</td>";
    print "<td valign='top'>";
    print $po;
    print "</td>";
    print "<td valign='top'>";
    print $packingSlip;
    print "</td>";
    print "<td valign='top'>";
    print formatDateDBToWeb($when);
    print "</td>";
    print "<td valign='top'>";
    print $by;
    print "</td>";
    print "<td valign='top'>";
    print formatDateDBToWeb($due);
    print "</td>";
    print "<td valign='top'>";
    if ($diff > $lead) {
        print "<font color='red'>";
        print $diff;
        print "</font>";
    } else {
        print $diff;
    }
    print "</td>";
    print "<td valign='top'>";
    $shipit=formatDateDBToWeb($shipped);
    list($dt,$tm)=explode(" ",$shipped);
    if ($shipit != "00/00/0000") {
        if ($dt > $due) {
            print "<font color='red'>$shipit</font>";
        } else {
            print $shipit;
        }
    }
    print "</td>";
    print "</tr>\n";
}

print "</tbody>";
print "</table>\n";
print renderClosePanel("");
?>
<script>
function page_init() {
  $('#start').datepicker();
  $('#end').datepicker();
  $('#dtResults').DataTable({"bPaginate" : false});
}
function exportTheForm() {
	document.findform.action='exportMachinePowderOTD.php';
	document.findform.target='_blank';
	document.findform.submit();
	document.findform.action='machinePowderOTD.php';
	document.findform.target='_self';
}
</script>
<?php
include('footer.php');
?>