<?php
date_default_timezone_set('America/Detroit');
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
$pageTitle="Batch Job Entry";
$wc=$primaryWC;
include('header.php');

print renderPanel($pageTitle,$pageTitle,"green","span11","cogs");
print "<h4>$userName</h4>";
print "<p>Please enter employee ID, then select from the available batches below.</p>";
print renderTextBox(TRUE,"employee1","","Employee 1");
print renderTextBox(TRUE,"employee2","","Employee 2");
print renderTextBox(TRUE,"employee3","","Employee 3");
print "<div id='components'></div>";
if ($wc) {
	print "<form name='selform' action='batchTimeEntry.php' method='POST'>";
	print "<input type='hidden' name='start' value='1'>";
	print "<input type='hidden' name='wc' value='$wc'>";
	print "<table id='avj' class='table table-striped'>";
	print "<thead >";	
	print "<tr id='header'><th>Batch</th><th>SO</th><th>Part</th><th>Start Date</th><th>Due to Next Step</th><th>Available Qty</th><th>Qty Good So Far</th><th>Qty Still Due</th><th>Total Job Qty</th></tr>\n";
	print "</thead><tbody>";
    $batchShown=array();
	$sql="select b.batch_id, jobs.item_id, sum(quantity_scheduled) as scheduled from jobs ";
	$sql.="inner join jobs_batch_orders jbo on jobs.job_id=jbo.job_id  inner join jobs_batch b on jbo.batch_id=b.batch_id and b.machine_id=? and batch_ready=1 and batch_complete=0 ";
	$sql.=" where  jobs.item_id in (select parent_part from routing where workcenter_id=? ) ";
	## cma 1/5/23 changed to only look at status 1
	## $sql.= " and jobs.status in (1,2) ";
	$sql.= " and jobs.status =1 ";
	$sql.=" group by b.batch_id, jobs.item_id ";
	$sql.=" order by b.batch_id ";
	list($rs,$err)=runIQuery($db,$sql,array("ii",$machineID,$wc));
	foreach ($rs as $data) {
		$batch=$data['batch_id'];
		$item=$data['item_id'];
		$cmpQty=$data['scheduled'];
		$goodQty=0;
		$sql="select display_sequence, sum(coalesce(pr.quantity_good,0)) from jobs_batch_orders jbo inner join jobs j on jbo.job_id=j.job_id ";
		$sql.=" inner join routing r on j.item_id=r.parent_part and r.workcenter_id=? ";
		$sql.=" left outer join production_results pr on j.job_id=pr.job_id and r.routing_id=pr.routing_id ";
		$sql.=" where jbo.batch_id=? group by display_sequence ";
		list($jrs,$err)=runIQuery($db,$sql,array("ii",$wc,$batch));
		$goodQty=0;
		foreach ($jrs as $jdata) {
			$jdata=$jrs[0];
			$ds=$jdata[0];
			$goodQty=$jdata[1];
		}
		$sql="select coalesce(schedule_date, start_date) as start_date from jobs_batch_orders jbo inner join jobs j on jbo.job_id=j.job_id ";
		$sql.=" left outer join routing r on j.item_id=r.parent_part and r.workcenter_id=? ";
		$sql.=" left outer join schedule_items s on j.job_id=s.job_id and r.routing_id=s.routing_id left outer join schedule h on h.schedule_id=s.schedule_id";
		$sql.=" and jbo.batch_id=? ";
		$sql.=" order by coalesce(schedule_date, start_date) LIMIT 1 ";
		list($jrs,$err)=runIQuery($db,$sql,array("ii",$wc,$batch));
		$jdata=$jrs[0];
		$wcStart = $jdata['start_date'];
		$due=$cmpQty - $goodQty;
		if ($due > 0) {
			$startDate=$wcStart;
			$sql="select coalesce(schedule_date, start_date) as start_date from jobs_batch_orders jbo inner join jobs j on jbo.job_id=j.job_id ";
			$sql.=" left outer join routing r on j.item_id=r.parent_part and r.display_sequence > ? ";
			$sql.=" left outer join schedule_items s on j.job_id=s.job_id and r.routing_id=s.routing_id left outer join schedule h on h.schedule_id=s.schedule_id";
			$sql.=" where jbo.batch_id=? ";
			$sql.=" order by coalesce(schedule_date, start_date) LIMIT 1 ";
			list($srs,$err)=runIQuery($db,$sql,array("ii",$ds,$batch));
			if (count($srs)>0) {
				$sdata=$srs[0];
				$startDate=$sdata['start_date'];
			}
			print "<tr><td>$batch</td><td>MULTIPLE</td><td>$item</td><td>";
			print formatDateDBToWeb($wcStart);
			print "</td><td>";
			print formatDateDBToWeb($startDate);
			print "</td>";
			print "<td align='right'>$due</td>";
			$goodsofar=$cmpQty-$due;
			print "<td align='right'>$goodQty</td>";
			print "<td align='right'>$due</td><td align='right'>$cmpQty</td>";
			print "<td align='center'>";
			print renderButton("Start Batch $batch","red","openBatch('$batch');");
			$batchShown[]=$batch;
			print "</td>";
			print "</tr>\n";
		}
	}
	print "</tbody>";
	print "</table>\n";
	print "</form>";
}
print renderClosePanel();
include('footer.php'); ## bdoss 12/12/22 moving footer from below script - jquery was loading after jquery methods are called
?>
<script>
	
	function page_init() {
	}

	// bdoss 12/12/22 prevent enter from submitting - this was auto submitting a ticket when people pressed enter in the employee textarea
	$('#employee1').keydown(function(e) {
		if (e.keyCode === 13) {
			e.preventDefault();
			return false;
		}
	});
	$('#employee2').keydown(function(e) {
		if (e.keyCode === 13) {
			e.preventDefault();
			return false;
		}
	});
	$('#employee3').keydown(function(e) {
		if (e.keyCode === 13) {
			e.preventDefault();
			return false;
		}
	});

	function openBatch(batchid) {
        if ($('#employee1').val()=='') {            
            alert('You must enter at least one employee');
        } else {
            url='validateEmployee.php?id='+$('#employee1').val()+'&code=8383';
            $.ajax({url: url, success: function(data){
                if (data == 'OK-Employee Found') {
                    document.location.href='batchTimeEntry.php?batch='+batchid+'&rand='+Math.random()+'&e1='+$('#employee1').val()+'&e2='+$('#employee2').val()+'&e3='+$('#employee3').val();
                } else {
                    alert('Please enter valid employee number');
                }                
            } })				
        }
	}
</script>
