<?php
#error_reporting(E_ALL);
#ini_set('display_errors','on');
include('dbConnection.php');
## session start is now in dbconnection.php;
include('functions.php');
## if send pack slip, then it is either to update the invoice number, or to list the packing slip details.

if (isset($_GET['pack'])) {
	$id=$_GET['pack'];
	if ($_GET['code'] == 'WELD443') {
		if (isset($_GET['invoice'])) {
			## update packing slip
			$inv=$_GET['invoice'];
			$sql="update packing_slip set invoice_number=? where packing_slip_id=?";
			list($rs,$err)=runIQuery($db,$sql,array("si",$inv,$id));
		}	 else {
			$sql="select * from packing_slip, packing_slip_lines where packing_slip_id=? and packing_slip_id=packing_list_id order by line_id ";
			list($rs,$err)=runIQuery($db,$sql,array("i",$id));
			foreach ($rs as $data) {
				print $data['attention'];
				print "|";
				print $data['ship_name'];
				print "|";
				print $data['ship_address'];
				print "|";
				print $data['ship_address2'];
				print "|";
				print $data['ship_city'];
				print "|";
				print $data['ship_state'];
				print "|";
				print $data['ship_zip'];
				print "|";
				print $data['po_number'];
				print "|";
				print $data['po_line'];
				print "|";
				print $data['order_id'];
				print "|";
				## part number is currently either Weldment or Steel - based on category
				$part=$data['part_number'];
				$description=$data['part_number'] . " " . $data['description'];
				$sql="select item_category from items where item_name=?";
				list ($irs,$err)=runIQuery($db,$sql,array("s",$part));
				$part="Weldment";
				if (count($irs) > 0) {
					$idata=$irs[0];
					$category=$idata[0];
					if ($category == 15) {
						$part="Weldment";
					} else {
						$part="Steel";
					}
				}
				print $part;
				print "|";
				print $data['quantity'];
				## get price - from so if possible otherwise part master otherwise based on production results
				$oline=$data['order_line'];
				$onum=$data['order_id'];
				$part=$data['part_number'];
				$price=-1;
				if ($onum and $oline) {
					$sql="select price, cost from order_lines where line_id=? or (order_id=? and item_id=?) ";
					list($irs,$err)=runIQuery($db,$sql,array("iis",$oline,$onum,$part));
					foreach ($irs as $idata) {
						$price=number_format($idata['price'],4);
						$cost=number_format($idata['cost'],4);
					}		
				}
				if ($price <= 0 ) {
					$sql="select price, coalesce(last_cost, average_cost,0) as cost from items where item_name=?";
					list($irs,$err)=runIQuery($db,$sql,array("s",$part));
					foreach ($irs as $idata) {
						$price=number_format($idata['price'],4);
						$cost=number_format($idata['cost'],4);
					}		
				}
				if ($price <= 0) {
					## get from the operations
					$sql="select g.operation_id, o.operation_price, sum(duration_hours) as hours, sum(duration_minutes) as minutes from production_results r inner join routing g on r.routing_id = g.routing_id inner join operations o on g.operation_id = o.operation_id inner join jobs j on r.job_id = j.job_id where j.line_id = ? group by g.operation_id, o.operation_price  ";
					list($irs,$err) = runIQuery($db,$sql,array("i", $oline));
					$totprice = 0;
					foreach ($irs as $idata) {
						$duration=$idata['hours']  + ($idata['minutes'] / 60);
						$oprice=$idata['operation_price'];
						$totprice += ($duration * $oprice);
					}
					$qty=$data['quantity'];
					if ($qty > 0) {
						$price=$totprice / $qty;
					}
				}
				if ($price < 0) {
					$price=0;
				}
				print "|";
				print $price;
				print "|";
				print $cost;
				print "|";
				print $description;
				print "\n";				
			}
		}
	}	
} else {
	$sql="select packing_slip_id, customers.name, date_shipped, invoice_number from packing_slip, customers where packing_slip.customer_id=customers.customer_id ";
	#$sql.=" and coalesce(invoice_number,'0')='0' and coalesce(date_shipped,'0000-00-00') <> '0000-00-00' and name  <> '' ";
	$sql.=" order by name, date_shipped";
	list($rs,$err)=runIQuery($db,$sql);
	foreach ($rs as $data) {
		print $data['packing_slip_id'];
		print "|";
		print $data['name'];
		print "|";
		print formatDateDBToWeb($data['date_shipped']);
		print "|";
		print $data['invoice_number'];
		print "\n";
	}
}
?>