<?php
include("dbConnection.php");
include("functions.php");


$start=date("m/d/Y", strtotime("last week sunday -7 day"));
if (isset($_GET["start"])) {
    $start=$_GET["start"];
}

$end=date("m/d/Y", strtotime("last week saturday"));
if (isset($_GET["end"])) {
    $end=$_GET["end"];
}
$export=0;
if (isset($_GET["export"])) {
    $export=$_GET["export"];
}

$code=0;
if (isset($_GET["code"])) {
    $code=$_GET["code"];
}

$company=1;
if (isset($_GET["company"])) {
    $company=$_GET["company"];
}
$employee=0;
if (isset($_GET["employee"])) {
    $employee=$_GET["employee"];
}



$department=0;
if ($code!=8383) {
    include("security.php");
    $sql = "select t.department_id from departments t, site_admins sa where t.lead_email=sa.email and sa.user_id=?";
    list($rs,$err)=runIQuery($db,$sql,["s",$userID]);
    if (count($rs)) {
        $isAdmin=1;
        $department=$rs[0]["department_id"];
    }
    if ($userEmail == "ap@preferredcompaniesllc.com" || $userEmail == "ap@preferredmachinellc.com") { //ap can change anyone's hours
        $isAdmin=1;
        $department=0;
    }
}


function renderWeekBox($showLabel,$fieldName,$currentValue,$title) {
	$retval=renderStartItem($showLabel,$fieldName,$title);
	$retval.= "<input style='background-color: white;' type='text' class='form-control datepicker weekpicker' name='$fieldName' id='$fieldName' value='";
	if (formatDateDBtoWeb($currentValue)=="") {
		$retval.=$currentValue;
	} else {
		$retval.= formatDateDBtoWeb($currentValue);
	}
	$retval.= "'>";
	$retval.=renderEndItem();
	return $retval;
}

if (!isset($userID) && $code != 8383) { //* NOTE: If no user is logged in and no or incorrect code is supplied
    die;
}
if ($code == 8383) {
    $isAdmin=1;
    $export=2; // code ONLY allows access to the hours export
}

$holidays = [];
if ($isAdmin) {
    if (!$export) {
        include("header.php");
        print "<style>
            .printarea * {
                text-align: left;
                font-size: 10px !important;
                color: #000 !important;
                padding: 0px;
            }
            .printarea table {
                width: 100% !important;
                border-spacing:0;
                border-collapse: collapse;
            }
            .printarea .separator th,td {
                border-bottom: 1px solid #000;
            }
            .printarea .padded th,td {
                padding: 3px;
            }
            .punchlist * {
                font-size: 14px;
            }
        </style>";

        //confirmation dialog
        print "<div id='confModal' class='modal fade' role='dialog'>
            <div class='modal-dialog'>
                <div class='modal-content'>
                    <div class='modal-header'><h4 class='modal-title confTitle'></h4></div>
                    <div class='modal-body'>
                        <span class='confBody'></span>
                    </div>
                    <div class='modal-footer'>
                        <button class='btn btn-success' data-dismiss='modal' onclick='confInput(true)'>Okay</button>
                        <button class='btn btn-danger' data-dismiss='modal' id='confno' onclick='confInput(false)'>Cancel</button>
                    </div>
                </div>
            </div>
        </div>";

        print renderPanel("List Clock Punches", "List Clock Punches");
        print "<form name='punchForm' method='GET' action='listPunches.php'>";

        print renderWeekBox(TRUE,"start",formatDateWebToDB($start),"Start Date");

        print renderStartItem(TRUE,"end","End Date");
            print "<input class='form-control' type='text' id='end' name='end' value='$end' readonly>";
        print renderEndItem();
        //print renderDateBox(TRUE,"end",formatDateWebToDB($end),"End Date");

        if ($employee && $employee !="-1") {
            $sql = "select e.company_id from employees e, quickbooks_companies q where e.company_id=q.company_id and e.card_number=?";
            list($ders)=runIQuery($db,$sql,["i",$employee]);
            if (count($ders)) {
                $company=$ders[0]["company_id"];
            }
        }

        if ($department) {
            //* Note: $department is grabbed from the database, can't inject sql with it
            $sql = "select card_number, concat(first_name, ' ', last_name) as name from employees where inactive=0 and department_id=$department order by name";
        } else {
            $sql = "select card_number, concat(first_name, ' ', last_name) as name from employees where inactive=0 group by name order by name";
        }
        list($rs)=runIQuery($db,$sql);

        //? Maybe find a better way to do this?
        array_unshift($rs,["0" => -1, "card_number" => -1, "1" => "All Employees", "name" => "All Employees"]);

        print renderSelect(TRUE,"employee",$employee,"Employee","N",$rs,TRUE);

        $sql = "select company_id, company_name from quickbooks_companies";
        list($crs,$err) = runIQuery($db,$sql);
        print renderSelect(TRUE,"company",$company,"Company","",$crs,TRUE);
        print "<br>";
        print "<br>";

        print renderButton("Find","blue","document.forms.punchForm.submit();");
        if ($employee) { //* NOTE: if an employee is specified
            print " " . renderButton("Export Excel","green","window.open('listPunches.php?start=$start&end=$end&employee=$employee&company=$company&export=1','_blank');");
            if ($employee==-1) { //* NOTE: if the employee is "All Employees"
                print " " . renderButton("Export QuickBooks","yellow","window.open('listPunches.php?start=$start&end=$end&employee=-1&company=$company&export=2&byweek','_blank');");
            }
        }
        print "</form>";
    }

    if ($employee) { //* NOTE: if an employee is specified
        $sql_vars = ["ss",date("Y-m-d", strtotime($start)), date("Y-m-d", strtotime($end . " +1 day"))];
        $sql = "select e.employee_id as eid, company_id, tcp.*, concat(e.first_name, ' ', e.last_name) as full_name, points, e.salaried from time_clock_punches tcp, employees e where";
        if ($employee != -1) {
            $sql .= " tcp.employee_id=? and ";
            $sql_vars[0] = $employee;
            array_unshift($sql_vars, "iss");
        }
        $sql .= " e.card_number=tcp.employee_id and in_date between ? and ? and company_id=? order by full_name,in_date limit 1000";
        $sql_vars[0] .= "s";
        $sql_vars[] = $company;
        list($rs)=runIQuery($db,$sql,$sql_vars,FALSE);
        $empid = $rs[0]["eid"];

        //Add punch panel
        if ($employee != -1 && !$export) { //* NOTE: if the employee is NOT "All Employees" and not an export
            //* NOTE: Show Add Punch and Edit Points buttons
            print "<br><br>";
            print renderButton("Add Punch","red","toggleAdd()");
            //print " " . renderButton("Edit Points","warning","togglePoints()");
            print " " . renderButton("Edit Points","yellow","window.open('employeePoints.php?employee=$empid', '_blank')");

            print "<div id='addpunch' style='display:none;'><br>";
            print renderPanel("Add Punch", "Add Punch", "red");
            print "<form name='addForm'>
            <div style='display: flex;'><div class='span3'>
            <div class='input-group'>
                <label class='control-label' for='in'>In Time (Required)</label>
                <input type='datetime-local' class='form-control' name='in' id='in'>
            </div>
            </div>

            <div class='span3'>
            <div class='input-group'>
                <label class='control-label' for='out'>Out Time</label>
                <input type='datetime-local' class='form-control' name='out' id='out'>
            </div>
            </div></div>";
            print renderTextArea(TRUE,"addnotes","","Notes");
            print "<div style='display: flex;'><label for='is_lunch'>Is Lunch</label>  <input type='checkbox' id='is_lunch' name='is_lunch' value='0'>";
            print " <label for='holiday'>Is Holiday</label>  <input type='checkbox' id='holiday' name='holiday' value='0'></div>";
            print "<br>" . renderButton("Add","red","addPunch()");
            print renderClosePanel();
            print "<br><br><br><br></div></div>";

        }

        if ($export==0 && $employee == -1 && ($isAdmin || $userEmail == "ap@preferredmachinellc.com") && $company != "") {
            print renderButton("Add Salary Punches","warning","addSalaryHours()") . " ";
            $hstart = date("Y-m-d", strtotime("-9 day")); // Don't want to go back too far just in case
            $sql = "select * from holidays where curdate() >= holiday_date and holiday_date >= '$hstart' and hours_given=0";

            list($hrs)=runIQuery($db,$sql);
            if (count($hrs)) {
                foreach ($hrs as $holiday) {
                    $holidays[] = ["date" => $holiday["holiday_date"], "name" => $holiday["holiday_name"]];
                }
                print renderButton("Add Holiday Hours","danger","addHolidayHours()");
            }
        }

        $weeks = [];
        $employees = [];
        foreach ($rs as $punch) { // TODO: Move this part to a separate file for custom exports?
            $punch["regular"]=0;
            $punch["overtime"]=0;
            $punch["holiday_hours"]=0;
            $week = date("W", strtotime($punch["in_date"]));
            $day = date("w", strtotime($punch["in_date"]));
            $is_lunch = $punch["is_lunch"];

            if (!isset($employees[$punch["employee_id"]])) {
                $employees[$punch["employee_id"]] = ["weeks" => [], "full_name" => $punch["full_name"], "company" => $punch["company_id"], "salaried" => $punch["salaried"]];
            }

            $weeks = $employees[$punch["employee_id"]]["weeks"];

            if (!isset($weeks[$week])) {
                $weeks[$week] = ["regular" => 0, "overtime" => 0, "holiday_hours" => 0, "days" => []];
            }
            if (!isset($weeks[$week]["days"][$day])) {
                $weeks[$week]["days"][$day] = ["regular" => 0, "overtime" => 0, "holiday_hours" => 0, "punches" => []];
            }

            if (!empty($punch["out_date"])) {
                $punch_hours = (strtotime($punch["out_date"]) - strtotime($punch["in_date"]))/60/60;
                $before = $weeks[$week]["regular"];

                if ($punch["holiday"] != 1) {
                    $weeks[$week]["regular"] += $punch_hours;
                }

                if ($punch["holiday"] == 1) {

                    $punch["holiday_hours"] = round($punch_hours*100)/100;
                    $weeks[$week]["days"][$day]["holiday_hours"] += $punch_hours;
                    $weeks[$week]["holiday_hours"] += $punch_hours;

                } else if ($weeks[$week]["regular"] > 40) { //we're shifting into maximum overtime

                    $weeks[$week]["overtime"] += $weeks[$week]["regular"]-40;
                    $weeks[$week]["regular"] = 40;

                    if ($before < 40) {

                        $reg = 40-$before;
                        $ot = abs($punch_hours-$reg);

                        $punch["regular"] = round($reg*100)/100;
                        $punch["overtime"] = round($ot*100)/100;
                        $weeks[$week]["days"][$day]["regular"] += $reg;
                        $weeks[$week]["days"][$day]["overtime"] += $ot;

                    } else {

                        $punch_hours = round($punch_hours*100)/100;
                        $punch["overtime"] = $punch_hours;
                        $weeks[$week]["days"][$day]["overtime"] += $punch_hours;

                    }

                } else {

                    $punch["regular"] = round($punch_hours*100)/100;
                    $punch["overtime"] = 0;
                    $weeks[$week]["days"][$day]["regular"] += $punch_hours;

                }

                if ($punch["holiday"] != 1) {

                    $weeks[$week]["days"][$day]["regular"] = round($weeks[$week]["days"][$day]["regular"]*100)/100;
                    $weeks[$week]["days"][$day]["overtime"] = round($weeks[$week]["days"][$day]["overtime"]*100)/100;
                    $weeks[$week]["overtime"] = round($weeks[$week]["overtime"]*100)/100;
                    $weeks[$week]["regular"] = round($weeks[$week]["regular"]*100)/100;

                }

                $weeks[$week]["days"][$day]["holiday_hours"] = round($weeks[$week]["days"][$day]["holiday_hours"]*100)/100;
                $weeks[$week]["holiday_hours"] = round($weeks[$week]["holiday_hours"]*100)/100;
            }

            $weeks[$week]["days"][$day]["punches"][] = $punch;

            $employees[$punch["employee_id"]]["weeks"] = $weeks;
        }

        if (!$export) {
            print "<br><br><div class='punchtables'>";
        }
        $csv = "";
        foreach ($employees as $employee_id => $info) {
            if (!$export) {
                print "<div class='punchlist'><table style='width: 90%;' class='table table-condensed'><tr" . ($employee == -1 ? " style='cursor: pointer;' onclick='window.open(\"listPunches.php?start=$start&end=$end&employee=$employee_id&company=$company\", \"_blank\");'" : "") . "><th" . ($employee == -1 ? " onmouseover='this.style.background=\"#46a6c4\"' onmouseout='this.style.background=\"#5BC0DE\"'" : "") . " style='background: #5BC0DE; color: #ffffff;'>" . floor($employee_id) . " - " . $info["full_name"] . ($info["salaried"] ? " (Salary)" : "") . "</th></tr><tbody><tr><th>";

                foreach ($info["weeks"] as $title => $week) {
                    $weeks[$title]["days"] = array_values($week["days"]);

                    //Separator used for printing formatting
                    print "<h5>Week $title<table class='table table-condensed'>
                        <tr style='display: none;' class='separator'><th></th><th></th><th></th><th></th><th></th><th></th><th></th><th></th><th></th></tr>
                        <tr style='background: #d0d0d0;' class='active'>
                            <th style='width: 8%;'>Date</th>
                            <th style='width: 7%;'>Lunch Out</th>
                            <th style='width: 9%;'>Time In</th>
                            <th style='width: 9%;'>Time Out</th>
                            <th style='width: 6%;'>Regular</th>
                            <th style='width: 6%;'>Overtime</th>
                            <th style='width: 6%;'>Holiday</th>
                            <th>Notes</th>
                            <th style='width: 4%;'>Total</th>
                        </tr>

                    <tbody>";

                    foreach ($week["days"] as $day) {
                        foreach ($day["punches"] as $i => $punch) {
                            if (!$i) {
                                print "<tr style='display: none;' class='separator'><th></th><th></th><th></th><th></th><th></th><th></th><th></th><th></th><th></th></tr>";
                            }

                            $punchhrs =  $punch["regular"]+$punch["overtime"]+$punch["holiday_hours"];
                            $hrs = floor($punchhrs);
                            $mins = floor(($punchhrs-$hrs)*60);
                            $punchtime = "$hrs:$mins";
                            if ($mins == 0) {
                                $punchtime = $hrs;
                            }

                            print "<tr style='color: #db3939; cursor: pointer;' onmouseover='this.style.backgroundColor=\"#d0d0d0\"' onmouseout=\"this.style.background='white';\" onclick='window.location=\"editPunch.php?punch_id=" . $punch["punch_id"] . "&start=$start&end=$end&employee=$employee&company=$company\";'>
                                <th>" . (!$i ? date("m/d/Y", strtotime($punch["in_date"])) : "") . "</th>
                                <th>" . ($punch["is_lunch"] ? "Yes" : "No") . "</th>
                                <th>" . date("D, h:i A", strtotime($punch["in_date"])) . "</th>
                                <th>" . (!empty($punch["out_date"]) ? date("D, h:i A", strtotime($punch["out_date"])) : "N/A") . "</th>
                                <th>" . $punch["regular"] . "</th>
                                <th>" . $punch["overtime"] . "</th>
                                <th>" . $punch["holiday_hours"] . "</th>
                                <th>" . $punch["notes"] . "</th>
                                <th>$punchtime</th>
                            </tr>";
                        }
                        //Separator used for printing formatting
                        $dayhrs =  $day["regular"]+$day["overtime"]+$day["holiday_hours"];
                        $hrs = floor($dayhrs);
                        $mins = floor(($dayhrs-$hrs)*60);
                        $daytime = "$hrs:$mins";
                        if ($mins == 0) {
                            $daytime = $hrs;
                        }

                        print "<tr class='active' style='background: #d0d0d0; color: #3b91c4;'>
                            <th>Day Totals</th>
                            <th></th>
                            <th></th><th></th>
                            <th>" . $day["regular"] . "</th>
                            <th>" . $day["overtime"] . "</th>
                            <th>" . $day["holiday_hours"] . "</th>
                            <th></th>
                            <th>$daytime</th>
                        </tr>";
                        //Separator used for printing formatting
                    }

                    $weekhrs =  $week["regular"]+$week["overtime"]+$week["holiday_hours"];
                    $hrs = floor($weekhrs);
                    $mins = floor(($weekhrs-$hrs)*60);
                    $weektime = "$hrs:$mins";
                    if ($mins == 0) {
                        $weektime = $hrs;
                    }

                    print "<tr style='display: none;' class='separator'><th></th><th></th><th></th><th></th><th></th><th></th><th></th><th></th><th></th></tr><tr>
                        <th>Week Totals</th>
                        <th></th>
                        <th></th><th></th>
                        <th>" . $week["regular"] . "</th>
                        <th>" . $week["overtime"] . "</th>
                        <th>" . $week["holiday_hours"] . "</th>
                        <th></th>
                        <th>$weektime</th>
                    </tr></tbody></table>";
                }
                print "</th></tr></tbody></table></div>";
            } else {
                if ($export==1) { //regular export
                    $csv .= floor($employee_id) . " - " . $info["full_name"] . "\n";

                    foreach ($info["weeks"] as $title => $week) {
                        $weeks[$title]["days"] = array_values($week["days"]);
                        $csv .= "Week $title\n";
                        $csv .= "Date\tLunch Out\tTime In\tTime Out\tRegular\tOvertime\tHoliday\tNotes\tTotal";

                        foreach ($week["days"] as $day) {
                            $csv .= "\n";
                            foreach ($day["punches"] as $i => $punch) {
                                $csv .= (!$i ? date("m/d/Y", strtotime($punch["in_date"])) : "") . "\t";
                                $csv .= ($punch["is_lunch"] ? "Yes" : "No") . "\t";
                                $csv .= date("D, h:i A", strtotime($punch["in_date"])) . "\t";
                                $csv .= (!empty($punch["out_date"]) ? date("D, h:i A", strtotime($punch["out_date"])) : "N/A") . "\t";
                                $csv .= $punch["regular"] . "\t";
                                $csv .= $punch["overtime"] . "\t";
                                $csv .= $punch["holiday_hours"] . "\t";
                                $csv .= $punch["notes"] . "\t";
                                $csv .= ($punch["regular"]+$punch["overtime"]+$punch["holiday_hours"]) . "\n";
                            }
                            $csv .= "Day Totals\t\t\t\t" . $day["regular"] . "\t" . $day["overtime"] . "\t" . $day["holiday_hours"] . "\t\t" . ($day["regular"]+$day["overtime"]+$day["holiday_hours"]) . "\n";
                        }
                        $csv .= "Week Totals\t\t\t\t" . $week["regular"] . "\t" . $week["overtime"] . "\t" . $week["holiday_hours"] . "\t\t" . ($week["regular"]+$week["overtime"]+$week["holiday_hours"]) . "\n\n";
                    }
                } else { // if export is 2 or more
                    $name = $info["full_name"];
                    $comp = $info["company"];
                    $salaried = $info["salaried"];
                    foreach ($info["weeks"] as $title => $week) {
                        $reg_hours = $week["regular"];
                        $ot_hours = $week["overtime"];
                        $h_hours = $week["holiday_hours"];

                        $weekday = current($week["days"])["punches"][0]["in_date"];
                        $date = date("Y-m-d", strtotime("this friday", strtotime("$weekday -1 day")));

                        $item = "Hourly";
                        if ($salaried) {
                            $item = "Salary";
                            if ($reg_hours > 0) {
                                $reg_hours = 1;
                            }

                            if ($ot_hours > 0) {
                                $ot_hours = 0;
                                $reg_hours = 1;
                            }

                        }

                        if ($reg_hours > 0) {
                            $csv .= "\nTIMEACT\t$date\t\t$name\t\t$item\t$reg_hours\t\t\t1\t0";
                        }

                        if ($ot_hours > 0) {
                            $item = "Overtime";
                            if (!$salaried) {
                                $csv .= "\nTIMEACT\t$date\t\t$name\t\t$item\t$ot_hours\t\t\t1\t0";
                            }
                        }

                        if ($h_hours > 0) {
                            $csv .= "\nTIMEACT\t$date\t\t$name\t\tHoliday Pay\t$h_hours\t\t\t1\t0";
                        }


                        //switching to only have one punch on the friday of a given week -Josh Jan 2023
                        /*foreach ($week["days"] as $id => $day) {
                            $date = date("Y-m-d", strtotime($day["punches"][0]["in_date"]));
                            $reg_hours = $day["regular"];
                            $ot_hours = $day["overtime"];
                            $h_hours = $day["holiday_hours"];

                            $item = "Hourly";
                            if ($salaried) {
                                $item = "Salary";
                                if ($reg_hours > 0) {
                                    $reg_hours = 1;
                                }

                            }

                            if ($reg_hours > 0) {
                                $csv .= "\nTIMEACT\t$date\t\t$name\t\t$item\t$reg_hours\t\t\t1\t0";
                            }

                            if ($ot_hours > 0) {
                                $item = "Overtime";
                                if ($salaried) {
                                    $ot_hours = 0;
                                    $item = "Salary";
                                }

                                $csv .= "\nTIMEACT\t$date\t\t$name\t\t$item\t$ot_hours\t\t\t1\t0";
                            }

                            if ($h_hours > 0) {
                                $csv .= "\nTIMEACT\t$date\t\t$name\t\tHoliday Pay\t$h_hours\t\t\t1\t0";
                            }
                        }*/
                    }
                }
            }
        }
    }

    if ($export) {
        $filename = "Punches_$start-$end.xls";
        if ($export > 1) {
            $filename = "QuickBooks-Punches_$start-$end.iif";
            $csv = "!TIMEACT\tDATE\tJOB\tEMP\tITEM\tPITEM\tDURATION\tPROJ\tNOTE\tXFERTOPAYROLL\tBILLINGSTATUS" . $csv;
        }
        header("Content-type: application/octet-stream");
        header("Content-Disposition: attachment; filename=$filename");
        print $csv;
    }
}
if (!$export) {

print renderClosePanel();
print "</div>";
?>
<script>
    var start_date = new Date("<?=$start?>"), end_date = new Date("<?=$end?>");
    function page_init() {
        var is_weekpicker = false;
        function select_week() {
            setTimeout(function() {
                $(".ui-datepicker a.ui-state-active, .ui-datepicker a.selectedweek").parent().parent().addClass("selected");
            }, 50);
        }
        $(".weekpicker").on("change", function(e) {
            setTimeout(function() {
                var inst = $.datepicker._getInst(e.target);
                date = new Date(e.target.value);
                start_date = new Date(date.getFullYear(), date.getMonth(), date.getDate() - date.getDay());
                end_date = new Date(date.getFullYear(), date.getMonth(), date.getDate() - date.getDay() + 6);
                var dateFormat = $.datepicker._defaults.dateFormat;
                $('#start').val($.datepicker.formatDate( dateFormat, start_date ));
                $('#end').val($.datepicker.formatDate( dateFormat, end_date ));
            }, 50);
        });
        $(".datepicker").datepicker();

        $(".panel-close").remove();
    }

    function confirmModal(title,body,cb=function(){}) {
        $("#confModal .confTitle").text(title);
        $("#confModal .confBody").html(body);
        $("#confno").show();
        window.confInput = cb;
        $("#confModal").modal("show");
    }

    function toggleAdd() {
        var elm = $("#addpunch");
        if (elm[0].style.display != "none") {
            elm.slideUp();
        } else {
            elm.slideDown();
        }
    }

    function togglePoints() {
        var elm = $("#editpoints");
        if (elm[0].style.display != "none") {
            elm.slideUp();
        } else {
            elm.slideDown();
        }
    }

    function addPunch() {
        var in_date = $("#in").val();
        var out_date = $("#out").val();
        var notes = $("#addnotes").val();
        var is_lunch = $("#is_lunch").is(':checked');
        var holiday = $("#holiday").is(':checked');

        function apply() {
            var url = "timeclock/addPunch.php?employee=" + $("#employee").val() + "&in="+in_date+"&out="+out_date+"&notes="+notes+"&is_lunch=" + is_lunch + "&holiday=" + holiday + "&code=8383&rand="+Math.random();
            $.ajax({url: url, success:
                function(data) {
                    if(data=="success") {
                        document.location.reload();
                    } else {
                        $.gritter.add("Failed to add punch: " + data);
                    }
                }
            });
        }

        if (out_date != "") {
            var outdate = new Date(out_date);
            var indate = new Date(in_date);
            if (outdate.getTime() < indate.getTime()) {
                return $.gritter.add("Failed to add punch: Out time must be later than in time");
            }
            if (outdate.getDate() != indate.getDate()) {
                return confirmModal("Punch Day Mismatch","Are you sure punch out should be on a different day than punch in?",function(yes) {
                    if (yes) {
                        apply();
                    }
                });
            }
        }
        if (in_date == "") {
            return $.gritter.add("Failed to add punch: In time must be specified");
        }
        apply();
    }

    function changeAdjust() {
        var adj = +$("#point_adjustment").val();
        if (adj == 0) {
            $("#point_adjustment").css("color","black");
        }
        if (adj > 0) {
            $("#point_adjustment").css("color","green");
        }
        if (adj < 0) {
            $("#point_adjustment").css("color","red");
        }
    }

    function changeReason() {
        $("#point_adjustment").val($("#point_reason").val());
        changeAdjust();
    }

    function adjustPoints() { //! Decided against having a separate UI from the standalone page, obsolete code but keeping just in case (for now)
        var adj = $("#point_adjustment").val();
        var reason = $("#point_reason option:selected").text();
        var date = new Date($("#pointDate").val() + "T00:00:00");

        if (adj != "0" && reason != "Not Selected" && $("#pointDate").val() != "") confirmModal("Adjust Points?", "Are you sure you want to adjust points by <b style='color: " + (adj > 0 ? "green" : "red") + ";'>" + adj + "</b> points for <b>\"" + reason + "\"</b> on <b>" + date.toLocaleString("en-US", {year: 'numeric', month: 'long', day: 'numeric'}) + "</b>?", function(yes) {
            //adjust points
            if (yes) {
                $.ajax({
                    url: "",
                    success: function(data) {

                    }
                });
            }
        });
        //updateEmployeePoints.php?code=8383&id=EMPLOYEEID&adj=ADJUSTMENT&rsn=REASON&date=WHEN&rand=Math.random()
    }
    <?php
        $salaried = [];
        $sql = "select card_number, first_name, last_name from employees where inactive=0 and salaried=1 and company_id=?";
        list($rs)=runIQuery($db,$sql,["s",$company]);

        foreach ($rs as $emp) {
            $salaried[] = [
                "full_name" => $emp["first_name"] . " " . $emp["last_name"],
                "card_number" => $emp["card_number"],
                "checked" => true
            ];
        }
    ?>
    var salaried = <?=json_encode($salaried)?>;
    function addSalaryHours() {

        var html = "<h5>Please uncheck any employees that you do not want to give salary hours!</h5>";
        for (var i = 0; salaried.length > i; i++) {
            var emp = salaried[i];
            salaried[i].checked = true;
            html += `<input onchange='salaried[${i}].checked=!salaried[${i}].checked;' type='checkbox' name='emp${emp.card_number}' checked> <label for='emp${emp.card_number}'>${emp.full_name}</label><br>`;
        }
        confirmModal("Add Salary Hours", html, function(yes) {
            if (yes) {
                var checked = salaried.filter(x => x.checked);

                var formdata = "code=8383&salaried=1&date=<?=$end?>&start=<?=$start?>&company=<?=$company?>";
                var len = formdata.length;
                for (var j = 0; checked.length > j; j++) {
                    formdata  += "&emp" + j + "=" + checked[j].card_number;
                }

                if (formdata.length > len) { // only make a request if at least one employee is checked
                    var url = "timeclock/addPunch.php";
                    $.ajax({
                        url: url,
                        type: "POST",
                        data: formdata,
                        success: function(data) {
                            if (data != "success") {
                                $.gritter.add(data);
                            } else {
                                $.gritter.add("Added punches!");
                                window.location.reload();
                            }
                        }
                    });
                } else {
                    $.gritter.add("No Punches Added: No salaried employees selected");
                }
            }
        });
    }

    function addHolidayHours() {
        var holidays = <?=json_encode($holidays)?>;
        var prompt = "Add Holiday hours for these dates?<br>";
        holidays.forEach(function(x) {
            prompt += x.date + " - " + x.name + "<br>";
        });

        confirmModal("Add Holiday Hours?", prompt, function(yes) {
            // apply hours
            $("#confModal").modal("hide");
            if (yes) {
                $.ajax({
                    url: "timeclock/addHolidayHours.php?code=8383&company=<?=$company?>&rand="+Math.random(),
                    success: function(data) {
                        if (data[0] == "[") {
                            var json = JSON.parse(data);
                            /*
                            5.75-6 hours of holiday pay and 1/4 point back.
                            5.50-4 hours of holiday pay and will be given .5 points back.
                            5.25-2 hours of holiday pay and will be given .75 points back.
                            5 points or less you will receive 0 hours of holiday pay and will be given 1 point back.
                            */
                            // if given_points greater than 0 then they got fewer hours and need points adjusted
                            // if gets_holidays is false then they did not work the day before and the day after the holiday
                            var text = "The following employees need their points adjusted or did not get an holiday hours:<br>";
                            for (var i = 0; json.length > i; i++) {
                                var emp = json[i];
                                var reason = "Did not work the day before and after the holiday";
                                if (emp.given_points > 0) {
                                    reason = "Needs " + emp.given_points + " points, only gets " + emp.given_hours + " holiday hours";
                                }
                                if (emp.given_points == 1) {
                                    reason = "Needs 1 point, no holiday hours given";
                                }

                                text += `<a href="#" onclick="window.open('listPunches.php?employee=${emp.card_number}&start=<?=$start?>&end=<?=$end?>&company=<?=$company?>', '_blank');">${emp.full_name}</a> - ${reason}<br>`;
                            }
                            setTimeout(function() {

                                confirmModal("Holiday Pay Results", text, function(yes) {
                                    $("#confModal").modal("hide");
                                    window.location.reload();
                                });
                                $("#confno").hide();
                            }, 1000);

                            //window.location.reload();
                        } else {
                            $.gritter.add("Failed to add holiday hours: " + data);
                        }
                    }
                });
            }
        });
    }

    function printPage() {
        $(".printarea").empty();
        $(".punchtables").clone().appendTo(".printarea");
        $(".header, .page-container, div b:contains('Page loaded in ')").hide();
        $(".separator, .printarea").show();
        window.print();
        $(".header, .page-container, div b:contains('Page loaded in ')").show();
        $(".separator, .printarea").hide();
    }
</script>

<?php
    include("footer.php");
}
if ($export) {
    die;
}
?>
<div class='weekpickerbox'></div>
<div style='text-align: left; background-color: #ffffff; display: none; z-index: 99999; font-size: 1px;' class='printarea'></div>