<?php
#error_reporting(E_ALL);
#ini_set('display_errors','on');
date_default_timezone_set('America/Detroit');
include('dbConnection.php');
## session start is now in dbconnection.php;
include('functions.php');
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
require_once('Psr/autoloader.php');
require_once('PHPOffice/PhpSpreadsheet/autoloader.php');
require 'Mail/class.phpmailer.php';
include('tcpdf.php');
include('tcpdf_barcodes_1d.php');
$pdf = new TCPDF("P","pt","LETTER");
$pdf->SetAutoPageBreak(false, 0);
$pdf->setCellPaddings(0,0,0,0);
#$barcode = $pdf->addTTFfont('FREE3OF9.TTF', '', '', 32);
#$pdf->setFontSubsetting(false);
$pdf->SetLeftMargin(.20);
$pdf->SetRightMargin(.20);
$pdf->SetTextColor(0,0,0,100); ## 100% black
$pdf->SetDrawColor(0,0,0,100);
$pdf->SetLineWidth(1);

function printHeader($pdf,$start,$end) {
		$pdf->AddPage();
		$pdf->Image("logoblank.jpg",0,0,660,100,'','','',true);
		$pdf->Image("images/logoblack.png",1,1,125, 50,'','','',true);
		$pdf->SetFont("times","I",8,'',false);
		$pdf->SetXY(520,10);
        $pdf->Write("10",'Page '.$pdf->getAliasNumPage().' of '.$pdf->getAliasNbPages());
		$pdf->SetFont("times","",10,'',false);
		$pdf->SetXY(150,10);
		$pdf->Write(16,"Production Results $start - $end");

		$pdf->SetXY(300,26);
		$pdf->Write(16,"Printed " . Date("l, m/d/Y h:i:s"));	
		$pdf->SetXY(20,50);
		$pdf->Write(16,"Work Center");		
		$pdf->SetXY(80,50);
		$pdf->Write(16,"Job-Step");		
		$pdf->SetXY(140,50);
		$pdf->Write(16,"Part");		
		$pdf->SetXY(200,50);
		$pdf->Write(16,"Employee");		
		$pdf->SetXY(250,50);
		$pdf->Write(16,"Duration");		
		$pdf->SetXY(300,50);
		$pdf->Write(16,"Qty Good");		
		$pdf->SetXY(350,50);
		$pdf->Write(16,"Qty Scheduled");		
		$pdf->SetXY(420,50);
		$pdf->Write(16,"Complete");		
		$pdf->SetXY(490,50);
		$pdf->Write(16,"Next Up");		
		// enclosing box
		$pdf->Rect(18,50,565,1);
}
$lc=99;


$start=Date("Y-m-d 05:29:00");
$dtmessage=Date("m/d/Y");
$end=Date("Y-m-d 23:59:59");
if (isset($_GET['start'])) {	
	$start=$_GET['start'];	
	$end=$_GET['end'];
	$dtmessage=$start;
	if ($end) {
		$dtmessage .= " - " . $end;
	}
	if ($start=="yesterday") {
		$date = new DateTime();
		$date->add(DateInterval::createFromDateString('yesterday'));
		$start=$date->format("Y-m-d");
		$end=Date("Y-m-d 05:29:00");
		$dtmessage=$date->format("m/d/Y");
		$dtmessage .= " - " . Date("m/D/Y") . "(5:30)";
	}
}
if (isset($_GET['end'])) {
	$end=$_GET['end'] . " 23:59:59";
}

$sql="select j.job_id, r.display_sequence, last_name, first_name,  duration_hours, duration_minutes, p.quantity_good, clocked_time, p.complete, workcenter_name, j.item_id, j.quantity_scheduled, result_date from production_results p inner join routing r on p.routing_id=r.routing_id left outer join employees e on p.employee_id=e.employee_id left outer join workcenters w on w.workcenter_id=r.workcenter_id inner join jobs j on j.job_id=p.job_id where ";
if ($end != $start) {
	$sql.=" clocked_time >= '$start' and clocked_time <= '$end' ";
} else {
	$sql.=" clocked_time >='$start'  ";
}
$sql.=" order by workcenter_name, clocked_time ";  

$title="Production Results";
if ($_GET['code']=='8385' ) {
	$filename="Production-Results.xls";
	$objSpreadsheet = new Spreadsheet();

	// Set document properties
	$objSpreadsheet->getProperties()->setCreator("Influx MFG")
								 ->setLastModifiedBy("SYSTEM")
								 ->setTitle($title)
								 ->setSubject($title)
								 ->setDescription($title)
								 ->setKeywords($title)
								 ->setCategory("Influx MFG");



	// Add some data
	$objSpreadsheet->setActiveSheetIndex(0);
	$objSpreadsheet->getActiveSheet()->setTitle($title);
	$objSpreadsheet->getActiveSheet()->SetCellValue('A1', $title);
	$objSpreadsheet->getActiveSheet()->SetCellValue('B1', " for " . $dtmessage);
	$objSpreadsheet->getActiveSheet()->SetCellValue('C1', "Run At " . Date("m/d/Y h:i"));
	$objSpreadsheet->getActiveSheet()->SetCellValue('A3', 'Work Center');
	$objSpreadsheet->getActiveSheet()->SetCellValue('B3', 'Job-Step');
	$objSpreadsheet->getActiveSheet()->SetCellValue('C3', 'Part');
	$objSpreadsheet->getActiveSheet()->SetCellValue('D3', 'Employee');
	$objSpreadsheet->getActiveSheet()->SetCellValue('E3', 'Duration');
	$objSpreadsheet->getActiveSheet()->SetCellValue('F3', 'Qty Good');
	$objSpreadsheet->getActiveSheet()->SetCellValue('G3', 'Qty Scheduled');
	$objSpreadsheet->getActiveSheet()->SetCellValue('H3', 'Complete');
	$objSpreadsheet->getActiveSheet()->SetCellValue('I3', 'Next Up');

	$objSpreadsheet->getActiveSheet()->GetColumnDimension('A')->setAutoSize(true);
	$objSpreadsheet->getActiveSheet()->GetColumnDimension('B')->setAutoSize(true);
	$objSpreadsheet->getActiveSheet()->GetColumnDimension('C')->setAutoSize(false);
	$objSpreadsheet->getActiveSheet()->GetColumnDimension('D')->setAutoSize(true);
	$objSpreadsheet->getActiveSheet()->GetColumnDimension('E')->setAutoSize(true);
	$objSpreadsheet->getActiveSheet()->GetColumnDimension('F')->setAutoSize(true);
	$objSpreadsheet->getActiveSheet()->GetColumnDimension('G')->setAutoSize(true);
	$row=3;
	list($result,$err)=runIQuery($db,$sql);
	$holdWC="";
	foreach ($result as $data) {
		$row++;
		$wc=$data['workcenter_name'];
		if ($holdWC != $wc) {
			if ($holdWC) {
				$row++;
			}
			$holdWC=$wc;
		}
		$job=$data['job_id'];
		$seq=$data['display_sequence'];
		$item=$data['item_id'];
		$employee=$data['first_name'] . " " . $data['last_name'];			$duration=abs($data['duration_hours']) * 60;
		$duration+=abs($data['duration_minutes']);
		$qty=$data['quantity_good'];
		$scheduled=$data['quantity_scheduled'];
		$dt=formatDateDBToWeb($data['result_date']);
		$complete=$data['complete'];
		if ($complete) {
			$complete="Y";
		} else {
			$complete="N";
			$sql="select sum(quantity_good) as totgood from production_results, routing where production_results.routing_id = routing.routing_id and job_id=? and display_sequence=? ";
			list($prs,$err)=runIQuery($db,$sql,array("ii",$job,$seq));
			$data=$prs[0];
			if ($data[0] >= $scheduled) {
				$complete="Y";
			}
		}
		## get the next WC
		$sql="select workcenter_name from routing, workcenters where routing.workcenter_id = workcenters.workcenter_id and display_sequence > ? and parent_part=?  order by display_sequence LIMIT 1 ";
		list($prs,$err)=runIQuery($db,$sql,array("is",$seq,$item));
		$next="";
		if (count($prs)>0) {
			$data=$prs[0];
			$next=$data[0];
		}

		$objSpreadsheet->getActiveSheet()->SetCellValue("A".$row, $wc);
		$objSpreadsheet->getActiveSheet()->SetCellValue("B".$row, "$job-$seq");
		$objSpreadsheet->getActiveSheet()->SetCellValue("C".$row,$item . " ");
		$objSpreadsheet->getActiveSheet()->SetCellValue("D".$row, $employee);
		$objSpreadsheet->getActiveSheet()->SetCellValue("E".$row, $duration);
		$objSpreadsheet->getActiveSheet()->SetCellValue("F".$row, number_format($qty,0));
		$objSpreadsheet->getActiveSheet()->SetCellValue("G".$row, number_format($scheduled,0));
		$objSpreadsheet->getActiveSheet()->SetCellValue("H".$row, $complete);
		$objSpreadsheet->getActiveSheet()->SetCellValue("I".$row, $next);
		if ($lc > 40) {
			printHeader($pdf,formatDateDBToWeb($start),formatDateDBToWeb($end));
			$lc=0;
		}
		$lc++;
		$xpos=50 + ($lc * 19);
		$pdf->SetFont("times","",8,'',false);
		$pdf->SetXY(20,$xpos);
		$pdf->Write(16,$wc);		
		$pdf->SetXY(80,$xpos);
		$pdf->Write(16,"$job-$seq");		
		$pdf->SetXY(140,$xpos);
		$pdf->Write(16,$item);		
		$pdf->SetFont("times","",6,'',false);
		$pdf->SetXY(200,$xpos);
		$pdf->Write(16,$employee);		
		$pdf->SetXY(250,$xpos);
		$pdf->SetFont("times","",8,'',false);
		$pdf->Write(16,$duration);		
		$pdf->SetXY(300,$xpos);
		$pdf->Write(16,number_format($qty));		
		$pdf->SetXY(350,$xpos);
		$pdf->Write(16,number_format($scheduled));		
		$pdf->SetXY(420,$xpos);
		$pdf->Write(16,$complete);		
		$pdf->SetXY(490,$xpos);
		$pdf->Write(16,$next);		

	}
	$row++;
	
	$prfname="/var/www/vhosts/ip-50-63-152-47.ip.secureserver.net/httpdocs/documents/ProductionResults.pdf";	
	if (file_exists($prfname)) {
		unlink($prfname);
	}
	$pdf->Output($prfname, "F");
	
	$objWriter = IOFactory::createWriter($objSpreadsheet, 'Xls');


	$fname="/var/www/vhosts/ip-50-63-152-47.ip.secureserver.net/httpdocs/documents/" . $filename;
	if (file_exists($fname)) {
		unlink($fname);
	}
	$objWriter->save($fname);
	$mail = new PHPMailer();
	$mail->IsSMTP();
	$mail->SMTPDebug  = 0;
	$mail->Debugoutput = 'html';
	$mail->Host       = 'smtp.googlemail.com';
	$mail->Port       = 587;
	$mail->SMTPSecure = 'tls';
	$mail->SMTPAuth   = true;
	$mail->Username   = "chris@netinflux.com";
	//Password to use for SMTP authentication
	$mail->Password   = "Cathie@9448";
	$mail->SetFrom("chris@netinflux.com","Influx MFG");
	$mail->AddAddress("sales@netinflux.com","Chris Allen");
	## they do not want weekend emails
	if (Date("w") > 0) {
		if (Date("w") < 6) {
			$mail->AddAddress("rcox@callcma.com","Rick Cox");
			$mail->AddAddress("jplatt@callcma.com","Jim Platt");
			$mail->AddAddress("dvoss@callcma.com","Diane Voss");
			$mail->AddAddress("gmeller@callcma.com","Greg Meller");
			$mail->AddAddress("jrosenberg@callcma.com","Jamie Rosenberg");
		}	
	}
	$mail->Subject = "Production Results for " . $dtmessage;
	$mail->AltBody = "Production Results are attached.";
	$mail->MsgHTML("<b>Production Results are attached</b>");
	$mail->AddAttachment($fname);	
	$mail->AddAttachment($prfname);	
	## 3 tries	
	if(!$mail->Send()) {
		if(!$mail->Send()) {
			if(!$mail->Send()) {
					print "error sending...";
			} else {
				print "Sent.";
			}
		} else {
			print "Sent.";
		}
	} else {
		print "Sent.";
	}
	unlink($fname);
}

?>