<?php
#error_reporting(E_ALL);
#ini_set('display_errors','on');
include('dbConnection.php');
## session start is now in dbconnection.php;
include('functions.php');
## if send pack slip, then it is either to update the invoice number, or to list the packing slip details.
if (isset($_GET['pack'])) {
	$id=$_GET['pack'];
	if ($_GET['code'] == 'WELD443') {
		if (isset($_GET['invoice'])) {
			## update packing slip
			$inv=$_GET['invoice'];
			$sql="update packing_slip set invoice_number=? where packing_slip_id=?";
			list($rs,$err)=runIQuery($db,$sql,array("si",$inv,$id));
		}	 else {
			$sql="select name from packing_slip_lines l, orders o, customers c where packing_list_id=? and l.order_id=o.order_id and o.customer_id=c.customer_id ";
			list($rs,$err)=runIQuery($db,$sql,array("i",$id));
			$data=$rs[0];
			$customerName=$data[0];
			$sql="select * from packing_slip inner join packing_slip_lines on packing_slip_id=packing_list_id ";
			$sql.=" inner join orders o on packing_slip_lines.order_id=o.order_id left outer join order_classes c on o.order_class=c.class_id ";
			$sql.=" where packing_slip_id=? and packing_slip_id=packing_list_id ";
			$sql.="  order by line_id ";
			list($rs,$err)=runIQuery($db,$sql,array("i",$id));

			$totalMOQ = 0;
			$tmpdata = 0;
			foreach ($rs as $data) {
				$shipName=$data['ship_name'];
				$shipAddress=$data['ship_address'];
				$shipAddress2=$data['ship_address2'];
				if ($customer != $shipName) {
					$shipAddress2=$shipAddress;
					$shipAddress=$shipName;
				}
				print $data['attention'];
				print "|";
				print $customerName;
				print "|";
				print $shipAddress;
				print "|";
				print $shipAddress2;
				print "|";
				print $data['ship_city'];
				print "|";
				print $data['ship_state'];
				print "|";
				print $data['ship_zip'];
				print "|";
				print $data['po_number'];
				print "|";
				print $data['po_line'];
				print "|";
				print $data['order_id'];
				$po=$data['po_number'];
				$customer=$data['customer_id'];
				print "|";
				## part number is currently either Weldment or Steel - based on category
				$part=$data['part_number'];
				$description=$data['part_number'] . " " . $data['description'];
				$sql="select item_category from items where item_name=?";
				list ($irs,$err)=runIQuery($db,$sql,array("s",$part));
				$part="Weldment";
				if (count($irs) > 0) {
					$idata=$irs[0];
					$category=$idata[0];
					if ($category == 15) {
						$part="Weldment";
					} else {
						$part="Steel";
					}
				}
				print $part;
				print "|";
				print $data['quantity'];
				## get price - from so if possible otherwise part master otherwise based on production results
				$oline=$data['order_line'];
				$onum=$data['order_id'];
				$part=$data['part_number'];
				$price=-1;
				$order_quantity = 0;
				if ($onum and $oline) {
					$sql="select price, cost, quantity from order_lines where line_id=? or (order_id=? and item_id=?) ";
					list($irs,$err)=runIQuery($db,$sql,array("iis",$oline,$onum,$part));
					foreach ($irs as $idata) {
						$price=number_format($idata['price'],4);
						$cost=number_format($idata['cost'],4);
						$order_quantity=$idata["quantity"];
						if ($customer == 693 && $order_quantity < 10) { // add MOQ -Josh 01-03-2023
							$totalMOQ += 75;
						}
					}
				}
				if ($price < 0) {
					$price=0;
				}
				print "|";
				if (! $price) {
					$price=0;
				}
				print $price;
				print "|";
				if (! $cost) {
					$cost=0;
				}
				print $cost;
				print "|";
				$description=str_replace("|","",$description);
				print $description;
				## now indicate whether EDI or not
				$edi="NO";
				if ($customer == 693) {
					$sql="select * from edi_orders where po_number=?";
					list($edirs,$err)=runIQuery($db,$sql,array("s",$po));
					if (count($edirs)>0) {
						$edi="YES";
					}
				}
				print "|";
				print $edi;
				print "|";
				print $data['class_name'];
				print "\n";
				$tmpdata = $data;
			}

			// print MOQ -Josh 01-04-2023
			// print MOQ if needed
			if ($customer == 693 && $totalMOQ != 0 and 1 < 0) {
				$moqQTY = $totalMOQ/75;

				print $tmpdata['attention'];
				print "|";
				print $customerName;
				print "|";
				print $shipAddress;
				print "|";
				print $shipAddress2;
				print "|";
				print $tmpdata['ship_city'];
				print "|";
				print $tmpdata['ship_state'];
				print "|";
				print $tmpdata['ship_zip'];
				print "|";
				print $tmpdata['po_number'];
				print "|";
				print "9999";
				print "|";
				print $tmpdata['order_id'];
				print "|";
				print "Minimum Order Quantity Fee";
				print "|";
				print $moqQTY;
				print "|";
				print number_format($totalMOQ,4);
				print "|";
				print "0.0000"; // cost
				print "|";
				print "MOQ FEE"; // desc
				print "|";
				print $edi; // edi
				print "|";
				print $tmpdata['class_name'];
				print "\n";
			}
		}
	}
} else {
	$sql="select packing_slip_id, customers.name, date_shipped, invoice_number from packing_slip, customers where packing_slip.customer_id=customers.customer_id 
		and coalesce(invoice_number,'0')='0' and coalesce(date_shipped,'0000-00-00') <> '0000-00-00' and name  <> '' 
		and packing_slip_id in (select packing_list_id from packing_slip_lines where order_id < 100000) 
		 order by name, date_shipped";
	list($rs,$err)=runIQuery($db,$sql);
	foreach ($rs as $data) {
		print $data['packing_slip_id'];
		print "|";
		print $data['name'];
		print "|";
		print formatDateDBToWeb($data['date_shipped']);
		print "|";
		print $data['invoice_number'];
		print "\n";
	}
}
?>