<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
$activePanel='openpo';
$pageTitle="Purchase Orders";
include('header.php');
print renderPanel("Purchase Orders");
$start_date=$_POST['start_date'];
if (! $start_date) {
$start_date=Date("m/1/Y");
}
$end_date=$_POST['end_date'];
if (! $end_date) {
$end_date=Date("m/d/Y");
}
$vendor=0;
if (isset($_POST['vendor'])) {
	$vendor=$_POST['vendor'];
}
$who=0;
if (isset($_POST['who'])) {
    $who=$_POST['who'];
}
$searchjob="";
if (isset($_POST['searchjob'])) {
    $searchjob=$_POST['searchjob'];
}
print "<form name='listform' method='POST' action='listPO.php'>\n";
print renderDateBox(TRUE,"start_date",$start_date,"Start Date");
print renderDateBox(TRUE,"end_date",$end_date,"End Date");
print "<div style='clear: both;'></div>";
$sql="select vendor_id, vendor_name from vendors order by vendor_name";
list($rs,$err)=runIQuery($db,$sql);
print renderSelect(TRUE,"vendor",$vendor,"Vendor","N",$rs,1);
$sql="select user_id, email from site_admins where coalesce(inactive,0)=0 ";
$sql.=" and user_id in (select distinct who from purchase_orders)  ";
$sql.=" order by email ";
list($rs,$err)=runIQuery($db,$sql);
print renderSelect(TRUE,"who",$who,"Buyer","N",$rs,1);
print "<div style='clear: both;'></div>";
print renderTextBox(TRUE,"searchjob",$searchjob,"Search");
print renderButton("Find","red","document.listform.submit();");
print "<a href='#' id='downloader'>" . renderButton("Export","blue","tableToTab('openPOList','POList.xls')") . "</a>";
print renderButton("+ Add New","green","newPO()");
print "</form>";
$sql="select distinct p.po_id, vendor_name, status_name, l.folder_number, coalesce(date_po_created,po_date) as po_date, full_name, l.date_expected, l.item_id ";
$sql.=" from purchase_orders p inner join po_lines l on p.po_id=l.po_id left outer join site_admins a on p.who=a.user_id ";
$sql.=" left outer join vendors v on p.vendor_id=v.vendor_id left outer join po_status on p.status=status_id ";
$sql.=" where date_expected >= '" . formatDateWebtoDB($start_date) . "' ";
$sql.=" and date_expected <= '" . formatDateWebToDB($end_date) . "' ";
if ($vendor) {
	$sql.=" and  p.vendor_id = $vendor  ";
}
if ($who) {
    $sql.=" and p.who= $who ";
}
if ($searchjob) {
    $sj="%" . $searchjob . "%";
    if (is_numeric($searchjob)) {
        $sql.=" and  ( p.po_id = ? or item_id like ? or description like ? or folder_number like ? ) ";
    } else {
        $sql.=" and  ( item_id like ? or description like ? or folder_number like ? ) ";
    }
}
$sql.=" order by date_expected, item_id";
print "<table class='table table-striped' id='openPOList'>";
print "<thead>";
print "<tr>";
print "<th valign='top'>";
print "PO#";
print "</th>";
print "<th valign='top'>";
print "Vendor";
print "</th>";
print "<th valign='top'>";
print "Buyer";
print "</th>";
print "<th valign='top'>";
print "Date Created";
print "</th>";
print "<th valign='top'>";
print "Date Expected";
print "</th>";
print "<th valign='top'>";
print "Folder";
print "</th>";
print "<th valign='top'>";
print "Date Sent";
print "</th>";
print "<th valign='top' style='width: 200;'>";
print "Sent To";
print "</th>";
print "<th valign='top'>";
print "Viewed";
print "</th>";
print "</tr>\n";
print "</thead><tbody>";
if ($searchjob) {
    if (is_numeric($searchjob)) {
        list($rs,$err)=runIQuery($db,$sql,array("isss",$searchjob,$sj,$sj,$sj));
    } else {
        list($rs,$err)=runIQuery($db,$sql,array("sss",$sj,$sj,$sj));
    }
} else {
    list($rs,$err)=runIQuery($db,$sql);
}
foreach ($rs as $data) {
	$po=$data['po_id'];
	$vend=$data['vendor_name'];
	$s=$data['status_name'];
	$job=$data['folder_number'];
	$buyer=$data['full_name'];
	$created=formatDateDBToWeb($data['po_date']);
	$sql="select distinct date_expected from po_lines where po_id=? ";
	list($irs,$err)=runIQuery($db,$sql,array("i",$po));
	$dt="";
	foreach ($irs as $idata) {
		if ($dt) {
			$dt.="<BR>";
		}
		$dt.=formatDateDBToWeb($idata['date_expected']);
	}
	print "<tr>";
	print "<td valign='top'><a  target='_blank' href='editPO.php?table=purchase_orders&key=po_number&id=$po'>";
	print $po;
	print "</a></td>";
	print "<td valign='top'><a  target='_blank' href='editPO.php?table=purchase_orders&key=po_number&id=$po'>";
	print $vend;
	print "</a></td>";
	print "<td valign='top'><a  target='_blank' href='editPO.php?table=purchase_orders&key=po_number&id=$po'>$buyer</a></td>";
	print "<td valign='top'><a  target='_blank' href='editPO.php?table=purchase_orders&key=po_number&id=$po'>$created</a></td>";
	print "<td valign='top'><a  target='_blank' href='editPO.php?table=purchase_orders&key=po_number&id=$po'>";
	print $dt;
	print "</a></td>";
	print "<td valign='top' align='center'>";
	print $job;
	print "</td>";
	$sql="select * from email_log where email_type='PO' and document_number=? order by email_date ";
	list($ers,$err)=runIQuery($db,$sql,array("i",$po));
	$sent="";
	$recipient="";
	$viewed="";
	foreach ($ers as $edata) {
		if ($sent) {
			$sent.="<BR>";
		}
		$sent.=formatDateDBToWeb($edata['email_date']);
		if ($recipient) {
			$recipient.="<BR>";
		}
		$nextrecip=strtolower($edata['email_recipient']);
		$nextrecip=str_replace(",purchasing@preferredmachinellc.om","",$nextrecip);
		$nextrecip=str_replace(",purchasing@preferredmachinellc.com","",$nextrecip);
		$nextrecip=str_replace("purchasing@preferredmachinellc.com","",$nextrecip);
		$recipient.=$nextrecip;
		if ($viewed) {
			$viewed.="<BR>";
		}
		$viewed.=formatDateDBToWeb($edata['viewed_date']);
	}
	print "<td valign='top'>";
	print $sent;
	print "</td>";
	print "<td valign='top'>";
	print $recipient;
	print "</td>";
	print "<td valign='top'>";
	print $viewed;
	print "</td>";
	print "</tr>\n";
}
print "</tbody></table>";
print renderClosePanel();
?>
<script>

function tableToTab(tableid, filename="download.xls") {
	var csv = "";
	var rows = $("#"+tableid+" tr");

	for(var i = 0; rows.length > i; i++) {
		var row = rows[i].innerText.replace(/\n/g," ");
		csv += row + "\n";
	}

	var a = document.getElementById("downloader");
	var file = new Blob([csv], {type: 'text/plain'});
	a.href = URL.createObjectURL(file);
	a.download = filename;
}



function exportListPO(tblid) {
    var uri = 'data:application/vnd.ms-excel;base64,'
          , template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body><table>{table}</table></body></html>'
          , base64 = function (s) { return window.btoa(unescape(encodeURIComponent(s))); }
          , format = function (s, c) { return s.replace(/{(\w+)}/g, function (m, p) { return c[p]; }); };
        table = document.getElementById(tblid);
        var ctx = { worksheet: name || 'Worksheet', table: table.innerHTML };
        window.location.href = uri + base64(format(template, ctx));

}
var currentObj;

function newPO() {
	window.open('editPO.php?id=0','_blank');
}

function page_init() {
	jQuery('.datepicker').datepicker();

}
</script>
</div>
<?php
include('footer.php');
