<?php

include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');
// status 8 is at processor
$sql = "select distinct o.order_id, i.vendor_id from orders o, order_lines ol, items i where o.ship_name='Preferred Machine-OSW' and o.status=8 and ol.order_id=o.order_id and i.item_name=ol.item_id order by o.date_due";

list($rs,$err)=runIQuery($db,$sql);
print renderPanel("Outsourced Weldments");
print renderButton("Receive","blue","processList()");
print "<table class='table table-striped'><thead><tr><th>Order</th><th>Outsourced Welder</th><th>Part</th><th>Description</th><th>Quantity Open</th><th>Quantity Received</th></tr></thead><tbody>";
$lc=0;
foreach ($rs as $data) {
    $order=$data['order_id'];
    $vendor=$data['order_vendor'];
    $sql="select * from vendors where vendor_id=?";
    list($vrs,$err)=runIQuery($db,$sql,array("i",$vendor));
    $vdata=$vrs[0];
    $name=$vdata['vendor_name'];
	$sql="select * from order_lines where order_id=$order and coalesce(shipped_quantity,0)<quantity order by line_id ";
	list($lrs,$err)=runIQuery($db,$sql);
	$linedata="";
	foreach ($lrs as $ldata) {
		$line=$ldata['line_id'];
		$item=$ldata['item_id'];
        $desc=$ldata['item_description'];
        $quantity=$ldata['quantity'];
        $shipped=$ldata['shipped_quantity'];
        $quantity-=$shipped;
        if ($quantity < 0) {
            $quantity=0;
        }
        $desc=str_replace("|","",$desc);
        $lc++;
        print "<tr><td>$order</td><td>$name</td><td>$item</td><td>$desc</td<td>$quantity</td><td>";
        print "<input type='text' name='rqty$lc' id='rqty$lc'>";
        print "<input type='hidden name='line$lc' id='line'$lc'>";
        print "</td></tr>\n";
	}
}
print "</tbody></table>";
print renderClosePanel();
?>
<script>
function processList() {
    foreach (i=1; i<=<?=$lc?>; i++) {
        rqty=document.getElementById('rqty'+i).value;
        if (rqty != '') {
            if (rqty != '0') {
                oline=document.getElementById('line'+i).value;
                url='receiveOSW.php?qty='+rqty+'&line='+oline+'&rand='+Math.random();
                $.ajax(url);
            }
        }
    }
    document.location.reload();
}
</script>
<?php
include('footer.php');