<?php
##detail=1 gets you line items
include('dbConnection.php');
include('functions.php');
include('header.php');
if (! isset($_GET['code'])) {
	exit;
}
$code=$_GET['code'];
if ($code != '8383') {
	exit;
}
$order=$_GET['order'];
$sql="select name from orders, customers where order_id=? and orders.customer_id=customers.customer_id";
list($rs,$err)=runIQuery($db,$sql,array("i",$order));
$customer=$rs[0][0];
$sql=" select o.ship_name, o.shop_notes, o.notes_to_self, item_id, item_description, quantity, due_date, revision, xdimension, ydimension, weight, ";
$sql.=" color_code, color_description, plugs, masking from orders o inner join order_lines l on o.order_id=l.order_id ";
$sql.=" left outer join order_line_color c on l.line_id=c.order_line ";
$sql.=" left outer join vendor_colors vc on c.color_id=vc_id where o.order_id=? order by o.order_id desc ";
list($rs,$err)=runIQuery($db,$sql,array("i",$order));
print renderPanel("Order Detail");
print "<table class='table table-striped'>";
print "<thead><tr><th>Customer</th><th>Due</th><th>Part</th><th>Description</th><th>Revision</th><th>Quantity</th><th>Length</th><th>Width</th><th>Weight</th>";
print "<th>Color</th>";
print "<th>Plugs</th><th>Masking</th>";
print "<th>Notes</th></tr>\n";
print "</thead><tbody>";
foreach ($rs as $data) {
		$notes=$data['notes_to_self'] . " " . $data['shop_notes'];
		$notes=trim($notes);
		$name=$data['ship_name'];
		$item=$data['item_id'];
		
		$description=$data['item_description'];
		$qty=$data['quantity'];
		$due=formatDateDBToWeb($data['due_date']);
		$rev=$data['revision'];
		$x=$data['xdimension'];
		$y=$data['ydimension'];
		if ($x < $y) {
			$s=$x;
			$x=$y;
			$y=$s;
		}
		$weight=$data['weight'];
		$color=$data['color_code'] . " " . $data['color_description'];
        $plugs=$data['plugs'];
        $mskiong=$data['masking'];
		print "<tr><td valign='top'>$name</td><td valign='top'>$due</td><td valign='top'>";
		$sql="select name from orders o, customers c where o.order_id=? and o.customer_id=c.customer_id";
		list($crs,$err)=runIQuery($db,$sql,array("i",$order));
		$name=$crs[0][0];
		print renderPartLink($name,$item);
		print "</td><td valign='top'>$description</td><td valign='top'>$rev</td>";
		print "<td valign='top'>$qty</td><td valign='top'>$x</td><td valign='top'>$y</td><td valign='top'>$weight</td><td valign='top'>$color</td>";
		print "<td valign='top'>$plugs</td><td>$masking</td>\n";
		print "<td valign='top'>$notes</td></tr>\n";
}
print "</tbody>";
print "</table>";
print renderClosePanel();
include('footer.php');