<?php
include('dbConnection.php');
include('functions.php');
$days=30;
if (isset($_GET['days'])) {
    $days=$_GET['days'];
}
$delim=",";
if ($_GET['code'] != '8383') {
	exit;
}

ob_end_flush();

$sql="select distinct  c.customer_id, c.name, j.job_id, j.item_id, j.description, j.start_date, j.quantity_scheduled, o.date_due, ";
$sql.=" (j.quantity_scheduled - j.quantity_good) as tocut, i.item_name as material, i.thickness, l.order_id, l.line_id, p.revision ";
$sql.=" from jobs j inner join order_lines l on j.line_id=l.line_id inner join routing r on j.item_id=parent_part and operation_id=3123 ";
$sql.=" inner join customers c on j.customer_id=c.customer_id ";
$sql.=" inner join orders o on l.order_id=o.order_id and o.status  not in (3,4,5,6,16,17,19) ";
$sql.=" inner join billofmaterial b on j.item_id=parent_item and r.routing_id=b.routing_id ";
$sql.=" inner join items i on b.child_item=i.item_name and i.item_category=24 ";
$sql.=" inner join items p on j.item_id=p.item_name ";
$sql.=" left outer join production_results pr on pr.job_id=j.job_id and pr.routing_id=r.routing_id ";
$sql.=" where j.status in (1,2)  ";
$sql.=" and coalesce(l.shipped_quantity,0) < l.quantity ";
$sql.=" and i.width <= 120.2 and i.length <= 120.2 ";
$sql.=" and j.job_id not in (select job_id from skip_laser_jobs) ";
$sql.=" and l.due_date <= date_add(sysdate(), INTERVAL $days DAY)  ";
$sql.=" group by  c.customer_id, c.name, j.job_id, j.item_id, j.description, j.start_date, j.quantity_scheduled,";
$sql.=" j.quantity_good, i.item_name, i.thickness, l.order_id, l.line_id, p.revision ";
$sql.=" having sum(coalesce(pr.quantity_good,0)) < j.quantity_scheduled ";
list($rs,$err)=runIQuery($db,$sql);
foreach ($rs as $data) {
    set_time_limit(120);
	$line=$data['line_id'];	
	## $dt=$data['start_date'];
    ### cma 3/1/23 per Justin we want the order due date
	$orderdue=$data['date_due'];
    $dt=$orderdue;
	$odue=substr($orderdue,5,5);
    $job=$data['job_id'];
	$folder=$data['order_id'];
	$item=$data['item_id'];
	$desc=$data['description'];
    $desc=str_replace(",","",$desc);
    $desc=str_replace("#","",$desc);
    $desc=str_replace("&","",$desc);
    $desc=str_replace("[","",$desc);
    $desc=str_replace("]","",$desc);
    $desc=str_replace("\"","",$desc);
    $desc=str_replace(",","",$desc);
	$desc=substr($desc,0,20);
    if (! strstr(strtoupper(substr($desc,0,4)),"RAL")) {
        $code=strtoupper(getColorCode($db,$item,$job));
        if ($code != "") {
            if (! strstr(strtoupper($desc),$code)) {
                $desc=$code . " " . $desc;
            }
        }
    }
    $item=str_replace(",","",$item);
    $item=str_replace("#","",$item);
    $item=str_replace("&","",$item);
    $item=str_replace(" ","",$item);
    $item=str_replace("[","",$item);
    $item=str_replace("]","",$item);
    $item=str_replace("\"","",$item);
	$qtyr=$data['tocut'];
	$qty=$data['quantity_scheduled'];
    $material=$data['material'];
    $customer=$data['name'];
    $customer=str_replace(",","",$customer);
    $customer=str_replace(" ","",$customer);
    $customer=str_replace("+", " Plus",$customer);
    $revision=$data['revision'];
    $odesc=trim($desc)."_".$odue;
    $rec=implode($delim,array($dt,$folder,$item,$odesc,$qty,$material,$customer,$revision,$job));
    $rec=str_replace("&","",$rec);
    $rec=str_replace("^","",$rec);
    $rec=str_replace(":","",$rec);
    $rec=str_replace(";","",$rec);
    print $rec;
    $sql="select operation_name, min(start_date) as operation_date from jobs j, routing r, operations o where j.job_id=$job ";
    $sql.="  and j.item_id=r.parent_part and r.operation_id=o.operation_id  ";
    $sql.=" and r.operation_id in (3081,3085,3086,3091,3099,3100,3106,3108,3113,3118,3122,3134,3144,3138,3148,3151,3119,3136,3137,3146,3155,3158) ";
    $sql.=" group by operation_name ";
    $sql.=" order by r.display_sequence ";
    list ($ors,$err)=runIQuery($db,$sql);
    $opcount=1;
    print $delim;
    print "WO$job";
    foreach ($ors as $odata) {
        print $delim;
        $op=trim($odata['operation_name']);
        $opdate=$odata['operation_date'];
        if (strlen($opdate) > 5) {
            $opdate=substr($opdate,5,5);            
        }
        $opcount++;
        print $op;
        if ($opdate) {
            print " ";
            print $opdate;
        }
    }
    while ($opcount < 10) {
        print $delim;
        $opcount++;
    }
    $orderdue=formatDateDBToWeb($dt);
    print "$orderdue";
    $sql="select * from wip_data where order_id=? and part_number=?";
    list($wrs,$err)=runIQuery($db,$sql,array("is",$folder,$item));
    if (count($wrs)>0) {
        print ",1";
    } else {
        print ",0";
    }
    print "\n";
}
print "ENDOFFILE";		
?>