<?php
include('dbConnection.php');
include('functions.php');
$days=30;
if (isset($_GET['days'])) {
    $days=$_GET['days'];
}
$delim=",";
if ($_GET['code'] != '8383') {
	exit;
}

ob_end_flush();

$sql="select distinct  c.customer_id, c.name, j.job_id, j.item_id, j.description, j.start_date, j.quantity_scheduled, o.date_due, 
    i.item_name as material,  l.order_id, l.line_id, p.revision, coalesce(so_number,0) as is_concrete 
    from jobs j inner join order_lines l on j.line_id=l.line_id inner join routing r on j.item_id=parent_part and operation_id=3123 
    inner join orders o on l.order_id=o.order_id and o.status  not in (3,4,5,6,16,17,19) 
    inner join customers c on o.customer_id=c.customer_id 
    inner join billofmaterial b on j.item_id=parent_item and r.routing_id=b.routing_id 
    inner join items i on b.child_item=i.item_name  
    inner join items p on j.item_id=p.item_name 
    left outer join ncell_concrete nc on l.order_id=nc.so_number 
    where coalesce(l.shipped_quantity,0) < l.quantity 
    and j.job_id not in (select job_id from skip_laser_jobs) 
         and l.due_date <= date_add(sysdate(), INTERVAL $days DAY)  ";
list($rs,$err)=runIQuery($db,$sql);
foreach ($rs as $data) {
    set_time_limit(120);
	$line=$data['line_id'];	
	## $dt=$data['start_date'];
    ### cma 3/1/23 per Justin we want the order due date
	$orderdue=$data['date_due'];
    $dt=$orderdue;
	$odue=substr($orderdue,5,5);
    $job=$data['job_id'];
	$folder=$data['order_id'];
    $isConcrete=$data['is_concrete'];
    // if it is in the ncell_concrete table, then we send the SO number as key  and WO + job as first operation,
    // otherwise send WO + job_id as key, and  SO+order_id as the first operation
	$item=$data['item_id'];
	$desc=$data['description'];
    $desc=str_replace(",","",$desc);
    $desc=str_replace("#","",$desc);
    $desc=str_replace("&","",$desc);
    $desc=str_replace("[","",$desc);
    $desc=str_replace("]","",$desc);
    $desc=str_replace("\"","",$desc);
    if (! strstr(strtoupper(substr($desc,0,4)),"RAL")) {
        $code=strtoupper(getColorCode($db,$item,$job));
        if ($code != "") {
            if (! strstr(strtoupper($desc),$code)) {
                $desc=$code . " " . $desc;
            }
        }
    }
    $desc=str_replace(",","",$desc);
	$desc=substr($desc,0,200);
    $item=str_replace(",","",$item);
    $item=str_replace("#","",$item);
    $item=str_replace("&","",$item);
    $item=str_replace(" ","",$item);
    $item=str_replace("[","",$item);
    $item=str_replace("]","",$item);
    $item=str_replace("\"","",$item);
	$qtyr=$data['tocut'];
	$qty=$data['quantity_scheduled'];
    $material=$data['material'];
    $customer=$data['name'];
    $customer=str_replace(",","",$customer);
    $customer=str_replace(" ","",$customer);
    $customer=str_replace("+", " Plus",$customer);
    $revision=$data['revision'];
    $odesc=trim($desc);
    $nothing="";
    if ($isConcrete) {
        $rec=implode($delim,array($dt,$folder,$item,$odesc,$qty,$material,$customer,$revision,""));
    } else {
        $key="WO$job"; 
        $rec=implode($delim,array($dt,$key,$item,$odesc,$qty,$material,$customer,$revision,""));

    }
    $rec=str_replace("&","",$rec);
    $rec=str_replace("^","",$rec);
    $rec=str_replace(":","",$rec);
    $rec=str_replace(";","",$rec);
    print $rec;
    $sql="select operation_name, min(start_date) as operation_date from jobs j, routing r, operations o where j.job_id=$job ";
    $sql.="  and j.item_id=r.parent_part and r.operation_id=o.operation_id  ";
    $sql.=" and r.operation_id NOT in (3090,3092,3109,3110,3112,3116,3123,3124,3131,3132,3133,3139,3145,3147,3149,3150,3152,3153,3156,3157,3159,3161,3162) ";
    $sql.=" group by operation_name ";
    $sql.=" order by r.display_sequence ";
    list ($ors,$err)=runIQuery($db,$sql);
    $opcount=1;
    print $delim;

    if ($isConcrete) {
        print "WO$job";
    } else {
        print "SO$folder";
    }
    foreach ($ors as $odata) {
        print $delim;
        $op=trim($odata['operation_name']);
        $opdate=$odata['operation_date'];
        if (strlen($opdate) > 5) {
            $opdate=substr($opdate,-5);            
        }
        $opcount++;
        print $op;
        if ($opdate) {
            print " ";
            print $opdate;
        }
    }
    while ($opcount < 10) {
        print $delim;
        $opcount++;
    }
    $orderdue=formatDateDBToWeb($dt);
    print "$orderdue";
    $sql="select * from wip_data where order_id=? and part_number=?";
    list($wrs,$err)=runIQuery($db,$sql,array("is",$folder,$item));
    if (count($wrs)>0) {
        print ",1";
    } else {
        $sql="select sum(quantity_good) from production_results pr, routing r where  job_id=?  and pr.routing_id=r.routing_id and operation_id=3123 ";
        list($wrs,$err)=runIQuery($db,$sql,array("i",$job));
        if ($wrs[0][0] >= $qty) {
            print ",2";
        } else {
            print ",0";
        }
    }
    print "\n";
}
print "ENDOFFILE";		
?>