<?php
$expanded=1;
$locked=0;
include('dbConnection.php');
## session start is now in dbconnection.php
include('security.php');
include('functions.php');
$pageTitle="BOM Missing";
include('header.php');
print renderPanel("BOM Issues");
print "<br><div style='display: flex;'><div style='display: block; width: 50%;'>";
print renderPanel("Missing from Item Master","","blue");
print "<h3>Any item highlighted in red is missing, parent or child</h3>";


$sql = "select parent_item, child_item, bom_id from billofmaterial b left outer join items i on child_item=item_name where item_name is null order by parent_item, child_item";
list($crs,$err)=runIQuery($db,$sql);
$sql = "select parent_item, child_item, bom_id from billofmaterial b left outer join items i on parent_item=item_name where item_name is null order by parent_item, child_item";
list($prs,$err)=runIQuery($db,$sql);

$bom = [];
foreach ($crs as $item) {
    if (!isset($bom[$item["bom_id"]] )) {
        $bom[$item["bom_id"]] = ["parent" => $item["parent_item"], "child" => $item["child_item"], "missing" => []];
    }
    $bom[$item["bom_id"]]["missing"][] = "child";
}
foreach ($prs as $item) {
    if (!isset($bom[$item["bom_id"]] )) {
        $bom[$item["bom_id"]] = ["parent" => $item["parent_item"], "child" => $item["child_item"], "missing" => []];
    }
    $bom[$item["bom_id"]]["missing"][] = "parent";
}

$both = [];
$parent = [];
$child = [];
foreach ($bom as $id => $data) {
    if (count($data["missing"]) == 2) {
        $both[$id] = $data;
    } else {
        if ($data["missing"][0] == "parent") {
            $parent[$id] = $data;
        }
        if ($data["missing"][0] == "child") {
            $child[$id] = $data;
        }
    }
}

$bom = [];

foreach ($child as $id => $data) {
    $bom[$id] = $data;
}
foreach ($parent as $id => $data) {
    $bom[$id] = $data;
}
foreach ($both as $id => $data) {
    $bom[$id] = $data;
}

print "<style>
.hover {
    cursor: pointer;
}
.hover:hover {
    background-color: #dbdbdb;
}
</style><table class='table table-bordered'>
    <thead>
        <tr>
            <th>BOM</th>
            <th>Parent</th>
            <th>Child</th>
        </tr>
    </thead>
    <tbody>";

    foreach ($bom as $id => $data) {
        print "<tr>";

            $hasParent = !in_array("parent", $data["missing"]);
            $hasChild = !in_array("child", $data["missing"]);

            $sql = "select item_id from items where item_name=?";
            $parent = 0;
            if ($hasParent) {
                list($rs,$err) = runIQuery($db,$sql,["s",$data["parent"]]);
                if (count($rs)) {
                    $parent = $rs[0]["item_id"];
                }
            }
            $child = 0;
            if ($hasChild) {
                list($rs,$err) = runIQuery($db,$sql,["s",$data["child"]]);
                if (count($rs)) {
                    $child = $rs[0]["item_id"];
                }
            }

            print "<td class='hover' onclick='window.open(\"editRecord.php?table=billofmaterial&key=bom_id&id=$id\",\"_blank\");'>$id</td>";
            print "<td " . (in_array("parent", $data["missing"]) ? "style='background-color: #ff7575;'" : "class='hover' onclick='window.open(\"editRecipe.php?id=$parent\",\"_blank\");'") . ">" . $data["parent"] . "</td>";
            print "<td " . (in_array("child", $data["missing"]) ? "style='background-color: #ff7575;'" : "class='hover' onclick='window.open(\"editRecipe.php?id=$child\",\"_blank\");'") . ">" . $data["child"] . "</td>";

        print "</tr>";
    }

print "</tbody>
</table></div>";
print renderClosePanel();
print "<div style='display: block; width: 50%;'>";
print renderPanel("Components Not In BOM","","red");
$sql="select item_id, item_name, item_description from items where item_category=19 and item_name not in (select child_item from billofmaterial) ";
list($rs,$err)=runIQuery($db,$sql);


print "<h3>Below are items that are listed as Components but are not on any Bill Of Material</h3>";
print "<table class='table table-bordered'>
    <thead>
        <tr>
            <th>Item</th>
            <th>Description</th>
        </tr>
    </thead>
    <tbody>";

    foreach ($rs as $item) {
        $id = $item["item_id"];
        $name = $item["item_name"];
        $desc = $item["item_description"];
        print "<tr class='hover' onclick='window.open(\"editRecipe.php?id=$id\", \"_blank\")'>";

            print "<td>$name</td>";
            print "<td>$desc</td>";

        print "</tr>";
    }

    print "</tbody>
</table></div>";
print renderClosePanel() . "</div>";
print renderClosePanel();

include('footer.php');