<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');
print renderPanel("BOL","BOL","green");
print renderButton("New BOL","green","newBOL();");
print "<table class='table table-striped'>";
print "<thead>";
print "<tr>";
print "<th>";
print "BOL";
print "</th>";
print "<th>";
print "Trailer";
print "</th>";
print "<th>";
print "Date Created";
print "</th>";
print "<th>";
print "Ship Name";
print "</th>";
print "<th>";
print "Ship Address";
print "</th>";
print "<th>";
print "Assigned To";
print "</th>";
print "</tr>";
print "</thead>";
print "<tbody>";
if ($isDriver) {
	$sql="select distinct bol.bol_id, date_created, trailer_number,  ship_name, ship_address  
		from active_bol bol inner join active_bol_skids b on bol.boL_id=b.bol_id inner join  skids s on b.skid_id=s.skid_id 
		inner join  packing_slip p on s.packing_slip_id=p.packing_slip_id where bol.assigned_to=?  and p.date_signed is null";
	list($rs,$err)=runIQuery($db,$sql,array("i",$userID));
} else {
	$sql="select distinct bol.bol_id, date_created, trailer_number, coalesce(full_name,'Not Assigned') as assigned_to, ship_name, ship_address  
		from active_bol bol inner join active_bol_skids b on bol.boL_id=b.bol_id inner join  skids s on b.skid_id=s.skid_id 
		inner join  packing_slip p on s.packing_slip_id=p.packing_slip_id left outer join site_admins a on  bol.assigned_to=a.user_id  where p.date_signed is null";
	list($rs,$err)=runIQuery($db,$sql);
}
foreach ($rs as $data) {
	$bol=$data['bol_id'];
	$dc=formatDateDBToWeb($data['date_created']);
	$trailer=$data['trailer_number'];
	$shipName=$data['ship_name'];
	$shipAddress=$data['ship_address'];
	$assignedTo=$data['assigned_to'];
	print "<tr>";
	print "<td>";
	print "<a href='editActiveBOL.php?id=$bol' target='_blank'>";
	print $bol;
	print "</a>";
	print "</td>";
	print "<td>";
	print "<a href='editActiveBOL.php?id=$bol' target='_blank'>";
	print $trailer;
	print "</a>";
	print "</td>";
	print "<td>";
	print "<a href='editActiveBOL.php?id=$bol' target='_blank'>";
	print $dc;
	print "</a>";
	print "</td>";
	print "<td>$shipName</td>";
	print "<td>$shipAddress</td>";
	if ($isDriver) {
		print "<td>You</td>";
	} else {
		print "<td>$assignedTo</td>";
	}
	print "</tr>";
}
print "</tbody>";
print "</table>";
print renderClosePanel();
?>
<script>
	function newBOL() {
		document.location.href='editActiveBOL.php?id=0';
	}
</script>
<?php
include('footer.php');
?>