<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
include('header.php');

$employee=0;
$noGo = 0;
function createResults($db,$card,$job,$routing,$hours,$minutes,$qtygood,$notes,$lastPunch,$newPunch) {
	$complete=0;
	$sql="select employee_id from employees where card_number=? and coalesce(inactive,0) = 0 ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$card));
	$data=$rs[0];
	$employee=0;
	if ($data[0]) {
		$employee=$data[0];
	}
	date_default_timezone_set('America/Detroit');
	$sql="SET time_zone = '" .date('P') . "'";
	list($rs,$err)=runIQuery($db,$sql);
	include('overProduction.php');
	$sql="insert into production_results (job_id, routing_id, employee_id, result_date, duration_hours, duration_minutes, quantity_good, shift_id, notes, start_time, end_time, complete) values (?, ?, ?, now(), ?, ?, ?, 1, ?, ?, ?, ?) ";
	list($rs,$err)=runIQuery($db,$sql,array("iiiiiisssi",$job,$routing,$employee,$hours,$minutes,$qtygood,$notes,$lastPunch,$newPunch,$complete));
	$rid=$rs[0][0];
	return $rid;
}
print renderPanel("Laser Time Entry");
print "<form name='teform' id='teform' action='laserTimeEntry.php' method='POST'>";
if (isset($_POST['stop'])) {
	$i=0;
	$material=$_POST['material'];
	$sheets=$_POST['sheets'] * -1;
	$nestName=$_POST['nest'];
	$rows=$_POST['totalrows'];
	$employee=$_POST['employee'];
	$employee2=$_POST['employee2'];
	$employee3=$_POST['employee3'];
	$notes=$_POST['notes'];
	$lastPunch=$_POST['start'];
	list($lastDate,$lastTime)=explode(" ",$lastPunch);
	$newPunch=Date("Y-m-d H:i:s");


	// chris 8/18/22 - get punch out of each employee in TIME CLOCK system - last one sets the time
	// only if it goes across days
	if ($lastDate < Date("Y-m-d")) {
		$elist="";
		if ($employee) {
			$elist="($employee";
		}
		if ($employee2) {
			if ($elist) {
				$elist.=",$employee2";
			} else {
				$elist="($employee2";
			}
		}
		if ($employee3) {
			if ($elist) {
				$elist.=",$employee3";
			} else {
				$elist="($employee3";
			}
		}
		if ($elist) {
			$elist.=") ";
			$sql="select out_date, out_time from employees e, clock_punches c where card_number in $elist and e.employee_id=c.employee_id ";
			$sql.=" and out_date < '$newPunch'  order by out_date desc limit 1 ";
			list($crs,$err)=runIQuery($db,$sql);
			if (count($crs)>0) {
				$cdata=$crs[0];
				$newPunch = date("Y-m-d H:i:s", strtotime($cdata["out_date"] . " " . $cdata["out_time"] . "m"));
			}
		}
	}

	//Switch over to new time calculation -Josh 04-25-2022
	$diff = strtotime($newPunch) - strtotime($lastPunch); //total seconds taken

    $minutes = round($diff/60)%60;
    $hours = floor($diff/60/60);


	$factor = 0;

	$x=0;
	while ($x < $rows) {
		$x++;
		$cut=$_POST['cut'.$x];

		if ($cut > 0) {
			$factor++;
		}
	}
	if ($factor == 0) {
		$factor=1;
	}
	$totalminutes = $minutes + ($hours*60);
	$timegiven = floor($totalminutes/$factor);
	$timeleft = $totalminutes - ($timegiven * $factor);

	if (isset($_POST['nest'])) {
		$nest=$_POST['nest'];
	} else {
		$sql="insert into nests (date_created, nest_name, number_sheets, material) values (now(), ?, ?)";
		list($rs,$err)=runIQuery($db,$sql,array("sis",$nestName,$sheets, $material));
		$nest=$rs[0]['id'];
	}
	$joblist=array();
	print "<table class='table table-striped'><thead><tr><th>Work Order</th><th>Part</th><th>Description</th><th>Qty Scheduled</th><th>Qty Good so far</th><th>Quantity Cut</th></tr></thead><tbody>\n";
	//print "<table class='table table-striped'><thead><tr><th>Work Order</th><th>Part</th><th>Description</th><th>Qty Scheduled</th><th>Qty Good so far</th><th>Quantity Cut</th><th>Qty Scrap</th></tr></thead><tbody>\n";
	print "<p>Below are the results.  To Select more work orders, click the Next button.</p>";
	while ($i < $rows) {
		$i++;
		$job=$_POST['job'.$i];
		$part=$_POST['part'.$i];
		$description=$_POST['description'.$i];
		$qty=$_POST['qty'.$i];
		$good=$_POST['good'.$i];
		$cut=$_POST['cut'.$i];
		//$qtylost=$_POST['scrap'.$i];
		$dt=$_POST['due'.$i];
		$good+=$qty;
		print "<tr><td>$job</td><td>$part</td><td>$description</td><td>$qty</td><td>$good</td><td>$cut</td></tr>\n";
		//print "<tr><td>$job</td><td>$part</td><td>$description</td><td>$qty</td><td>$good</td><td>$cut</td><td>$qtylost</td></tr>\n";
		## figure out routing for the part
		$sql="select routing_id from routing where parent_part='$part'  and operation_id=3123 ";
		list($rrs,$err)=runIQuery($db,$sql);
		$routing=0;
		if (count($rrs)>0) {
			$routing=$rrs[0][0];
		}
		$lastStep=0;
		$sql="select routing_id from routing where  parent_part='$part'  ";
		list($rrs,$err)=runIQuery($db,$sql);
		if (count($rrs)==1) {
			$lastStep=1;
		}
		if ($cut > 0) {
			$sql="select coalesce(quantity_scheduled - sum(coalesce(p.quantity_good,0)),0) as tomake, item_id from jobs j left outer join production_results p on j.job_id=p.job_id  left outer join routing r on p.routing_id=r.routing_id and r.operation_id=3123  where j.job_id=?";
			list($rs,$err)=runIQuery($db,$sql,array("i",$job));
			$data=$rs[0];
			if ($data['tomake'] > 0)  {
				if ($data['tomake']<$cut) {
					$cut=$data['tomake'];
					print "<p><b>Job $job only creating $cut because it meets the quantity scheduled.</b></p>";
				}
				$factor=1;
				if ($employee2) {
					$factor++;
				}
				if ($employee3) {
					$factor++;
				}
				if ($factor > 0) {
					$qtyinsert=floor($cut/$factor);
				}
				$leftover=$cut - ($qtyinsert * $factor);

				$giventime = $timegiven;
				if ($i == 1) {
					$giventime += $timeleft;
				}
				$minutes = $giventime%60;
				$hours = floor($giventime/60);
				$result_id=createResults($db,$employee,$job,$routing,$hours,$minutes,$qtyinsert+$leftover,$notes,$lastPunch,$newPunch);
				$sql="insert into nest_contents (nest_id, result_id) values (?, ?) ";
				list($rs,$err)=runIQuery($db,$sql,array("ii",$nest,$result_id));
				if ($employee2) {
					$result_id2=createResults($db,$employee2,$job,$routing,$hours,$minutes,$qtyinsert,$notes,$lastPunch,$newPunch);
					$sql="insert into nest_contents (nest_id, result_id) values (?, ?) ";
					list($rs,$err)=runIQuery($db,$sql,array("ii",$nest,$result_id2));
				}
				if ($employee3) {
					$result_id3=createResults($db,$employee3,$job,$routing,$hours,$minutes,$qtyinsert,$notes,$lastPunch,$newPunch);
					$sql="insert into nest_contents (nest_id, result_id) values (?, ?) ";
					list($rs,$err)=runIQuery($db,$sql,array("ii",$nest,$result_id3));
				}
				$sql="select coalesce(quantity_scheduled - sum(coalesce(p.quantity_good,0)),0) as tomake, item_id from jobs j left outer join production_results p on j.job_id=p.job_id  left outer join routing r on p.routing_id=r.routing_id and r.operation_id=3123  where j.job_id=?";
				list($rs,$err)=runIQuery($db,$sql,array("i",$job));
				$data=$rs[0];
				if ($data['tomake'] <= 0)  {
					$sql="update production_results set complete=1 where results_id=?";
					list($rs,$err)=runIQuery($db,$sql,array("i",$result_id));
					if ($employee2) {
						$sql="update production_results set complete=1 where results_id=?";
						list($rs,$err)=runIQuery($db,$sql,array("i",$result_id2));
					}
					if ($employee3) {
						$sql="update production_results set complete=1 where results_id=?";
						list($rs,$err)=runIQuery($db,$sql,array("i",$result_id3));
					}
				}

				$sql="select item_id,  default_location from items where item_name=?";
				list($rs,$err)=runIQuery($db,$sql,array("s",$part));
				$data=$rs[0];
				$item_id=$data['item_id'];
				$loc=$data['default_location'];
				if (! $loc) {
					$loc=1;
				}
				if ($lastStep) {
					makeQuantityFromJob($db,$job,$cut,"laserTimeEntry.php");
					//inventoryUpdate($db,$item_id,$cut,"laserTimeEntry.php","Job $job cut",$userID,$loc);
				} else {
					$joblist[]=$job;
				}
			} else {
				print "<p><b>Not making any of Job $job because it has already been fulfilled.</b></p>";
			}
		}
		// if ( $qtylost) {
		// 	$defect="Cut Quality";
		// 	$jobDate=Date("Y-m-d h:i:s");
		// 	$sql="insert into job_defects (job_id, defect_id, date_reported, quantity, routing_id) values (?, ?, ?, ?, ?) ";
		// 	list($rs,$err)=runIQuery($db,$sql,array("iisii",$job,$defect,$jobDate,$qtylost,$routing));
		// }
	}
	if (isset($_POST['complete_nest'])) {
		$complete=$_POST['complete_nest'];
		if ($complete) {
			$sql="update nests set nest_complete=1 where nest_id=?";
			list($updrs,$err)=runIQuery($db,$sql,array("i",$nest));
		}
	}
	if (count($joblist)>0) {
		$jl=implode(",",$joblist);
		print "\n<script>window.open('renderTCPDF.php?type=WO&laser=1&id=$jl&so=&due=$dt&part=$part&qty=$qty&copies=1','_blank');</script>\n";
	}
	if ($sheets != 0 ) {
		## consume the sheets that were used to make these parts
		$sql="select item_id, default_location from items where item_name=?";
		list($rs,$err)=runIQuery($db,$sql,array("s",$material));
		if (count($rs)) {
			$rawID=$rs[0][0];
			$loc=$rs[0][0];
			if (! $loc) {
				$loc=1;
			}
			inventoryUpdate($db,$rawID,$sheets,"laserTimeEntry.php","Job $job Nest $nestName Consumed Sheets",$userID,$loc);
		}
	}

    $sql="select p.job_id, sum(p.quantity_good) as good, j.quantity_scheduled from nest_contents n  ";
	$sql.=" left outer join production_results p on n.result_id=p.results_id  ";
	$sql.=" left outer join jobs j on p.job_id=j.job_id ";
	$sql.="  where n.nest_id=? group by p.job_id, j.quantity_scheduled having sum(p.quantity_good) < quantity_scheduled  ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$nest));
	if (count($rs)==0) {
		$sql="update nests  set nest_complete=1 where nest_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$nest));
	}

	print renderButton("Next","green","document.location.href='laserTimeEntry.php';");
} else {
    if (isset($_POST['start'])) {
		$i=0;
		$j=0;
		$rows=$_POST['totalrows'];
		print "rows is <br>";
		$start=$_POST['start'];
		$material=$_POST['material'];
		$newPunch=Date("Y-m-d H:i:s");
		print "<input type='hidden' name='stop' id='stop' value='1'>";
		print "<input type='hidden' name='start' id='start' value='$start'>";
		print "<input type='hidden' name='material' id='material' value='$material'>";
		print "<p>After completion, enter the number of sheets used, the nest number/name, and then the specific quantities for each job and press the Stop button.</p>";
		print "<p>Please fill out your Employee Number and any notes.</p>";
		print renderTextBox(TRUE,"sheets","1","Number of Sheets");
		print renderTextBox(TRUE,"nest","","Nest ID");
		print renderTextBox(TRUE,"employee","54","Employee");
		print renderTextArea(TRUE,"notes","","Notes");
		print renderButton("Save Nest","primary","saveNest();");
		print "<table class='table table-striped'><thead><tr><th>Work Order</th><th>Part</th><th>Description</th><th>Paint Color</th><th>Qty Scheduled</th><th>Qty Good so far</th><th>Quantity Cut</th></tr></thead><tbody>\n";
		//print "<table class='table table-striped'><thead><tr><th>Work Order</th><th>Part</th><th>Description</th><th>Paint Color</th><th>Qty Scheduled</th><th>Qty Good so far</th><th>Quantity Cut</th><th>Qty Scrap</th></tr></thead><tbody>\n";
		while ($i < $rows) {
			$i++;
			if (isset($_POST['job'.$i])) {
				#added routing_id and step for job defects functionality Brittany 7/14/22
				if ($_POST['job'.$i]) {
					$job=$_POST['job'.$i];
					$sql="select j.item_id, j.description, start_date, quantity_scheduled, quantity_good, routing_id, display_sequence from jobs j, routing r where status=1 ";
					$sql.=" and j.item_id=r.parent_part  and workcenter_id=181 ";
					$sql.=" and j.job_id=?";
					list($rs,$err)=runIQuery($db,$sql,array("i",$job));
					$data=$rs[0];
					$part=$data['item_id'];
					$description=$data['description'];
					$qty=$data['quantity_scheduled'];
					$good=$data['quantity_good'];
					$routing=$data['routing_id'];
					$step=$data['display_sequence'];
					$dt=formatDateDBToWeb($data['start_date']);
					$togo=$qty-$good;
					if ($togo < 0) {
						$togo=1;
					}
					$j++;
					print "<tr><td>$job</td><td>$part</td><td>$description</td><td>$qty</td><td>$good</td><td>";
					print "<input type='text' name='cut$j' id='cut$j' value='$togo' onchange=\"checkQuantity(this,'$togo');\">";
					print "<input type='hidden' name='job$j' id='job$j' value='$job'>";
					print "<input type='hidden' name='part$j' id='part$j' value='$part'>";
					print "<input type='hidden' name='description$j' id='description$j' value=\"$description\">";
					print "<input type='hidden' name='qty$j' id='qty$j' value='$qty'>";
					print "<input type='hidden' name='good$j' id='good$j' value='$good'>";
					print "<input type='hidden' name='due$j' id='due$j' value='$dt'>";

					print "</td><td>";
					//changed from input box with scrap and now it links to enterJobDefects Brittany 7/6/22
					print "<button class='btn red'><a href='enterJobDefects.php?job=$job&routing=$routing&step=$step' target='_blank' style='color: white'>Enter Defects</a></button>";
					//print "<input type='text' name='scrap$j' id='scrap$j'  value='0'>";
					print "</td></tr>\n";
					$sql="select order_id, order_lines.line_id from order_lines, jobs_orders where job_id=? and jobs_orders.order_line=order_lines.line_id";
					list($rs,$err)=runIQuery($db,$sql,array("i",$job));
					if (count($rs)>0) {
						$data=$rs[0];
						$order=$data['order_id'];
						$line=$data['line_id'];
						if ($order) {
							$sql="update orders set status=14 where order_id = ? and status not in (3,4,5,6,7,8,9,10,12,13,15)";
							list($rs,$err)=runIQuery($db,$sql,array("i",$order));
						}
						if ($line) {
							$sql="update order_lines set line_status=14 where line_id =? and line_status not in (3,4,5,6,7,8,9,10,12,13,15)";
							list($rs,$err)=runIQuery($db,$sql,array("i",$line));
						}
					}
					$sql="select order_id, order_lines.line_id from order_lines, jobs where job_id=? and jobs.line_id=order_lines.line_id";
					list($rs,$err)=runIQuery($db,$sql,array("i",$job));
					if (count($rs)>0) {
						$data=$rs[0];
						$order=$data['order_id'];
						$line=$data['line_id'];
						if ($order) {
							$sql="update orders set status=14 where order_id = ? and status not in (3,4,5,6,7,8,9,10,12,13,15)";
							list($rs,$err)=runIQuery($db,$sql,array("i",$order));
						}
						if ($line) {
							$sql="update order_lines set line_status=14 where line_id =? and line_status not in (3,4,5,6,7,8,9,10,12,13,15)";
							list($rs,$err)=runIQuery($db,$sql,array("i",$line));
						}
					}
				}
			}
		}
		print "</tbody></table>\n";
		print renderButton("Stop","red","document.teform.submit();");
		print "<input type='hidden' name='totalrows' value='$j'>";


    } else {
        if (isset($_POST['material'])) {
            $material=$_POST['material'];
			print "<p>Select which jobs you will be cutting and press the Start button.</p>";
            print "<center>Showing Jobs with Material $material</center>";
			$newPunch=Date("Y-m-d H:i:s");
            print "<input type='hidden' name='start' value='$newPunch'>";
			print "<input type='hidden' name='material' value='$material'>";
			print renderButton("Start","green","document.teform.submit();");
			// 6/22 Brittany adding paint color per ticket #964 - column header
            print "<table class='table table-striped'><thead><tr><th>Work Order</th><th>Sales Order</th><th>Part</th><th>Description</th><th>Paint Color</th><th>Qty Scheduled<th>Qty Good</th><th>Due Date</th><th>Select";
			print "<br><input type='checkbox' name='selall' id='selall' onclick='selectAll();'>";
			print  "</th></tr></thead><tbody>\n";
			//adding sql query for paint color
            $sql="select job_id, j.item_id, j.description, start_date, quantity_scheduled, quantity_good, r.routing_id, color_description ";
			$sql.=" from jobs j inner join  order_lines l on j.line_id=l.line_id inner join routing r on j.item_id=r.parent_part ";
			$sql.=" left outer join  vendor_colors vc on vc_id=l.powder_color where status=1 ";
			$sql.=" and  l.line_status not in (3,4,5,6) ";
			$sql.=" and workcenter_id=181 ";
            $sql.=" order by start_date, job_id";
            list($rs,$err)=runIQuery($db,$sql);
            $i=0;
            foreach ($rs as $data) {
                $job=$data['job_id'];
				$sql="select order_id from jobs j, order_lines l where j.line_id=l.line_id and job_id=?";
				list($jrs,$err)=runIQuery($db,$sql,array("i",$job));
				$so=$jrs[0][0];
                $part=$data['item_id'];
                $description=$data['description'];
				$description=str_replace("\"","",$description);
				$paint=$data['color_description'];
                $dt=formatDateDBToWeb($data['start_date']);
                $qty=$data['quantity_scheduled'];
                $good=$data['quantity_good'];
				$routing=$data['routing_id'];
				$sql="select sum(quantity_good) from production_results where job_id=? and routing_id=? ";
				list($prs,$err)=runIQuery($db,$sql,array("ii",$job,$routing));
				$good=$prs[0][0];
                $sql="select child_item from billofmaterial where parent_item='$part' and child_item='$material' ";
                list($crs,$err)=runIQuery($db,$sql);
                $tm=$crs[0][0];
				if ($tm == $material and $good < $qty) {
					print "<tr><td>";
					print $job;
					print "</td>";
					print "<td>$so</td>";
					print "<td>";
					print $part;
					print "</td>";
					print "<td>";
					print $description;
					print "</td>";
					// 6/22 added data for paint color
					print "<td>";
					print $paint;
					print "</td>";
					print "<td>";
					print $qty;
					print "</td>";
					print "<td>";
					print $good;
					print "</td>";
					print "<td>$dt</td>";
					print "<td>";
					$i++;
					print "<input type='checkbox' name='job$i' id='job$i' value='$job'>";
					print "</td>";
					print "</tr>\n";
				}
            }
            print "</tbody></table>\n";
			print renderButton("Start","green","document.teform.submit();");
            print "<input type='hidden' name='totalrows' value='$i'>";
        } else {
			print "<p>Select which material you would like to clock into.</p>";
            print "<center>";
            $sql="select item_name as a, item_name as b from items where item_category = 24 order by item_name";
            $rs=mysqli_query($db,$sql);
            print renderSelect(TRUE,"material","","Material","C",$rs,1,"document.teform.submit();");
            print "</center>";
			// 6/22 adding paint color Brittany
            print "<table class='table table-striped'><thead><tr><th>Work Order</th><th>Sales Order</th><th>Material</th><th>Part</th><th>Description</th><th>Paint Color</th><th>Qty Scheduled<th>Qty Good</th><th>Due Date</th></tr></thead><tbody>\n";
            $sql="select job_id, j.item_id, j.description, start_date, quantity_scheduled, quantity_good from jobs j, routing r where status=1 ";
			$sql.=" and j.item_id=r.parent_part and workcenter_id=181 ";
            $sql.=" order by start_date, job_id ";
            list($rs,$err)=runIQuery($db,$sql);
            foreach ($rs as $data) {
                $job=$data['job_id'];
				$sql="select order_id, color_description from jobs j inner join order_lines l on j.line_id=l.line_id ";
				$sql.=" left outer join vendor_colors vc on l.powder_color=vc.vc_id where job_id=?";
				list($jrs,$err)=runIQuery($db,$sql,array("i",$job));
				$so=$jrs[0][0];
				//getting paint color
				$paint=$jrs[0][1];
                $part=$data['item_id'];
                $description=$data['description'];
                $dt=formatDateDBToWeb($data['start_date']);
                $qty=$data['quantity_scheduled'];
                $good=$data['quantity_good'];
                $sql="select child_item from billofmaterial where parent_item='$part'  ";
                list($crs,$err)=runIQuery($db,$sql);
                $material=$crs[0][0];
                print "<tr><td>";
                print $job;
                print "</td>";
				print "<td>$so</td>";
                print "<td>";
                print $material;
                print "</td>";
                print "<td>";
                print $part;
                print "</td>";
                print "<td>";
                print $description;
                print "</td>";
				//added paint color
				print "<td>";
                print $paint;
                print "</td>";
                print "<td>";
                print $qty;
                print "</td>";
                print "<td>";
                print $good;
                print "</td>";
				print "<td>";
				print $dt;
				print "</td>";
				print "</tr>\n";
            }
            print "</tbody></table>\n";
        }
    }
}

print "</form>";
print renderClosePanel();
?>
<script>
function selectAll() {
	$("[id^='job']").each(function(index) {
		this.click();
    });
}
function checkQuantity(fld,max) {
	if (parseInt(fld.value)>max) {
		alert('You can only make ' + max + " parts.");
		fld.value=max;
	}
}

function saveNest() {
	if (document.teform.nest.value!='') {
		document.teform.action='saveNest.php';
		document.teform.submit();
	}
}
</script>
<?php
include('footer.php');
?>