// const listEmployeeInformationURL =
//   "https://preferrederp1.com/listEmployeeInformation.php?code=8383&id=";

const listEmployeeInformationURL =
  "listEmployeeInformation.php?code=8383&id=";

const makeAdjURL =
  "updateEmployeePoints.php?code=8383&id=";

const pointReasonURL = "getPointReasons.php?code=8383";

let empID = getUrlParameter("employee");

//runs on page load
function page_init() {
  //Brittany 4/26 added date picker
  $('#date').datepicker();
  let url = listEmployeeInformationURL + empID;
  mitchFunction(url);
  
};

//pulls parameter value out of the URL bar
function getUrlParameter(sParam) {
  var sPageURL = window.location.search.substring(1),
    sURLVariables = sPageURL.split("&"),
    sParameterName,
    i;

  for (i = 0; i < sURLVariables.length; i++) {
    sParameterName = sURLVariables[i].split("=");

    if (sParameterName[0] === sParam) {
      return sParameterName[1] === undefined
        ? true
        : decodeURIComponent(sParameterName[1]);
    }
  }

  return false;
}

//sets the field values based on response from ERP
function mitchFunction(url) {
  $.ajax({
    url: url,
    success: function (data) {
      const obj = JSON.parse(data);
		console.log(data);
      document.getElementById("adjustment").value = 0.25;
      document.getElementById("reason").value = "";

      document.getElementById("employeeNameText").innerHTML = obj.employee_name;
      document.getElementById("employeePointsText").innerHTML =
        obj.employee_points;
      document.getElementById("employeeHistText").innerHTML =
        obj.employee_history;
    },
  });

  $.ajax({
    url: pointReasonURL,
    success: function (data) {
		console.log(data);
      const obj = JSON.parse(data);
      console.log(obj);

      document.getElementById("reason").options.length = 0;

      $("#reason").append(
        $("<option>", {
          value: "",
          text: "Please select adjustment reason",
        })
      );

      $.each(obj, function (i, item) {
        $("#reason").append(
          $("<option>", {
            value: item.adjustment,
            text: item.reason,
          })
        );
        console.log(item.reason);
        console.log(item.adjustment);

      });
    },
  });
}

function reasonChanged(newAdj) {
  document.getElementById("adjustment").value = newAdj;
}

function adjChange() {
  adj = document.getElementById("adjustment").value;
  if (adj < 0) {
    ptQtrs = Math.ceil(adj / 0.25) * 0.25;
  } else {
    ptQtrs = Math.floor(adj / 0.25) * 0.25;
  }
  document.getElementById("adjustment").value = ptQtrs;
}

function makeAdjustment() {
  adj = document.getElementById("adjustment").value;
  //seems ok down to here - can't get rsn to equal the text
  sel = document.getElementById("reason");
  rsn = sel.options[sel.selectedIndex].text
  if (rsn == "Please select adjustment reason") {
    $.gritter.add("You must select a reason");
    $('#goBabyGo').show();
  } else {  
    //Brittany Addition for date of incident
    adjdate = document.getElementById("date").value;
    //change adj and rsn to data from point_reasons table?
    //it should be pulling info from item.reason and item.adjustment? 
    let rem = (url =
      makeAdjURL +
      empID +
      "&adj=" +
      adj +
      "&rsn=" +
      rsn +
      "&date=" +
      adjdate +    //added date here Brittany 4/26
      "&rand=" +
      Math.random);

    $.ajax({
        url: url,
        success: function (data) {
          alert(data);
          $('#goBabyGo').show();
          url = listEmployeeInformationURL + empID;
          mitchFunction(url);
        },
      });
  }
  
}
