<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');


$since = date("Y-m-d", strtotime("-2 year"));
$hasSince = false;
if (isset($_GET["since"])) {
    $since = $_GET["since"];
    $hasSince = true;
}

$filter=0;
$opts = ["Used and Unused", "Only Used", "Only Unused", "Dematic Only: Used and Unused", "Dematic Only: Used", "Dematic Only: Unused"];
if (isset($_GET["filter"])) {
    $filter = $_GET["filter"];
}
print renderPanel("Items Last Used");

print "<form name='itemform' id='itemform' method='GET' action='itemsUsedReport.php'>";
    print renderDateBox(TRUE, "since", $since, "Since");

    print renderStartItem(TRUE, "", "Item Filter");
    print "<select name='filter' id='filter'>";

        $i=0;
        foreach ($opts as $opt) {
            print "<option value='$i' " . ($i == $filter ? "selected" : "") . ">$opt</option>";
            $i++;
        }
    print "</select>";
    print renderEndItem();

    print renderStartItem(TRUE,"","‎");
    print renderButton("Filter","blue");
    print "<a href='#' id='downloader'> " . renderButton("Export","green", "tableToTab();") . "</a>";
    print renderEndItem();
print "</form>";

?>
<div style="position: fixed; top: 0px; left: 0px; width: 100vw; height: 100vh; background-color: #a0a0a03b;" id="loader">
    <img style="position: fixed; top: 50vh; left: 50vw; z-index: 9999;" src="images/loading.gif">
</div>
<script>
    setTimeout(function() {
        if ($("#loader").length) {
            alert("Something went wrong");
        }
    }, 25*1000); // 25s
</script>
<?php
$dematic = [3,4,5];
$sql = "select ol.item_id, max(ol.due_date) as last_used, count(*) as times_used, sum(ol.quantity) as total_qty from order_lines ol, orders o where ol.due_date > ? and ol.order_id=o.order_id and " . (in_array($filter, $dematic) ? "" : "not") . " o.customer_id=693 group by ol.item_id order by last_used desc";
list($ors,$err) = runIQuery($db,$sql,["s",$since]);

$sql = "select i.item_id, i.item_name, ic.category_name, i.item_description, its.status_name, c.name from items i, item_categories ic, item_status its, customers c where " . (in_array($filter, $dematic) ? "" : "not") . " i.customer_id=693 and its.status_id=i.status and ic.category_id=i.item_category and i.customer_id=c.customer_id";
list($irs,$err) = runIQuery($db,$sql);

$items = [];

$used = [0,1,3,4];
$unused = [0,2,3,5];
foreach ($ors as $line) {
    if (!isset($items[$line['item_id']])) {
        if (!in_array($filter, $used)) {
            continue;
        }
        $items[$line['item_id']] = ["last_used" => $line["last_used"], "times_used" => $line["times_used"], "total_qty" => $line["total_qty"]];
    }
}

foreach ($irs as $item) { //separate query in case we use more than just order lines in the future
    if (isset($items[$item['item_name']])) {
        $item['total_qty'] = $items[$item['item_name']]['total_qty'];
        $item["last_used"] = $items[$item['item_name']]["last_used"];
        $item["times_used"] = $items[$item['item_name']]["times_used"];
    } else {
        if (!in_array($filter, $unused)) {
            continue;
        }
        $item["last_used"] = "Unused";
    }

    $items[$item['item_name']] = $item;
}
print "<table style='display: none;' class='table table-bordered table-condensed'>
    <thead><tr>
        <th>Item Name</th>
        <th>Main Customer</th>
        <th style='width: 7.5%;'>Item Status</th>
        <th style='width: 7.5%;'>Last Used</th>
        <th style='width: 7.5%;'>Times Used</th>
        <th style='width: 7.5%;'>Qty Ordered</th>
        <th style='width: 9%;'>Category</th>
        <th style='width: 25%;'>Description</th>
    </tr></thead><tbody>";

    //used to print table data here but it crashed the webpage from too many rows being rendered

print "</tbody></table>";

print renderClosePanel();
include('footer.php');
?>
<style>
    .table tbody tr:hover {
        background-color: #e0e0e0;
    }
    .table thead th {
        cursor: pointer;
    }
</style>
<script>
    var items = [<?php
        $count = count($items);
        $printstr = "";
        $i = 1;
        foreach ($items as $item) { //faster than json_encode
            if (!isset($item["item_name"])) { // on SO but no longer an item
                continue;
            }
            $times_used = 0;
            if (isset($item["times_used"])) {
                $times_used = $item["times_used"];
            }

            $total_qty = 0;
            if (isset($item["total_qty"])) {
                $total_qty = $item["total_qty"];
            }

            $onclickstr = '`<div style="cursor: pointer;" onclick="window.open(\'editRecipe.php?id=' . $item['item_id'] . '\', \'_blank\'); return false;">';

            print "[";
                print $onclickstr . str_replace('"', "''", $item["item_name"]) . '</div>`,';
                print $onclickstr . str_replace('"', "''", $item["name"]) . '</div>`,';
                print $onclickstr . $item["status_name"] . '</div>`,';
                print $onclickstr . $item["last_used"] . '</div>`,';
                print $onclickstr . $times_used . '</div>`,';
                print $onclickstr . $total_qty . '</div>`,';
                print $onclickstr . $item["category_name"] . '</div>`,';
                print $onclickstr . str_replace('"', "''", $item["item_description"]) . '</div>`';
            print "]";
            if ($i != $count) {
                print ",";
            }
            $i++;
        }
    ?>];
    var datatable = $(".table").DataTable({
        "iDisplayLength" : 25
    });

    datatable.fnAddData(items);

    $("#loader").remove();
    $(".table").show();
    var since = $(".datepicker").val();

    function tableToTab() {
        var csv = "Item Name\tMain Customer\tItem Status\tLast Used\tTimes Used\tQty Ordered\tCategory\tDescription\n";
        for (var i = 0; items.length > i; i++) {
            var item = items[i];
            for (var j = 0; item.length > j; j++) {
                if (j != 0) csv += "\t";
                csv += item[j].split('return false;">')[1].split("</div>")[0];
            }
            if (i != items.length-1) csv += "\n";
        }
        var a = document.getElementById("downloader");
        var file = new Blob([csv], {type: 'text/plain'});
        a.href = URL.createObjectURL(file);
        a.download = "ItemReport-<?=$opts[$filter]?>-Since-" + since.replace(/\//g, "-") + ".xls";
    }
</script>