<?php
if (! isset($showExplanation)) {
	$showExplanation=0;
}

$showred=0;
$surcharge=0;
if ($orderType) {
	$sql="select factor, type_name from order_types where type_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$orderType));
	$data=$rs[0];
	$surcharge=$data[0];
	$typeName=$data[1];
}
$sql="select * from production_results where coalesce(minutes,0) <= 0 and job_start <> '' and job_end <> '' and job_id='$folder_number' order by operation_id, minutes desc ";
list($rs,$err)=runIQuery($db,$sql);
$already=0;
$alreadyShip=0;
foreach ($rs as $data) {
	$id=$data['results_id'];
	$start=$data['job_start'];
	$end=$data['job_end'];
	$op=$data['operation_id'];
	$minutes=(strtotime($end) - strtotime($start)) / 60;
	if ($op == 60) {
		if (! $already) {
			if ($minutes < 3) {
			#	$minutes=3;
			}
		}
		$already=1;
	}
	if ($op == 61) {
		if (! $alreadyShip) {
			if ($minutes < 5) {
				$minutes=5;
			}
		}
		$alreadyShip=1;
	}
	if ($minutes < 1) {
		$minutes=1;
	}
	$sql="update production_results set minutes=$minutes where results_id=$id  ";
	list($updrs,$err)=runIQuery($db,$sql);
}

// Engineering, Shipping, Delivery - add the total minutes times standard rate for each of them and add them together = Setup
// Need to Add Delivery Time and then mark the folder as Delivered and that is what will then be the sync
// Divide this for each part and add to the item price, minimum of .01
$sql="select standard_rate,operation_name, o.operation_id, sum(minutes) as totminutes from operations o, production_results r where job_id=? and o.operation_id=r.operation_id   ";
$sql.=" and operation_name in ('Engineering') ";
$sql.=" group by standard_rate, operation_name, o.operation_id order by operation_name";
list($ors,$err)=runIQuery($db,$sql,array("s",$folder_number));
$stprice=0;
foreach ($ors as $odata) {
	$minutes=$odata['totminutes'];
	$rate=$odata['standard_rate'];
	$op=$odata['operation_id'];
	$ext=$minutes*$rate;
	if ($ext < 5) {
		$ext=5;
	}
	if ($showExplanation) {
		print "<tr><td>";		
		print "Engineering";
		print "</td><td align='right'>" . $minutes . "</td>";
		print "<td align='right'>" . number_format($rate,4) ."</td>";
		print "<td align='right'>" . number_format($ext,2) . "</td>";
		print "</tr>\n";
	}	
	$stprice+= $ext;
}
if ($stprice == 0) {
	if ($showExplanation) {
		print "<tr><td colspan=4 style='color: red;'>Engineering is Zero</td></tr>\n";
		$showred=1;
	}
}
$sql="select standard_rate,operation_name, sum(minutes) as totminutes from operations o, production_results r where job_id=? and o.operation_id=r.operation_id   ";
$sql.=" and operation_name in ('Delivery') ";
$sql.=" group by standard_rate, operation_name order by operation_name";
$dminutes=0;
$setupNoEngineering=0;
list($ors,$err)=runIQuery($db,$sql,array("s",$folder_number));
foreach ($ors as $odata) {
	$minutes=$odata['totminutes'];
	$rate=$odata['standard_rate'];
	$ext=$minutes*$rate;
	if ($showExplanation) {
		print "<tr><td>Delivery</td><td align='right'>" . $minutes . "</td>";
		print "<td align='right'>" . number_format($rate,4) ."</td>";
		print "<td align='right'>" . number_format($ext,2) . "</td>";
		print "</tr>\n";
	}
	$stprice+= $ext;
	$setupNoEngineering+=$ext;
}
if ($dminutes == 0) {
	if ($showExplanation) {
		#print "<tr><td colspan=4 style='color: red;'>Delivery is Zero</td></tr>\n";
	}
}

$packprice=0;

$sql="select standard_rate,operation_name, sum(minutes) as totminutes from operations o, production_results r where job_id=? and  o.operation_id=r.operation_id   ";
$sql.=" and operation_name in ('Packaging') ";
$sql.=" group by standard_rate, operation_name ";
list($ors,$err)=runIQuery($db,$sql,array("s",$folder_number));
$packprice=0;
$ext=0;

foreach ($ors as $odata) {
	$minutes=$odata['totminutes'];
	$rate=$odata['standard_rate'];
	$ext=$minutes*$rate;
	if ($ext < 5) {
		$ext=5;
	}
	if ($showExplanation) {
		print "<tr><td>Packaging</td><td align='right'>" . $minutes . "</td>";
		print "<td align='right'>" . number_format($rate,4) ."</td>";
		print "<td align='right'>" . number_format($ext,2) . "</td>";
		print "</tr>\n";
	}
	$packprice=$ext;
}


$sql="select standard_rate,operation_name, sum(minutes) as totminutes from operations o, production_results r where job_id=? and  o.operation_id=r.operation_id   ";
$sql.=" and operation_name in ('Shipping') ";
$sql.=" group by standard_rate, operation_name ";
list($ors,$err)=runIQuery($db,$sql,array("s",$folder_number));
$shipprice=0;
$ext=0;


foreach ($ors as $odata) {
	$minutes=$odata['totminutes'];
	$rate=$odata['standard_rate'];
	$ext=$minutes*$rate;
	if ($ext < 5) {
		$ext=5;
	}
	if ($showExplanation) {
		print "<tr><td>Shipping</td><td align='right'>" . $minutes . "</td>";
		print "<td align='right'>" . number_format($rate,4) ."</td>";
		print "<td align='right'>" . number_format($ext,2) . "</td>";
		print "</tr>\n";
	}
	$shipprice=$ext;
}

$sql="select standard_rate, operation_name from operations o, production_results r where job_id=? and  o.operation_id=r.operation_id   ";
$sql.=" and operation_name in ('Shipping') and employee_id > 0";
list($ors,$err)=runIQuery($db,$sql,array("s",$folder_number));
if (count($ors)==0) {
	## if no manual shipping, then get mileage from customer
	$sql="select mileage from orders, customer_shiptos where order_id=? and orders.ship_name=customer_shiptos.ship_name and orders.customer_id=customer_shiptos.customer_id ";
	list($ors,$err)=runIQuery($db,$sql,array("s",$id));
	if (count($ors)) {
		$odata=$ors[0];
		$shipprice=$odata['mileage'];
		if ($showExplanation) {
			print "<tr><td>Standard Shipping from ShipTo</td><td align='right'>" . $shipprice . "</td>";
			print "<td align='right'>1</td>";
			print "<td align='right'>" . number_format($shipprice,2) . "</td>";
			print "</tr>\n";
		}
	} else {
		$sql="select mileage from orders, customers where order_id=? and orders.customer_id=customers.customer_id";
		list($ors,$err)=runIQuery($db,$sql,array("s",$id));
		if (count($ors)) {
			$odata=$ors[0];
			$shipprice=$odata['mileage'];
			if ($showExplanation) {
				print "<tr><td>Standard Shipping from Customer</td><td align='right'>" . $shipprice . "</td>";
				print "<td align='right'>1</td>";
				print "<td align='right'>" . number_format($shipprice,2) . "</td>";
				print "</tr>\n";
			}
		}
	}
	
}


if ($shipprice < 0) {
	$shipprice=5;
	if ($showExplanation) {
		print "<tr><td>Shipping</td><td align='right'>Using Minimum</td>";
		print "<td align='right'>1</td>";
		print "<td align='right'>" . number_format($ext,2) . "</td>";
		print "</tr>\n";
	}
}
$setupNoEngineering+=$shipprice;
$setupNoEngineering+=$packprice;

$sql="select sum(quantity) from order_lines where order_id=?";
list($rs,$err)=runIQuery($db,$sql,array("i",$id));
$data=$rs[0];
$totalQuantity=$data[0];

$sql="select separate_shipping, c.customer_id from orders o, customers c where order_id=? and o.customer_id=c.customer_id";
list($rs,$err)=runIQuery($db,$sql,array("i",$folder_number));
$data=$rs[0];
$separateShipping=$data['separate_shipping'];
$customer_id=$data['customer_id'];

if ($separateShipping) {
	$totalSetup=$stprice + $packprice;
} else {	
	$totalSetup=$stprice + $shipprice + $packprice;
}
if ($totalQuantity == 0) {
	$sprice=.01;
	$snoPrice=.01;
} else {
	$sprice=($stprice + $shipprice + $packprice) / $totalQuantity;
	if ($sprice < .01) {
		$sprice=.01;
	}
	$snoPrice = $setupNoEngineering / $totalQuantity;
}
if ($showExplanation) {
	print "<tr><td>Total Setup Price</td><td colspan='3' align='right'>" . number_format($totalSetup,2) . "</td></tr>";
	print "<tr><td>Setup Price Per Unit</td><td colspan='3' align='right'>" . number_format($sprice,2) . "</td></tr>\n";
	if ($separateShipping) {
		$extras=$shipprice*$surcharge/100;
		$ext=$shipprice + $extras;
		print "<tr><td style='font: red;'>SEPARATE SHIPPING PRICE</td><td colspan='3' align='right'>" . number_format($ext,2) . "</td></tr>\n";
	}
	print "</table>";
	print "</div>";
	print "<div style='clear: both;'></div>\n";
	print "<table class='table table-striped'>";
	print "<thead>";
	print "<tr><th>Part</th><th align='right'>Quantity</th><th align='right'>Price</th><th align='right'>Extended</th>";
	print "<th>Explanation</th>";
	print "</tr>\n";
	print "</thead>\n";
	print "<tbody>\n";
}
$sql="select * from order_lines where order_id=? order by line_id ";
list($rs,$err)=runIQuery($db,$sql,array("i",$id));

$grandTotal=0;
foreach ($rs as $ldata) {
		if ($showExplanation) {
			print "<tr>";
		}
		$date_due=$ldata['due_date'];
		$line_id=$ldata['line_id'];
		$item=$ldata['item_id'];
		$desc=$ldata['item_description'];
		$qty=$ldata['quantity'];
		$quotedPrice=$ldata['price'];		
		$rev=$ldata['revision'];
		$material=$ldata['material'];
		$xdimension=$ldata['xdimension'];
		$ydimension=$ldata['ydimension'];
		$experimental=$ldata['experimental_price'];
		// to calculate price
		//  Material square inches, Rounded anything over .1 goes to .5, anything over .6 to next whole number. 
		// Then Add 2 inches to each dimension times Rate on Material Record
		$explanation="";
		$explanation.="<form name='updform$line_id' action='printInvoice.php'><input type='hidden' name='id' value='$id'><input type='hidden' name='a' value='updateline'><input type='hidden' name='line' value='$line_id'> X= ";
		if ($xdimension == 0) {
			$explanation.="<input type='text' name='x' size='8' value='$xdimension' style='color: red;'>";
			$showred=1;		
		} else {
			$explanation.="<input type='text' name='x' size='8' value='$xdimension'>";		
		}
		$explanation.=" Y= ";
		if ($ydimension == 0) {
			$explanation.="<input type='text' name='y' size='8' value='$ydimension' style='color: red;'>";
			$showred=1;
		} else {
			$explanation.="<input type='text' name='y' size='8' value='$ydimension'>";
		}
		$explanation.="&nbsp;&nbsp;<input type='submit' value='CHANGE'></form>";
		$explanation.="<BR>";
		if ($xdimension - floor($xdimension) >= .6) {
			$xdimension=floor($xdimension)+1;
		} else {
			if ($xdimension - floor($xdimension) >= .1 and $xdimension - floor($xdimension) < .5) {
				$xdimension=floor($xdimension) + .5;
			}
		}
		if ($ydimension - floor($ydimension) >= .6) {
			$ydimension=floor($ydimension)+1;
		} else {
			if ($ydimension - floor($ydimension) >= .1 and $ydimension - floor($ydimension) < .5) {
				$ydimension=floor($ydimension) + .5;
			}
		}
		$margin=2;
		if ($qty > 50) {
			// possibly change to 1.5
			$margin=2;
		}
		$sf=$xdimension * $ydimension;
				
		$xdimension+=$margin;
		$ydimension+=$margin;
		$explanation.="After Rounding and adding $margin inches, ";
		$sf=$xdimension * $ydimension;
		$explanation.="X=$xdimension, Y=$ydimension, Square Inches: $sf<BR>";
		$hypotenuse = sqrt(($xdimension*$xdimension) + ($ydimension*$ydimension));
		$ehypotenuse = number_format($hypotenuse,6);
		$explanation.="Hypotenuse is $ehypotenuse<BR>";
		$sql="select material_name, price_per_square_inch, laser_time_factor from materials where material_id=$material";
		list($mrs,$err)=runIQuery($db,$sql);
		$mdata=$mrs[0];
		$ppi=$mdata['price_per_square_inch'];
		$factor=$mdata['laser_time_factor'];
		$mname=$mdata['material_name'];
		if (! $factor) {
			$factor=1;
		}
		$mprice=$sf * $ppi;
		$ext=$mprice * $qty;
		$explanation.="<table class='col-sm-12 table table-striped'><tr><td>Pricing Input</td><td align='right'>Rate</td><td align='center'>Minutes</td><td align='center'>Factor</td><td align='right'>For $qty</td><td align='right'>Unit Price</td></tr>\n";
		$explanation.="<tr><td>";
		if ($mname == "Custom Material") {
			$explanation.="<font color='red'>$mname</font>";
			$showred=1;
		} else {
			$explanation.=$mname;
		}
		$explanation.="</td><td align='right'>";
		if ($ppi == 0) {
			$explanation.="<span style='color: red'>$ppi</span>";
		} else {
			$explanation.=$ppi;
		}
		$explanation.="</td><td></td><td align='center'></td><td align='right'>" . number_format($ext,2) . "</td><td align='right'>" . number_format($mprice,2) . "</td></tr>\n";

		// Laser - take the standard rate times minutes time factor from the Material record
		$sql="select standard_rate,operation_name, o.operation_id,  sum(minutes) as totminutes from order_lines l, order_line_operations o, production_results r, operations op where l.line_id=? and l.item_id=r.item_name and job_id=? and l.line_id=o.line_id and o.operation_id=r.operation_id and o.operation_id=op.operation_id   ";
		$sql.=" and operation_name in ('Laser') ";
		$sql.=" group by standard_rate, operation_name, o.operation_id ";
		list($ors,$err)=runIQuery($db,$sql,array("is",$line_id,$folder_number));
		$lprice=0;
		if (count($ors)==0) {
			$explanation.="<tr><td colspan='6' style='color: red;'>Laser is Missing</td></tr>\n";			
			$showred=1;
		}
		foreach ($ors as $odata) {
			$rate=$odata['standard_rate'];
			$minutes=$odata['totminutes'];
			$opid=$odata['operation_id'];
			$ext=$rate*$minutes*$factor;
			$lrate=$ext / $qty;
			$lprice+=$lrate;
			$explanation.="<tr><td>Laser</td><td align='right'>" . $rate . "</td>";
			$explanation.="<td align='center'>$minutes</td><td align='center'>$factor</td>";
			$explanation.="<td align='right'>$ext</td>";
			$explanation.="<td align='right'>" . number_format($lrate,2) . "</td></tr>";
			$sql="select sum(quantity) as iqty from irma where line_id=? and subtract_operations like '%$opid%' and operation_id <> 60 ";
			list($irs,$ierr)=runIQuery($db,$sql,array("i",$line_id));
			$iqty=$irs[0][0];
			if ($iqty and $qty) {
				$iminus=$ext * ($iqty / ($qty + $iqty));
				$irate = $iminus / $qty;
				$lprice -= $irate;
				$explanation .= "<tr><td>IRMA</td><td colspan='3' align='right'>$iqty<td align='right' style='color: red;'>- " . number_format($iminus,2) . "</td><td align='right' style='color: red;'>- " . number_format($irate,2) . "</td></tr>";
				$showred=1;
			}
		}
		// OutSource - just list that this is outsourced and show the notes
		$sql="select  notes_to_self from order_lines l, order_line_operations o, orders h, operations op where l.line_id=? and l.line_id=o.line_id and l.order_id=h.order_id and o.operation_id=op.operation_id   ";
		$sql.=" and operation_name in ('Outsource') ";
		list($ors,$err)=runIQuery($db,$sql,array("i",$line_id));
		foreach ($ors as $odata) {
			$explanation.="<tr><td valign='top' style='color: red;'>Outsource</td><td valign='top' colspan='5'><b>" . nl2br($odata['notes_to_self']) . "</b></td></tr>";
			$showred=1;
		}


		// Setup
		$ext=$sprice * $qty;
		$explanation.="<tr><td>Setup</td><td align='right'>" . number_format($sprice,2) . "</td><td></td><td></td><td align='right'>" . number_format($ext,2) . "</td><td align='right'>" . number_format($sprice,2) . "</td></tr>\n";

		//  Deburr - take the hypotenuse of the part times the standard rate
		$sql="select standard_rate, operation_name from operations o, order_line_operations l where line_id=? and o.operation_id=l.operation_id and operation_name in ('Deburr','Hand-Deburr')   ";
		list($ors,$err)=runIQuery($db,$sql,array("i",$line_id));
		$oprice=0;
		if (count($ors)>0) {
			$odata=$ors[0];
			$rate=$odata['standard_rate'];
			$opname=$odata['operation_name'];
			$hypotenuse=round($hypotenuse,6);
			$ext=$rate*$hypotenuse*$qty;
			$hprice=$hypotenuse*$rate;
			$explanation.="<tr><td>$opname</td><td align='right'>" . number_format($rate,2) . "</td><td align='center' colspan='2'>$hypotenuse (hypotenuse)</td><td align='right'>" . number_format($ext,2) . "</td>";
			$explanation.="<td align='right'>" . number_format($hprice,2) . "</td></tr>";
			$oprice+= $ext;
		} 
		// inner join orders on l.order_id=orders.order_id inner join production_results r on l.item_id=r.item_name and l.job_id=folder_number left outer join order_line_operations o on o.operation_id=r.operation_id left outer join operations op on o.operation_id=op.operation_id
		// 2. Each Operation except Laser, Deburr, Engineering, Shipping, take the operation standard rate times minutes from results
		// check for missing operations
		$sql="select operation_name from order_lines l inner join order_line_operations o on l.line_id=o.line_id and l.line_id=? left outer join production_results r on l.item_id=r.item_name and r.job_id=? and r.operation_id=o.operation_id inner join operations op on o.operation_id=op.operation_id where r.operation_id is null ";
		$sql.=" and coalesce(cancel,0) = 0 ";
		$sql.=" and operation_name not in ('Laser', 'Deburr', 'Hand-Deburr', 'Engineering', 'Shipping', 'Delivery','Purchase') ";
		list($ors,$err)=runIQuery($db,$sql,array("is",$line_id,$folder_number));
		$searchForBend2 = 0;
		foreach ($ors as $odata) {
				$explanation.="<tr><td colspan='6' style='color: red;'>" . $odata['operation_name']	. " IS MISSING</td></tr>\n";
				$showred=1;
				if ($odata['operation_name'] == 'Bend') {
					$searchForBend2=1;
				}
		}
		$sql="select standard_rate, operation_name, op.operation_id, sum(coalesce(minutes,0)) as totminutes from order_lines l inner join production_results r on l.item_id=r.item_name and r.job_id=? left outer join operations op on r.operation_id=op.operation_id left outer join order_line_operations o on l.line_id=o.line_id and o.operation_id=r.operation_id  where l.line_id=?   ";
		$sql.=" and coalesce(cancel,0) = 0 ";
		$sql.=" and operation_name not in ('Laser', 'Deburr', 'Hand-Deburr', 'Engineering', 'Shipping', 'Delivery','Purchase') ";
		$sql.=" group by standard_rate, op.operation_id, operation_name order by customer_sequence";
		list($ors,$err)=runIQuery($db,$sql,array("si",$folder_number,$line_id));
		foreach ($ors as $odata) {
			$rate=$odata['standard_rate'];
			$op=$odata['operation_id'];
			$minutes=$odata['totminutes'];
			$ext=$rate*$minutes;
			$orate=$ext/$qty;
			if ($minutes == 0) {
				$explanation.="<tr><td colspan='6' style='color: red;'>" . $odata['operation_name']	. " IS MISSING</td></tr>\n";
				if ($odata['operation_name'] == 'Bend') {
					$searchForBend2=1;
				}
				$showred=1;
			} else {
				$explanation.="<tr><td>" . $odata['operation_name'] . "</td>";
				$explanation.="<td align='right'>" . number_format($rate,2) . "</td>";
				$explanation.="<td align='center'>" . $minutes . "</td>";
				$explanation.="<td align='center'></td>";
				$explanation.="<td align='right'>" . number_format($ext,2) . "</td>";
				$explanation.="<td align='right'>" . number_format($orate,2) . "</td></tr>";
				$oprice+= $ext;
				$sql="select sum(quantity) as iqty from irma where line_id=? and subtract_operations like '%$op%' ";
				list($irs,$ierr)=runIQuery($db,$sql,array("i",$line_id));
				$iqty=$irs[0][0];
				if ($iqty and $qty) {
					$iminus=$ext * ($iqty / ($qty + $iqty));
					$irate = $iminus / $qty;
					$oprice -= $irate;
					$explanation .= "<tr><td>IRMA</td><td colspan='3' align='right'>$iqty<td align='right' style='color: red;'>- " . number_format($iminus,2) . "</td><td align='right' style='color: red;'>- " . number_format($irate,2) . "</td></tr>";
					$showred=1;
				}
			}
		}
		$oprice=$oprice/$qty;
		
		$extra=0;
		if ($surcharge) {
			$explanation.="<tr><td>$typeName</td><td colspan='5' align='right'>";
			$price=$mprice+$oprice+$sprice+$lprice;
			$extra=$surcharge*$price/100;
			$explanation.= number_format($extra,2);
			$explanation.="</td></tr>\n";
			
		}
		
		$sql="select * from billofmaterial where parent_item=? ";
		list($brs,$err)=runIQuery($db,$sql,array("s",$item));
		if (count($brs) == 0) {
			if ($mname == "Custom Material") {
				$explanation.="<tr><td colspan='5' style='color: red;'>";
				$explanation.="COMPONENT NOT DEFINED</td></tr>\n";
				$showred=1;
			}
		}
		$componentPrice=0;
		foreach ($brs as $bdata) {
			$cp=$bdata['child_item'];
			$qtyper=$bdata['quantity_per'];
			$sql="select price from po_lines where folder_number=? and item_id=? ";
			list($prs,$perr)=runIQuery($db,$sql,array("ss",$folder_number, $cp));
			$pdata=$prs[0];			
			$cprice=$pdata['price'];
			// standard markup is 20 percent
			$cprice=$cprice*1.2;
			$componentPrice+= ($qtyper * $cprice);
			$explanation.="<tr><td colspan='2'>";
			$explanation.="Component $cp";
			if ($cprice == 0) {
				$explanation.="<font color='red'>MISSING</font>";
				$showred=1;				
			}
			$explanation.="</td><td align='center'>$qtyper @ $cprice</td><td colspan='2' align='right'>" . number_format($cprice * $qtyper * $qty,2) . "</td><td align='righ	t'>" . number_format($cprice * $qtyper,2) . "</td></tr>";			
		}		
		$price=$mprice+$oprice+$sprice+$lprice + $extra + $componentPrice;
		$newprice=ceil($price*4)/4;
		$price=$newprice;
		
		
		$explanation.="<tr><td>Price Per Unit</td><td colspan='5' align='right' ";
		if ($showred > 0) {
			$explanation.=" style='color: red;' ";
		}
		$explanation.=" >" . number_format($price,2) . "</td></tr>";
		$price=str_replace("NAN","0",$price);
		if (! is_numeric($price)) {
			$price=0;
		}
		$sql="update order_lines set calculated_price = $price where line_id=$line_id";
		list($updrs,$err)=runIQuery($db,$sql);
		if ($experimental > 0) {
			$explanation.="<tr><td>Consuela Price (with shipping) ";
			if ($surcharge > 0) {
				$explanation.= " (includes expediting fee)";
			}
			$explanation.="</td><td colspan='5' align='right'>";
			$extra=($experimental+$snoPrice)*$surcharge/100;
			$experimental+=$extra;
			$experimental+=$snoPrice;
			$explanation.= number_format($experimental,2);
			$explanation.= "</td></tr>\n";
		}

		$sql="select folder_number, type_name, coalesce(factor,0) as pct, qb_price from orders o inner join order_lines l on o.order_id=l.order_id left outer join order_types t on o.order_type=t.type_id  ";
		$sql.=" where item_id=? and qb_price > 0 and o.customer_id=? and folder_number <> ? order by o.order_id DESC LIMIT 10";
		list($qrs,$qerr)=runIQuery($db,$sql,array("sis",$item,$customer_id,$folder_number));
		foreach ($qrs as $qdata) {
			$f=$qdata['folder_number'];
			$t=$qdata['type_name'];
			$pct=$qdata['pct'];
			$qbPrice=$qdata['qb_price'];
			if ($pct != $surcharge) {
				$qbPrice = $qbPrice * (1 + ($pct/100));
				$qbPrice = $qbPrice / (1 + ($surcharge/100));
			}
			$explanation.= "<tr><td>QB Price</td><td>$f</td><td>$t</td><td colspan='3' align='right'>";
			$explanation.= number_format($qbPrice,2);
			$explanation.= "</td></tr>\n";
		}
		$explanation.="</table>";
		$ext=$qty*$price;
		$grandTotal+=$qty*$price;
		if ($showExplanation) {
			print "<td valign='top'>";
			print renderPartLink($customer,$item);
			print " $desc</td>";
			print "<td valign='top' align='right'>$qty</td>";
			print "<td valign='top' align='right'>" . number_format($price,2);
		}
		if ($quotedPrice > 0) {
			if ($showExplanation) {
				print " <b>Quoted Price " . number_format($quotedPrice,2) . "</b>";
			}
		}
		if ($showExplanation) {
			print "</td>";
			print "<td valign='top' align='right'>" . number_format($ext,2) . "</td>";
			print "<td>$explanation</td>";
			print "</tr>";
		}
}
if ($showExplanation) {
	print "<tr><td>Grand Total</td><td colspan='2'></td><td align='right'>";
	print number_format($grandTotal,2);
	print "</td></tr>";
	print "</tbody>\n";
	print "</table>\n";
}