-- MySQL dump 10.13  Distrib 5.1.69, for redhat-linux-gnu (x86_64)
--
-- Host: localhost    Database: influx_mfg
-- ------------------------------------------------------
-- Server version	5.1.69

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `access_groups`
--

DROP TABLE IF EXISTS `access_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `access_groups` (
  `group_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(200) NOT NULL,
  `display_sequence` int(11) NOT NULL,
  PRIMARY KEY (`group_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `admin_access`
--

DROP TABLE IF EXISTS `admin_access`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_access` (
  `access_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `table_name` varchar(300) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `allow_view` tinyint(4) NOT NULL,
  `allow_edit` tinyint(4) NOT NULL,
  `allow_delete` tinyint(4) NOT NULL,
  PRIMARY KEY (`access_id`)
) ENGINE=InnoDB AUTO_INCREMENT=694 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `billofmaterial`
--

DROP TABLE IF EXISTS `billofmaterial`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `billofmaterial` (
  `bom_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `parent_item` varchar(200) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `child_item` varchar(200) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `quantity_per` decimal(10,4) DEFAULT NULL,
  `routing_id` bigint(20) NOT NULL,
  `runseq` bigint(20) NOT NULL,
  PRIMARY KEY (`bom_id`),
  KEY `bomparent` (`parent_item`),
  KEY `bom_child` (`child_item`)
) ENGINE=InnoDB AUTO_INCREMENT=31137 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `campaigns`
--

DROP TABLE IF EXISTS `campaigns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `campaigns` (
  `campaign_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `campaign_name` varchar(200) NOT NULL,
  PRIMARY KEY (`campaign_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `company_shiptos`
--

DROP TABLE IF EXISTS `company_shiptos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `company_shiptos` (
  `shipto_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ship_name` varchar(200) NOT NULL,
  `ship_address` varchar(200) NOT NULL,
  `ship_city` varchar(200) NOT NULL,
  `ship_state` varchar(20) NOT NULL,
  `ship_zip` varchar(20) NOT NULL,
  `ship_phone` varchar(20) NOT NULL,
  `ship_contact` varchar(200) NOT NULL,
  `ship_email` varchar(200) NOT NULL,
  `use_on_packer` tinyint(1) NOT NULL,
  `ship_address2` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`shipto_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `contact_types`
--

DROP TABLE IF EXISTS `contact_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contact_types` (
  `type_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `contact_name` varchar(300) NOT NULL,
  PRIMARY KEY (`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contacts` (
  `contact_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `customer_id` bigint(20) NOT NULL,
  `salutation` varchar(100) NOT NULL,
  `first_name` varchar(200) NOT NULL,
  `last_name` varchar(200) NOT NULL,
  `email` varchar(300) NOT NULL,
  `phone` varchar(300) NOT NULL,
  `mobile` varchar(300) NOT NULL,
  `title` varchar(300) NOT NULL,
  `fax` varchar(20) NOT NULL,
  `reports_to` varchar(300) NOT NULL,
  `contact_type` varchar(200) NOT NULL,
  `donotcall` tinyint(4) NOT NULL,
  `email_opt_out` tinyint(4) NOT NULL,
  `image_name` varchar(300) NOT NULL,
  `birthdate` date NOT NULL,
  `last_contact_date` date NOT NULL,
  `next_contact_date` date NOT NULL,
  `next_message_type` varchar(200) NOT NULL,
  `lead_source` varchar(200) NOT NULL,
  `address` varchar(300) NOT NULL,
  `city` varchar(300) NOT NULL,
  `state` varchar(10) NOT NULL,
  `zip` varchar(20) NOT NULL,
  `customer_name` varchar(200) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `vendor_id` bigint(20) DEFAULT NULL,
  `vendor_name` varchar(200) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`contact_id`)
) ENGINE=InnoDB AUTO_INCREMENT=117 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `custom_fields`
--

DROP TABLE IF EXISTS `custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `custom_fields` (
  `cf_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `field_name` varchar(100) NOT NULL,
  `field_calculation` text NOT NULL,
  `title` varchar(200) NOT NULL,
  `table_name` varchar(200) NOT NULL,
  PRIMARY KEY (`cf_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=ascii;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customer_shiptos`
--

DROP TABLE IF EXISTS `customer_shiptos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_shiptos` (
  `shipto_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `customer_id` bigint(20) NOT NULL,
  `ship_name` varchar(200) CHARACTER SET latin1 NOT NULL,
  `ship_address` varchar(200) CHARACTER SET latin1 NOT NULL,
  `ship_city` varchar(200) CHARACTER SET latin1 NOT NULL,
  `ship_state` varchar(20) CHARACTER SET latin1 NOT NULL,
  `ship_zip` varchar(20) CHARACTER SET latin1 NOT NULL,
  `ship_phone` varchar(20) CHARACTER SET latin1 NOT NULL,
  `ship_contact` varchar(200) CHARACTER SET latin1 NOT NULL,
  `ship_email` varchar(200) CHARACTER SET latin1 NOT NULL,
  `short_name` varchar(200) CHARACTER SET latin1 DEFAULT NULL,
  `ship_address2` varchar(300) CHARACTER SET latin1 DEFAULT NULL,
  `is_default` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`shipto_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1257 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customers` (
  `customer_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `name` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `address` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `city` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `state` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `zip` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `phone` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `date_added` date NOT NULL,
  `notes` text COLLATE latin1_general_ci,
  `country` varchar(100) COLLATE latin1_general_ci DEFAULT NULL,
  `fax` varchar(100) COLLATE latin1_general_ci DEFAULT NULL,
  `salesperson_id` bigint(20) DEFAULT NULL,
  `bill_skids` tinyint(1) NOT NULL,
  `bill_packaging` tinyint(1) NOT NULL,
  `address2` varchar(300) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`customer_id`)
) ENGINE=InnoDB AUTO_INCREMENT=287 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cycle_count_categories`
--

DROP TABLE IF EXISTS `cycle_count_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cycle_count_categories` (
  `ccc_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(200) NOT NULL,
  `frequency` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`ccc_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cycle_count_items`
--

DROP TABLE IF EXISTS `cycle_count_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cycle_count_items` (
  `cci_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `cc_id` bigint(20) NOT NULL,
  `item_id` bigint(20) NOT NULL,
  `quantity` bigint(20) NOT NULL,
  `counted_quantity` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`cci_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3417 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cycle_counts`
--

DROP TABLE IF EXISTS `cycle_counts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cycle_counts` (
  `cc_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `count_date` datetime NOT NULL,
  `posted` tinyint(1) NOT NULL,
  `who` bigint(20) NOT NULL,
  PRIMARY KEY (`cc_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `defect_categories`
--

DROP TABLE IF EXISTS `defect_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `defect_categories` (
  `category_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(200) NOT NULL,
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `defect_types`
--

DROP TABLE IF EXISTS `defect_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `defect_types` (
  `defect_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `defect_name` varchar(200) NOT NULL,
  `defect_category` bigint(20) NOT NULL,
  PRIMARY KEY (`defect_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `documents`
--

DROP TABLE IF EXISTS `documents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documents` (
  `document_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `document_title` varchar(300) NOT NULL,
  `file_name` varchar(200) NOT NULL,
  `content` longblob NOT NULL,
  PRIMARY KEY (`document_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `employees`
--

DROP TABLE IF EXISTS `employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `employees` (
  `employee_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `last_name` varchar(200) COLLATE latin1_general_ci NOT NULL,
  `first_name` varchar(200) COLLATE latin1_general_ci NOT NULL,
  `card_number` varchar(100) COLLATE latin1_general_ci NOT NULL,
  PRIMARY KEY (`employee_id`)
) ENGINE=MyISAM AUTO_INCREMENT=104 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `feedback`
--

DROP TABLE IF EXISTS `feedback`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `feedback` (
  `feedback_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `description` text COLLATE latin1_general_ci NOT NULL,
  `feedback_date` datetime NOT NULL,
  `script_id` varchar(200) COLLATE latin1_general_ci NOT NULL,
  `table_name` varchar(200) COLLATE latin1_general_ci NOT NULL,
  `current_id` bigint(20) NOT NULL,
  `filter_id` bigint(20) NOT NULL,
  `post_variables` text COLLATE latin1_general_ci NOT NULL,
  `get_variables` text COLLATE latin1_general_ci NOT NULL,
  `current_html` text COLLATE latin1_general_ci NOT NULL,
  `viewed` tinyint(1) NOT NULL,
  `closed` tinyint(1) NOT NULL,
  `resolution` text COLLATE latin1_general_ci NOT NULL,
  `viewed_by_user` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`feedback_id`)
) ENGINE=MyISAM AUTO_INCREMENT=427 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `field_names`
--

DROP TABLE IF EXISTS `field_names`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_names` (
  `fn_idx` bigint(20) NOT NULL AUTO_INCREMENT,
  `table_name` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `field_name` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `title` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `field_type` varchar(10) COLLATE latin1_general_ci NOT NULL,
  `field_size` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `lookup_table` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `lookup_field` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `return_field` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `default_value` varchar(500) COLLATE latin1_general_ci NOT NULL,
  `description` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `display_sequence` bigint(20) NOT NULL,
  `key_field` tinyint(4) NOT NULL,
  `allow_zero` tinyint(4) NOT NULL,
  `show_on_mini` tinyint(4) DEFAULT NULL,
  `readonly` tinyint(1) NOT NULL,
  PRIMARY KEY (`fn_idx`)
) ENGINE=InnoDB AUTO_INCREMENT=1144 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `filter_conditions`
--

DROP TABLE IF EXISTS `filter_conditions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `filter_conditions` (
  `condition_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `filter_id` bigint(20) NOT NULL,
  `field_name` varchar(200) NOT NULL,
  `operation` varchar(10) NOT NULL,
  `condition` varchar(500) NOT NULL,
  PRIMARY KEY (`condition_id`)
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=ascii;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `filter_fields`
--

DROP TABLE IF EXISTS `filter_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `filter_fields` (
  `field_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `filter_id` bigint(20) NOT NULL,
  `field_name` varchar(200) NOT NULL,
  `display_sequence` bigint(20) NOT NULL,
  PRIMARY KEY (`field_id`)
) ENGINE=InnoDB AUTO_INCREMENT=286 DEFAULT CHARSET=ascii;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `filters`
--

DROP TABLE IF EXISTS `filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `filters` (
  `filter_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `filter_name` varchar(200) NOT NULL,
  `agent_id` bigint(20) NOT NULL,
  `table_name` varchar(200) NOT NULL,
  `match_all` tinyint(1) NOT NULL,
  `table_name2` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=ascii;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_actions`
--

DROP TABLE IF EXISTS `group_actions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_actions` (
  `action_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `action_name` varchar(200) NOT NULL,
  `action_script` text NOT NULL,
  `display_sequence` bigint(20) NOT NULL,
  `group_id` bigint(20) NOT NULL,
  `icon_id` bigint(20) NOT NULL,
  PRIMARY KEY (`action_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `group_customers`
--

DROP TABLE IF EXISTS `group_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_customers` (
  `gid` bigint(20) NOT NULL AUTO_INCREMENT,
  `group_id` bigint(20) NOT NULL,
  `customer_id` bigint(20) NOT NULL,
  PRIMARY KEY (`gid`)
) ENGINE=MyISAM AUTO_INCREMENT=67 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `groups` (
  `group_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `owner_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`group_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `icons`
--

DROP TABLE IF EXISTS `icons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `icons` (
  `icon_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `icon_name` varchar(100) COLLATE latin1_general_ci NOT NULL,
  PRIMARY KEY (`icon_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `inactive_inventory`
--

DROP TABLE IF EXISTS `inactive_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inactive_inventory` (
  `item_id` varchar(300) COLLATE latin1_general_ci DEFAULT NULL,
  `item_description` varchar(300) COLLATE latin1_general_ci DEFAULT NULL,
  `quantity` bigint(20) DEFAULT NULL,
  `id` bigint(20) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `inventory_locations`
--

DROP TABLE IF EXISTS `inventory_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inventory_locations` (
  `location_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `location_name` varchar(200) NOT NULL,
  `warehouse_id` bigint(20) NOT NULL,
  `available` tinyint(1) NOT NULL,
  PRIMARY KEY (`location_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `inventory_transactions`
--

DROP TABLE IF EXISTS `inventory_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inventory_transactions` (
  `transaction_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `tx_date` datetime NOT NULL,
  `script_name` varchar(200) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `location` bigint(20) NOT NULL,
  `prior_quantity` decimal(10,0) NOT NULL,
  `quantity` decimal(10,0) NOT NULL,
  `reference` varchar(200) NOT NULL,
  `item_name` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`transaction_id`)
) ENGINE=InnoDB AUTO_INCREMENT=169045 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `item_categories`
--

DROP TABLE IF EXISTS `item_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `item_categories` (
  `category_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(300) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `show_purchasing` tinyint(1) NOT NULL,
  `show_engineering` tinyint(1) NOT NULL,
  `show_sheet` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `item_images`
--

DROP TABLE IF EXISTS `item_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `item_images` (
  `image_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `item_id` bigint(20) NOT NULL,
  `image_name` varchar(300) NOT NULL,
  PRIMARY KEY (`image_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `item_locations`
--

DROP TABLE IF EXISTS `item_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `item_locations` (
  `il_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `item_id` bigint(20) NOT NULL,
  `location_id` bigint(20) NOT NULL,
  `quantity` decimal(14,4) NOT NULL,
  `available` tinyint(1) NOT NULL,
  PRIMARY KEY (`il_id`),
  KEY `itemidx` (`item_id`)
) ENGINE=InnoDB AUTO_INCREMENT=52815 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `item_status`
--

DROP TABLE IF EXISTS `item_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `item_status` (
  `status_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `status_name` varchar(200) NOT NULL,
  PRIMARY KEY (`status_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `items`
--

DROP TABLE IF EXISTS `items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `items` (
  `item_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `item_name` varchar(300) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `item_category` bigint(20) NOT NULL,
  `item_description` text CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `unit_of_measure` bigint(20) NOT NULL,
  `price` decimal(10,4) DEFAULT NULL,
  `cost` decimal(10,4) DEFAULT NULL,
  `status` bigint(20) NOT NULL,
  `quantity_on_hand` decimal(10,2) NOT NULL,
  `vendor_id` bigint(20) NOT NULL,
  `vendor_part_number` varchar(300) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `salesperson_id` bigint(20) NOT NULL,
  `commission_rate` float(10,4) NOT NULL,
  `safety_stock` bigint(20) NOT NULL,
  `lead_time` int(11) NOT NULL,
  `order_increment` bigint(20) NOT NULL,
  `average_cost` float(10,4) NOT NULL,
  `last_cost` float(10,4) NOT NULL,
  `default_location` varchar(20) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `drawing` varchar(50) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `revision` varchar(20) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `base_item` varchar(200) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `quickbooks_id` varchar(200) NOT NULL,
  `sales_account` varchar(200) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `cogs_account` varchar(200) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `item_type` varchar(200) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `asset_account` varchar(200) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `customer_id` bigint(20) DEFAULT NULL,
  `skid_quantity` bigint(20) DEFAULT NULL,
  `under_review` tinyint(1) DEFAULT NULL,
  `length` decimal(9,4) DEFAULT NULL,
  `width` decimal(9,4) DEFAULT NULL,
  `notes` text NOT NULL,
  `service` tinyint(1) NOT NULL,
  `initial_mrp_quantity` decimal(10,2) NOT NULL,
  `pounds` decimal(8,1) DEFAULT NULL,
  `cycle_count` bigint(20) NOT NULL,
  PRIMARY KEY (`item_id`),
  UNIQUE KEY `uitemname` (`item_name`)
) ENGINE=InnoDB AUTO_INCREMENT=25747 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `items_vendors`
--

DROP TABLE IF EXISTS `items_vendors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `items_vendors` (
  `iv_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `item_id` bigint(20) NOT NULL,
  `is_default` tinyint(1) NOT NULL,
  `vendor_id` bigint(20) DEFAULT NULL,
  `vendor_description` text,
  PRIMARY KEY (`iv_id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `job_defects`
--

DROP TABLE IF EXISTS `job_defects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `job_defects` (
  `jd_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `job_id` bigint(20) NOT NULL,
  `defect_id` bigint(20) NOT NULL,
  `date_reported` date NOT NULL,
  `quantity` bigint(20) NOT NULL,
  `routing_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`jd_id`)
) ENGINE=InnoDB AUTO_INCREMENT=91 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `job_status`
--

DROP TABLE IF EXISTS `job_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `job_status` (
  `status_id` int(11) NOT NULL AUTO_INCREMENT,
  `status_name` varchar(15) NOT NULL,
  PRIMARY KEY (`status_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jobs` (
  `job_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `item_id` varchar(200) COLLATE latin1_general_ci NOT NULL,
  `description` text COLLATE latin1_general_ci NOT NULL,
  `sequence` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `duration` bigint(20) NOT NULL,
  `quantity_scheduled` bigint(20) NOT NULL,
  `quantity_good` bigint(20) NOT NULL,
  `customer_id` bigint(20) NOT NULL,
  `shift` int(11) NOT NULL,
  `status` bigint(20) NOT NULL,
  `who` bigint(20) NOT NULL,
  `line_id` bigint(20) NOT NULL,
  `customer_name` varchar(200) COLLATE latin1_general_ci DEFAULT NULL,
  `quickbooks_job_number` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`job_id`),
  KEY `mrpone` (`item_id`,`start_date`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=73817 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `leads`
--

DROP TABLE IF EXISTS `leads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `leads` (
  `lead_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email` varchar(300) NOT NULL,
  `interest` text NOT NULL,
  `first_name` varchar(200) NOT NULL,
  `last_name` varchar(200) NOT NULL,
  `salutation` varchar(100) NOT NULL,
  `company` varchar(300) NOT NULL,
  `annual_revenue` bigint(20) NOT NULL,
  `industry` varchar(200) NOT NULL,
  `campaign_id` bigint(20) NOT NULL,
  `rating` varchar(200) NOT NULL,
  `lead_status` varchar(100) NOT NULL,
  `lead_source` varchar(100) NOT NULL,
  `converted` tinyint(4) NOT NULL,
  `comments` text NOT NULL,
  `priority` varchar(100) NOT NULL,
  `item_id` bigint(20) NOT NULL,
  `next_step_date` date NOT NULL,
  `next_contact_type` varchar(200) NOT NULL,
  `phone` varchar(100) NOT NULL,
  `address` varchar(300) NOT NULL,
  `city` varchar(300) NOT NULL,
  `state` varchar(10) NOT NULL,
  `zip` varchar(20) NOT NULL,
  PRIMARY KEY (`lead_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `machines`
--

DROP TABLE IF EXISTS `machines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `machines` (
  `machine_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `machine_name` varchar(300) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `workcenter_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`machine_id`)
) ENGINE=InnoDB AUTO_INCREMENT=303 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `message_types`
--

DROP TABLE IF EXISTS `message_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `message_types` (
  `type_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `type_name` varchar(200) NOT NULL,
  PRIMARY KEY (`type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `messages` (
  `message_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `message_type` bigint(20) NOT NULL,
  `message` text COLLATE latin1_general_ci NOT NULL,
  `viewed` tinyint(1) NOT NULL,
  `assigned_to` bigint(20) NOT NULL,
  `message_date` datetime NOT NULL,
  PRIMARY KEY (`message_id`)
) ENGINE=MyISAM AUTO_INCREMENT=62794 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `morders`
--

DROP TABLE IF EXISTS `morders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `morders` (
  `order_id` bigint(20) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mrp_summary`
--

DROP TABLE IF EXISTS `mrp_summary`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mrp_summary` (
  `ms_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `generated_date` datetime NOT NULL,
  `item_id` bigint(20) NOT NULL,
  `mrp_date` date NOT NULL,
  `start_quantity` decimal(10,2) NOT NULL,
  `end_quantity` decimal(10,2) NOT NULL,
  `allocated` decimal(10,2) NOT NULL,
  `on_work_order` decimal(10,2) NOT NULL,
  `on_sales_order` decimal(10,2) NOT NULL,
  `on_purchase_order` decimal(10,2) NOT NULL,
  PRIMARY KEY (`ms_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1171087 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mrp_summary_work`
--

DROP TABLE IF EXISTS `mrp_summary_work`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mrp_summary_work` (
  `ms_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `generated_date` datetime NOT NULL,
  `item_id` bigint(20) NOT NULL,
  `mrp_date` date NOT NULL,
  `start_quantity` decimal(10,2) NOT NULL,
  `end_quantity` decimal(10,2) NOT NULL,
  `allocated` decimal(10,2) NOT NULL,
  `on_work_order` decimal(10,2) NOT NULL,
  `on_sales_order` decimal(10,2) NOT NULL,
  `on_purchase_order` decimal(10,2) NOT NULL,
  PRIMARY KEY (`ms_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1171087 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `olditems`
--

DROP TABLE IF EXISTS `olditems`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `olditems` (
  `item_id` bigint(20) NOT NULL DEFAULT '0',
  `item_name` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `item_category` bigint(20) NOT NULL,
  `item_description` text COLLATE latin1_general_ci NOT NULL,
  `unit_of_measure` bigint(20) NOT NULL,
  `price` decimal(10,4) DEFAULT NULL,
  `cost` decimal(10,4) DEFAULT NULL,
  `status` bigint(20) NOT NULL,
  `quantity_on_hand` decimal(10,2) NOT NULL,
  `vendor_id` bigint(20) NOT NULL,
  `vendor_part_number` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `salesperson_id` bigint(20) NOT NULL,
  `commission_rate` float(10,4) NOT NULL,
  `safety_stock` bigint(20) NOT NULL,
  `lead_time` int(11) NOT NULL,
  `order_increment` bigint(20) NOT NULL,
  `average_cost` float(10,4) NOT NULL,
  `last_cost` float(10,4) NOT NULL,
  `default_location` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `drawing` varchar(50) COLLATE latin1_general_ci NOT NULL,
  `revision` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `base_item` varchar(200) COLLATE latin1_general_ci NOT NULL,
  `quickbooks_id` varchar(200) CHARACTER SET latin1 NOT NULL,
  `customer_name` varchar(100) CHARACTER SET latin1 DEFAULT NULL,
  `sales_account` varchar(200) COLLATE latin1_general_ci DEFAULT NULL,
  `cogs_account` varchar(200) COLLATE latin1_general_ci DEFAULT NULL,
  `item_type` varchar(200) COLLATE latin1_general_ci DEFAULT NULL,
  `asset_account` varchar(200) COLLATE latin1_general_ci DEFAULT NULL,
  `customer_id` bigint(20) DEFAULT NULL,
  `skid_quantity` bigint(20) DEFAULT NULL,
  `under_review` tinyint(1) DEFAULT NULL,
  `length` decimal(9,4) DEFAULT NULL,
  `width` decimal(9,4) DEFAULT NULL,
  `notes` text CHARACTER SET latin1 NOT NULL,
  `service` tinyint(1) NOT NULL,
  `initial_mrp_quantity` decimal(10,2) NOT NULL,
  `pounds` decimal(8,1) DEFAULT NULL,
  `cycle_count` bigint(20) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `oldsys_items`
--

DROP TABLE IF EXISTS `oldsys_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oldsys_items` (
  `item_id` bigint(20) NOT NULL DEFAULT '0',
  `item_name` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `item_category` bigint(20) NOT NULL,
  `item_description` text COLLATE latin1_general_ci NOT NULL,
  `unit_of_measure` bigint(20) NOT NULL,
  `price` decimal(10,3) NOT NULL,
  `cost` decimal(10,3) NOT NULL,
  `status` bigint(20) NOT NULL,
  `quantity_on_hand` decimal(10,2) NOT NULL,
  `vendor_id` bigint(20) NOT NULL,
  `vendor_part_number` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `salesperson_id` bigint(20) NOT NULL,
  `commission_rate` float(10,4) NOT NULL,
  `safety_stock` bigint(20) NOT NULL,
  `lead_time` int(11) NOT NULL,
  `order_increment` bigint(20) NOT NULL,
  `average_cost` float(10,4) NOT NULL,
  `last_cost` float(10,4) NOT NULL,
  `default_location` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `drawing` varchar(50) COLLATE latin1_general_ci NOT NULL,
  `revision` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `base_item` varchar(200) COLLATE latin1_general_ci NOT NULL,
  `quickbooks_id` varchar(200) CHARACTER SET latin1 NOT NULL,
  `customer_name` varchar(100) CHARACTER SET latin1 DEFAULT NULL,
  `sales_account` varchar(200) COLLATE latin1_general_ci DEFAULT NULL,
  `cogs_account` varchar(200) COLLATE latin1_general_ci DEFAULT NULL,
  `item_type` varchar(200) COLLATE latin1_general_ci DEFAULT NULL,
  `asset_account` varchar(200) COLLATE latin1_general_ci DEFAULT NULL,
  `customer_id` bigint(20) DEFAULT NULL,
  `skid_quantity` bigint(20) DEFAULT NULL,
  `under_review` tinyint(1) DEFAULT NULL,
  `length` decimal(7,2) NOT NULL,
  `width` decimal(7,2) NOT NULL,
  `notes` text CHARACTER SET latin1 NOT NULL,
  `service` tinyint(1) NOT NULL,
  `initial_mrp_quantity` decimal(10,2) NOT NULL,
  KEY `osn` (`item_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `operations`
--

DROP TABLE IF EXISTS `operations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `operations` (
  `operation_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `operation_name` varchar(300) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `default_vendor` bigint(20) NOT NULL,
  PRIMARY KEY (`operation_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3081 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `order_lines`
--

DROP TABLE IF EXISTS `order_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `order_lines` (
  `line_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) NOT NULL,
  `item_id` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `item_description` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `quantity` float(10,2) NOT NULL,
  `cost` decimal(10,4) DEFAULT NULL,
  `document_id` bigint(20) NOT NULL,
  `po_line` varchar(10) COLLATE latin1_general_ci NOT NULL,
  `shipped_quantity` float(10,2) DEFAULT NULL,
  `due_date` date NOT NULL,
  `revision` varchar(50) COLLATE latin1_general_ci DEFAULT NULL,
  `price` decimal(10,4) DEFAULT NULL,
  PRIMARY KEY (`line_id`),
  KEY `mrpthree` (`order_id`,`due_date`,`item_id`)
) ENGINE=InnoDB AUTO_INCREMENT=29120 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `order_status`
--

DROP TABLE IF EXISTS `order_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `order_status` (
  `status_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `status_name` varchar(300) NOT NULL,
  PRIMARY KEY (`status_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orders` (
  `order_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `customer_id` bigint(20) NOT NULL,
  `date_order` date NOT NULL,
  `date_due` date NOT NULL,
  `status` bigint(20) NOT NULL,
  `ship_name` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `ship_address` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `ship_city` varchar(200) COLLATE latin1_general_ci NOT NULL,
  `ship_state` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `ship_zip` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `po_number` varchar(30) COLLATE latin1_general_ci NOT NULL,
  `salesperson_id` bigint(20) NOT NULL,
  `notes_to_customer` text COLLATE latin1_general_ci NOT NULL,
  `notes_to_self` text COLLATE latin1_general_ci NOT NULL,
  `email` varchar(200) COLLATE latin1_general_ci NOT NULL,
  `phone` varchar(200) COLLATE latin1_general_ci NOT NULL,
  `ship_address2` varchar(300) COLLATE latin1_general_ci DEFAULT NULL,
  `attention` varchar(300) COLLATE latin1_general_ci DEFAULT NULL,
  `quickbooks_order_number` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`order_id`),
  KEY `orderstat` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=32360 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `packing_slip`
--

DROP TABLE IF EXISTS `packing_slip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `packing_slip` (
  `packing_slip_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `customer_id` bigint(20) NOT NULL,
  `attention` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `ship_name` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `ship_address` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `ship_city` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `ship_state` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `ship_zip` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `ship_phone` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `ship_email` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `tracking_number` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `ship_via` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `date_printed` date NOT NULL,
  `invoice_number` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `date_shipped` date NOT NULL,
  `notes_to_customer` text COLLATE latin1_general_ci NOT NULL,
  `notes_to_self` text COLLATE latin1_general_ci NOT NULL,
  `customer_name` varchar(200) COLLATE latin1_general_ci DEFAULT NULL,
  `ship_address2` varchar(200) COLLATE latin1_general_ci DEFAULT NULL,
  `quickbooks_packing_slip` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`packing_slip_id`)
) ENGINE=InnoDB AUTO_INCREMENT=117804 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `packing_slip_lines`
--

DROP TABLE IF EXISTS `packing_slip_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `packing_slip_lines` (
  `line_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `packing_list_id` bigint(20) NOT NULL,
  `order_id` bigint(20) NOT NULL,
  `order_line` int(11) NOT NULL,
  `part_number` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `description` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `quantity` bigint(20) NOT NULL,
  `po_number` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `po_line` varchar(10) COLLATE latin1_general_ci NOT NULL,
  `packing_list_line` bigint(20) DEFAULT NULL,
  `qbline` varchar(50) COLLATE latin1_general_ci DEFAULT NULL,
  `oqb` bigint(20) DEFAULT NULL,
  `shipped` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`line_id`),
  KEY `psl_parts` (`packing_list_id`,`part_number`),
  KEY `orderandline` (`order_id`,`order_line`),
  KEY `packinglist` (`packing_list_id`)
) ENGINE=InnoDB AUTO_INCREMENT=72362 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `po_lines`
--

DROP TABLE IF EXISTS `po_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `po_lines` (
  `line_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `po_id` bigint(20) NOT NULL,
  `item_id` bigint(20) NOT NULL,
  `description` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `quantity` bigint(20) NOT NULL,
  `price` float(10,4) NOT NULL,
  `quantity_received` decimal(10,2) NOT NULL,
  `date_expected` date NOT NULL,
  `job_id` bigint(20) DEFAULT NULL,
  `operation_id` bigint(20) DEFAULT NULL,
  `routing_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`line_id`),
  KEY `mrptwo` (`po_id`,`date_expected`),
  KEY `popart` (`item_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17111 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `po_status`
--

DROP TABLE IF EXISTS `po_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `po_status` (
  `status_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `status_name` varchar(100) NOT NULL,
  PRIMARY KEY (`status_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pricing`
--

DROP TABLE IF EXISTS `pricing`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pricing` (
  `price_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `customer_id` bigint(20) NOT NULL,
  `item_id` bigint(20) NOT NULL,
  `quantity` bigint(20) NOT NULL,
  `price` decimal(10,3) NOT NULL,
  PRIMARY KEY (`price_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `production_results`
--

DROP TABLE IF EXISTS `production_results`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `production_results` (
  `results_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `job_id` bigint(20) NOT NULL,
  `routing_id` bigint(20) NOT NULL,
  `employee_id` bigint(20) NOT NULL,
  `result_date` date NOT NULL,
  `duration_hours` int(11) NOT NULL,
  `duration_minutes` int(11) NOT NULL,
  `quantity_good` bigint(20) NOT NULL,
  `shift_id` bigint(20) NOT NULL,
  `notes` text COLLATE latin1_general_ci NOT NULL,
  `clocked_time` datetime DEFAULT NULL,
  `complete` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`results_id`)
) ENGINE=MyISAM AUTO_INCREMENT=917 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `purchase_orders`
--

DROP TABLE IF EXISTS `purchase_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_orders` (
  `po_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `vendor_id` bigint(20) NOT NULL,
  `po_date` date NOT NULL,
  `who` bigint(20) NOT NULL,
  `ship_name` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `ship_address` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `ship_city` varchar(200) COLLATE latin1_general_ci NOT NULL,
  `ship_state` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `ship_zip` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `notes_to_vendor` text COLLATE latin1_general_ci NOT NULL,
  `notes_to_self` text COLLATE latin1_general_ci NOT NULL,
  `status` bigint(20) NOT NULL,
  `job_id` bigint(20) NOT NULL,
  `phone` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `terms` varchar(30) COLLATE latin1_general_ci NOT NULL,
  `ship_address2` varchar(300) COLLATE latin1_general_ci DEFAULT NULL,
  `quickbooks_po_number` bigint(20) DEFAULT NULL,
  `date_due` date DEFAULT NULL,
  PRIMARY KEY (`po_id`),
  KEY `postat` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=47850 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `quality_issues`
--

DROP TABLE IF EXISTS `quality_issues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quality_issues` (
  `q_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `customer_id` bigint(20) NOT NULL,
  `reported_by` bigint(20) NOT NULL,
  `item_id` varchar(300) DEFAULT NULL,
  `issue` text NOT NULL,
  `quantity` bigint(20) NOT NULL,
  `date_reported` date NOT NULL,
  `part_revision` varchar(20) NOT NULL,
  `reason_code` bigint(20) NOT NULL,
  `customer_reference` varchar(100) NOT NULL,
  `action_taken` text NOT NULL,
  `resolved` tinyint(1) NOT NULL,
  `resolution` text NOT NULL,
  `dollars` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`q_id`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `quality_reasons`
--

DROP TABLE IF EXISTS `quality_reasons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quality_reasons` (
  `reason_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `reason_code` varchar(200) NOT NULL,
  PRIMARY KEY (`reason_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `quality_reporter`
--

DROP TABLE IF EXISTS `quality_reporter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quality_reporter` (
  `report_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `reporter_name` varchar(200) NOT NULL,
  PRIMARY KEY (`report_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `ratings`
--

DROP TABLE IF EXISTS `ratings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ratings` (
  `rating_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `rating_value` varchar(200) NOT NULL,
  PRIMARY KEY (`rating_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `receipt_lines`
--

DROP TABLE IF EXISTS `receipt_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `receipt_lines` (
  `receipt_line` bigint(20) NOT NULL AUTO_INCREMENT,
  `receipt_id` bigint(20) NOT NULL,
  `line_id` bigint(20) NOT NULL,
  `quantity_received` decimal(10,2) NOT NULL,
  PRIMARY KEY (`receipt_line`)
) ENGINE=InnoDB AUTO_INCREMENT=14721 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `receipts`
--

DROP TABLE IF EXISTS `receipts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `receipts` (
  `receipt_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date_received` datetime NOT NULL,
  `who_received` bigint(20) NOT NULL,
  `processed` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`receipt_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14712 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `report_conditions`
--

DROP TABLE IF EXISTS `report_conditions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `report_conditions` (
  `condition_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `report_id` bigint(20) NOT NULL,
  `field_name` varchar(200) NOT NULL,
  `operation` varchar(10) NOT NULL,
  `condition` varchar(500) NOT NULL,
  `table_name` varchar(200) NOT NULL,
  PRIMARY KEY (`condition_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1143 DEFAULT CHARSET=ascii;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `report_fields`
--

DROP TABLE IF EXISTS `report_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `report_fields` (
  `field_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `table_name` varchar(200) NOT NULL,
  `report_id` bigint(20) NOT NULL,
  `field_name` varchar(200) NOT NULL,
  `display_sequence` bigint(20) NOT NULL,
  PRIMARY KEY (`field_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1917 DEFAULT CHARSET=ascii;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reports` (
  `report_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `report_name` varchar(200) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `table_name` varchar(200) NOT NULL,
  `table_name2` varchar(200) NOT NULL,
  `match_all` tinyint(1) NOT NULL,
  `table_name3` varchar(200) NOT NULL,
  PRIMARY KEY (`report_id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=ascii;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `routing`
--

DROP TABLE IF EXISTS `routing`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `routing` (
  `routing_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `description` varchar(200) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `parent_part` varchar(200) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `operation_id` bigint(20) NOT NULL,
  `machine_id` bigint(20) NOT NULL,
  `workcenter_id` bigint(20) NOT NULL,
  `pph` bigint(20) NOT NULL,
  `units` decimal(5,2) NOT NULL,
  `notes` text CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `vendor_id` bigint(20) NOT NULL,
  `display_sequence` bigint(20) NOT NULL,
  `opname` varchar(20) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `machine` varchar(20) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `workcenter` varchar(20) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `calculate` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`routing_id`),
  KEY `opers` (`operation_id`),
  KEY `machine_id` (`machine_id`,`workcenter_id`,`vendor_id`)
) ENGINE=InnoDB AUTO_INCREMENT=90020 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `routing_configuration`
--

DROP TABLE IF EXISTS `routing_configuration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `routing_configuration` (
  `rc_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `routing_id` bigint(20) NOT NULL,
  `routing_configuration` bigint(20) NOT NULL,
  `configuration_value` varchar(300) COLLATE latin1_general_ci NOT NULL,
  PRIMARY KEY (`rc_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `routing_text`
--

DROP TABLE IF EXISTS `routing_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `routing_text` (
  `routing_id` bigint(20) NOT NULL,
  `routing_text` text NOT NULL,
  `part_number` varchar(300) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `display_sequence` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `salespeople`
--

DROP TABLE IF EXISTS `salespeople`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `salespeople` (
  `salesperson_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `last_name` varchar(300) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `first_name` varchar(300) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `phone` varchar(300) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `email` varchar(300) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `full_name` varchar(100) NOT NULL,
  `initials` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`salesperson_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `savejobs`
--

DROP TABLE IF EXISTS `savejobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `savejobs` (
  `job_id` bigint(20) NOT NULL DEFAULT '0',
  `item_id` varchar(200) COLLATE latin1_general_ci NOT NULL,
  `description` text COLLATE latin1_general_ci NOT NULL,
  `sequence` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `duration` bigint(20) NOT NULL,
  `quantity_scheduled` bigint(20) NOT NULL,
  `quantity_good` bigint(20) NOT NULL,
  `customer_id` bigint(20) NOT NULL,
  `shift` int(11) NOT NULL,
  `status` bigint(20) NOT NULL,
  `who` bigint(20) NOT NULL,
  `line_id` bigint(20) NOT NULL,
  `customer_name` varchar(200) COLLATE latin1_general_ci DEFAULT NULL,
  `quickbooks_job_number` bigint(20) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `savelines`
--

DROP TABLE IF EXISTS `savelines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `savelines` (
  `line_id` bigint(20) NOT NULL DEFAULT '0',
  `order_id` bigint(20) NOT NULL,
  `item_id` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `item_description` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `quantity` float(10,2) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `document_id` bigint(20) NOT NULL,
  `po_line` varchar(10) COLLATE latin1_general_ci NOT NULL,
  `shipped_quantity` float(10,2) DEFAULT NULL,
  `due_date` date NOT NULL,
  `revision` varchar(50) COLLATE latin1_general_ci DEFAULT NULL,
  `price` decimal(10,4) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `schedule`
--

DROP TABLE IF EXISTS `schedule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `schedule` (
  `schedule_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `workcenter_id` bigint(20) NOT NULL,
  `schedule_date` date NOT NULL,
  PRIMARY KEY (`schedule_id`)
) ENGINE=InnoDB AUTO_INCREMENT=105719 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `schedule_items`
--

DROP TABLE IF EXISTS `schedule_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `schedule_items` (
  `si_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `schedule_id` bigint(20) NOT NULL,
  `machine_id` bigint(20) NOT NULL,
  `job_id` bigint(20) NOT NULL,
  `operation_id` bigint(20) NOT NULL,
  `vendor_id` bigint(20) DEFAULT NULL,
  `hours` float(10,2) NOT NULL,
  `display_sequence` bigint(20) DEFAULT NULL,
  `routing_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`si_id`)
) ENGINE=InnoDB AUTO_INCREMENT=24830 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `shifts`
--

DROP TABLE IF EXISTS `shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shifts` (
  `shift_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `shift_name` varchar(20) NOT NULL,
  PRIMARY KEY (`shift_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `site_admins`
--

DROP TABLE IF EXISTS `site_admins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `site_admins` (
  `user_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email` varchar(300) NOT NULL,
  `password` varchar(100) NOT NULL,
  `last_login` date NOT NULL,
  `full_name` varchar(300) NOT NULL,
  `site_id` bigint(20) NOT NULL,
  `google_calendar` varchar(200) DEFAULT NULL,
  `gmail_password` varchar(200) DEFAULT NULL,
  `is_admin` tinyint(1) NOT NULL,
  `inventory_admin` tinyint(1) NOT NULL,
  `salesperson_id` bigint(20) DEFAULT NULL,
  `time_entry_only` tinyint(1) DEFAULT NULL,
  `debug` tinyint(1) DEFAULT NULL,
  `quality` tinyint(1) DEFAULT NULL,
  `initials` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `states` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(40) COLLATE latin1_general_ci NOT NULL,
  `abbreviation` char(2) COLLATE latin1_general_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `table_names`
--

DROP TABLE IF EXISTS `table_names`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `table_names` (
  `tn_idx` bigint(20) NOT NULL AUTO_INCREMENT,
  `table_name` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `table_title` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `description` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `key_field` varchar(200) COLLATE latin1_general_ci NOT NULL,
  `group_id` bigint(20) NOT NULL,
  `display_sequence` bigint(20) NOT NULL,
  `icon_id` bigint(20) NOT NULL,
  `default_order` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `special_edit_page` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `special_edit_title` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `show_preview` tinyint(4) NOT NULL,
  `show_key` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`tn_idx`)
) ENGINE=InnoDB AUTO_INCREMENT=125 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `table_relations`
--

DROP TABLE IF EXISTS `table_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `table_relations` (
  `tr_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `table1` varchar(200) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `field1` varchar(200) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `table2` varchar(200) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `field2` varchar(200) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `display_field` bigint(20) NOT NULL,
  `allow_zero` tinyint(11) NOT NULL,
  `parent_child` tinyint(4) NOT NULL,
  PRIMARY KEY (`tr_id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `table_tabs`
--

DROP TABLE IF EXISTS `table_tabs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `table_tabs` (
  `tt_idx` bigint(20) NOT NULL AUTO_INCREMENT,
  `tn_idx` bigint(20) NOT NULL,
  `tab_name` varchar(100) NOT NULL,
  `display_sequence` bigint(20) NOT NULL,
  PRIMARY KEY (`tt_idx`)
) ENGINE=InnoDB DEFAULT CHARSET=ascii;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tasks` (
  `task_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `due_date` date NOT NULL,
  `task_name` text COLLATE latin1_general_ci NOT NULL,
  `assigned_to` bigint(20) NOT NULL,
  `completed` tinyint(1) NOT NULL,
  `assigned_by` bigint(20) NOT NULL,
  `description` text COLLATE latin1_general_ci NOT NULL,
  `priority` varchar(10) COLLATE latin1_general_ci NOT NULL,
  PRIMARY KEY (`task_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `transaction_log`
--

DROP TABLE IF EXISTS `transaction_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_log` (
  `txid` bigint(20) NOT NULL AUTO_INCREMENT,
  `who` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `when` datetime NOT NULL,
  `script_name` varchar(200) COLLATE latin1_general_ci NOT NULL,
  `table_name` varchar(200) COLLATE latin1_general_ci NOT NULL,
  `sql_statement` text COLLATE latin1_general_ci NOT NULL,
  PRIMARY KEY (`txid`)
) ENGINE=MyISAM AUTO_INCREMENT=1150550 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `transfer_lines`
--

DROP TABLE IF EXISTS `transfer_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transfer_lines` (
  `txid` bigint(20) NOT NULL AUTO_INCREMENT,
  `part_number` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `description` text COLLATE latin1_general_ci NOT NULL,
  `quantity` bigint(20) NOT NULL,
  `po_number` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `packaging` text COLLATE latin1_general_ci NOT NULL,
  `packing_slip` bigint(20) NOT NULL,
  PRIMARY KEY (`txid`),
  KEY `tl_partindex` (`part_number`)
) ENGINE=InnoDB AUTO_INCREMENT=36690 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transfers` (
  `packing_slip` bigint(20) NOT NULL AUTO_INCREMENT,
  `location` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `transfer_date` date NOT NULL,
  `ship_address` varchar(200) COLLATE latin1_general_ci DEFAULT NULL,
  `ship_city` varchar(200) COLLATE latin1_general_ci DEFAULT NULL,
  `ship_state` varchar(10) COLLATE latin1_general_ci DEFAULT NULL,
  `ship_zip` varchar(10) COLLATE latin1_general_ci DEFAULT NULL,
  `ship_name` varchar(200) COLLATE latin1_general_ci DEFAULT NULL,
  `quickbooks_packing_slip` bigint(20) DEFAULT NULL,
  `vendor_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`packing_slip`)
) ENGINE=MyISAM AUTO_INCREMENT=14434 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `units_of_measure`
--

DROP TABLE IF EXISTS `units_of_measure`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `units_of_measure` (
  `uom_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `uom_name` varchar(300) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  PRIMARY KEY (`uom_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `updl`
--

DROP TABLE IF EXISTS `updl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `updl` (
  `line_id` bigint(20) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `updol`
--

DROP TABLE IF EXISTS `updol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `updol` (
  `line_id` bigint(20) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_display_sequence`
--

DROP TABLE IF EXISTS `user_display_sequence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_display_sequence` (
  `ds_idx` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `tn_idx` bigint(20) NOT NULL,
  `display_sequence` bigint(20) NOT NULL,
  `sequence_type` varchar(10) NOT NULL,
  PRIMARY KEY (`ds_idx`)
) ENGINE=InnoDB AUTO_INCREMENT=1905 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `vendors`
--

DROP TABLE IF EXISTS `vendors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `vendors` (
  `vendor_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `vendor_name` varchar(300) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `address` varchar(300) NOT NULL,
  `city` varchar(200) NOT NULL,
  `state` varchar(20) NOT NULL,
  `zip` varchar(20) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `email` varchar(300) NOT NULL,
  `fax` varchar(20) DEFAULT NULL,
  `terms` varchar(30) NOT NULL,
  `address2` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`vendor_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2172 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `warehouses`
--

DROP TABLE IF EXISTS `warehouses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `warehouses` (
  `warehouse_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `warehouse_name` varchar(200) NOT NULL,
  PRIMARY KEY (`warehouse_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `workcenter_configuration`
--

DROP TABLE IF EXISTS `workcenter_configuration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `workcenter_configuration` (
  `configuration_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `workcenter_id` bigint(20) NOT NULL,
  `configuration_name` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `configuration_type` bigint(20) NOT NULL,
  `display_sequence` bigint(20) NOT NULL,
  PRIMARY KEY (`configuration_id`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `workcenter_configuration_types`
--

DROP TABLE IF EXISTS `workcenter_configuration_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `workcenter_configuration_types` (
  `type_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `configuration_name` varchar(300) COLLATE latin1_general_ci NOT NULL,
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `workcenters`
--

DROP TABLE IF EXISTS `workcenters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `workcenters` (
  `workcenter_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `workcenter_name` varchar(300) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `vendor_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`workcenter_id`)
) ENGINE=InnoDB AUTO_INCREMENT=156 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `zeroitems`
--

DROP TABLE IF EXISTS `zeroitems`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `zeroitems` (
  `item_id` bigint(20) NOT NULL DEFAULT '0',
  `item_name` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `item_category` bigint(20) NOT NULL,
  `item_description` text COLLATE latin1_general_ci NOT NULL,
  `unit_of_measure` bigint(20) NOT NULL,
  `price` decimal(10,3) NOT NULL,
  `cost` decimal(10,3) NOT NULL,
  `status` bigint(20) NOT NULL,
  `quantity_on_hand` decimal(10,2) NOT NULL,
  `vendor_id` bigint(20) NOT NULL,
  `vendor_part_number` varchar(300) COLLATE latin1_general_ci NOT NULL,
  `salesperson_id` bigint(20) NOT NULL,
  `commission_rate` float(10,4) NOT NULL,
  `safety_stock` bigint(20) NOT NULL,
  `lead_time` int(11) NOT NULL,
  `order_increment` bigint(20) NOT NULL,
  `average_cost` float(10,4) NOT NULL,
  `last_cost` float(10,4) NOT NULL,
  `default_location` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `drawing` varchar(50) COLLATE latin1_general_ci NOT NULL,
  `revision` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `base_item` varchar(200) COLLATE latin1_general_ci NOT NULL,
  `quickbooks_id` varchar(200) CHARACTER SET latin1 NOT NULL,
  `customer_name` varchar(100) CHARACTER SET latin1 DEFAULT NULL,
  `sales_account` varchar(200) COLLATE latin1_general_ci DEFAULT NULL,
  `cogs_account` varchar(200) COLLATE latin1_general_ci DEFAULT NULL,
  `item_type` varchar(200) COLLATE latin1_general_ci DEFAULT NULL,
  `asset_account` varchar(200) COLLATE latin1_general_ci DEFAULT NULL,
  `customer_id` bigint(20) DEFAULT NULL,
  `skid_quantity` bigint(20) DEFAULT NULL,
  `under_review` tinyint(1) DEFAULT NULL,
  `length` decimal(7,2) NOT NULL,
  `width` decimal(7,2) NOT NULL,
  `notes` text CHARACTER SET latin1 NOT NULL,
  `service` tinyint(1) NOT NULL,
  `initial_mrp_quantity` decimal(10,2) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2017-02-24  8:10:51
