<?php

// Database credentials
$dbHost     = 'localhost';
$dbUsername = 'root';
$dbPassword = 'root';
$dbName     = 'weld';

// Directory containing SQL files
$sqlDirectory = './prefmach_weld.sql';

// Create database connection
$mysqli = new mysqli($dbHost, $dbUsername, $dbPassword, $dbName);

// Check connection
if ($mysqli->connect_error) {
    die("Connection failed: " . $mysqli->connect_error);
}

// Iterate over each SQL file in the directory
foreach (new DirectoryIterator($sqlDirectory) as $fileInfo) {
    if ($fileInfo->isDot() || $fileInfo->getExtension() !== 'sql') {
        continue;
    }

    $sqlFile = $fileInfo->getPathname();
    echo "Importing $sqlFile...\n";

    $sqlContents = file_get_contents($sqlFile);
    if ($sqlContents === false) {
        echo "Error reading file $sqlFile\n";
        continue;
    }

    if ($mysqli->multi_query($sqlContents)) {
        do {
            echo "working...";
            // Wait for the current query to finish
            if ($result = $mysqli->store_result()) {
                $result->free();
            }
        } while ($mysqli->more_results() && $mysqli->next_result());
        echo "$sqlFile imported successfully.\n";
    } else {
        echo "Error occurred while importing $sqlFile: " . $mysqli->error . "\n";
    }
}

$mysqli->close();

?>
