<?php

## given part / so / line / job (parent only?) / display sequence of operation that consumes weldment child / bay type
## I have an order match, and I know if it's a weldment or not.  Need to break it up into powder coating bay as well based on operations returned here, and then update bay type before getting open bays
$noRouting = 0;
$containsDeburr = 0;
$containsCoat = 0;
$prePowderSatisfied = 0;
$postPowderSatisfied = 0;
$firstToFailOp = 0;
$firstToFailSeq = 0;
$requiresResults = 0;
$outsideProcessSatisfied = 0;
$missingOperations = array();

$powderOperations = array(3113,3116,3138,3139,3140);
//$stageQty=0; // max available amount for staging, could be 0, qty scheduled, or anything in between
$overrideStageQty=0;

$sql = "SELECT job_id, quantity_scheduled, quantity_good FROM jobs WHERE item_id=? AND line_id=?";  ## STEP 1: get job
list($rs,$err)=runIQuery($db,$sql,array("si",$part,$line));

    if ($rs) {
        $jobPart = $rs[0]['job_id'];   ## I don't want to overwrite the existing job of the parent if it's a child part
        $qtySch = $rs[0]['quantity_scheduled'];
        $qtyGood = $rs[0]['quantity_good'];
        ## skipping over material handling and plug/mask and per justin 3/17 sort laser
        $sql = "SELECT routing_id, operation_id, display_sequence, business_unit FROM routing WHERE parent_part=? AND operation_id NOT IN (3090, 3119, 3136, 3159, 3123) ORDER BY display_sequence ASC";  ## STEP 2: get routing 
        list($ars,$err) = runIQuery($db,$sql,array("s",$part));

        if ($ars) {
           $index = 0;
            foreach ($ars as $data) {  ## START OF THE LOOP
                $routing = $data['routing_id'];
                $op = $data['operation_id'];
                $displaySequence = $data['display_sequence'];
                $routLocation = $data['business_unit'];

                ## first verify the business unit for the user and the routing are valid, then check if there's routing where they don't match
                if (($businessUnit == 1 || $businessUnit == 2) && ($routLocation == 1 || $routLocation == 2) && ($businessUnit != $routLocation)) {
                    $transferRequired = 1;
                }

                if ($op == 3113 || $op == 3116 || $op == 3138 || $op == 3140 || $op == 3139 || $op == 3119) {  ## (racking,powder application, line load, )
                    ## it's destined for a powder coat bay, three scenarios:
                        ## 1. not enough production results to go into any bay, but powder coat bay would be the bay it would go into first
                        ## 2. production results up to powder coat are satisfied, but still needs to be powder coated, goes into pc bay
                        ## 3. it has all routing finished; it can go into post powder bay and can be shipped if the rest of the order is satisfied

                    $containsCoat = 1;
                } else {
                    if (!($op == 3119)) { ## verify that plug/ mask can also be skipped over for JR parts going into poweder
                        $requiresResults = 1; // allows purchased goods that get painted but nothing else to bypass production results requirements
                    }
                }

                ## adding flag for parts that require deburr and need to be transferred from Jenison to Holland
                // 3148	Deburr
                // 3151	Hand-Deburr
                // 3161	Vibe Unload
                if ($op == 3148 || $op == 3151 || $op == 3161) {
                    $containsDeburr = 1;
                }


                $sql = "SELECT SUM(quantity_good) AS qty FROM production_results WHERE job_id=? AND routing_id=?";  ## STEP 3: check production results for each routing
                list($brs,$err)=runIQuery($db,$sql,array("ii",$jobPart,$routing));
                if (!(count($brs) > 0)) {
                    $productionQty = 0;
                } else {
                     $productionQty = $brs[0][0];
                }
                               
                if ($index == 0 && is_numeric($productionQty)) {
                    $stageQty = $productionQty;
                } elseif ($productionQty < $stageQty) {
                    $stageQty = $productionQty;
                }

                // testing for now
                if ($qtyGood > 0 && $containsCoat) {
                    $postPowderSatisfied = 1;
                }


                if ($productionQty > 0 && ($op == 3113 || $op == 3116 || $op == 3139)) {
                    $postPowderSatisfied = 1; // it shows production results for powder coat; allow it into post powder
                    $overrideStageQty = $productionQty;
                } elseif (($op == 3113 || $op == 3116 || $op == 3138) && $firstToFailOp == 0 ) {
                    $prePowderSatisfied = 1;  // not ready for post powder, but it contains powder coat routing and has satisfactory production results up to the powder stage
                    $overrideStageQty = $productionQty;
                    if ($displaySequence == 10) { // it's the first step, so there won't be production results for it, but it's in stock
                        $stageQty = $qtySch;
                    }
                }

                if (!($productionQty > 0)) {
                    $missingMinutes = 1;
                    array_push($missingOperations, $op);
                    if ($firstToFailOp == 0) {
                        $firstToFailSeq = $displaySequence;
                        $firstToFailOp = $op;
                    }
                }

               
             

                $index++;
                
            } ## END OF THE LOOP


            if ($overrideStageQty && ($overrideStageQty > $stageQty)) {  ## the qty doesn't satisfy a normal bay, but it is good enough for powder coat staging
                $stageQty = $overrideStageQty;
            }
    
            if ($qtyGood > $stageQty) {
                $stageQty = $qtyGood;
                $missingMinutes = 0;
                $missingOperations = [];
            }
            
    
            if ($postPowderSatisfied) {
                $bayType = 5;
                $missingMinutes = 0;
            } elseif ($prePowderSatisfied || $containsCoat) {
                $bayType = 3;
                if ($prePowderSatisfied) {
                    $missingMinutes = 0; 
                } else {
                    $missingOperations = array_diff($missingOperations,$powderOperations); // it is missing operations before pre powder, but I don't want to show powder operations, just the ones before them
                }
                
            }

            if ($requiresResults == 0) {
                $noRouting = 1; // resets stageable quantity so it's not 0
                $missingMinutes = 0; // prevents warning of missing operations
            }

            if ($firstToFailOp == 3106  && (count($ars)>1)) {
                $sql="SELECT `description` FROM routing WHERE parent_part=? AND operation_id=3106";
                list($rs,$err)=runIQuery($db,$sql,array("s",$part));
                $descNotes=$rs[0][0];
                if (!($descNotes == "PURCHASE")) {
                    $bayType = 1; // even if it gets powder coated later, it needs to go to staging for outside process now
                    $missingMinutes = 0;
                    $outsideProcessSatisfied = 1; // not using this yet
                }
            }


        } else {
            $noRouting = 1;
        }

       
    } else {
        $noRouting = 1;
    }

    ## for now, set everything to $noRouting, remove below when merge has settled 2/24/22
    // commenting out below because production results can be enforced again
    // if ( !(in_array(3148,$missingOperations) || (in_array(3151,$missingOperations))) ) { ## burr and hand deburr
    //     $noRouting = 1;
    //     $missingMinutes = 0;
    //     $missingOperations=array();
    // } else {
    //     $addDeburrArray=array();
    //     if (in_array(3148,$missingOperations)) {
    //         array_push($addDeburrArray, 3148);
    //     }
    //     if (in_array(3151,$missingOperations)) {
    //         array_push($addDeburrArray, 3151);
    //     }
    //     $missingOperations=$addDeburrArray;
    // }
  

    ## if Jenison has something that might go into a powder coat bay, make sure it can go into staging at least
    if ($businessUnit == 1 && ($bayType == 3 || $bayType == 5)) {
        $bayType =1;
    }

// CMA trying to group these together you should treat the groups the same
// Group 1 is Welding
//  3081	Tig Weld
// 3099	Weld
// 3091	Fabrication
// 3108	Production Weld
// 3134	Production Fab
// 3162	Weldment

// Group 2 should never hold up staging
// 3090	Material Handling
// 3106	Outside Process
// 3107	Quality Inspection
// 3109	Pre Treatment
// 3110	Dry Off
// 3112	Cure
// 3113	Racking
// 3119	Plug/Mask
// 3124	Cleaning
// 3131	Piece Work
// 3132	Training
// 3133	Maintenance
// 3136	Class A Finish
// 3137	Custom Crating
// 3139	Line Unload
// 3145	Break Time
// 3152	Internal Work
// 3153	Meeting
// 3154	Peel-Plastic
// 3150	Engineering
// 3156	Phone Call
// 3157	Preventative Maintenance
// 3160	Vibe Load
// 3149	Drafting
// 3147	CNC Programming

// Group 3 these are all deburr
// 3148	Deburr
// 3151	Hand-Deburr
// 3161	Vibe Unload

// Group 4 these are all Machining
// 3118	Boring Mill
// 3086	Drill/Tap
// 3144	Machining
// 3146	CNC Mill


// These are by themselves they do not get grouped.  Possibly Saw and Passivate should not hold up in Jenison
// 3085	Saw
// 3092	PASSIVATE
// 3100	Assembly
// 3116	Powder Application
// 3122	Bend
// 3123	Laser
// 3138	Line Load
// 3155	PemNut
// 3158	Roll
// 3159	Sort




        ## you would never hold up staging over these operations
        if ($businessUnit == 1) {
            $excludeOperations = array(3085, 3091, 3108, 3100,3090,3106,3107,3109,3110,3112,3113,3116,3119,3124,3131,3132,3133,3134,3136,3137,3138,3139,3145,3147,3149,3150,3152,3153,3154,3156,3157,3159);
        }
        if ($businessUnit == 2) {
            $excludeOperations = array(3090,3106,3107,3109,3110,3112,3113,3119,3124,3131,3132,3133,3134,3136,3137,3138,3139,3145,3147,3149,3150,3152,3153,3154,3156,3157,3159);
        }

        ## UNCOMMENT BELOW WHEN PUSHING TO PRODUCTION
        ## turning off production results requirement with missingMinutes = 0
        //$missingMinutes = 0;

    if ($missingMinutes > 0) {
        //print "checking for exclusions";
        $missingOperations=array_diff($missingOperations,$excludeOperations);
        if (count($missingOperations)==0) {
            $missingMinutes=0;  ## gets rid of missing operations requirement
            $noRouting = 1; ## gets rid of quantity good requirement
        } else {
            //print_r($missingOperations);
        }
    }



?>