<?php
## given part and order
## I need to be able to select the parts that would go in the same bay
##  Parent Level        Children Level
##      FOOBAR  [       FOO-1, BAR-1      
##      BARFOO  [       BAR-2, FOO-2
##
## Given foobar, I need to show foobar and barfoo / Given foo-1, I need to show foo-1 and bar-1 and limit the bays to weldment
## only show items at the same level.  for the purposes of staging, we won't care about "missing" parts on another level, just need the correct operations in production_results
## FOR NOW hard coding to ignore PPF, but PPF will be added to staging_ignore later on

if ($bayType == 1) {
    $sql = "SELECT line_id, order_lines.item_id, quantity, width, `length`, COALESCE(shipped_quantity,0) AS shipped_quantity, COALESCE(items.powder_color,0) AS color, items.item_description
    FROM order_lines
    LEFT OUTER JOIN items ON order_lines.item_id=items.item_name
    WHERE items.item_name NOT IN ('PPF') AND order_id=?";
    list($prs,$err)=runIQuery($db,$sql,array("i",$order));
} elseif ($bayType == 2) {
    $sql="SELECT ii.item_name AS item_id, b.quantity_per AS quantity, 0 AS shipped_quantity, 0 AS line_id, ii.width, ii.`length`, COALESCE(ii.powder_color,0) AS color, ii.item_description 
    FROM items i, billofmaterial b, items ii, routing r 
    WHERE i.item_name=?
    AND i.item_name=b.parent_item AND b.child_item = ii.item_name
    AND ii.item_name NOT IN ('PPF')
    AND i.item_name=r.parent_part AND r.operation_id IN (3081, 3091, 3099, 3108, 3134)
    AND b.routing_id=r.routing_id";
    list($prs,$err)=runIQuery($db,$sql,array("s",$parentPart));
} elseif ($bayType == 3 || $bayType == 5) {
    if ($parentPart && $bayType == 5) { //if it's assembly and has passed powder bay, it can go into assembly rather than post powder
        $sql="SELECT ii.item_name AS item_id, b.quantity_per AS quantity, 0 AS shipped_quantity, 0 AS line_id, ii.width, ii.`length`, COALESCE(ii.powder_color,0) AS color, ii.item_description 
        FROM items i, billofmaterial b, items ii, routing r 
        WHERE i.item_name=?
        AND ii.item_name (NOT IN 'PPF')
        AND i.item_name=b.parent_item AND b.child_item = ii.item_name
        AND i.item_name=r.parent_part AND r.operation_id IN (3100)
        AND b.routing_id=r.routing_id";
        list($prs,$err)=runIQuery($db,$sql,array("s",$parentPart));
        $bayType = 4;
    } elseif ($parentPart && $useUpOp > 0 ) {
        $sql = "SELECT ii.item_name AS item_id, b.quantity_per AS quantity, 0 AS shipped_quantity, 0 AS line_id, ii.width, ii.`length`, COALESCE(ii.powder_color,0) AS color, ii.item_description 
        FROM  billofmaterial b, items ii, routing r, routing rout
        WHERE b.parent_item=?
        AND ii.item_name NOT IN ('PPF')
        AND b.child_item = ii.item_name
        AND b.routing_id=r.routing_id
        AND r.operation_id IN ($useUpOp)
         GROUP BY item_id";
        list($prs,$err)=runIQuery($db,$sql,array("s",$parentPart));
    } elseif ($parentPart && $bayType == 3) { // destined for assembly later on
        $sql="SELECT ii.item_name AS item_id, b.quantity_per AS quantity, 0 AS shipped_quantity, 0 AS line_id, ii.width, ii.`length`, COALESCE(ii.powder_color,0) AS color, ii.item_description 
        FROM  billofmaterial b, items ii, routing r, routing rout
        WHERE b.parent_item=?
        AND ii.item_name NOT IN ('PPF')
        AND b.child_item = ii.item_name
        AND b.routing_id=r.routing_id
        AND r.operation_id IN (3100)
        AND rout.parent_part=ii.item_name AND rout.operation_id IN (3116,3138)"; // leave out the components that are needed for assembly, but not powder coat
        list($prs,$err)=runIQuery($db,$sql,array("s",$parentPart));
    } else {
        ## I intend to designate they get a powder bay at this point, and later I'll worry about the specific color when they get separated by color onto different pallets
        $sql = "SELECT line_id, order_lines.item_id, quantity, width, `length`, COALESCE(shipped_quantity,0) AS shipped_quantity, COALESCE(items.powder_color,0) AS color
        FROM order_lines
        LEFT OUTER JOIN items ON order_lines.item_id=items.item_name
        WHERE order_lines.item_id NOT IN ('PPF') AND order_id=?";
        list($prs,$err)=runIQuery($db,$sql,array("i",$order));
    }
    
} elseif ($bayType == 4) {
    $sql="SELECT ii.item_name AS item_id, b.quantity_per AS quantity, 0 AS shipped_quantity, 0 AS line_id, ii.width, ii.`length`, COALESCE(ii.powder_color,0) AS color  
    FROM items i, billofmaterial b, items ii, routing r 
    WHERE i.item_name=?
    AND ii.item_name NOT IN ('PPF')
    AND i.item_name=b.parent_item AND b.child_item = ii.item_name
    AND i.item_name=r.parent_part AND r.operation_id IN (3100)
    AND b.routing_id=r.routing_id";
    list($prs,$err)=runIQuery($db,$sql,array("s",$parentPart));
}

## even though I already have the line id of the parent, 
## the children will share that line id rather than have their own, and it's still needed to look up if any are already staged

?>