<?php

include('dbConnection.php');
include('security.php');
include('functions.php');
$order=$_GET['so'];
$which=$_GET['which'];

print "<table class='table table-bordered table-striped'>";
print "<thead><tr><th>Date</th><th>Who</th><th>Activity</th><th>Status</th></tr></thead>";
print "<tbody>";
if ($which=='viewed') {
    $sql="select distinct activity_date, who, activity, status_name from order_activity, order_status where order_id=? and status=status_id and activity = 'VIEWED' order by activity_date";
} else {
    print "<h4>Order Activity</h4>";
    $sql="select distinct activity_date, who, activity, status_name from order_activity, order_status where order_id=? 
    and status=status_id and activity != 'VIEWED' and not activity like 'PSACT:%' order by activity_date";
}
list($rs,$err)=runIQuery($db,$sql,array("i",$order));
foreach ($rs as $data) {
    if (strstr($data["activity"], "Changed Status from")) {
        $ft = explode(" to ", explode("from ", $data["activity"])[1]);
        if ($ft[0] == $ft[1]) continue;
    }
    print "<tr>
        <td>" . formatDateDBToWeb($data["activity_date"]) . "</td>
        <td>" . $data["who"] . "</td>
        <td>" . $data["activity"] . "</td>
        <td>" . $data["status_name"] . "</td>
    </tr>";
}
print "</tbody></table>";

if ($which != "viewed") {

    $sql = "select distinct activity_date, who, activity, status_name from order_activity, order_status 
    where order_id=? and status=status_id and activity like 'PSACT:%' order by activity_date";
    list($rs,$err)=runIQuery($db,$sql,["i",$order]);
    print "<h4>Packing Slip Activity</h4><table class='table table-bordered table-striped'>";
        print "<thead>
            <tr>
                <th>Date</th>
                <th>Who</th>
                <th>Activity</th>
                <th>Status</th>
            </tr>
        </thead><tbody>";

        foreach ($rs as $data) {
            $date = date("m/d/Y h:i a", strtotime($data["activity_date"]));
            $name = $data["who"];
            $activity = substr($data["activity"],6);
            $status = $data["status_name"];
            print "<tr>";
                print "<td>$date</td>";
                print "<td>$name</td>";
                print "<td>$activity</td>";
                print "<td>$status</td>";
            print "</tr>";
        }

        print "</tbody></table>";


    $sql = "select pr.end_time, pr.quantity_good, pr.duration_hours, pr.duration_minutes, j.job_id, e.first_name, e.last_name, ops.operation_name 
    from employees e, production_results pr, jobs j, order_lines ol, orders o, routing r, operations ops where pr.job_id=j.job_id 
    and j.line_id=ol.line_id and ol.order_id=o.order_id and e.employee_id=pr.employee_id and r.routing_id=pr.routing_id 
    and ops.operation_id=r.operation_id and o.order_id=? order by end_time";
    list($rs,$err) = runIQuery($db,$sql,["i",$order]);

    print "<h4>Job Activity</h4><table class='table table-bordered table-striped'>";
        print "<thead>
            <tr>
                <th>Date</th>
                <th>Who</th>
                <th>Activity</th>
            </tr>
        </thead><tbody>";

        foreach ($rs as $results) {
            $job      = $results["job_id"];
            $qtygood  = $results["quantity_good"];
            $dhours   = $results["duration_hours"];
            $dminutes = $results["duration_minutes"];
            $name     = $results["first_name"] . " " . $results["last_name"];
            $op       = $results["operation_name"];
            $date     = date("m/d/Y h:i a", strtotime($results["end_time"]));
            print "<tr>";
                print "<td>$date</td>";
                print "<td>$name</td>";
                print "<td>Spent $dhours hour(s) and $dminutes minute(s) on job $job operation $op with $qtygood made</td>";
            print "</tr>";
        }

    print "</tbody></table>";
}

if ($which != "viewed") {
    $sql="select pl.po_id, r.date_received,  rl.quantity_received, j.item_id, pl.description, j.job_id, u.full_name  from receipts r, receipt_lines rl, po_lines pl, ";
    $sql.=" jobs j, order_lines l, site_admins u where r.receipt_id=rl.receipt_id and  rl.line_id=pl.line_id and  pl.job_id=j.job_id and j.line_id=l.line_id ";
    $sql.=" and r.who_received=u.user_id and order_id=?";
    list($rs,$err)=runIQuery($db,$sql,array("i",$order));
    if (count($rs)>0) {
        print "<h4>Receiving Activity</h4>";
        print "<table class='table table-striped'><thead><tr><th>PO Number</th><th>Date Received</th><th>Quantity</th><th>Item</th><th>Description</th><th>WO</th><th>Who</th></tr></thead></tbody>";
    }
    foreach ($rs as $data) {
        print "<tr>
            <td>" . $data["po_id"] . "</td>
            <td>" . formatDateDBToWeb($data["date_received"]) . "</td>
            <td>" . $data["quantity_received"] . "</td>
            <td>" . $data["item_id"] . "</td>
            <td>" . $data["description"] . "</td>
            <td>" . $data["job_id"] . "</td>
            <td>" . $data["full_name"] . "</td>
        </tr>";
    }
    if (count($rs)>0) {
        print "</tbody></table>\n";
    }
}
if ($which !="viewed") {
    print "<h4>Email Activity</h4>";
    print "<table class='table table-bordered'><thead>
        <tr>
            <th>Sent Date</th>
            <th>Viewed Date</th>
            <th>Recipient</th>
            <th>Subject</th>
        </tr>
    </thead><tbody>";

    //Can we see who sent the email at all? If not should we log it? -Josh 05-02-2022
    $sql = "select distinct email_date, email_recipient, email_subject, viewed_date from email_log where email_type='SO' and document_number=?";
    list($rs,$err) = runIQuery($db, $sql, ["i",$order]);

    foreach ($rs as $log) {
        print "<tr>
            <td>" . $log["email_date"] . "</td>
            <td>" . $log["viewed_date"] . "</td>
            <td>" . $log["email_recipient"] . "</td>
            <td>" . $log["email_subject"] . "</td>
        </tr>";
    }
    print "</tbody></table>";

    print "<h4>Copy Order Activity</h4>";
    print "<table class='table table-bordered'><thead>
        <tr>
            <th>Old Order</th>
            <th>New Order</th>
            <th>Date Copied</th>
            <th>Who Copied</th>
        </tr>
    </thead><tbody>";
    $sql = "select old_order, new_order, date_copied, email from copy_order_log, site_admins where who_copied=user_id and (old_order=? or new_order=?)";
    list($rs,$err) = runIQuery($db, $sql, ["ii",$order,$order]);
    foreach ($rs as $log) {
        $isOld = false;
        if ($log["old_order"] == $order) {
            $isOld = true;
        }
        print "<tr>
            <td>" . $log["old_order"] . ($isOld ? " (Current Order)" : "") . "</td>
            <td>" . $log["new_order"] . ($isOld ? "" : " (Current Order)") . "</td>
            <td>" . $log["date_copied"] . "</td>
            <td>" . $log["email"] . "</td>
        </tr>";
    }
    print "</tbody></table>";
}