<?php
// include('dbConnection.php');
// include('security.php');
// include('functions.php');
// include('header.php');

## bdoss we have bay, order, bay type

if ($bayType == 1 ||  $bayType == 5) {  // staging and postpowder
    // -- 1 -- 
    // get parts in staging
   
    $sql = "SELECT sbc.item_id, SUM(sbc.quantity) AS staged_qty, (l.quantity - coalesce(l.shipped_quantity,0)) AS order_qty, business_unit 
    FROM staging_bay_contents AS sbc 
    INNER JOIN order_lines l ON sbc.line_id=l.line_id
    INNER JOIN staging_bays sb ON sb.bay_id=sbc.bay_id
    WHERE sbc.bay_id=?
    GROUP BY sbc.item_id";
    list($staged_rs,$err)=runIQuery($db,$sql,array("i",$bayID));

    // -- 1B -- 
    // get parts in other staging bays
   
    $sql = "SELECT sbc.item_id, SUM(sbc.quantity) AS staged_qty, (l.quantity - coalesce(l.shipped_quantity,0)) AS order_qty, sb.bay_name, business_unit 
    FROM staging_bay_contents AS sbc 
    INNER JOIN order_lines l ON sbc.line_id=l.line_id
    INNER JOIN staging_bays sb ON sb.bay_id=sbc.bay_id
    WHERE sb.bay_id<>? AND sb.order_id=?
    GROUP BY sbc.item_id";
    list($other_bays_rs,$err)=runIQuery($db,$sql,array("ii",$bayID,$order));

    // -- 2 --
    // get parts we're waiting on
    // leave out parts in staging_ignore

    $sql = "SELECT DISTINCT order_lines.item_id, (order_lines.quantity - COALESCE(shipped_quantity,0) - COALESCE( ( SELECT SUM(quantity) FROM staging_bay_contents WHERE staging_bay_contents.line_id=order_lines.line_id AND staging_bay_contents.item_id=order_lines.item_id),0)) AS waiting_qty
    FROM order_lines
    LEFT JOIN staging_ignore ON staging_ignore.part_number=order_lines.item_id
    WHERE order_id=? 
    AND order_lines.item_id NOT IN ('PPF')
    AND staging_ignore.part_number IS NULL
    GROUP BY item_id";
    list($waiting_rs,$err)=runIQuery($db,$sql,array("i",$order));

    // -- 3 --
    // get parts already shipped
    $sql = "SELECT item_id, shipped_quantity FROM order_lines WHERE order_id=? AND shipped_quantity > 0";
    list($shipped_rs,$err)=runIQuery($db,$sql,array("i",$order));

} elseif ($bayType == 2 || $bayType == 3 || $bayType == 4) { ## Weldment, Pre Powder, and Assembly
    // -- 1 -- 
    // get weldment parts in staging
    $sql="select job_id, business_unit from staging_bay_contents sbc,  staging_bays sb where sbc.bay_id=? and sbc.bay_id=sb.bay_id ";
    list($jobinfo,$err)=runIQuery($db,$sql,array("i",$bayID));
    if (count($jobinfo) > 0) {
        $jobNumber=$jobinfo[0][0];
        $bayBU=$jobinfo[0][1];
    }
    
    $sql = "SELECT sbc.item_id, SUM(sbc.quantity) AS staged_qty, j.quantity_scheduled * bom.quantity_per AS order_qty
    FROM staging_bay_contents sbc
    INNER JOIN jobs j on sbc.job_id=j.job_id 
    LEFT JOIN billofmaterial bom ON bom.child_item=sbc.item_id AND bom.parent_item=j.item_id
    WHERE sbc.bay_id=? 
    GROUP BY sbc.item_id";
    list($staged_rs,$err)=runIQuery($db,$sql,array("i",$bayID));

    if ((count($staged_rs) == 0) && $bayType == 3) {  ## it's an order line powder coat item and the job will be 0 in staging_bay_contents
        $sql = "SELECT sbc.item_id, SUM(sbc.quantity) AS staged_qty, (l.quantity - coalesce(l.shipped_quantity,0)) AS order_qty, business_unit 
        FROM staging_bay_contents AS sbc 
        INNER JOIN order_lines l ON sbc.line_id=l.line_id
        INNER JOIN staging_bays sb ON sb.bay_id=sbc.bay_id
        WHERE sbc.bay_id=?
        GROUP BY sbc.item_id";
        list($staged_rs,$err)=runIQuery($db,$sql,array("i",$bayID));
    }

     // -- 1B -- 
    // get parts in other staging bays
   
    if (isset($jobNumber) && $jobNumber > 0) {
        $sql = "SELECT sbc.item_id, SUM(sbc.quantity) AS staged_qty, j.quantity_scheduled AS order_qty, sb.bay_name, business_unit
        FROM staging_bay_contents AS sbc 
        INNER JOIN jobs j on sbc.job_id=j.job_id
        INNER JOIN staging_bays sb ON sb.bay_id=sbc.bay_id
        WHERE sb.bay_id<>? and sbc.job_id = ?
        GROUP BY sbc.item_id";
        list($other_bays_rs,$err)=runIQuery($db,$sql,array("ii",$bayID,$jobNumber));
    } else {
        $sql = "SELECT sbc.item_id, SUM(sbc.quantity) AS staged_qty, (l.quantity - coalesce(l.shipped_quantity,0)) AS order_qty, sb.bay_name, business_unit 
        FROM staging_bay_contents AS sbc 
        INNER JOIN order_lines l ON sbc.line_id=l.line_id
        INNER JOIN staging_bays sb ON sb.bay_id=sbc.bay_id
        WHERE sb.bay_id<>? AND sb.order_id=?
        GROUP BY sbc.item_id";
        list($other_bays_rs,$err)=runIQuery($db,$sql,array("ii",$bayID,$order));
    }
    
    // -- 2 --
    // get weldment parts we're waiting on
    // need to account for orders split between bays

    if ($bayType == 3 && (!isset($jobNumber) || $jobNumber==0)) {  ## finished good that goes into pre powder, below waiting won't apply to it
        $sql = "SELECT DISTINCT order_lines.item_id, (order_lines.quantity - COALESCE(shipped_quantity,0) - COALESCE( ( SELECT SUM(quantity) FROM staging_bay_contents WHERE staging_bay_contents.line_id=order_lines.line_id AND staging_bay_contents.item_id=order_lines.item_id),0)) AS waiting_qty
        FROM order_lines
        LEFT JOIN staging_ignore ON staging_ignore.part_number=order_lines.item_id
        WHERE order_id=? 
        AND order_lines.item_id NOT IN ('PPF')
        AND staging_ignore.part_number IS NULL
        GROUP BY item_id";
        list($waiting_rs,$err)=runIQuery($db,$sql,array("i",$order));
    } else {
        $sql=" SELECT DISTINCT b.child_item as item_id, b.quantity_per * j.quantity_scheduled -    
        COALESCE( ( SELECT SUM(quantity) FROM staging_bay_contents
            inner join jobs on staging_bay_contents.item_id=jobs.item_id
            and j.line_id=jobs.line_id    
            and jobs.item_id=b.child_item
            and staging_bay_contents.job_id=sbc.job_id  ## bdoss without this, it was counting duplicate staged parts that belonged to other jobs
        ),0)   AS waiting_qty
        from staging_bay_contents sbc 
        inner join  jobs j  on sbc.job_id=j.job_id 
        INNER JOIN billofmaterial b ON j.item_id=b.parent_item  ";
        if ($bayType == 2) {
            ## see if any of the various weldment operations
            $sql.=" INNER JOIN routing r on b.routing_id=r.routing_id and r.operation_id in (3081, 3091, 3099, 3108, 3134)  ";
        }
        // if ($bayType == 3) {  //expects billofmaterial.routing_id to be a powder operation, but not everything is included that is expected
        // ## see if in either powder application or line load - can't count on category
        //     $sql.=" INNER JOIN routing r on b.routing_id=r.routing_id and r.operation_id in (3116, 3138)  ";
        // }
        if ($bayType == 4) {
            ## see if in either powder application or line load - can't count on category
            $sql.=" INNER JOIN routing r on b.routing_id=r.routing_id and r.operation_id in (3100)  ";
        }
        $sql.="  LEFT JOIN staging_ignore ON staging_ignore.part_number=b.child_item
        where sbc.bay_id=? AND staging_ignore.part_number IS NULL AND b.child_item NOT IN ('PPF')";
        list($waiting_rs,$err)=runIQuery($db,$sql,array("i",$bayID));
    }
    
    // parts already shipped shouldn't apply to weldments - any exceptions that could be displayed here instead?
}

?>