<?php



function AddBusinessDays($currentDate, $numberDays, $holidays=array("01-01","1-1","12-25")) {

	date_default_timezone_set("America/Detroit");

	$begin=strtotime($currentDate);

	$inh=1;

	while ($inh and $numberDays) {

		$begin+=60*60*24;

		$inh=0;

		if (date('w',$begin)==0 or date('w',$begin)==6) {

			$inh=1;

		} else {

			$test=Date("m-d",$begin);

			// todo - get an array of holidays

			if (in_array($test,$holidays)) {

				$inh=1;

			} else {

				$numberDays--;

			}

		}

	}

	return Date("Y-m-d",$begin);

}



function SubtractBusinessDays($currentDate, $numberDays, $holidays=array("01-01","1-1","12-25","07-04")) {

	date_default_timezone_set("America/Detroit");

	$begin=strtotime($currentDate);

	$inh=1;

	while ($inh and $numberDays) {

		$begin-=60*60*24;

		$inh=0;

		if (date('w',$begin)==0 or date('w',$begin)==6) {

			$inh=1;

		} else {

			$test=Date("m-d",$begin);

			// todo - get an array of holidays

			if (in_array($test,$holidays)) {

				$inh=1;

			} else {

				$numberDays--;

			}

		}

	}

	return Date("Y-m-d",$begin);

}



function getEarliestDate($db,$job) {

	$sql="select min(schedule_date) as mindate from schedule, schedule_items where schedule.schedule_id=schedule_items.schedule_id and job_id=?";

	list($rs,$err)=runIQuery($db,$sql,array("i",$job));

	$data=$rs[0];

	print "mindate is $data['mindate']<BR>";

	return $data['mindate'];

}

function PushScheduleBack($db,$job,$workcenterID, $operationID, $sequence) {

	## this will push all scheduled items back one day, starting with the given workcentera

	## but will not push back if it is prior to the date.

	$sql="select * from schedule, schedule_items where workcenter_id=? and schedule.schedule_id=schedule_items.schedule_id and job_id=? and operation_id=? ";

	list($rs,$err)=runIQuery($db,$sql,array("iii",$workcenterID,$job,$operationID));

	$data=$rs[0];

	$testDate=SubtractBusinessDays($data['schedule_date'],1);

	print "psb - testdate $testDate<BR>";

	$oldSchedule=$data['schedule_id'];

	if ($testDate < Date("Y-m-d")) {

		$testDate=Date("Y-m-d");

	} 

	$sql="select schedule_id from schedule where workcenter_id=? and schedule_date=?";

	list($rs,$err)=runIQuery($db,$sql,array("is",$workcenterID,$testDate));	

	if (count($rs)==0) {

		$sql="insert into schedule (workcenter_id, schedule_date) values (?, ?) ";

		list($rs,$err)=runIQuery($db,$sql,array("is",$workcenterID,$testDate));

		$sql="select schedule_id from schedule where workcenter_id=? and schedule_date=?";

		list($rs,$err)=runIQuery($db,$sql,array("is",$workcenterID,$testDate));

	}

	$data=$rs[0];

	$scheduleID=$data['schedule_id'];

	if ($oldSchedule <> $scheduleID) {

		$sql="update schedule_items set schedule_id=? where job_id=? and schedule_id=? and operation_id=?";

		list($rs,$err)=runIQuery($db,$sql,array("iiii",$scheduleID,$job,$oldSchedule,$operationID));

		$sql="select routing.* from routing, jobs where job_id=? and item_id=parent_part order by display_sequence desc";

		list($rs,$err)=runIQuery($db,$sql,array("i",$job));

		$nextWorkCenter=0;

		$useNext=0;

		foreach ($rs as $data) {

			if ($useNext==1) {

				PushScheduleBack($db,$job,$data['workcenter_id'], $data['operation_id'], $data['display_sequence']);			

				$useNext=-1;			

			}

			if ($useNext==0) {

				if ($data['workcenter_id']==$workcenterID and $data['operation_id']=$operationID and $data['display_sequence']==$sequence) {

					$useNext=1;

				}

			}

		}		

	} else {

		print "ids matched<BR>";

	}

}



function addToAllocated($db,$parent,$qper, $txnlist,$item,$covered=0) {	

	$item=strtoupper($item);

	$parent=strtoupper($parent);

	$sql="select * from jobs where status=1 and item_id='$parent' and quantity_scheduled > coalesce(quantity_good,0)";

	$jrs=mysqli_query($db,$sql);

	print mysqli_error($db);

	$jc=0;

	while ($jdata=mysqli_fetch_array($jrs)) {

		$jc++;

		$qtytogo=$jdata['quantity_scheduled']-$jdata['quantity_good'];

		if ($qper==0) {

			$qper=1;

		}

		## have to multiply out by quantity per before subtracting covered amounts.

		$job=$jdata['job_id'];

		$qtytogo=$qtytogo*$qper;

		$newcovered=$covered-$qtytogo;		

		if ($newcovered < 0) {

			$newcovered=0;

		}

		$qtytogo-=$covered;

		if ($qtytogo > 0) {

			$alreadyThere=0;

			foreach ($txnlist as $txn) {

				if ($jdata['job_id'] == $txn['identifier']) {	

					if ($txn['type']=="ALLOCATED" and $txn['part_number']==$item) {

						$alreadyThere=1;

					}

				}

			}

			if (! $alreadyThere) {

				$txn=array();

				$txn['part_number']=$item;

				$txn['parent_part']=$parent;

				$txn['txndate']=$jdata['start_date'];

				$txn['description']=$jdata['description'];

				$txn['qtytogo']=abs($qtytogo)*-1;

				$txn['identifier']=$jdata['job_id'];

				$txn['type']='ALLOCATED';

				$txnlist[]=$txn;

			}

		}

		$covered=$newcovered;

	}	

	return $txnlist;

}





function logTransaction($dbI,$sql) {

	$sql=trim($sql);

	$fields=explode(" ",strtolower($sql));

	$table="";

	if ($fields[0]=='update') {

		$table=$fields[1];

	}

	if ($fields[0]=='delete') {

		$table=$fields[2];		

	}

	if ($fields[0]=='insert') {

		$table=$fields[2];		

	}

	if ($table) {

		$scriptid=$_SERVER['REQUEST_URI'];

		$user=$_SESSION['influxuser'];

		$tsql="insert into transaction_log (`who`, `when`, `script_name`, `table_name`, `sql_statement`) ";

		$tsql.=" values (?, NOW(), ?, ?, ?) ";

		$stmt=$dbI->prepare($tsql);

		$stmt->bind_param("ssss",$user,$scriptid,$table,$sql);

		$stmt->execute();	

		$stmt->close();		

	}

}





function isNumericField($ftype) {

	$retval=false;

	$ftype=strtolower($ftype);

	if (($ftype == 'n')  or (substr($ftype,0,3)=='int') or (substr($ftype,0,6)=='bigint')) {

		$retval=true;

	}

	if ($ftype=='currency') {

		$retval=true;

	}	

	return $retval;

}



function isDateField($ftype) {

	$retval=false;

	$ftype=strtolower($ftype);

	if ($ftype=='d') {

		$retval=true;

	}

	if ($ftype=='date') {

		$retval=true;

	}

	return $retval;

}



function dateDiff($start, $end) {



	$start_ts = strtotime($start);



	$end_ts = strtotime($end);



	$diff = $end_ts - $start_ts;



	return round($diff / 86400);



}



function time_diff_conv($start, $s) {

    $s = abs($s - $start);

	$days=floor($s/86400);

	$s -= ($days*86400);

	$hours=floor($s/3600);

	$s -= ($hours*3600);

	$minutes=floor($s/60);

	$s -= ($minutes*60);

	$seconds=$s;

	$string="";

	if ($days > 0) {

		if ($days > 1) {

			$string.=$days . " Days ";

		} else {

			$string.=$days . " Day ";

		}

	}

	if ($hours > 0) {

		if ($hours > 1) {

			$string.=$hours . " Hours ";

		} else {

			$string.=$hours . " Hour ";

		}

	}

	if ($minutes > 0) {

		if ($minutes > 1) {

			$string.=$minutes . " Minutes ";

		} else {

			$string.=$minutes . " Minute ";

		}

	}

	if ($seconds > 0) {

		if ($seconds > 1) {

			$string.=$seconds . " Seconds ";

		} else {

			$string.="1 Second";

		}

	}

    return $string;

}





function work_days_from_date($days, $date=NULL) 

{

    if(!$date)

    {

        $date = date('Y-m-d'); // if no date given, use todays date

    }



    if ($days < 0) {

		$forward=0;

		$days=$days*-1;

	} else {

		$forward=1;

	}

    while ($days != 0) 

    {

        $forward == 1 ? $day = strtotime($date.' +1 Weekday') : $day = strtotime($date.' -1 Weekday');

        $date = date('Y-m-d',$day);

	    ## todo: add holiday processing here

	    $days--;

    }

    return $date;

}



function formatDateWebtoDB($dval) {

	if (strtotime($dval)) {

		list($mo,$dy,$yr)=explode("/",$dval);

		$dval=$yr . "-";

		if (strlen($mo)<2) {

			$dval.="0";

		}

		$dval.=$mo . "-";

		if (strlen($dy)<2) {

			$dval.="0";

		}

		$dval.=$dy;

		return $dval;

	} else {

		return "0000-00-00";

	}

}

function formatDateOracletoDB($dval) {

	if (strtotime($dval)) {

		list($dy,$mo,$yr)=explode("-",$dval);

		$dval=$yr . "-";

		$mo=strtolower($mo);

		if ($mo=='jan') {

			$dval.="01";

		}

		if ($mo=='feb') {

			$dval.="02";

		}

		if ($mo=='mar') {

			$dval.="03";

		}

		if ($mo=='apr') {

			$dval.="04";

		}

		if ($mo=='may') {

			$dval.="05";

		}

		if ($mo=='jun') {

			$dval.="06";

		}

		if ($mo=='jul') {

			$dval.="07";

		}

		if ($mo=='aug') {

			$dval.="08";

		}

		if ($mo=='sep') {

			$dval.="09";

		}

		if ($mo=='oct') {

			$dval.="10";

		}

		if ($mo=='nov') {

			$dval.="11";

		}

		if ($mo=='dec') {

			$dval.="12";

		}

		$dval.="-";

		if (strlen($dy)<2) {

			$dval.="0";

		}

		$dval.=$dy;

		return $dval;

	} else {

		return "0000-00-00";

	}

}



function formatDateDBToWeb($dval) {	

	if ($dval=='0000-00-00') {

		return "";

} else {

		if (strstr($dval,"-")) {

			list($yr,$mo,$dy)=explode("-",$dval);

			$tm="";

			if (strstr($dy," ")) {

				list($dy,$tm)=explode(" ",$dy);

			}

			$dval="$mo/$dy/$yr$tm";

			if ($dval=='//') { $dval=''; }

			if ($dval=='//0') { $dval=''; }

			return $dval;

		} else {

			return "";

		}

	}

}

function FormatTime($tval) {

	list($hours,$minutes,$seconds)=explode(":",$tval);

	if ($hours < 12) {

		$tval=$hours . ":" . $minutes . " am";		

	} else {

		if ($hours > 12) {

			$hours-=12;

		}

		if (strlen($hours < 2)) {

			$hours="0" . $hours;

		}

		$tval=$hours . ":" . $minutes . " pm";

	}

	return $tval;

}





## 

/* This function will convert line breaks or other tags passed in the $tags variable

to linebreaks.  Multiple $tags must be separated by spaces, and must consist of the

regular tag text.  Ie. $result = br2nl($text_to_filter, "br p blockquote") */

function br2nl($text, $tags = "br")

{

 $tags = explode(" ", $tags);



 foreach($tags as $tag)

 { 	

 	$tag=strtolower($tag);

 	str_replace("<".strtoupper($tag),$tag,$text);

   $text=preg_replace('=<' . $tag . ' */?>=i', "\n", $text);

 }



 return($text);

}





function html2text($document){

    $search = array('@<script[^>]*?>.*?</script>@si',  // Strip out javascript

                   '@<[\/\!]*?[^<>]*?>@si',            // Strip out HTML tags

                   '@<style[^>]*?>.*?</style>@siU',    // Strip style tags properly

                   '@<![\s\S]*?--[ \t\n\r]*>@'         // Strip multi-line comments including CDATA

    );

    $text = preg_replace($search, '', $document);

    return $text;

}



    function get_display_size(DomNode $img)

    {

        $width = -1;

        $height = -1;



        if ($img->nodeName !== 'img')

        {

            return array($width, $height);

        }



        // See if there is aheight or width attribute in the tag itself.

        if (isset($img->attr['width']))

        {

            $width = $img->attr['width'];

        }



        if (isset($img->attr['height']))

        {

            $height = $img->attr['height'];

        }



        // Now look for an inline style.

        if (isset($img->attr['style']))

        {

            // Thanks to user gnarf from stackoverflow for this regular expression.

            $attributes = array();

            preg_match_all("/([\w-]+)\s*:\s*([^;]+)\s*;?/", $img->attr['style'], $matches, PREG_SET_ORDER);

            foreach ($matches as $match) {

              $attributes[$match[1]] = $match[2];

            }



            // If there is a width in the style attributes:

            if (isset($attributes['width']) && $width == -1)

            {

                // check that the last two characters are px (pixels)

                if (strtolower(substr($attributes['width'], -2)) == 'px')

                {

                    $proposed_width = substr($attributes['width'], 0, -2);

                    // Now make sure that it's an integer and not something stupid.

                    if (filter_var($proposed_width, FILTER_VALIDATE_INT))

                    {

                        $width = $proposed_width;

                    }

                }

            }



            // If there is a height in the style attributes:

            if (isset($attributes['height']) && $height == -1)

            {

                // check that the last two characters are px (pixels)

                if (strtolower(substr($attributes['height'], -2)) == 'px')

                {

                    $proposed_height = substr($attributes['height'], 0, -2);

                    // Now make sure that it's an integer and not something stupid.

                    if (filter_var($proposed_height, FILTER_VALIDATE_INT))

                    {

                        $height = $proposed_height;

                    }

                }

            }



        }



        // Future enhancement:

        // Look in the tag to see if there is a class or id specified that has a height or width attribute to it.



        // Far future enhancement

        // Look at all the parent tags of this image to see if they specify a class or id that has an img selector that specifies a height or width

        // Note that in this case, the class or id will have the img subselector for it to apply to the image.



        // ridiculously far future development

        // If the class or id is specified in a SEPARATE css file thats not on the page, go get it and do what we were just doing for the ones on the page.



        $result = array('height' => $height,

                        'width' => $width);

        return $result;

    }



function renderPanel($title="",$description="",$color="green",$width="span11",$icon="edit") {

	$retval.="<div class='portlet box $color $width' >";

	$retval.="	<div class='portlet-title'>";

	$retval.="		<div class='caption'><i class='icon-$icon'></i>$title</div>";

	$retval.="		<div style='display: none; float: right;' id='working'>&nbsp;&nbsp;&nbsp;<img src='img/loading.gif'></div>";

	$retval.="		<div class='tools'>";

	$retval.="			<a href='javascript:;' class='collapse'></a>";

	$retval.="		</div>";

	$retval.="	</div>";

	$retval.="	<div class='portlet-body form'>";

	$retval.="		<div class='tab-content'>";

	$retval.="			<div class='tab-pane active' id='portlet_tab1'>";

	return $retval;

}



function renderClosePanel($footer="") {

	$retval.= "			</div>\n";

    $retval.="			<div class='panel-footer'>\n";

    $retval.=$footer;

    $retval.="			</div>\n";

    $retval.='		</div>';

    $retval.='	</div>';

    $retval.='</div>';

    return $retval;

}



function renderHTML($showLabel,$fieldName,$table,$key,$id) {

	$retval=renderStartItem($showLabel,$fieldName,$title);

	$retval= "<button class='btn-success' onclick=\"window.open('showHTML.php?table=$table&field=$fieldName&key=$key&id=$id','preview');\" >Click To View</button>";

	$retval.=renderEndItem();

	return $retval;



}

function renderTextArea($showLabel,$fieldName,$currentValue,$title) {

	$retval="";

	$retval.="<div style='clear: both;'></div>";

	$retval=renderStartItem($showLabel,$fieldName,$title);

	$retval.= "<textarea class='wysihtml5 m-wrap span12' style='background-color: white;' name='$fieldName' id='$fieldName' rows='5' >";

	$retval.= stripslashes($currentValue);

	$retval.= "</textarea>\n";

	$retval.=renderEndItem();

	return $retval;	

}



function renderTextBox($showLabel,$fieldName,$currentValue,$title,$align="left") {

	$retval=renderStartItem($showLabel,$fieldName,$title);

	$retval.= "<input type='text' style='background-color: white; ";

	if ($align == 'right') {

		$retval.="text-align: right; ";

	}

	$retval.="' ";

	$retval.=" name='$fieldName' id='$fieldName' class='form-control'  value=\"";

	$retval.= htmlspecialchars(stripslashes($currentValue));

	if ($fieldName=='url')

	{

		$retval.= "\" onfocus=\"updateURL(this);";

	}

	$retval.= "\">";

	if ($fieldName=='email_address') {

		$retval.="<a href=\"javascript:testEmail($('#$fieldName').val(),'email');\"><button class='btn-primary' >Send Test</button></a>";

	}

	if ($fieldName=='text_address') {

		$retval.="<a href=\"javascript:testEmail($('#$fieldName').val(),'text');\"><button class='btn-primary' >Send Test</button></a>";

		$sql="select * from sms_domains order  by provider";

		$retval.="<select style=' background-color: white;' onchange='setTextAddress(this.value);'><option value=''>Select Cell Provider</option>";

		list($trs,$err)=runIQuery($db,$sql);

		foreach ($trs as $tdata) {

			$tdomain=$tdata['sms_domain'];

			$tname=$tdata['provider'];

			$retval.="<option value='$tdomain'>$tname</option>";

		}								

		$retval.="</select>";

	}

	$retval.=renderEndItem();

	return $retval;	

}



function renderPassword($showLabel,$fieldName,$currentValue,$title) {

	$retval=renderStartItem($showLabel,$fieldName,$title);

	$retval.= "<input class='form-control' style=' background-color: white;' type='text'  name='$fieldName' id='$fieldName' value='' placeholder='Password'>";

	$retval.= "<span class='help-block'>Enter new one to set, blank keeps existing.</span>";

	$retval.=renderEndItem();

	return $retval;	

}



function renderSelect($showLabel,$fieldName,$currentValue,$title,$fieldType,$optionList,$allowZero=0) {

	$retval=renderStartItem($showLabel,$fieldName,$title);

	$retval.= "<select class='form-control chosen-select'  id='$fieldName' name='$fieldName'   style='background-color: white;' ";

	if ($fieldName=='item_id') {

		$retval.=" onchange='changeItem(this.value);' ";

	}

	$retval.=">\n";

	$retval.=renderOptions($optionList,$currentValue,TRUE,FALSE);	 $retval.="</select>";

	$retval.=renderEndItem();

	return $retval;	

}



function renderStartItem($showLabel,$fieldName,$title,$width="span3") {

	$retval="<div class='$width'>\n";

	$retval.="<div class='control-group span11'>\n";

	$retval.="<label class='control-label' for='$fieldName'>";

	if ($showLabel) {

		$retval.= $title;

	}

	$retval.="</label>\n";

	$retval.="<div class='controls'>\n";

	return $retval;

}



function renderEndItem() {

	$retval.="\n</div>\n";

	$retval.="</div>\n";

	$retval.="</div>\n";

	return $retval;

}



function renderFile($showLabel,$fieldName,$currentValue,$title) {

	$retval=renderStartItem($showLabel,$fieldName,$title);

	$retval.= "<input type='file' name='$fieldName' id='$fieldName' >";

	$retval.=renderEndItem();

	return $retval;

}



function renderCheckBox($showLabel,$fieldName,$currentValue,$title) {

	$retval=renderStartItem($showLabel,$fieldName,$title);

	$retval.= "<input type=checkbox id='$fieldName' class='form-control' name='$fieldName'  value='1'  ";

	if ($currentValue) { $retval.= " checked "; } 

	$retval.= ">";

	$retval.=renderEndItem();

	return $retval;

}



function renderDateBox($showLabel,$fieldName,$currentValue,$title) {

	$retval=renderStartItem($showLabel,$fieldName,$title);

	$retval.= "<input style='background-color: white;' type='text' class='form-control datepicker' name='$fieldName' id='$fieldName' value='";

	if (formatDateDBtoWeb($currentValue)=="") {

		$retval.=$currentValue;

	} else {

		$retval.= formatDateDBtoWeb($currentValue);		

	}

	$retval.= "'>";

	$retval.=renderEndItem();

	return $retval;	

}



function renderTimePickerRaw($fieldName,$currentValue) {

    $retval="<div class='bootstrap-timepicker'><input id='$fieldName' name='$fieldName' type='text' value='$currentValue' class='form-control timepicker'/></div>";

    return $retval;

	

}

function renderTimePicker($showLabel,$fieldName,$currentValue,$title) {

	$retval=renderStartItem($showLabel,$fieldName,$title);

	$retval.=renderTimePickerRaw($fieldName,$currentValue);

	$retval.=renderEndItem();

	return $retval;	

}

              





function renderEdit($db,$table,$key,$id,$columns,$masterfield="",$masterkey="") {

	$retval="";

	$sql="select * from $table where $key=$id";

	$rs=mysqli_query($db,$sql);

	$data=mysqli_fetch_array($rs);

	$usingimage=0;

	$usingdoc=0;

	$usingpublished=0;

	$margin="";

	$rowUsed=0;	

	$gotItemList=0;

	foreach ($columns as $col)

	{

		$specialLookup="";

		$fnidx=$col['fn_idx'];

		$fieldName=$col['field_name'];

		if ($fieldName != $masterfield) {

			$default=$col['default_value'];

			if (substr($default,0,5)=='where') {

				$specialLookup=$default;

				$default="";

			}

			$default=str_replace("today()",Date('Y-m-d'),$default);

			$default=str_replace("startofmonth()",Date('Y') . "-" . Date("m") . "-01",$default);

			$default=str_replace("endofmonth()",Date('Y') . "-" . Date("m") . "-" . Date('t'),$default);

			$default=str_replace("currentUser()",$userID,$default);

			$size=$col['field_size'];

			$usingPX=false;

			if (strpos($size,"px")<0) {

				$fieldSetSize=$size*5;

				if ($fieldSetSize > 60) {

					$fieldSetSize=92;

				} else {

					if ($fieldSetSize > 48 ) {

						$fieldSetSize=48;

					}

				}

				$fieldSetSize.="%";

			} else {

				$usingPX=true;

				$fieldSetSize=$size;			

			}

			if ( $col['field_type']=='B') {

				$fieldSetSize="80";

			}

	 		if ($id!=0)

			{

				$default=$data[$fieldName];

			}

			$special_field=0;

			$margin="";

			if ($col['field_type']=='text' or $col['field_type']=='T') {



				$retval.="<div class='span6 '>\n";

				$retval.="<div class='control-group'>\n";

				$retval.="<label class='control-label' for='$fieldName'>";

				$rowUsed=0;

			} else {

				if (! $usingPX) {

					if ($rowUsed + $fieldSetSize+2 > 99) {

						if ($rowUsed+$fieldSetSize < 100) {

							$margin="";

							$rowUsed+=$fieldSetSize;

						} else  {

							## new line

							$margin="margin-right: 2%;";

							$rowUsed=$fieldSetSize+2;	

						}

					} else {

							$margin="margin-right: 2%;";

							$rowUsed+=$fieldSetSize+2;	

					}

				} else {

					$margin="margin-right: 2%;";

				}

				$retval.="<div class='span3 '>\n";

				$retval.="<div class='control-group'>\n";

				$retval.="<label class='control-label' for='$fieldName'>";

			}

			$retval.= $col['title'];

			$retval.="</label>\n";

		    $retval.="<div class='controls'>\n";

			if ($col['field_type']=='file')

			{

				$usingdoc=1;

				if ($id > 0) {

					$retval.= "<div id='docpreview' style='display: inline; float: right;'>";

					$retval.= "<BR><a href='javascript:viewDocument();'>View</a>";

					$retval.= "<br>Link: /viewDocument.php?document=$id";

					$retval.= "</div>";			

				} else {

					$retval.= "<div id='docpreview' style='display: none; float: right;'>";

					$retval.= "<BR><a href='javascript:viewDocument();'>View</a>";

					$retval.= "</div>";			

				}

				$retval.= "<input style='float: right;' type=file name='doc_file' id='doc_file' style='width: 92%;'>";

				$special_field=1;

			}

			if ($col['field_type']=='text')

			{

				$retval.= "<div style='position: relative; top: 20px;'><textarea style='background-color: white; 'id='$fieldName' name='$fieldName' class='wysihtml5 m-wrap span12' rows=20>";

				$retval.= stripslashes($data[$fieldName]);

				$retval.= "</textarea></div>";

				$special_field=1;

			}

			if ($fieldName=='child_item') {

				$itemlist=array();

				if (! $gotItemList) {

					$sql="select item_name from items where coalesce(under_review,0)=0 and status=1 order by item_name ";

					$irs=mysqli_query($db,$sql);

					while ($idata=mysqli_fetch_array($irs)) {

						$itemlist[]=$idata['item_name'];

					}		

					$itemcount=count($itemlist);

				}

				$retval.="<input type='text' id='$fieldName' name='$fieldName' data-provide=	'typeahead' data-min-length='2' autocomplete='off' data-items='15' data-source=\"" . str_replace('"','&quot;',json_encode($itemlist)) . "\" value=\"" . htmlspecialchars($data[$fieldName]) . "\" onchange='checkChildPartChanged();'>";

				$special_field=1;

			}

			if ($fieldName=='display_sequence' or $fieldName=='runseq') {

				if (! isset($data[$fieldName])) {

					$sql="select max($fieldName) as maxseq from $table where  $key=$id";

					$irs=mysqli_query($sql);

					$nextSeq=10;

					$idata=mysqli_fetch_array($irs);

					if ($idata['maxseq']) {

						$nextSeq=$idata['maxseq']+10;

					}

				} else {

					$nextSeq=$data[$fieldName];

				}

				$retval.="<input type='text' id='$fieldName' name='$fieldName'  value='$nextSeq'>";

				$special_field=1;

			}

			if ($col['lookup_table']!="" and ! $special_field)

			{

				if ($fieldName != 'lead_id') {

					$retval.= "<select id='$fieldName' name='$fieldName' style='width: 92%;' ";

					if ($fieldName=='item_id') {

						$retval.=" onchange='changeItem(this.value);' ";

					}

					$retval.=">\n";

					if ($col['allow_zero'])

					{

						if ($col['field_type']=='N') {

							$retval.= "<option value='0'>Not Selected</option>\n";

						} else {

							$retval.= "<option value=''>Not Selected</option>\n";

						}

					}

				}

				$lk=$col['lookup_table'];

				$rf=$col['return_field'];

				$lf=$col['lookup_field'];	

				if ($lf==$rf) {

					$sql="select distinct $rf from $lk ";

					$sql.=" order by $rf ";

					$crs=mysqli_query($db,$sql);

					if (mysqli_error($db)) {

						$retval.= "$sql<BR>" . mysqli_error($db);

					}

					while ($cdata=mysqli_fetch_array($crs))

					{

						$show=$cdata[0];

						$val=$cdata[0];

						if ($fieldName=='lead_id') {

							$retval.=$show;							

						} else {

							if ($val==$default)

							{

								$retval.= "<option selected='yes' value='$val'>$show</option>";

							}

							else {

								$retval.= "<option value='$val'>$show</option>";

							}

						}

					}

				} else {

					$sql="select distinct $lf, $rf from $lk ";

					if ($specialLookup) {

						$sql.=str_replace("?","'" . $masterkey . "'",$specialLookup);

					}	

					$sql.=" order by $rf ";

					$crs=mysqli_query($db,$sql);

					if (mysqli_error($db)) {

						print mysqli_error($db);

						print $sql . "<BR>";

					}

					while ($cdata=mysqli_fetch_array($crs))

					{

						$show=$cdata[1];

						$val=$cdata[0];

						if ($fieldName=='lead_id') {

							$retval.=$show;							

						} else {

							if ($val==$default)

							{

								$retval.= "<option selected='yes' value='$val'>$show</option>";

							}

							else {

								$retval.= "<option value='$val'>$show</option>";

							}

						}

					}

				}

				if ($fieldName!="lead_id") {

					$retval.= "</select>";

				}

				$special_field=1;

			}

			if ($col['field_type']=='N' and ! $special_field)

			{

				$retval.= "<input type='text'  style='text-align: right; width: 60%;' name='$fieldName' id='$fieldName' value='$default'>";

				$special_field=1;

			}

			if ($col['field_type']=='D' or $col['field_type']=='date')

			{

				$retval.= "<input type='text' name='$fieldName' id='$fieldName' style='width: 92%;' value='";

				$retval.= formatDateDBtoWeb($default);

				$retval.= "'>";

				$retval.= "<script>$('#$fieldName').datepicker();</script>\n";

				## add date picker

				$special_field=1;

			}

			if ($fieldName=='image_name' or $col['field_type']=='image')

			{

				$usingimage=1;

				$retval.= "<input type='text' style='display: inline;' name='$fieldName' id='$fieldName' onchange='removeSpaces(this);' value='";

				$retval.= $data[$fieldName];

				$retval.= "'>";

				$retval.= "<div id='preview' style='display: inline; float: right;'>";

				$testfile="../cms_images/" . $data[$fieldName] . ".png";

				$rand="?rand=" .rand();

				$retval.= "<a href='$testfile$rand' class='thumb'><img id='thumb' title='" . $data[$fieldName] . "' width='100px;' ";

				if (file_exists($testfile))

				{

					$retval.= "src='$testfile?rand=" . rand() . "'";

				}

				else {

					$retval.= "style='display: none;'";

				}

				$retval.= "></a></div>";

				$retval.= "<input style='float: right;' type=file name='image_file' id='image_file'>";

				$special_field=1;

			}

			if (! $special_field)

			{

				if ($fieldName=='published')

				{

					$usingpublished=1;

				}

				else {

					if ($col['field_type']=='T') {

						$retval.= "<textarea name='$fieldName' id='$fieldName' rows='15' class='wysihtml5 m-wrap span12' style='background-color: white; width: 92%;'>";

						$retval.= $data[$fieldName];

						$retval.= "</textarea>";					

					} else {

						$retval.= "<input type='text' name='$fieldName' id='$fieldName' style='width: 92%;' value=\"";

						$retval.= htmlspecialchars(stripslashes($data[$fieldName]));

						if ($fieldName=='url')

						{

							$retval.= "\" onfocus=\"updateURL(this);";

						}

						$retval.= "\">";

					}

				}

			}

			$retval.="\n</div><!-- control -->";

			$retval.="</div><!-- control group -->\n";

			$retval.="</div><!-- span3 -->\n";

		}

	}

	return array($retval,$usingimage,$usingdoc,$usingpublished,$margin,$rowUsed);

}

function renderOptions($result,$selectedValue,$renderEmpty = false,$showKey=false) {

	if ($renderEmpty) {

		$retval="<option value=0>Not Selected</option>";

	}

	while ($roData=mysqli_fetch_array($result)) {

		$key=$roData[0];

		$show=$roData[1];

		if ($key==$selectedValue) {

			$retval.="<option value='$key' selected>$show";

		} else {

			$retval.="<option value='$key'>$show";

		}

		if ($showKey) {

			$retval.="($key)";

		}

		$retval.="</option>";

	}

	return $retval;

}

function getSectionInfo($sectionName,$userID,$db) {

	$columns=array();

	$sql="select * from table_names where table_title='$sectionName'";

	$rs=mysqli_query($db,$sql);

	$data=mysqli_fetch_array($rs);

	$table=$data['table_name'];

	$key=$data['key_field'];

	$preview=$data['show_preview'];

	if (! $preview) {

		$preview=false;

	} else {

		$preview=true;

	}	

	$order=$data['default_order'];

	$sql="select field_names.* from field_names left outer join user_display_sequence on user_id=1 and tn_idx=fn_idx and sequence_type='field' where table_name='$table' ";

	$sql.=" and key_field=0 ";

	$sql.=" order by coalesce(user_display_sequence.display_sequence,999), field_names.display_sequence";

	$i=1;

	$rs=mysqli_query($db,$sql);

	if (mysqli_error($db)) {

		print "$sql<BR>";

		print mysqli_error();

	}

	while ($data=mysqli_fetch_array($rs)) {

		if ($data['field_name'] == $order) {

			$columns[0]=$data;

		} else {

			$columns[$i]=$data;

			$i++;

		}

	}

	return array($key,$table,$order,$columns,$preview);

}



function getFieldTitle($db,$table,$field) {

	$sql="select title from field_names where table_name='$table' and field_name='$field' ";

	$rs=mysqli_query($db,$sql);

	$data=mysqli_fetch_array($rs);

	return $data['title'];

}

function renderList($sectionName,$userID,$db,$tablesql,$renderSearch,$inline=false) {

	list($key,$table,$order,$columns,$showPreview)=getSectionInfo($sectionName,$userID,$db);

	$sql="select * from admin_access where user_id=$userID and table_name='$table' and allow_view=1";

	$rs=mysqli_query($db,$sql);

	$data=mysqli_fetch_array($rs);

	$allow_edit=$data['allow_edit'];

	$allow_delete=$data['allow_delete'];

	$allow_view=$data['allow_view'];

	$sql="select * from agents where user_id=$userID";

	$rs=mysqli_query($db,$sql);

	$data=mysqli_fetch_array($rs);

	$isAdmin=$data['is_admin'];

	$sql="select * from table_names where table_name='$table' ";

	$rs=mysqli_query($db,$sql);

	$data=mysqli_fetch_array($rs);

	$editpage=$data['special_edit_page'];

	if (! $editpage) {

		$editpage='index.php';

	}		

	$retval="";

	$dataRows=array();

	$hasSequence=0;

	$preview=0;

	$targetWindow="self";

	if (! $renderSearch) {

		$targetWindow="editRec";

	}

	foreach ($columns as $col)

	{

		if ($col['title']=='Display Sequence') {

			$hasSequence=1;

		}

		if ($col['field_type']=='text') {

			$preview=1;

		}

	}

	if (! $showPreview) {

		$preview=0;

	}				

	if ($allow_view) {

		$retval.="<article class='module width_full'>\n";

		$retval.="<header><h3 class='tabs_involved'>$sectionName</h3>\n";

		$retval.="<ul class='tabs'>\n";

		if ($renderSearch) {			

			$retval.="<li><a href='$editpage" . "?section=$sectionName&action=edit&id=0";

			if ($inline) {

				$retval.="&from=inline";

			} else {

				$retval.="&from=view";

			}

			$retval.="'>Add New</a></li>\n";

			if ($inline) {

				$retval.="<li><a href='index.php?section=$sectionName&action=view'>View List</a></li>\n";				} else {

				$retval.="<li><a href='index.php?section=$sectionName&action=inline'>Edit List</a></li>\n";							}

		} else {

			if ($inline) {

				$retval.="<li><a href='$editpage" . "?section=$sectionName&action=edit&id=0";

				if ($inline) {

					$retval.="&from=inline";

				} else {

					$retval.="&from=view";

				}

				$retval.="' target='_blank'>Add New</a></li>\n";

				if ($inline) {

					$retval.="<li><a href='index.php?section=$sectionName&action=view' target='_blank'>View List</a></li>\n";

				} else {

					$retval.="<li><a href='index.php?section=$sectionName&action=inline' target='_blank'>Edit List</a></li>\n";

				}

			}

		}

		if ($inline) {

			if ($hasSequence) {

				$retval.="<li><a href='reSequence.php?section=$sectionName&sql=$tablesql' target='_blank'>Sequence</a></li>\n";

			}

		}

		$retval.="</ul>\n";

		$retval.="</header>\n";

		$retval.="<div class='tab_container'>\n";

		$retval.="<div id='tab1' class='tab_content'>\n";

		$retval.="<table class='tablesorter' cellspacing='0'> \n";

		$retval.="<thead> \n";

		$retval.="<tr> \n";

		if ($preview) {

			$retval.="<th>Preview</th>\n";

		}

		$colcount=0;

		foreach ($columns as $col)

		{

			if ($colcount < 5 or $inline)

			{

				$retval.="<th>";		

				$retval.=$col['title'];

				$retval.="</th>\n";

				$colcount++;

			}

		}			

		if ($renderSearch or $inline) {

			$retval.="<th style='width: 120px;'>Actions</th> \n";

		}	

		$retval.="</tr>\n";

		if ($renderSearch) {			

			$retval.="<tr >\n";

			$colcount=0;

			foreach ($columns as $col)

			{

				if ($colcount < 5 or $inline)

				{

					$retval.="<td valign=top>";		

					if ($col['field_type']!='text' and $col['field_type']!='file') {

						$fieldName=$col['field_name'];

						$sql="select distinct $fieldName, $fieldName as show_value from $table order by $fieldName ";

						if ($col['lookup_table']!="") {

							$lk=$col['lookup_table'];

							$rf=$col['return_field'];

							$lf=$col['lookup_field'];	

							$sql="select distinct $lf, $rf from $lk ";

							$sql.=" order by $rf ";							

						}

						$rs=mysqli_query($db,$sql);

						if (mysqli_error($db)) {

							print "$sql<BR>" . mysqli_error($db);

						}

						$retval.="<select name='search_$fieldName' id='search_$fieldName' onchange='filterList();'>";

						$retval.="<option value=''>All</option>";

						$retval.=renderOptions($rs,"",false,false);

						$retval.="</select>";

						$retval.="<script>if (parseInt(document.getElementById('search_$fieldName').style.width) > 200) { document.getElementById('search_$fieldName').style.width='200px'; }</script>\n";

					} else {

						$retval.="<select name='search_$fieldName' id='search_$fieldName' disabled>";

						$retval.="<option value=''>----</option>";

						$retval.="</select>";

					}

					$retval.="</td>\n";

					$colcount++;

				}

			}				

			$retval.="<td>";

			if ($inline) {

				$retval.="<div onclick=\"addRecord('$table','$fieldName');\"><img src='images/icn_new_article.png' border='0' title='Add Record'></div>";

			}

			$retval.="&nbsp;</td>\n";

			$retval.="</tr>\n";

		}

		$retval.="</thead>\n";

		$retval.="<tbody>\n";

		$rs=mysqli_query($db,$tablesql);

		if (mysqli_error($db))

		{

			$retval.="$sql<BR>";

			$retval.=mysqli_error($db);

		}

		while ($data=mysqli_fetch_array($rs))

		{			

			$dataRows[]=$data;

			$keyval=$data[$key];

			$colcount=0;

			$retval.="<tr class='datarow' id='datarow$keyval'>";

			if ($preview) {

				$previewHTML="";

				foreach ($columns as $col) {

					$fieldName=$col['field_name'];

					if ($col['field_type']=='text') {

						$previewHTML.=$data[$fieldName];

					}

				}

				$retval.="<td valign='top'>";

				$retval.="<a href='#$table$keyval' class='sidebar-fullview' style='color: black; text-decoration: none;'>";

				$retval.="<div class='sidebar-preview' >";

				$retval.=$previewHTML;

				$retval.="</div>";

				$retval.="</a>";

				$retval.="<div style='display: none;'><div id='$table$keyval'>$previewHTML</div></div>";

				$retval.="</td>";

			}

			foreach ($columns as $col)

			{

				$special_field=0;

				$fieldName=$col['field_name'];

				if ($colcount < 5 or $inline)

				{

					$retval.="<td valign=top ";

					if ($col['field_type']=='N' and $col['lookup_table']=="") {					

						$retval.=" align='right' ";

					}

					if ($col['field_type']=='B') {

						$retval.=" align='center' ";

					}

					$retval.=">";

					if ($col['field_type']=='text')

					{

						$retval.=substr(strip_tags($data[$fieldName]),0,50) . "...";

						$special_field=1;

					}

					if ($col['lookup_table']!="")

					{

						$lk=$col['lookup_table'];

						$rf=$col['return_field'];

						$lf=$col['lookup_field'];

						if ($lf==$rf and ! $inline) {

							$retval.=$data[$fieldName];

						} else {

							if ($inline) {

								$retval.="<select onfocus=\"globalObj=this;oldvalue='" . $data[$fieldName] . "';\" onchange=\"updateRecord('$table','$fieldName','$key','$keyval',this.value);\">";

								$sql="select $lf, $rf from $lk order by $rf ";

								$lkrs=mysqli_query($db,$sql);

								if (mysqli_error($db)) {

									print "$sql<BR>" . mysqli_error($db);

								}

								$retval.=renderOptions($lkrs,$data[$fieldName]);

								$retval.="</select>";

								} else {

								$sql="select $lf, $rf from $lk where $lf='" . $data[$fieldName] . "' ";

								$crs=mysqli_query($db,$sql);

								$cdata=mysqli_fetch_array($crs);

								$retval.=$cdata[1];

								$lkpreview="";

								$sql="select table_title from table_names where table_name='$lk'";

								$lkrs=mysqli_query($db,$sql);

								$lkdata=mysqli_fetch_array($lkrs);

								list($lkkey,$lktable,$lkorder,$lkcolumns,$lkshowPreview)=getSectionInfo($lkdata['table_title'],$userID,$db);

								if ($lkshowPreview) {

									$sql="select * from $lk where $lf='" . $data[$fieldName] . "' ";

									$lkrs=mysqli_query($db,$sql);

									$lkdata=mysqli_fetch_array($lkrs);

									foreach ($lkcolumns as $lkcol) {

										$lkfieldName=$lkcol['field_name'];

										if ($lkcol['field_type']=='text') {

											$lkpreview.=$lkdata[$lkfieldName];

										}

									}

								}

								if ($lkpreview) {

									$retval.="<BR>";

									$retval.="<a href='#$table$keyval-$colcount' class='sidebar-fullview' style='color: black; text-decoration: none;'>";

									$retval.="<div class='sidebar-preview'  >";

									$retval.=$lkpreview;

									$retval.="</div>";

									$retval.="</a>";

									$retval.="<div style='display: none;'><div id='$table$keyval-$colcount'>$lkpreview</div></div>";

								}

							}

						}

						$special_field=1;

					}

					if ($col['field_type']=='B')

					{

						

						if ($inline) {

							$retval.="<div class='switch' data-on='success' data-off='danger'>";

							$retval.="<input class='toggle' type=checkbox ";

							if ($data[$fieldName]) {

								$retval.= " checked ";

							}

							$retval.= " onclick=\"updateRecord('$table','$fieldName','$key','$keyval',this.checked);\">";

							$retval.="</div>\n";

						} else { 

							if ($data[$fieldName])

							{

								$retval.="Y";

							}

							else {

								$retval.="N";

							}

						}

						$special_field=1;

					}

					if ($col['field_type']=='D' or $col['field_type']=='date')

					{

						if ($inline) {

							$retval.="<input type='text'  onfocus=\"globalObj=this;oldvalue='" . $data[$fieldName] . "';\" value='" . formatDateDBToWeb($data[$fieldName]) . "' size='10' class='date-picker' onchange=\"updateRecord('$table','$fieldName','$key','$keyval',this.value);\">";							

						} else {

							$retval.=formatDateDBToWeb($data[$fieldName]);

						}

						$special_field=1;

					}

					if (! $special_field)

					{

						if ($col['field_type']!='file') {

							if ($inline) {

							$size=$col['field_size'];

							if ($size > 15) {

								$size=15;

							}

								$retval.="<input type='text' value='" . $data[$fieldName] . "' size='$size' onfocus=\"globalObj=this;oldvalue='" . $data[$fieldName] . "';\" onchange=\"updateRecord('$table','$fieldName','$key','$keyval',this.value);\">";							

							} else {

								$retval.=$data[$fieldName];

							}

						}

					}

					$retval.="</td>";					

					$colcount++;

				}

			}	

			$icon="icn_edit";

			$alt="Edit";

			if (! $allow_edit)

			{

				$icon="icn_search";

				$alt="View";

			}

			if ($renderSearch or $inline) {				

				$retval.="<td valign='top'><div style='cursor: pointer; display: inline;' onclick=\"editRecord('$sectionName','$keyval','$targetWindow');\"><input border='0' type='image' src='images/$icon.png' title='$alt' alt='$alt'></div>";

				if ($inline and $allow_edit) {

					$retval.="<div style='cursor: pointer; display: inline;' onclick=\"copyRecord('$sectionName','$key','$keyval');\"><img src='images/icon_copy.png' border='0' title='Copy Record'> </div>";

				}

				if ($allow_delete)

				{

					$retval.="<div style='cursor: pointer; display: inline;' onclick=\"deleteRecord('$key','$table','$keyval');\"><input type='image' src='images/icn_trash.png' title='Delete' border='0'>";

				}

			}

			$retval.="</td></tr>\n";

		}

		$retval.="</tbody></table></div></div></article>\n";

	}

	return array($retval,$dataRows);

}





## this expects to return one record matching the key (uses default key field if nothing passed)



function getRecordData($db,$id,$table,$key="") {

	if ($key=="") {

		$sql="select key_field from table_names where table_name=?";

		list($rs,$err)=runIQuery($db,$sql,array("s",$table));

		$data=$rs[0];

		$key=$data[0];

	}

	$sql="select * from " . cleanText($table) . " where $key=?";

	list($rs,$err)=runIQuery($db,$sql,array("s",$id));

	return $rs[0];		

}



function getTableInfo($db,$table) {

	$sql="select * from table_names where table_name=?";

	list($rs,$err)=runIQuery($db,$sql,array("s",$table));

	return $rs[0];

}





function getOpenOrders($db,$forShipping=false,$startdate="",$enddate="",$customerID=0) {

	$sql="select * from orders where 1 > 0";

	if ($forShipping) {

		## shipped and cancelled 

		$sql.=" and status not in (4,5) ";

	} else {

		## complete, shipped, cancelled 

		$sql.=" and status not in (3,4,5) ";

	}

	if ($startdate) {

		$sql.=" and date_due >= '$startdate' ";

	}

	if ($enddate) {

		$sql.=" and date_due <= '$enddate' ";

	}

	if ($customerID) {

		$sql.=" and customer_id=$customerID";

	}

	$sql.=" order by date_due=curdate() desc, date_due desc, customer_id";	

	list($rs,$err)=runIQuery($db,$sql);

	return $rs;

} 



function showOneValue($sql,$db) {

	$rs=mysqli_query($db,$sql);

	$viewdata=mysqli_fetch_array($rs);

	return $viewdata[0];

}



function getItemData($db,$itemID) {

	$sql="select items.*, uom_name from items left outer join units_of_measure on unit_of_measure=uom_id where item_id=? or item_name=?";

	list($girs,$err)=runIQuery($db,$sql,array("ss",$itemID,$itemID));

	$gidata=$girs[0];

	return $gidata;

}



function getCustomerData($db,$customerID) {

	$sql="select * from customers where customer_id=?";

	list($girs,$err)=runIQuery($db,$sql,array("i",$customerID));

	$gidata=$girs[0];

	return $gidata;

}



function calculateDuration($db,$job) {

	$retval=1;

	## take all operations and add up their durations

	return $retval;

}



function addParents($db,$joblist,$jplist) {

	$newplist=array();

	foreach ($jplist as $child) {

		$sql="select parent_item, quantity_per from billofmaterial where child_item='$child'";

		$rs=mysqli_query($db,$sql);

		print mysqli_error($db);	

		while ($data=mysqli_fetch_array($rs)) {

			$pid=$data['parent_item'];

			if (! in_array($pid,$joblist)) {

				$newplist[]=$pid;

			}

		}

	}

	return $newplist;

}

function addToList($db,$itemlist,$processlist) {

	$newplist=array();

	$newqtylist=array();	

	foreach ($processlist as $child) {

		$sql="select child_item, quantity_per from billofmaterial where parent_item='$child'";

		$rs=mysqli_query($db,$sql);

		print mysqli_error($db);	

		while ($data=mysqli_fetch_array($rs)) {

			$pid=$data['child_item'];

			if (! in_array($pid,$itemlist) and ! in_array($pid,$newplist))

				$newqtylist[$pid]=$data['quantity_per'];

				$newplist[]=$pid;			

		}

	}

	return array($newqtylist,$newplist);

}





function inventoryUpdate($db,$itemID,$quantity,$scriptid,$reference,$userID,$location="",$bulk=FALSE,$job=0) {	

	## if this is a service, we do not receive inventory for it. 

	$sql="select item_type from items where item_id=?";

	list($trs,$terr)=runIQuery($db,$sql,array("i",$itemID));

	$tdata=$trs[0];

	## if job sent, then update quantity good.

	if ($job) {

		$sql="update jobs set quantity_good=coalesce(quantity_good,0)+$quantity where job_id=?";

		list($rs,$err)=runIQuery($db,$sql,array("i",$job));

	}

	if ($tdata['item_type']!='Service') {

		$sql="select item_name, default_location from items where item_id=?";

		list($rs,$err)=runIQuery($db,$sql,array("i",$itemID));	

		$data=$rs[0];

		$item_name=$data['item_name'];

		if (! $location) {

			$location=$data['default_location'];

		}

		if (! $location) {

			$location="1";

		}

		$sql="select location_id, quantity from item_locations where item_id=? and location_id=?";

		list($rs,$err)=runIQuery($db,$sql,array("ii",$itemID,$location));

		$data=$rs[0];

		$hasrec=0;

		if ($data['location_id']) {

			$hasrec=1;

		}

		$beforeQuantity=$data['quantity'];

		if (! $beforeQuantity) {

			$beforeQuantity=0;

		}

		if (! $hasrec ) {

			$sql="select location_id, quantity from item_locations where item_id=? and location_id=?";

			list($rs,$err)=runIQuery($db,$sql,array("ii",$itemID,$location));

			$data=$rs[0];

			if ($data['location_id']) {

				$hasrec=1;

				$location=$data['location_id'];

			}

		}

		$newQuantity=$beforeQuantity + $quantity;

		$sql="insert into inventory_transactions (tx_date, script_name, user_id, location, prior_quantity, quantity, reference,item_name) values (sysdate(), ?, ?, ?, ?, ?, ?, ?) ";

		list($rs,$err)=runIQuery($db,$sql,array("siiddss",$scriptid,$userID,$location,$beforeQuantity,$quantity,$reference,$item_name));

		if ($hasrec) {

			if ($quantity < 0) {

				$sql="update item_locations set quantity = quantity  $quantity where item_id=? and location_id=?";		

			} else {

				$sql="update item_locations set quantity = quantity + $quantity where item_id=? and location_id=?";

			}

			list($rs,$err)=runIQuery($db,$sql,array("ii",$itemID,$location));

		} else {

			## create entry even if negative

			$sql="insert into item_locations (item_id, location_id, quantity, available) values (?,?,?,1)";

			list($rs,$err)=runIQuery($db,$sql,array("iid",$itemID,$location,$quantity));

		}

		## update quantity on hand for part master now

		## for now, update all qoh - skinny down to just this item if performance is an issue.

		if (! $bulk) {

			$sql="update items i inner join (select item_id, sum(quantity) 'qoh' from item_locations group by item_id) l on i.item_id=l.item_id set i.quantity_on_hand=l.qoh ";

			list($rs,$err)=runIQuery($db,$sql);

		}

	}

}



function inventoryTransfer($db,$itemID,$fromLocation,$toLocation,$quantity,$scriptid,$reference,$userID) {

	$fromQuantity=$quantity * -1;

	inventoryUpdate($db,$itemID,$fromQuantity,$scriptid,$reference,$userID,$fromLocation);

	inventoryUpdate($db,$itemID,$quantity,$scriptid,$reference,$userID,$toLocation);

}



function renderReportRow($fieldList,$i,$db,$table="",$field="",$operation="",$condition="") {

	print "<tr>";

	print "<td valign='top'>";

	print "<i class='icon-trash' onclick=\"deleteCondition('$i');\"></i>";

	print "</td>";

	print "<td valign='top'>";

	print "<select id='crit$i' name='crit$i' onchange=\"setValueType('$i');\" style='width: 200px;'>";

	print "<option value=''></option>";

	reset($fieldList);

	$holdTable="";

	foreach ($fieldList as $data) {

		$fname=$data['field_name'];

		$tbl=$data['table_name'];

		if ($tbl != $holdTable) {

			print "<option value=''>-- Fields from Module " . ucwords($tbl) . " --</option>";

			$holdTable=$tbl;

		}

		$ttl=$data['title'];

		if ($fname==$field and $tbl==$table) {

			print "<option selected value='$tbl.$fname'>$ttl</option>";

		} else {

			print "<option value='$tbl.$fname'>$ttl</option>";

		}

	}

	$sql="select *  from custom_fields where table_name =? or field_name=? order by title";

	list($fieldList,$err)=runIQuery($db,$sql,array("ss",$table,$field));

	$written=0;

	foreach ($fieldList as $data) {

		if (! $written) {

			print "<option value=''>-- Calculated Fields --</option>";

			$written=1;

		}

		$fname=$data['field_name'];

		$ttl=$data['title'];

		if ($fname==$field) {

			print "<option value='custom.$fname' selected >$ttl</option>";			

		} else {

			print "<option value='custom.$fname'>$ttl</option>";

		}

	}

	print "</select>";

	print "</td>";

	print "<td valign='top'>";

	print "<select name='operation$i' id='operation$i'>";

	print "<option value='eq' ";

	if ($operation=='eq') {

	print " selected ";

	}

	print ">Equal</option>";

	print "<option value='ne' ";

	if ($operation=='ne') {

	print " selected ";

	}

	print ">Not Equal</option>";

	print "<option value='contains' ";

	if ($operation=='contains') {

		print " selected ";

	}

	print ">Contains</option>";

	print "<option value='ge' ";

	if ($operation=='ge') {

		print " selected ";

	}

	print ">Greater Than or Equal</option>";

	print "<option value='le' ";

	if ($operation=='le') {

		print " selected ";

	}

	print ">Less Than or Equal</option>";

	print "<option value='starts' ";

	if ($operation=='starts') {

		print " selected ";

	}

	print ">Starts With</option>";

	print "<option value='ends' ";

	if ($operation=='ends') {

		print " selected ";

	}

	print ">Ends With</option>";

	print "</select>";

	print "</td>";

	print "<td valign='top'><div id='conditionWrapper$i'>";

	$sql="select field_type, title from field_names where table_name=? and field_name=?";

	list($frs,$err)=runIQuery($db,$sql,array("ss",$table,$field));

	$fdata=$frs[0];

	$ftype=$fdata['field_type'];

	$ttl=$fdata['title'];

	print renderField($db,$i,$table,$ttl,$condition,$isAdmin);

	print "</div></td>";

	print "</td>";

	print "</tr>\n";

}





# if search text, render the search

function renderSearch($db,$searchText,$table) {

	$sql="select * from field_names where table_name=?";

	list($frs,$err)=runIQuery($db,$sql,array("s",$table));	

	$retval=" ( ";

	$comma="";

	foreach ($frs as $fdata) {

		$fname=$fdata['field_name'];

		$ftype=$fdata['field_type'];

		$lkup=$fdata['lookup_table'];

		$lfld=$fdata['lookup_field'];

		$rfld=$fdata['return_field'];

		if (strstr(strtolower($rfld)," as ")) {

			list($rfld, $alias) = explode(" as ",strtolower($rfld));

		}

		if ($ftype != 'B' and $ftype!='blob') {

			if ($lkup) {

				$retval.=$comma;

				$retval.=" $table.$fname in (select $lfld from $lkup where $rfld like '%$searchText%') ";

				$comma=" or ";			

			} else {

				if (isNumericField($ftype)) {

					if (is_numeric($searchText)) {

						$retval.=$comma;

						$retval.=" $table.$fname = $searchText ";

						$comma=" or ";							

					}

				} else {

					if ($ftype=='D' or $ftype=='date') {

						if (formatDateWebToDB($searchText)!='0000-00-00') {

							$retval.=$comma;

							$retval.=" DATE_FORMAT($table.$fname,'%Y-%m-%d') =  '" . formatDateWebToDB($searchText) . "' ";

							$comma=" or ";

						}

					} else {

						$retval.=$comma;

						$retval.=" $table.$fname like  '%$searchText%' ";

						$comma=" or ";

					}

				}

			}			

		}	

	}

	if ($table == 'orders') {

		$retval .= $comma;

		$retval.=" orders.order_id in (select order_id from order_lines where item_id like '%$searchText%' or item_description like '%$searchText%') ";

	}

	if ($table == 'transfers') {

		$retval.= $comma;

		$retval.= " transfers.packing_slip in (select packing_slip from transfer_lines where part_number like '%$searchText%' ) ";

	}

	$retval.=") ";

	return $retval;

}



## render the conditions to display only the records that match this filter

## calling program is expected to know to put the where or and in front of the returned string



function renderFilter($db,$filterID) {	

	$retval=" 1 > 0 "; ## no conditions, match all;

	$sql="select * from filters where filter_id=?";

	list($rs,$err)=runIQuery($db,$sql,array("i",$filterID));

	$data=$rs[0];

	$matchAll=$data['match_all'];

	$table=$data['table_name'];

	$sql="select * from filter_conditions where filter_id=?";

	list($rs,$err)=runIQuery($db,$sql,array("i",$filterID));

	if (count($rs)) {

		$retval=" ( ";

		$sep="";

		foreach ($rs as $data) {

			$title=$data['field_name'];

			$op=$data['operation'];

			$condition=$data['condition'];

			$sql="select field_name from field_names where table_name=? and title=?";

			list($frs,$ferr)=runIQuery($db,$sql,array("ss",$table,$title));

			$fdata=$frs[0];

			$retval.=$sep;

			if ($matchAll) {

				$sep=" and ";

			} else {

				$sep = " or ";

			}

			$retval.="`" . $fdata[0] . "`";

			if ($op == "eq") {

				$retval.=" = '";

			}

			if ($op == "contains") {

				$retval.=" like '%";

			}

			if ($op == "ge") {

				$retval.=" >= '";

			}

			if ($op == "le") {

				$retval.=" <= '";

			}

			if ($op == "starts") {

				$retval.=" like '";

			}

			if ($op == "ends") {

				$retval.=" like '%";

			}

			$retval.=$condition;

			if ($op == "eq" or $op == "ge" or $op == "le" or $op == "ends") {

				$retval.="' ";

			}

			if ($op == "contains" or $op == "starts") {

				$retval.="%' ";

			}

		}

		$retval.=" )";	

	}

	return $retval;

}



function renderFilterRow($fieldList,$i,$table,$db,$field="",$operation="",$condition="",$isAdmin=0) {

	print "<tr>";

	print "<td valign='top'>";

	print "<i class='icon-trash' onclick=\"deleteCondition('$i');\"></i>";

	print "</td>";

	print "<td valign='top'>";

	print "<select id='crit$i' name='crit$i' onchange=\"setValueType('$i');\">";

	print "<option value=''></option>";

	reset($fieldList);

	foreach ($fieldList as $data) {

		$fname=$data['field_name'];

		$ttl=$data['title'];

		if ($ttl==$field) {

			print "<option selected value='$ttl'>$ttl</option>";

		} else {

			print "<option value='$ttl'>$ttl</option>";

		}

	}

	print "</select>";

	print "</td>";

	print "<td valign='top'>";

	print "<select name='operation$i' id='operation$i'>";

	print "<option value='eq' ";

	if ($operation=='eq') {

	print " selected ";

	}

	print ">Equal</option>";

	print "<option value='ne' ";

	if ($operation=='ne') {

	print " selected ";

	}

	print ">Not Equal</option>";

	print "<option value='contains' ";

	if ($operation=='contains') {

		print " selected ";

	}

	print ">Contains</option>";

	print "<option value='ge' ";

	if ($operation=='ge') {

		print " selected ";

	}

	print ">Greater Than or Equal</option>";

	print "<option value='le' ";

	if ($operation=='le') {

		print " selected ";

	}

	print ">Less Than or Equal</option>";

	print "<option value='starts' ";

	if ($operation=='starts') {

		print " selected ";

	}

	print ">Starts With</option>";

	print "<option value='ends' ";

	if ($operation=='ends') {

		print " selected ";

	}

	print ">Ends With</option>";

	print "</select>";

	print "</td>";

	print "<td valign='top'><div id='conditionWrapper$i'>";

	print renderField($db,$i,$table,$field,$condition,$isAdmin);

	print "</div></td>";

	$sql="select field_type from field_names where table_name=? and title=?";

	list($frs,$err)=runIQuery($db,$sql,array("ss",$table,$field));

	$fdata=$frs[0];

	print "</div>";

	print "</td>";

	print "</tr>\n";

}



function renderOperation($op,$cond) {

	$retval="";

	if ($op=="eq") {

		$retval.="='$cond'";

	}

	if ($op=="ne") {

		$retval.="!='$cond'";

	}

	#ends contains le ge eq 

	if ($op=="starts") {

		$retval.=" like '$cond%' ";

	}

	if ($op=="ends") {

		$retval.=" like '%$cond' ";

	}

	if ($op=="contains") {

		$retval.=" like '%$cond%' ";

	}

	if ($op=="le") {

		$retval.=" <= '$cond' ";

	}

	if ($op=="ge") {

		$retval.=" >= '$cond' ";

	}

	return $retval;

}

function renderEditForm($db,$fieldList,$recordData,$cols=2,$isAdmin=0,$userID=0,$key="",$id=0,$otherfield="",$tabList=array()) {

	$retval="";

	$coloridx=0;

	$colors=array("green","blue","red","yellow","purple","grey","black");

	if (count($tabList)) {

		foreach ($tabList as $tab) {

			$retval.=renderEditFields($db,$fieldList,$recordData,$cols,$isAdmin,$userID,$key,$id,$otherfield,$tab,$colors[$coloridx]);

			$coloridx++;

			if ($coloridx  > 6) {

				$coloridx=0;

			}

		}

	} else {

		$retval.=renderEditFields($db,$fieldList,$recordData,$cols,$isAdmin,$userID,$key,$id,$otherfield);

	}

	return $retval;

}



function renderEditFields($db,$fieldList,$recordData,$cols=2,$isAdmin=0,$userID=0,$key="",$id=0,$otherfield="",$tab="",$color="green") {

	$toggle=0;	

	$retval="";

	$retval.="<div class='row-fluid' >\n<div class='span12' >\n";

	$retval.="<div class='portlet box $color' >\n";

	$retval.="<div class='portlet-title'>\n";

	$retval.="<div class='caption'>";

	if ($tab) {

		$retval.=ucwords(strtolower($tab));

	}

	$retval.="</div>\n";

	$retval.="<div class='tools'><a href='javascript:;' class='collapse'></a></div>\n";

	$retval.="</div>\n";

	$retval.="<div class='portlet-body' style='background-color: #dddddd;'>\n";

	foreach ($fieldList as $data) {	

		$title=$data['title'];

		$table=$data['table_name'];

		$fieldName=$data['field_name'];

		if ($tab) {

			$okToUse=0;

			$sql="select * from field_tabs, table_tabs, field_names where tab_name=? and table_tabs.tt_idx=field_tabs.tt_idx and field_tabs.fn_idx=field_names.fn_idx and field_names.field_name=? ";

			list($rs,$err)=runIQuery($db,$sql,array("ss",$tab,$fieldName));

			$okToUse=count($rs);

		} else {

			$okToUse=1;

		}

		if ($fieldName=='is_admin' and ! $isAdmin) {

			$okToUse=0;

		}

		if ($fieldName=='lead_admin' and ! $isAdmin) {

			$okToUse=0;

		}

		if ($fieldName=='disabled' and ! $isAdmin) {

			$okToUse=0;

		}

		if ($okToUse) {

			$fieldType=$data['field_type'];

			$fieldSize=$data['field_size'];

			$lookupTable=$data['lookup_table'];

			$lookupField=$data['lookup_field'];

			$returnField=$data['return_field'];

			$defaultValue=$data['default_value'];

			$readOnly=$data['readonly'];

			$allowZero=$data['allow_zero'];

			$readOnly=$data['readonly'];

			$autoComplete=$data['autocomplete'];

			if ($fieldName != $key and $fieldName != $otherfield ) {

				if ($toggle==0) {

					$retval.= "<div class='row-fluid' >";

				}

				if ($fieldType=='text') {

					$retval.="<div class='span8'>";

				} else {

					$retval.="<div class='span4'>";

				}

				$retval.= "<div class='control-group'><label class='control-label' for='$fieldName'>$title:</label>";

				$retval.= "<div class='controls'>";

				if (substr($defaultValue,0,5)=='where') {

					$specialLookup=$defaultValue;

					$defaultValue="";

				}

				$defaultValue=str_replace("today()",Date('Y-m-d'),$defaultValue);

				$defaultValue=str_replace("startofmonth()",Date('Y') . "-" . Date("m") . "-01",$defaultValue);

				$defaultValue=str_replace("endofmonth()",Date('Y') . "-" . Date("m") . "-" . Date('t'),$defaultValue);

				$defaultValue=str_replace("currentUser()",$userID,$defaultValue);

				if (! $id) {

					$recordData[$fieldName]=$defaultValue;

				}

				$special_field=0;

				if ($fieldType=='file')

				{

					$usingdoc=1;

					if ($id > 0) {

						$retval.= "<div id='docpreview' style='display: inline; float: right;'>";

						$retval.= "<BR><a href='javascript:viewDocument();'>View</a>";

						$retval.= "<br>Link: /viewDocument.php?document=$id";

						$retval.= "</div>";			

					} else {

						$retval.= "<div id='docpreview' style='display: none; float: right;'>";

						$retval.= "<BR><a href='javascript:viewDocument();'>View</a>";

						$retval.= "</div>";			

					}

					$retval.= "<input  float: right;' type=file name='doc_file' id='doc_file' style='width: 92%;'>";

					$special_field=1;

				}

				if ($fieldType=='text') {

					$retval.= "<textarea class='m-wrap span12 wysihtml5 ' name='$fieldName' id='$fieldName' rows='5' style='background-color: white;'   >";

					$retval.= stripslashes($recordData[$fieldName]);

					$retval.= "</textarea>\n";

				}

				if ($lookupTable!="") {

					if ($autoComplete)  {

						

					} else {

						if (strstr($returnField," as ")) {

							list($seq,$rest)=explode(" as ",$returnField);

						} else {

							$seq=$returnField;

						}

						$sql="select $lookupField, $returnField from $lookupTable ";

						if ($lookupTable=='status_types') {

							if (! $isAdmin ) {

								$sql.=" where coalesce(admin_only,0)=0 ";

							}

						}

						if ($lookupTable == 'agents') {

							if (! $isAdmin) {

								$sql.=" where agent_id=$userID";

							}

						}

						$sql.=" order by $seq ";						

						$rs=mysqli_query($db,$sql);

						if (mysqli_error($db)) {

							$retval.= "$sql<BR>";

							$retval.= mysql_error($db);

						}

						if ($fieldName == 'lead_id' or $fieldName=='client_id') {

							while ($rdata=mysqli_fetch_array($rs)) {

								if ($rdata[$fieldName]==$recordData[$fieldName]) {

									$retval.= $rdata[$returnField];

								}

							}

						} else {

							$retval.= "<select class='m-wrap span12'  id='$fieldName' name='$fieldName' ";

							if ($readOnly) {

								$retval.=" disabled ";

							}

							$retval.=" style='background-color: white;' >";

							$retval.= renderOptions($rs,$recordData[$fieldName],$allowZero,false);

							$retval.= "</select>";

						}

					}

				} else {

					if ($fieldType=="D" or $fieldType=="date") {

						$datePickers[]=$fieldName;

						$retval.= "<input style=' background-color: white;' class='datepicker m-wrap' type='text' name='$fieldName' id='$fieldName' value='" . formatDateDBToWeb($recordData[$fieldName]) . "'  >";

					}

					if ($fieldType=='B')

					{

						$retval.= "<div class='switch'  data-on='success' data-off='danger' style='width: 200px;'>";

						$retval.= "<input type=checkbox id='$fieldName'  name='$fieldName' class='toggle' value='1'  ";

						if ($recordData[$fieldName]) { $retval.= " checked "; } 

						$retval.= ">";

						$retval.= "</div>";

					}

					if ($fieldType=="N" or $fieldType=="C") {

						if ($fieldName=="password") {

							$retval.= "Password:<BR><input class='m-wrap' style=' background-color: white;' type='text'  name='$fieldName' id='$fieldName' value='' placeholder='Password'>";

							$retval.= "<span class='help-block'>Enter new one to set, blank keeps existing.</span>";

						} else {

							$retval.= "<input style=' background-color: white;' class='m-wrap' type='text'  name='$fieldName' id='$fieldName' value='" . $recordData[$fieldName] . "'  >";							

							if ($fieldName=='email_address') {

								$retval.="<a href=\"javascript:testEmail($('#$fieldName').val(),'email');\"><button class='btn blue' >Send Test</button></a>";

							}

							if ($fieldName=='text_address') {

								$retval.="<a href=\"javascript:testEmail($('#$fieldName').val(),'text');\"><button class='btn blue' >Send Test</button></a>";

								$sql="select * from sms_domains order  by provider";

								$retval.="<select style=' background-color: white;' onchange='setTextAddress(this.value);'><option value=''>Select Cell Provider</option>";

								list($trs,$err)=runIQuery($db,$sql);

								foreach ($trs as $tdata) {

									$tdomain=$tdata['sms_domain'];

									$tname=$tdata['provider'];

									$retval.="<option value='$tdomain'>$tname</option>";

								}								

								$retval.="</select>";

							}

						}

					}

					if ($fieldType=="html") {

						$retval.= "<button class='btn green' onclick=\"window.open('showHTML.php?table=$table&field=$fieldName&key=$key&id=$id','preview');\" >Click To View</button>";



					}

				}

				$retval.= "</div></div></div>";

				$toggle++;

				if ($toggle==$cols) {

					$retval.= "</div>\n";

					$toggle=0;

				}

			}

		}

	}

	if ($toggle) {

		$retval.="</div>\n";

	}

	$retval.="</div>\n";

	$retval.="</div>\n";

	$retval.="</div>\n";

	return $retval;

}

function renderField($db,$idx,$table,$field,$currentValue="",$isAdmin=0) {

	$retval="";

	$written=false;

	if ($field!="") {

		$sql="select * from field_names where table_name=? and title=?";

		list($frs,$err)=runIQuery($db,$sql,array("ss",$table,$field));

		$fdata=$frs[0];

		$ftype=$fdata['field_type'];

		$lookupTable=$fdata['lookup_table'];

		$lookupField=$fdata['lookup_field'];

		$returnField=$fdata['return_field'];

		$autoComplete=$data['autocomplete'];

		if ($ftype=='B') {

			$retval.="<div class='switch'  data-on='success' data-off='danger'><input class='toggle' type='checkbox'  id='condition$idx' value=1 ";

			if ($currentValue) {

				$retval.=" checked ";

			}

			$retval.="></div>";

			$written=true;

		}	

		if ($lookupTable!= "") {

			if ($autoComplete) {

				

			} else {

				if (strstr($returnField," as ")) {

					list($seq,$rest)=explode(" as ",$returnField);

				} else {

					$seq=$returnField;

				}

				$sql="select $lookupField, $returnField from $lookupTable ";

				if ($lookupTable=='status_types') {

					if (! $isAdmin ) {

						$sql.=" where coalesce(admin_only,0)=0 ";

					}

				}

				$sql.=" order by $seq ";						

				$rs=mysqli_query($db,$sql);

				if (mysqli_error($db)) {

					print "$sql<BR>";

					print mysql_error($db);

				}

				$retval.="<select id='condition$idx' name='condition$idx' style='border: 0px solid black;' onclick=\"this.style.border='1px solid black;';\"  onchange=\"this.style.border='1px solid black;';changeField('$table','$key','$id','$fieldName',this.value);\" >";

				$retval.=renderOptions($rs,$currentValue,true,false);

				$retval.="</select>";				

				$written=true;

			}					

		}

	}

	if (! $written) {

		if ($ftype=='D' or $ftype=='date') {

			$retval.="<input id='condition$idx' name='condition$idx' class='m-wrap m-ctrl-medium date-picker' readonly size='16' type='text' value='$currentValue' /><span class='add-on'><i class='icon-calendar'></i></span>";

			$retval.="\n<script>$('#condition$idx').datepicker();</script>\n";

		} else {

			$retval.="<input type='text' id='condition$idx' size=20 name='condition$idx' value='$currentValue'>";			}

	

	}

	return $retval;

}



function postChangeMessage($db,$table,$id,$user,$assignTo) {

	if ($table=='customers') {

		$sql="select name from customers where customer_id=?";

		list($rs,$err)=runIQuery($db,$sql,array("i",$id));

		$data=$rs[0];

		$id=$data[0];

		$table="Customer ";

	}

	if ($table=='items') {

		$sql="select item_name from items where customer_id=?";

		list($rs,$err)=runIQuery($db,$sql,array("i",$id));

		$data=$rs[0];

		$id=$data[0];

		$table="Item ";

	}

	if ($table=='orders') {

		$table="Sales Order ";

	}

	if ($table=='purchase_orders') {

		$table="Purchase Order";

	}

	if ($table=='jobs') {

		$table="Work Order";

	}

	$message="$table $id changed by $user";

	$sql="select email from salespeople where salesperson_id=?";

	list($rs,$err)=runIQuery($db,$sql,array("i",$assignTo));

	$data=$rs[0];

	if ($data['email']) {

		## find their user ID 

		$em=$data['email'];

		$sql="select user_id from site_admins where email=? ";

		list($rs,$err)=runIQuery($db,$sql,array("s",$em));

		$data=$rs[0];

		$assignTo=$data[0];

	}	

	$sql="insert into messages (message_type, message, viewed, assigned_to, message_date) values (1, '$message', 0, $assignTo, sysdate())";

	list($rs,$err)=runIQuery($db,$sql);

}



function postMessage($assignTo, $message) {

	$sql="insert into messages (message_type, message, viewed, assigned_to, message_date) values (1, '$message', 0, $assignTo, sysdate())";

	list($rs,$err)=runIQuery($db,$sql);

}



function getMRPInfo($db,$item,$start_date="") {

	$retval=array();

	$item=strtoupper($item);

	$sql="select quantity_on_hand, item_description, vendor_name from items left outer join vendors on items.vendor_id=vendors.vendor_id where item_name=?";

	list($rs,$err)=runIQuery($db,$sql,array("s",$item));

	$data=$rs[0];

	$retval['item_description']=$data['item_description'];

	$retval['vendor_name']=$data['vendor_name'];

	$retval['quantity_on_hand']=$data['quantity_on_hand'];

	if (! $start_date) {

		$start_date=Date("Y-m-d");	

	}

	## get all jobs building this part before today

	$sql="select coalesce(sum(quantity_scheduled-coalesce(quantity_good,0)),0) as building from jobs where item_id=? and status=1 and coalesce(quantity_good,0) < quantity_scheduled and start_date <= ? ";

	list($rs,$err)=runIQuery($db,$sql,array("ss",$item,$start_date));

	$data=$rs[0];

	$retval['building']=$data['building'];

	## get all on PO not received yet due before today. 

	$sql="select coalesce(sum(quantity - coalesce(quantity_received,0)),0) as onpo from po_lines, items, purchase_orders where po_lines.date_expected <= ? and po_lines.po_id=purchase_orders.po_id and purchase_orders.status in (1, 3) and po_lines.item_id=items.item_id and item_name=? and coalesce(quantity_received,0) < quantity ";

	list($rs,$err)=runIQuery($db,$sql,array("ss",$start_date,$item));

	$data=$rs[0];

	$retval['onpo']=$data['onpo'];

	## get all on SO not shipped due up to end date

	$sql="select coalesce(sum(quantity - coalesce(shipped_quantity,0)),0) as onso from order_lines, orders where coalesce(shipped_quantity,0) < quantity and order_lines.due_date <= ? and order_lines.order_id=orders.order_id and orders.status in (1,2) and order_lines.item_id=? ";

	list($rs,$err)=runIQuery($db,$sql,array("ss",$start_date,$item));

	$data=$rs[0];

	$retval['onso']=$data['onso'];

	

	$sql="select parent_item, quantity_per from billofmaterial where child_item='$item'";

	$rs=mysqli_query($db,$sql);

	$txnlist=array();

	while ($data=mysqli_fetch_array($rs)) {

		$parent=$data['parent_item'];

		$qper=$data['quantity_per'];

		$txnlist=addToAllocated($db,$parent,$qper,$txnlist,$item,0);

		## up levels

		$sql="select coalesce(sum(quantity_scheduled-coalesce(quantity_good,0)),0) as covered from jobs where status=1 and item_id='$parent' ";

		$jrs=mysqli_query($db,$sql);

		$jdata=mysqli_fetch_array($jrs);

		$covered=$jdata['covered'];

		## seems like covered should include qoh of these items

		$sql="select quantity_on_hand from items where item_name='$parent'";		

		$jrs=mysqli_query($db,$sql);

		$jdata=mysqli_fetch_array($jrs);

		$covered+=$jdata['quantity_on_hand'];

		if ($covered < 0) {

			$covered=0;

		}

		$sql="select parent_item, quantity_per from billofmaterial where child_item='$parent'";

		$brs=mysqli_query($db,$sql);

		while ($bdata=mysqli_fetch_array($brs)) {

			$parent=$bdata['parent_item'];

			$qper=$bdata['quantity_per'];

			$txnlist=addToAllocated($db,$parent,$qper,$txnlist,$item,$covered);

			## up one more level

			## get quantity on jobs that are to be built.

			$sql="select coalesce(sum(quantity_scheduled-coalesce(quantity_good,0)),0) as covered from jobs where status=1 and item_id='$parent' ";

			$jrs=mysqli_query($db,$sql);

			$jdata=mysqli_fetch_array($jrs);

			$covered=$jdata['covered'];

			## seems like covered should include qoh of these items

			$sql="select quantity_on_hand from items where item_name='$parent'";		

			$jrs=mysqli_query($db,$sql);

			$jdata=mysqli_fetch_array($jrs);

			$covered+=$jdata['quantity_on_hand'];

			if ($covered < 0) {

				$covered=0;

			}

			$sql="select parent_item, quantity_per from billofmaterial where child_item='$parent'";

			$lrs=mysqli_query($db,$sql);

			while ($ldata=mysqli_fetch_array($lrs)) {

				$parent=$ldata['parent_item'];

				$qper=$ldata['quantity_per'];

				$txnlist=addToAllocated($db,$parent,$qper,$txnlist, $item,$covered);					

			}

		}					

	}

	$allocated=0;

	foreach ($txnlist as $txn) {

		$allocated=$allocated + abs($txn['qtytogo']);	

	}	

	## get all allocated to jobs not complete to up to the date

	$retval['allocated']=$allocated;

	return $retval;	

}

?>