<?php

function getHolidays($db) {
	$holidays=array();
	$y=Date("Y");
	$holidays[]="$y-01-01";
	$holidays[]="$y-1-1";
	$holidays[]="$y-07-04";
	$holidays[]="$y-7-4";
	$holidays[]="$y-12-25";
	$sql="select holiday_date from holidays where holiday_date > now()";
	list($rs,$err)=runIQuery($db,$sql);
	foreach ($rs as $data) {
		$dt=$data['holiday_date'];
		if (! in_array($dt,$holidays)) {
			$holidays[]=$dt;
		}
	}
	return $holidays;
}


function AddBusinessDays($currentDate, $numberDays) {
	global $db;
	$holidays=getHolidays($db);
	date_default_timezone_set("America/Detroit");
	$begin=strtotime($currentDate);
	$inh=1;
	while ($inh or $numberDays) {
		$begin+=60*60*24;
		$inh=0;
		if (date('w',$begin)==0 or date('w',$begin)==6) {
			$inh=1;
		} else {
			$test=Date("m-d",$begin);
			// todo - get an array of holidays
			if (in_array($test,$holidays)) {
				$inh=1;
			} else {
				$numberDays--;
			}
		}
	}
	return Date("Y-m-d",$begin);
}

function shouldIShowWC($db,$item,$wc,$order) {
	$sql="select display_sequence, operation_id from routing where parent_part=? and workcenter_id=?";
	list($wrs,$err)=runIQuery($db,$sql,array("si",$item,$wc));
	$ds=0;
	if (count($wrs)>0) {
		$ds=$wrs[0][0];
	}
	$showJob=0;
	if ($ds) {
		$sql="select min(display_sequence) from routing where parent_part=? ";
		list($wrs,$err)=runIQuery($db,$sql,array("s",$item));
		if ($wrs[0][0]==$ds) {
			$showJob=1;
		} else {
			$sql="select routing_id, workcenter_name from routing, workcenters where parent_part=? and display_sequence < ? and routing.workcenter_id=workcenters.workcenter_id order by display_sequence desc ";
			list($wrs,$err)=runIQuery($db,$sql,array("si",$item,$ds));
			$ckroute=$wrs[0][0];
			$priorWCName=$wrs[0][1];
			$sql="select coalesce(complete,0) as complete, sum(coalesce(r.quantity_good,0)) as good from order_lines l, jobs j,  production_results r ";
			$sql.=" where order_id=? and l.line_id=j.line_id and j.job_id=r.job_id  and routing_id=? group by coalesce(complete,0) ";
			list($wrs,$err)=runIQuery($db,$sql,array("ii",$order,$ckroute));
			## check this prior step and see if it is complete
			foreach ($wrs as $wdata) {
				if ($wdata['complete']) {
					$showJob=1;
				}
			}
			//$showJob=1;
		}
	}
	if (! $showJob) {
		$sql="select child_item from billofmaterial where parent_item=?";
		list($rs,$err)=runIQuery($db,$sql,array("s",$item));
		foreach ($rs as $data) {
			$child=$data['child_item'];
			$subshowjob=shouldIShowWC($db,$child,$wc,$order);
			if ($subshowjob) {
				$showJob=1;
			}
		}
	}
	return $showJob;
}


function shouldIShowWeld($db,$partID) {
	$sql="select * from items, item_categories, routing, workcenters where items.item_category=item_categories.category_id and items.item_name=routing.parent_part and routing.workcenter_id=workcenters.workcenter_id and category_name in ('Painted Parts', 'Sub Assy') and workcenter_name in ('Weld', 'Production Weld') and items.item_id=? ";
	list($rs,$db)=runIQuery($db,$sql,array("i",$partID));
	// for now never show welddiscontinuities
	return 0;
	return count($rs);
}
function getDematicColor($db,$part) {
	$code="";
	$name="";
	$sql="select customer_id from items where item_name=?";
	list($rs,$err)=runIQuery($db,$sql,array("s",$part));
	$data=$rs[0];
	if ($data['customer_id']==693) {
		$sql="select color_code, color_name from dematic_colors order by length(color_code) desc  "	;
		list($rs,$err)=runIQuery($db,$sql);
		foreach ($rs as $data) {
			if (! $code) {
				$ck=$data['color_code'];
				$l=strlen($ck);
				if (substr($part,$l*-1,$l) == $ck) {
					$code=$ck;
					$name=$data['color_name'];
				}
			}
		}
	}
	return array($code,$name);
}
function setDematicColor($db,$code,$name) {
	if ($code) {
		$sql="select color_code from dematic_colors where color_code=?";
		list($rs,$err)=runIQuery($db,$sql,array("s",$code));
		if (count($rs) == 0) {
			$sql="insert into dematic_colors (color_code, color_name) values (?, ?) ";
			list($rs,$err)=runIQuery($db,$sql,array("ss",$code,$name));
		}
	}
}

### take the generic operation name, and return a list of specific operation IDs that should be looked at
function getOperationList($db,$operation) {
	$retlist=array();
	if ($operation == "WELD" or $operation == "FABRICATION") {
		$retlist[]=3081; ## tig weld
		$retlist[]=3091; ## Fabrication
		$retlist[]=3099; ## weld
		$retlist[]=3108; ## production weld
		$retlist[]=3134; ## production fab
		## TODO Robotic Weld, Manual Weld
	## Not Yet in Weld's List - pluss there are more welds
	#Deburr
	#Hand-Deburr
	#Vibe Bowl
	#Vibe Unload
	#Tool Change
}
	if ($operation == "MACHINING") {
		$retlist[]=3085; ## saw
		$retlist[]=3086; ## drill/tap
		#CNC Mill
		#Boring Mill
	}
	if (count($retlist)==0) {
		$sql="select operation_id from operations where operation_name=?";
		list($rs,$err)=runIQuery($db,$sql,array("s",$operation));
		$data=$rs[0];
		$retlist[]=$data[0];
	}



	return $retlist;

}

function switchFromLineToOutsideProcess($db,$partNumber) {
	## not sure when this would be called, but doing it for completeness
	##  un-park Outside Process as well  - they will only be paint vendors
	## when switching from line to batch
	## park the load and unload
	## 		you do this by moving the routing records into routing_park
	## 			this way only current routings will show -
	##  get the  outside process

	## this could only be called if you previously moved from outside process to line (switchfrombatchtoline function below)
	$sql="select display_sequence from routing_park where parent_part=? and operation_id=3106 ";
	list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
	if (count($rs)> 0) {
		$sql="select display_sequence from routing where parent_part=? and operation_id=3138 ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
		if (count($rs > 0)) {
			$data=$rs[0];
			$seq=$data[0];
			## load and unload
			## clear them if they exist in routing_park in case any changes were made
			$sql="delete from routing_park where parent_part=? and operation_id  in (3138, 3139, 3090) ";
			list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
			$sql="insert into routing_park (routing_id, description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, vendor_id,
				display_sequence, opname, machine, workcenter, calculate, step_cost, business_unit) select * from routing where parent_part=?
				and operation_id in (3138, 3139, 3090)  ";
			list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
			$sql="delete from routing where parent_part=? and operation_id in (3138, 3139, 3090)  ";
			list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
		}
		## just move OP back over
		$sql="insert into routing (routing_id, description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, vendor_id,
			display_sequence, opname, machine, workcenter, calculate, step_cost, business_unit) select * from routing_park where parent_part=?
				and operation_id  = 3106   ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
		$sql="delete from routing_park where parent_part=? and operation_id = 3106 ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
	}
}

function switchFromLineToBatch($db,$partNumber) {
	## when switching from line to batch
	## park the load and unload
	## 		you do this by moving the routing records into routing_park
	## 			this way only current routings will show -
	##  get the  racking, pretreat, dry off, plug/mask, powder application, cure and material handling from routing_park if possbile
	## if they do not exist, you have to just run addpaintsteps
	## get sequence in case we have to insert paint steps
	$sql="select display_sequence from routing where parent_part=? and operation_id=3138 ";
	list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
	if (count($rs)==0) {
		$seq=0; ## add paint steps will add them to the end as we have nothing to go off of
	} else {
		$data=$rs[0];
		$seq=$data[0];
		## load and unload
		## clear them if they exist in routing_park in case any changes were made
		$sql="delete from routing_park where parent_part=? and operation_id  in (3138, 3139) ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
		$sql="insert into routing_park (routing_id, description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, vendor_id,
			display_sequence, opname, machine, workcenter, calculate, step_cost, business_unit) select * from routing where parent_part=?
			and operation_id in (3138, 3139)  ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
		$sql="delete from routing where parent_part=? and operation_id in (3138, 3139)  ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
	}
	## see if there are paint steps for this already in the routing_park table
	$sql="select display_sequence from routing_park where parent_part=? and operation_id  in (3113, 3109, 3110, 3119, 3116, 3112, 3090) ";
	list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
	if (count($rs)>0) {
		## just move them back over
		$sql="insert into routing (routing_id, description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, vendor_id,
			display_sequence, opname, machine, workcenter, calculate, step_cost, business_unit) select * from routing_park where parent_part=?
			 and operation_id in (3113, 3109, 3110, 3119, 3116, 3112, 3090)  ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
		$sql="delete from routing_park where parent_part=? and operation_id in (3113, 3109, 3110, 3119, 3116, 3112, 3090)  ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
	} else {
		## even if there is a routing_park for  outside process with a paint vendor, it does not matter
		## we would only ever be calling this if they are scanning to the batch line.
		## need to create new
		addPaintSteps($db,$partNumber,$seq);
	}
	$sql="select routing_id from routing_park where operation_id=3138 and parent_part=?";
	list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
	$oldRouting=$rs[0][0];
	$sql="select routing_id from routing where operation_id=3116 and parent_part=?";
	list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
	$newRouting=$rs[0][0];
	$sql="update billofmaterial set routing_id=? where routing_id=? ";
	list($rs,$err)=runIQuery($db,$sql,array("ii",$newRouting,$oldRouting));
}

function switchFromBatchToLine($db,$partNumber) {
	## when switching from batch to line, we need to
	##  park racking, pretreat, dry off, plug/mask, powder application, cure and material handling
	## 		you do this by moving the routing records into routing_park
	## 			this way only current routings will show -
	## HOWEVER - if there is plugging or masking for the part, you do NOT remove it.  and you put load and unload after it.
	##  park Outside Process as well  - IF the vendor is a paint_vendor
	## TODO - address how you get production results - this will be a UNION ALL thing with routing_park
	## get sequence in case we have to insert load and unload

	$sql="select display_sequence from routing where parent_part=? and operation_id=3113 ";
	list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
	$mhStep=0;
	$oldRoutingList=array();
	if (count($rs)==0) {
		## check for outside process
		$sql="select display_sequence, routing_id from routing r, vendors v where parent_part=? and operation_id=3106 and v.vendor_id=r.vendor_id and coalesce(paint_vendor,0)=1 ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
		if (count($rs)>0) {
			## ok we have the outside process type
			$data=$rs[0];
			$seq=$data[0];
			$routing=$data[1];
			## see if material handling is the last step if it is we need to make sure we move it to the last step after switching to line
			$sql="select display_sequence from routing where parent_part=? and operation_id=3090";
			list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
			if (count($rs)>0) {
				$testmh=$rs[0][0];
				$sql="select max(display_sequence) from routing where parent_part=? ";
				list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
				$max=$rs[0][0];
				if ($max == $testmh) {
					$mhStep=$max;
				}
			}
			## clear it if it exists in routing_park in case any changes were made
			$sql="delete from routing_park where parent_part=? and operation_id = 3106 ";
			list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
			$sql="insert into routing_park (routing_id, description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, vendor_id,
				display_sequence, opname, machine, workcenter, calculate, step_cost, business_unit) select * from routing where routing_id=? ";
			list($rs,$err)=runIQuery($db,$sql,array("i",$routing));
			$sql="delete from routing where routing_id=?  ";
			list($rs,$err)=runIQuery($db,$sql,array("i",$routing));
			$oldRoutingList[]=$routing;
			$sql="select plugs, masking from items where item_name=? ";
			list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
			$data=$rs[0];
			$plugs=$data[0];
			$masking=$data[1];
		}
	} else {
		$data=$rs[0];
		$seq=$data[0];
		## clear it if it exists in routing_park in case any changes were made
		$sql="delete from routing_park where parent_part=? and operation_id in (3113, 3109, 3110, 3119, 3116, 3112, 3090) ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
		$sql="select plugs, masking from items where item_name=? ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
		$data=$rs[0];
		$plugs=$data[0];
		$masking=$data[1];
		$ops="3113, 3109, 3110, 3116, 3112, 3090";
		if (! $plugs and ! $masking) {
			$ops.=", 3119 ";
		}
		$sql="insert into routing_park (routing_id, description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, vendor_id,
			display_sequence, opname, machine, workcenter, calculate, step_cost, business_unit) select * from routing where parent_part=?
			and operation_id in ($ops) ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
		$sql="select routing_id from routing where parent_part=? and operation_id in ($ops) ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
		foreach ($rs as $data) {
			$oldRoutingList[]=$data['routing_id'];
		}
		$sql="delete from routing where parent_part=? and operation_id in ($ops)  ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
	}
	## see if there are load and unload for this already in the routing_park table
	$sql="select display_sequence from routing_park where parent_part=? and operation_id=3138 ";
	list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
	if (count($rs)>0) {
		## just move them back over
		$sql="insert into routing (routing_id, description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, vendor_id,
			display_sequence, opname, machine, workcenter, calculate, step_cost, business_unit) select * from routing_park where parent_part=? and operation_id in (3138, 3139) ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
		$sql="delete from routing_park where parent_part=? and operation_id in (3138, 3139) ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));

	} else {
		## need to create new
		if ($plugs > 0  or $mask > 0) {
			## if plugging or masking, then get the display sequence for that and add 10 so our load and unload happen after it
			$sql="select display_sequence from routing where parent_part=? and operation_id=3119";
			list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
			if (count($rs)>0) {
				$data=$rs[0];
				$seq=$data[0];
				$seq+=10;
			} else {
				$seq=10;
				$sql="insert into routing (description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, vendor_id,
				display_sequence, opname, machine, workcenter, calculate, step_cost, business_unit) values ('Plug/Mask', ?, 3119, 0, 179, 0, 1, 1, '', 0, ?, '','','',0,0)  ";
				list($updrs,$err)=runIQuery($db,$sql,array("si",$partNumber,$seq));
				$seq=20;
			}
		}
		$sql="select * from routing where parent_part=? and operation_id=3138";
		list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
		if (count($rs)==0) {
			$sql="insert into routing (description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, vendor_id,
				display_sequence, opname, machine, workcenter, calculate, step_cost, business_unit) values ('Load', ?, 3138, 328, 186, 0, 2, 1, '', 0, ?, '','','',0,0)  ";
			list($updrs,$err)=runIQuery($db,$sql,array("si",$partNumber,$seq));
			$seq+=10;
		}
		$sql="select * from routing where parent_part=? and operation_id=3139";
		list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
		if (count($rs)==0) {
			$sql="insert into routing (description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, vendor_id,
				display_sequence, opname, machine, workcenter, calculate, step_cost, business_unit) values ('Unload', ?, 3139, 329, 187, 0, 2, 1, '', 0, ?, '','','',0,0)  ";
			list($updrs,$err)=runIQuery($db,$sql,array("si",$partNumber,$seq));
		}
		if ($mhStep) {
			$sql="select * from routing where parent_part=? and operation_id=3090";
			list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
			if (count($rs)==0) {
				$seq+=10;
				## set the orginal material handling
				$sql="update routing set display_sequence=? where operation_id =3090 and parent_part=? and display_sequence=?";
				list($updrs,$err)=runIQuery($db,$sql,array("isi",$seq,$partNumber,$mhStep));
			}
		}
	}
	$sql="select routing_id from routing where operation_id=3138 and parent_part=?";
	list($rs,$err)=runIQuery($db,$sql,array("s",$partNumber));
	$newRouting=$rs[0][0];
	foreach ($oldRoutingList as $oldRouting) {
		$sql="update billofmaterial set routing_id=? where routing_id=? ";
		list($rs,$err)=runIQuery($db,$sql,array("ii",$newRouting,$oldRouting));
	}

}



function newPaintCalculator($db,$x,$y,$powder,$masking,$plugs,$primer,$batchFlag=0,$debug=0) {
	## x and y of part,
	## id of the color they are using
	## square inches of masking
	## number of plugs
	## primer id
	## will return line,batch,recommended,explanation,mincharge
	$explanation="";
	$line=.015;
	$batch=.02;
	$recommended=$line;
	if ($primer) {
		$line+=.005;
		$batch+=.005;
		$explanation.="Primer added .005 to the per square inch price<br>";
	}
	$minCharge=125;
	$sql="select category_name, additional_price, minimum_lot_charge from vendor_colors v, powder_categories c where vc_id=? and powder_category=category_id";
	list($rs,$err)=runIQuery($db,$sql,array("i",$powder));
	if ($debug) {
		$explanation.="$sql<BR>\n";
	}
	$minLotMessage="";
	if (count($rs)>0) {
		$data=$rs[0];
		$cat=$data[0];
		$addit=$data[1];
		$testMinCharge=$data[2];
		$line+=$addit;
		$batch+=$addit;
		if ($addit > 0) {
			$explanation.=" Powder Category $cat added $addit to the square inch price<br>";
		}
		if ($testMinCharge != $minCharge) {
			$minCharge=$testMinCharge;
			$minLotMessage=" Powder Category $cat changed Min Lot (When applicable) Charge to $minCharge<BR>";
		}
	} else {
		if ($debug) {
			$explanation.="vc_id of $powder not found<BR>";
		}
	}
	if (! $masking) {
		$masking=0;
	}
	$maskingCost=$masking*0.57;
	if ($maskingCost > 50) {
		$maskingCost=50;
	}
	if ($maskingCost > 0) {
		$explanation.=" Masking Cost is $maskingCost (.57 per square inch, max of $50)<br>";
	}
	$pluggingCost=$plugs * .10;
	if ($pluggingCost) {
		$explanation.=" Plugging Cost is $pluggingCost (for the part)<BR>";
	}
	$lineCost=round($line * $x * $y * 2,2);
	$batchCost=round($batch * $x * $y * 2,2);
	$lineCost+=$maskingCost;
	$batchCost+=$maskingCost;
	$lineCost+=$pluggingCost;
	$batchCost+=$pluggingCost;
	$recommended=$lineCost;
	if ($x > 156 or $y > 156) {
		## recommend batch
		$recommended=$batchCost;
		$explanation.=" We Recommended Batch because of part size<br>";
	} else {
		if ($batchFlag) {
			$recommended=$batchCost;
			$explanation.=" You requested Batch Price<BR>";
		}
	}
	return array($lineCost,$batchCost,$recommended,$explanation,$minCharge);
}

function calculatePowderCost($db,$item,$factor=1.3) {
	$sql="select length, width, box_weight, box_price, pound_coverage, laser_part_space from items, vendor_colors where item_name=? and powder_color=vc_id";
	list($rs,$err)=runIQuery($db,$sql,array("s",$item));
	if (count($rs)) {
		$data=$rs[0];
		$length=$data['length']; ## inches
		$width=$data['width']; ## inches
		$weight=$data['box_weight']; ## pounds
		$price=$data['box_price']; ## price for entire box
		$coverage=$data['pound_coverage'];  ## square feet
		$lpc=$data['laser_part_space'];
		if ($weight > 0) { ## bdoss division by 0 errors
			$poundPrice=$price / $weight;
		} else {
			$poundPrice = 0;
		}
		if ($coverage > 0) { ## bdoss division by 0 errors
			$sqftPrice=$poundPrice / $coverage;
		} else {
			$sqftPrice = 0;
		}
		$inchPrice = $sqftPrice / 144; ## square inch price
		$area=($length + $lpc)  * ($width + $lpc) ;
		$surfaceArea=$area*2;  ## not counting thickness, but counting both sides of the part
		## 1.3 is the factor for now
		return $surfaceArea * $inchPrice * $factor;
	} else {
		return 0;
	}
}

function BusinessDaysDifferent($date1,$date2) {
	global $db;
	$holidays=getHolidays($db);
	list($date1,$tm)=explode(" ",$date1);
	list($date2,$tm)=explode(" ",$date2);
	if ($date1 == $date2) {
		return 0;
	}
	$factor=1;
	if ($date1 < $date2) {
		$factor=-1;
	} else {
		$sdate=$date1;
		$date1=$date2;
		$date1=$sdate;
	}
	date_default_timezone_set("America/Detroit");
	$begin=strtotime($date1);
	$end=strtotime($date2);
	$inh=1;
	$numberDays=0;
	while ($inh or $begin < $end) {
		$begin+=60*60*24;
		$inh=0;
		if (date('w',$begin)==0 or date('w',$begin)==6) {
			$inh=1;
		} else {
			$test=Date("m-d",$begin);
			// todo - get an array of holidays
			if (in_array($test,$holidays)) {
				$inh=1;
			} else {
				$numberDays++;
			}
		}
	}
	return $numberDays * $factor;
}

function OKToShip($db,$order_line) {
	$sql="select * from order_lines,  routing r, workcenters w where line_id=? and item_id=parent_part and r.workcenter_id=w.workcenter_id and workcenter_name='Quality Inspection' ";
	$ok=0;
	list($rs,$err)=runIQuery($db,$sql,array("i",$order_line));
	if (count($rs) > 0) {
		$sql="select * from jobs, production_results p, routing r, workcenters w where jobs.line_id=? and jobs.job_id=p.job_id 
			and p.routing_id=r.routing_id and r.workcenter_id=w.workcenter_id and workcenter_name='Quality Inspection' ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$order_line));
		if (count($rs) > 0) {
			$ok=1;
		}
	} else {
		$ok=1;
	}
	return $ok;
}


function getOnSOAndEDIDetail($db,$child,$olist,$start_date="") {
	$qtyper=1;
	$thislist=array();
	$fglist=array();
	$qtyperlist=array();
	$sql="select parent_item, quantity_per from billofmaterial where child_item=? ";
	list($rs,$err)=runIQuery($db,$sql,array("s",$child));
	if (count($rs)==0) {
		if (! in_array($child,$fglist)) {
			$fglist[]=$child;
			$qtyperlist[$child]=$qtyper;
		}
	} else {
		foreach ($rs as $data) {
			set_time_limit(120);
			$child=$data['parent_item'];
			$qtyper=$data['quantity_per'];
			$originalQtyPer=$qtyper;
			$sql="select parent_item, quantity_per from billofmaterial where child_item=? ";
			list($rs2,$err)=runIQuery($db,$sql,array("s",$child));
			if (count($rs2)==0) {
				if (! in_array($child,$fglist)) {
					$fglist[]=$child;
					$qtyperlist[$child]=$qtyper;
				}
			} else {
				foreach ($rs2 as $data2) {
					set_time_limit(120);
					$qtyper=$originalQtyPer;
					$child=$data2['parent_item'];
					$qtyper=$qtyper*$data2['quantity_per'];
					$levelQtyPer2=$qtyper;
					$sql="select parent_item, quantity_per from billofmaterial where child_item=? ";
					list($rs3,$err)=runIQuery($db,$sql,array("s",$child));
					if (count($rs3)==0) {
						if (! in_array($child,$fglist)) {
							$fglist[]=$child;
							$qtyperlist[$child]=$qtyper;
						}
					} else {
						foreach ($rs3 as $data3) {
							set_time_limit(120);
							$qtyper=$levelQtyPer2;
							$child=$data3['parent_item'];
							$qtyper=$qtyper*$data3['quantity_per'];
							$levelQtyPer3=$qtyper;
							$sql="select parent_item, quantity_per from billofmaterial where child_item=? ";
							list($rs4,$err)=runIQuery($db,$sql,array("s",$child));
							if (count($rs4)==0) {
								if (! in_array($child,$fglist)) {
									$fglist[]=$child;
									$qtyperlist[$child]=$qtyper;
								}
							} else {
								foreach ($rs4 as $data4) {
									set_time_limit(120);
									$qtyper=$levelQtyPer3;
									$child=$data4['parent_item'];
									$qtyper=$qtyper*$data4['quantity_per'];
									if (! in_array($child,$fglist)) {
										$fglist[]=$child;
										$qtyperlist[$child]=$qtyper;
									}
							}
								}
						}
					}
				}
			}
		}
	}
	$mylist=array();
	$final=array();
	set_time_limit(120);
	$sql="select distinct item_id from orders o, order_lines l where (o.status in (1,7,11,14) or (o.status=2 and o.inhouse_decision='INTERNAL')) ";
	$sql.="  and o.order_id=l.order_id and item_id in ('" . implode("','",$fglist) . "') ";
	if ($start_date) {
		$sql.=" and l.due_date <= '$start_date' ";
	}
	$sql.=" union all select distinct original_item as item_id from edi_orders o, edi_order_lines l where o.duplicate != 1 and ";
	$sql.=" coalesce(duplicate,0)=0 and coalesce(ack_ready,0) = 0 and o.order_id=l.order_id and document_type='850'  ";
	$sql.=" and original_item in ('" . implode("','",$fglist) . "') ";
	if ($start_date) {
		$sql.=" and ((l.due_date <= '$start_date' and l.due_date != '0000-00-00') or (l.original_due_date <= '$start_date' and l.due_date='0000-00-00')) ";
	}
	list($rs,$err)=runIQuery($db,$sql);
	foreach ($rs as $data) {
		set_time_limit(120);
		$item=$data['item_id'];
		if (! in_array($item,$final)) {
			$final[]=$item;
		}
	}
	foreach ($final as $child) {
		if (isset($qtyperlist[$child])) {
			$qtyper=$qtyperlist[$child];
		} else {
			$qtyper=1;
		}
		set_time_limit(120);
		$thislist=oneSOAndEDIDetail($db,$child,$qtyper,$olist,$start_date);
		foreach ($thislist as $txn) {
			$mylist[]=$txn;
		}
	}
	return $mylist;
}

function oneSOAndEDIDetail($db,$part,$qtyper,$olist,$start_date) {
	$txnlist=array();
	$sql="select due_date, date_due, orders.order_id, ship_name, quantity, shipped_quantity, line_id, order_lines.item_id from order_lines, orders where coalesce(shipped_quantity,0) < quantity ";
	$sql.=" and order_lines.item_id=?  and order_lines.order_id=orders.order_id  ";
	$sql.=" and (orders.status in (1,7,11,14) or (orders.status=2 and orders.inhouse_decision='INTERNAL')) ";
	if (count($olist)>0) {
		$sql.=" and line_id not in (" . implode(",",$olist) . ") ";
	}
	if ($start_date) {
		$sql.=" and order_lines.due_date<='$start_date' ";
	}
	list($rs,$err)=runIQuery($db,$sql,array("s",$part));
	foreach ($rs as $data) {
		set_time_limit(120);
		$line=$data['line_id'];
		$order=$data['order_id'];
		## check for transfers, if on there, take bigger of shipped and transfer
		$sql="select coalesce(sum(quantity),0) from transfer_lines where so_number=?";
		list($trs,$err)=runIQuery($db,$sql,array("i",$order));
		$transfer=$trs[0][0];
		$sql="select coalesce(sum(p.quantity_good),0)  from  jobs j, production_results p where j.line_id=? and j.job_id=p.job_id ";
		list($jrs,$err)=runIQuery($db,$sql,array("i",$line));
		$results=$jrs[0][0];
		## check job production results
		$shipped=$data['shipped_quantity'];
		$bigger=$shipped;
		if ($transfer > $bigger) {
			$bigger=$transfer;
		}

		if ($results > $bigger) {
			$bigger=$results;
		}
		$qtytogo=$data['quantity']-$bigger;
		if ($qtytogo < 0 ) {
			$qtytogo=0;
		}
		$txn=array();
		$txn['part_number']=$part;
		$txn['parent_part']=$part;
		$txn['txndate']=$data['due_date'];
		if ($data['due_date']!='0000-00-00') {
			$txn['txndate']=$data['due_date'];
		} else {
			$txn['txndate']=$data['date_due'];
		}
		$txn['description']=$data['ship_name'];
		$txn['qtytogo']=$qtytogo*-1*$qtyper;
		$txn['identifier']=$data['order_id'];
		$txn['type']='ON SALES ORDER';
		$txnlist[]=$txn;
	}
	$sql="select l.original_due_date, po_number, ship_name, original_quantity from edi_orders o, edi_order_lines l  where  ";
	$sql.="  coalesce(duplicate,0)=0 and coalesce(ack_ready,0) = 0 and o.order_id=l.order_id and document_type='850' ";
	$sql.=" and original_item=? ";
	if ($start_date) {
		$sql.=" and l.original_due_date <= '$start_date' ";
	}
	list($rs,$err)=runIQuery($db,$sql,array("s",$part));
	foreach ($rs as $data) {
		$qtytogo=$data['original_quantity'];
		$txn=array();
		$txn['part_number']=$part;
		$txn['parent_part']=$part;
		$txn['txndate']=$data['original_due_date'];
		$txn['description']=$data['ship_name'];
		$txn['qtytogo']=$qtytogo*-1*$qtyper;
		$txn['identifier']=$data['po_number'];
		$txn['type']='ON EDI ORDER';
		$txnlist[]=$txn;
	}
	return $txnlist;
}

// calculates the cost of  a part based on components  and parts per hour - breaks it down between painted and unpainted
function calculateRawAndPaintedCost($db,$part) {
	$partCost=0;
	$paintCost=0;
	$sql="select item_id, cost, price, item_category, vendor_id  from items where item_name=?";
	list($rs,$err)=runIQuery($db,$sql,array("s",$part));
	$itemID = $rs[0][0];
	$partCost=$rs[0][1];
	$itemPrice=$rs[0]['price'];
	$vendorID=$rs[0]['vendor_id'];
	$category=$rs[0]['item_category'];
	if (strstr($part,"-PAINTED")) {
		$partCost=0;
		$paintCost=0;
	} else {
		$sql="select * from billofmaterial where parent_item=? ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$part));
		if (count($rs) > 0) {
			foreach  ($rs as $data) {
				$component=$data['child_item'];
				$qtyper=$data['quantity_per'];
				if ($qtyper==0) {
					$qtyper=1;
				}
				list($componentCost,$componentPaint)=calculateRawAndPaintedCost($db,$component);
				$ext=$componentCost * $qtyper;
				$partCost +=  $ext;
				$ext=$componentPaint * $qtyper;
				$paintCost += $ext;
			}
		} else {
			## must be purchased
			if ($partCost == 0) {
				$sql="select price from po_lines where price > 0 and item_id=? order by line_id desc LIMIT 1";
				list($rs,$err)=runIQuery($db,$sql,array("i",$itemID));
				if (count($rs) > 0) {
					$data=$rs[0];
					$price=$data['price'];
					$partCost += $price;
				}
			}
		}
		$sql="select * from routing where parent_part=?";
		list($rs,$err)=runIQuery($db,$sql,array("s",$part));
		foreach ($rs as $data) {
			$pph=$data['pph'];
			if ($pph == 0) {
				$pph=60;
			}
			$hours=60/$pph;
			$op=$data['operation_id'];
			if ($vendorID) {
				## outside process - get the price of it
				$sql="select po_lines.price from   po_lines where po_lines.item_id=? order by line_id desc LIMIT 1";
				list($rs,$err)=runIQuery($db,$sql,array("i",$itemID));
				if (count($rs) > 0) {
					$paintCost = $rs[0][0];
				}
				$timeCost = 0;
			} else {
				if ($pph > 0) {
					$sql="select operation_cost from operations where operation_id=?";
					list($ors,$err)=runIQUery($db,$sql,array("i",$op));
					$operationCost=$ors[0][0];
					$timeCost = $operationCost * $hours;
					$timeCost = $timeCost / 60;
					$partCost += $timeCost;
				}
			}
		}
	}
	return array($partCost,$paintCost);
}



// calculates the cost of  a part based on components  and parts per hour
// Pass the Sales Order Line Number so that you can get PO Lines specifically for that SO
function calculateCost($db,$part,$line=0,$sequence=0,$update=0) {
	global $scriptid;
	$sql="select setting from system_settings where `name` = 'laser_factor' ";
	list($rs,$err)=runIQuery($db,$sql);
	$laserFactor=$rs[0][0];
	$partCost=0;
	$sql="select item_id, cost, price, item_category, vendor_id  from items where item_name=?";
	list($rs,$err)=runIQuery($db,$sql,array("s",$part));
	$data=$rs[0];
	$itemID=$data['item_id'];
	$partCost=$data['cost'];
	$itemPrice=$data['price'];
	$vendorID=$data['vendor_id'];
	$savedPaintCost=$partCost;
	if (strstr($part,"-PAINTED")) {
		$partCost=0; ## do not use for placeholders
	}
	$category=$data['item_category'];
	if ($category == 20 or $category == 21 or $category == 18) {
		$partCost=0; ## do not use cost from FG (20) and painted parts (21) and Sub Assemblies (18)
	}
	if ($partCost == 0) {
		if ($sequence > 0) {
			$sql="select * from billofmaterial where parent_item=? and runseq <= ?";
			list($rs,$err)=runIQuery($db,$sql,array("si",$part,$sequence));
		} else {
			$sql="select * from billofmaterial where parent_item=? ";
			list($rs,$err)=runIQuery($db,$sql,array("s",$part));
		}
		if (count($rs) > 0) {
			foreach  ($rs as $data) {
				$component=$data['child_item'];
				$qtyper=$data['quantity_per'];
				if ($qtyper==0) {
					$qtyper=1;
				}
				$componentCost=calculateCost($db,$component,0,0,$update);
				$ext=$componentCost * $qtyper;
				$partCost +=  $ext;
			}
		} else {
			## must be purchased
			if ($partCost == 0) {
				## include SO line if sent
				$sql="select price from po_lines where price > 0 and item_id=? order by order_line=? desc, line_id desc LIMIT 1";
				list($rs,$err)=runIQuery($db,$sql,array("ii",$itemID,$line));
				if (count($rs) > 0) {
					$data=$rs[0];
					$price=$data['price'];
					$partCost += $price;
				} else {
					$price=$itemPrice;
					$partCost+=$price;
				}
			}
		}
		if ($sequence > 0) {
			$sql="select * from routing where parent_part=? and display_sequence <= ? order by display_sequence ";
			list($rs,$err)=runIQuery($db,$sql,array("si",$part,$sequence));
		} else {
			$sql="select * from routing where parent_part=? order by display_sequence ";
			list($rs,$err)=runIQuery($db,$sql,array("s",$part));
		}
		$noMoreSteps=0;
		foreach ($rs as $data) {
			if ($noMoreSteps == 0) {
				$pph=$data['pph'];
				if ($pph == 0) {
					$pph=60;
				}
				$hours=60/$pph;
				$wc=$data['workcenter_id'];
				$vendorID=$data['vendor_id'];
				$operation=$data['operation_id'];
				if ($vendorID) {
					## outside process - get the price of it
					## include SO line in this
					## also only include IF the po line has been received
					if ($line > 0) {
						$sql="select sum(quantity_received) from po_lines where order_line=? ";
						list($rrs,$err)=runIQuery($db,$sql,array("i",$line));
						$received=$rrs[0][0];
						$sql="select quantity from order_lines where line_id=?";
						list($rrs,$err)=runIQuery($db,$sql,array("i",$line));
						$linequantity=$rrs[0][0];
						$factor=1;
						if ($linequantity > 0) {
							$factor=$received/$linequantity;
						}
						$sql="select po_lines.price from   po_lines where po_lines.item_id=? and order_line=?  LIMIT 1";
						list($rs,$err)=runIQuery($db,$sql,array("ii",$itemID,$line));
						if (count($rs) > 0) {
							$paintCost = $rs[0][0];
							### override
							$paintCost=$savedPaintCost;
							$paintCost = $paintCost * $factor;
							$partCost += $paintCost;
						} else {
							$paintCost=$savedPaintCost;
							$partCost +=$paintCost;
							$noMoreSteps=1;
						}
					} else {
						$sql="select po_lines.price from   po_lines where po_lines.item_id=? order by line_id desc LIMIT 1";
						list($rs,$err)=runIQuery($db,$sql,array("i",$itemID));
						if (count($rs) > 0) {
							$paintCost = $rs[0][0];
							### override
							$paintCost=$savedPaintCost;
							$partCost += $paintCost;
						} else {
							$paintCost=$savedPaintCost;
							$partCost += $paintCost;
						}
					}
					$timeCost = 0;
				} else {
					if ($pph > 0) {
						$sql="select operation_cost, operation_name from operations where operation_id=?";
						list($ors,$err)=runIQUery($db,$sql,array("i",$operation));
						$operationPrice=$ors[0][0];
						$operationName=$rs[0][0];

						$timeCost = $operationPrice * $hours;
						if ($operationName == "Laser") {
							$timeCost = $timeCost * $laserFactor;
						}
						$timeCost = $timeCost / 60;
						$partCost += $timeCost;
					} else {
						#$partCost += 1;
					}
				}
			}
		}
	}
	if ($update) {
		## fg, painted, sub assembly
		if ($category == 20 or $category == 21 or $category == 18) {
			## do nothing
		} else {
			$sql="update items set cost=? where item_id=?";
			list($updrs,$err)=runIQuery($db,$sql,array("di",$partCost,$itemID));
		}
	}
	return $partCost;
}

// calculates the cost of  a part based on components  and parts per hour
function calculateCostSeparate($db,$part) {
	$partCost=0;
	$sql="select item_id, cost, price, item_category, vendor_id  from items where item_name=?";
	list($rs,$err)=runIQuery($db,$sql,array("s",$part));
	$itemID = $rs[0][0];
	$partCost=$rs[0][1];
	$itemPrice=$rs[0]['price'];
	$vendorID=$rs[0]['vendor_id'];
	$paintCost=0;
	$laborCost=0;
	if (strstr($part,"-PAINTED")) {
		$partCost=0; ## do not use for placeholders
	}
	$category=$rs[0]['item_category'];
	if ($category == 21 or $category == 20) {
		## painted item, finished good
		$sql="select * from billofmaterial where parent_item=? ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$part));
		if (count($rs) > 0) {
			foreach  ($rs as $data) {
				$component=$data['child_item'];
				$qtyper=$data['quantity_per'];
				if ($qtyper==0) {
					$qtyper=1;
				}
				list($componentCost,$laborCost,$paintCost)=calculateCostSeparate($db,$component);
				$ext=$componentCost * $qtyper;
				$partCost +=  $ext;
				$ext=$laborCost * $qtyper;
				$laborCost += $ext;
				$ext=$paintCost * $qtyper;
				$paintCost += $ext;
			}
		} else {
			## must be purchased
			$sql="select price from po_lines l, purchase_orders o, vendors v where price > 0 and item_id=? and l.po_id=o.po_id and o.vendor_id=v.vendor_id and v.paint_vendor=1 order by line_id desc LIMIT 1";
			list($rs,$err)=runIQuery($db,$sql,array("i",$itemID));
			if (count($rs) > 0) {
				$data=$rs[0];
				$price=$data['price'];
				$paintCost += $price;
			} else {
				$sql="select price from po_lines l, purchase_orders o, vendors v where price > 0 and item_id=? and l.po_id=o.po_id and o.vendor_id=v.vendor_id and v.paint_vendor=- order by line_id desc LIMIT 1";
				list($rs,$err)=runIQuery($db,$sql,array("i",$itemID));
				if (count($rs) > 0) {
					$data=$rs[0];
					$price=$data['price'];
					$partCost+=$price;
				}
			}
		}
		if ($category == 20 or $category == 21) {
			$sql="select * from routing where parent_part=?";
			list($rs,$err)=runIQuery($db,$sql,array("s",$part));
			foreach ($rs as $data) {
				$pph=$data['pph'];
				if ($pph == 0) {
					$pph=60;
				}

				$hours=60/$pph;
				$wc=$data['workcenter_id'];
				$operation=$data['operation_id'];
				if ($vendorID) {
					## outside process - get the price of it
					$sql="select po_lines.price from   po_lines where po_lines.item_id=? order by line_id desc LIMIT 1";
					list($rs,$err)=runIQuery($db,$sql,array("i",$itemID));
					if (count($rs) > 0) {
						$paintCost += $rs[0][0];
					}
				} else {
					if ($pph > 0) {
						$sql="select operation_cost from operations where operation_id=?";
						list($ors,$err)=runIQUery($db,$sql,array("i",$operation));
						$operationPrice=$ors[0][0];
						$timeCost = $operationPrice * $hours;
						$timeCost = $timeCost / 60;
						$laborCost += $timeCost;
					}
				}
			}
		}
	}
	return array($partCost,$laborCost,$paintCost);
}

// calculates the cost of  a part based on operation_times table
// update the pph if proper
function calculateCostFromOT($db,$partID,$line=0,$update=0) {
	$sql="delete from billofmaterial where parent_item=child_item";
	list($rs,$err)=runIQuery($db,$sql);
	$order=0;
	$quantity=1;
	if ($line > 0) {
		$sql="select order_id, quantity from order_lines where line_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$line));
		if (count($rs)>0) {
			$order=$rs[0][0];
			$quantity=$rs[0][1];
			if ($quantity == 0) {
				$quantity=1;
			}
		}
	}
	$sql="select routing_id, operation_name, item_name, pph from  items i, routing r, operations o where i.item_id=? and item_name=parent_part and r.operation_id=o.operation_id ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$partID));
	$totalCost=0;
	$totalPrice=0;
	foreach ($rs as $data) {	
		$routing=$data['routing_id'];
		$operation=$data['operation_name'];
		$pph=$data['pph'];
		$itemName=$data['item_name'];
		$sql="select * from operation_times where operation='$operation' and part_number=? ";
		if ($order > 0) {
			$sql.="order by order_id=$order desc, ot_id ";
		} else {
			$sql.="	order by ot_id desc ";
		}
		list($ors,$err)=runIQuery($db,$sql,array("s",$itemName));
		print renderQuery($sql,array("s",$itemName));
        $hoursPerPart=0;
		if (count($ors)>0) {
			$odata=$ors[0];
			$setup=$odata['setup'];
			$perPart=$odata['per_part'];
            print "quantity is $quantity<bR>";
			$totalSeconds=($setup/$quantity)+$perPart;
            print "no div by zero";
            print "total seconds is $totalSeconds<BR>";
			$hoursPerPart=$totalSeconds/3600;
            print "hours per part is $hoursPerPart<BR>";
            if ($hoursPerPart > 0) {
                $pph=1/$hoursPerPart;
                ## 0, .01, and 3.6 are some system generated fake pph
                $sql="update routing set pph=$pph where routing_id=$routing and (pph=0 or pph=.01 or pph=3.6) ";
                $updrs=runIQuery($db,$sql);
            }
        }
		if ($hoursPerPart == 0) {
			if ($pph > 0) {
				$hoursPerPart=1/$pph;
			}				
		}
        if ($operation == "Deburr") {
            $operation = "Hand-Deburr";
        }        
        $sql="select operation_price, operation_cost from operations where operation_name='$operation'";
        list($ors,$err)=runIQuery($db,$sql);
        $opCost=$ors[0]['operation_cost'];
        print "op cost is $opCost<BR>";
		print "Hours Per Part: $hoursPerPart<BR>";
        $price=round($ors[0]['operation_price'] * $hoursPerPart,2);
        $cost=round($ors[0]['operation_cost'] * $hoursPerPart, 4);
        print "cost is $cost<BR>";
        $totalPrice+=$price;
        $totalCost+=$cost;
	}
	## have all the routings, now get the parts that go into it
	$sql="select child_item, quantity_per from  items i, billofmaterial b where i.item_id=? and item_name=parent_item ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$partID));
	if (count($rs) > 0) {
		foreach  ($rs as $data) {
			$component=$data['child_item'];
			$qtyper=$data['quantity_per'];
			if ($qtyper==0) {
				$qtyper=1;
			}
			$sql="select item_id from items where item_name='$component'";
			list($crs,$err)=runIQuery($db,$sql);
			$componentID=$crs[0][0];
			list($cost,$price)=calculateCostFromOT($db,$componentID);
			$totalPrice+=($price * $qtyper);
			$totalCost+=($cost * $qtyper);
		}
	} else {
		## must be purchased
		$sql="select price from po_lines l, purchase_orders o, vendors v where price > 0 and item_id=? and l.po_id=o.po_id and o.vendor_id=v.vendor_id order by line_id desc LIMIT 1";
		list($rs,$err)=runIQuery($db,$sql,array("i",$partID));
		if (count($rs) > 0) {
			$data=$rs[0];
			$price=$data['price'];
			$totalCost+=($price*$qtyper);
			$totalPrice+=($price * $qtyper * 1.2);
		}
	}
	$totalCost=round($totalCost,4);
	$totalPrice=round($totalPrice,2);
	return array($totalCost,$totalPrice);
}


// calculates the cost of  a part based on components  and parts per hour
function calculateActualCost($db,$part,$line) {
	$partCost=0;
	$sql="select item_id, cost, item_category, price, vendor_id  from items where item_name=?";
	list($rs,$err)=runIQuery($db,$sql,array("s",$part));
	$itemID = $rs[0][0];
	$partCost=$rs[0][1];
	$category=$rs[0]['item_category'];
	$itemPrice=$rs[0]['price'];
	$vendorID=$rs[0]['vendor_id'];
	// fg do not use cost.  all others use the cost (if 21 painted part, the cost is just the cost of the paint)
	if ($category == 20 ) {
			$partCost=0;
	}
	$sql="select * from billofmaterial where parent_item=? ";
	list($rs,$err)=runIQuery($db,$sql,array("s",$part));
	if (count($rs) > 0) {
		foreach  ($rs as $data) {
			$component=$data['child_item'];
			$qtyper=$data['quantity_per'];
			if ($qtyper==0) {
				$qtyper=1;
			}
			$componentCost=calculateActualCost($db,$component,$line);
			$ext=$componentCost * $qtyper;
			$partCost +=  $ext;
		}
	} else {
		## must be purchased
		if ($partCost == 0) {
			$sql="select price from po_lines where price > 0 and item_id=? order by line_id desc LIMIT 1";
			list($rs,$err)=runIQuery($db,$sql,array("i",$itemID));
			if (count($rs) > 0) {
				$data=$rs[0];
				$price=$data['price'];
				$partCost += $price;
			} else {
				$price=$itemPrice;
				$partCost+=$price;
			}
		}
	}
	$sql="select * from routing where parent_part=?";
	list($rs,$err)=runIQuery($db,$sql,array("s",$part));
	foreach ($rs as $data) {
		$wc=$data['workcenter_id'];
		$operation=$data['operation_id'];
		$routingID=$data['routing_id'];
		$sql="select sum(duration_hours) as hours, sum(duration_minutes) as minutes, sum(r.quantity_good) as good from  jobs j, production_results r where j.line_id=? and j.job_id=r.job_id and r.routing_id=? ";
		list($prs,$err)=runIQuery($db,$sql,array("ii",$line,$routingID));
		$pdata=$prs[0];
		$hours=$pdata['hours'] + ($pdata['minutes'] / 60);
		$quantity=$pdata['good'];
		if ($vendorID) {
			## outside process - get the price of it
			$sql="select po_lines.price from   po_lines where po_lines.item_id=? order by line_id desc LIMIT 1";
			list($rs,$err)=runIQuery($db,$sql,array("i",$itemID));
			if (count($rs) > 0) {
				$paintCost = $rs[0][0];
				$partCost += $paintCost;
			}
			$timeCost = 0;
		} else {
			if ($hours)  {
				$sql="select operation_cost from operations where operation_id=?";
				list($ors,$err)=runIQUery($db,$sql,array("i",$operation));
				$operationPrice=$ors[0][0];
				$operationPrice=$ors[0][0];
				$timeCost = $operationPrice * $hours;
				$timeCost = $timeCost / $quantity;
				$partCost += $timeCost;
			}
		}
	}
	return number_format($partCost,4);
}

function SubtractBusinessDays($currentDate, $numberDays) {
	global $db;
	$holidays=getHolidays($db);
	date_default_timezone_set("America/Detroit");
	$begin=strtotime($currentDate);
	$inh=1;
	while ($inh or $numberDays> 0) {
		$begin-=60*60*24;
		$inh=0;
		if (date('w',$begin)==0 or date('w',$begin)==6) {
			$inh=1;
		} else {
			$test=Date("m-d",$begin);
			if (in_array($test,$holidays)) {
				$inh=1;
			} else {
				$numberDays--;
			}
		}
	}
	return Date("Y-m-d",$begin);
}

function getEarliestDate($db,$job) {
	$sql="select min(schedule_date) as mindate from schedule, schedule_items where schedule.schedule_id=schedule_items.schedule_id and job_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$job));
	$data=$rs[0];
	return $data['mindate'];
}

function liveScheduling($db,$job,$recreate=0) {
	$sql="select * from schedule_items where job_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$job));
	## nothing in the schedule tells us that we should schedule it.
	if ((count($rs)==0) or ($recreate > 0)) {
		if ($recreate > 0) {
			$sql="delete from schedule_items where job_id=?";
			list($rs,$err)=runIQuery($db,$sql,array("i",$job));
		}
		$sequence=0;
		$sql="select item_id, start_date, quantity_scheduled from jobs where job_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$job));
		$data=$rs[0];
		$part=$data[0];
		$testDate=$data[1];
		$quantity=$data[2];
		$hardDate=AddBusinessDays(Date("Y-m-d"),1);
		if ($testDate < $hardDate) {
			$hardDate=$testDate;
		}
		$priorOperation=0;
		$sql="select * from routing where parent_part=? order by display_sequence desc ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$part));
		foreach ($rs as $data) {
			$dueDate=$testDate;
			$pph=$data['pph'];
			## if no pph, default it so it will take 1 hour (1 day)
			if ($pph==0){
				$pph=$quantity;
			}
			$vendor=$data['vendor_id'];
			$operationID=$data['operation_id'];
			$machineID=$data['machine_id'];
			$workcenterID=$data['workcenter_id'];
			$routingID = $data['routing_id'];
			## the end date is the date it has to ship.
			## if outside process, get lead time from vendor
			$sql="select workcenter_name from workcenters where workcenter_id=?";
			list($wrs,$err)=runIQuery($db,$sql,array("i",$workcenterID));
			$wcName=$wrs[0][0];
			if (strtolower($wcName)=="outside process") {
				$leadTime=3;
				$sql="select lead_time from vendors where vendor_id=?";
				list($vrs,$err)=runIQuery($db,$sql,array("i",$vendor));
				if (count($vrs)>0) {
					$leadTime = $vrs[0][0];
				}
				$testDate=SubtractBusinessDays($testDate,$leadTime);
				$hours=$leadTime * 8;
			} else {
				$sql="select days_schedule from operations where operation_id=$operationID";
				list($oprs,$err)=runIQuery($db,$sql);
				$days=$oprs[0]['days_schedule'];
				if ($days > 0) {
					if ($pph <= 0) {
						$pph=1;
					}
					$hours=$quantity / $pph + .5;
					## to allow for 50 minute hours
					$hours=$hours*60/50;
					if ($hours < 1) {
						$hours=1;
					}
					$i=3;
					while ($i < 10) {
						$testHours = 8.4 * $i;
						$i++;
						if ($hours > $testHours) {
							$days=$i;
						}
					}
					$testDate=SubtractBusinessDays($testDate,$days);
				}
			}
			if ($testDate < $hardDate) {
				$testDate=$hardDate;
			}
			$sql="select schedule_id from schedule where workcenter_id=? and schedule_date=?";
			list($rs,$err)=runIQuery($db,$sql,array("is",$workcenterID,$testDate));
			if (count($rs)==0) {
				$sql="insert into schedule (workcenter_id, schedule_date) values (?, ?) ";
				list($rs,$err)=runIQuery($db,$sql,array("is",$workcenterID,$testDate));
				$sql="select schedule_id from schedule where workcenter_id=? and schedule_date=?";
				list($rs,$err)=runIQuery($db,$sql,array("is",$workcenterID,$testDate));
			}
			$data=$rs[0];
			$scheduleID=$data['schedule_id'];
			if (! $vendor) {
				$vendor=0;
			}
			$sql="delete from schedule_items where machine_id=? and job_id=? and operation_id=? and routing_id=? ";
			list($rs,$err)=runIQuery($db,$sql,array("iiii",$machineID,$job,$operationID,$routingID));
			$sql="insert into schedule_items (schedule_id, machine_id, job_id, operation_id,  hours, due_date, routing_id, vendor_id) values (?, ?, ?, ?, ?, ?, ?, ?) ";
			list($rs,$err)=runIQuery($db,$sql,array("iiiiisii",$scheduleID, $machineID,$job, $operationID, $hours, $testDate,$routingID,$vendor));
			$sql="";
			$priorOperation=$operationID;
		}
	}
}


function PushScheduleBack($db,$job,$workcenterID, $operationID, $sequence) {
	## this will push all scheduled items back one day, starting with the given workcentera
	## but will not push back if it is prior to the date.
	$sql="select * from schedule, schedule_items where workcenter_id=? and schedule.schedule_id=schedule_items.schedule_id and job_id=? and operation_id=? ";
	$hardDate=AddBusinessDays(Date("Y-m-d"),1);
	list($rs,$err)=runIQuery($db,$sql,array("iii",$workcenterID,$job,$operationID));
	$data=$rs[0];
	$testDate=SubtractBusinessDays($data['schedule_date'],1);
	$oldSchedule=$data['schedule_id'];
	if ($testDate < $hardDate) {
		$testDate=$hardDate;
	}
	$sql="select schedule_id from schedule where workcenter_id=? and schedule_date=?";
	list($rs,$err)=runIQuery($db,$sql,array("is",$workcenterID,$testDate));
	if (count($rs)==0) {
		$sql="insert into schedule (workcenter_id, schedule_date) values (?, ?) ";
		list($rs,$err)=runIQuery($db,$sql,array("is",$workcenterID,$testDate));
		$sql="select schedule_id from schedule where workcenter_id=? and schedule_date=?";
		list($rs,$err)=runIQuery($db,$sql,array("is",$workcenterID,$testDate));
	}
	$data=$rs[0];
	$scheduleID=$data['schedule_id'];
	if ($oldSchedule <> $scheduleID) {
		$sql="update schedule_items set schedule_id=? where job_id=? and schedule_id=? and operation_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("iiii",$scheduleID,$job,$oldSchedule,$operationID));
		$sql="select routing.* from routing, jobs where job_id=? and item_id=parent_part order by display_sequence desc";
		list($rs,$err)=runIQuery($db,$sql,array("i",$job));
		$nextWorkCenter=0;
		$useNext=0;
		foreach ($rs as $data) {
			if ($useNext==1) {
				PushScheduleBack($db,$job,$data['workcenter_id'], $data['operation_id'], $data['display_sequence']);
				$useNext=-1;
			}
			if ($useNext==0) {
				if ($data['workcenter_id']==$workcenterID and $data['operation_id']=$operationID and $data['display_sequence']==$sequence) {
					$useNext=1;
				}
			}
		}
	}
}


function addToAllocated($db,$parent,$qper,$item,$txnlist,$covered=0,$usepr=1) {
	$item=strtoupper($item);
	$parent=strtoupper($parent);
	## 100000 jobs are to stock and are not to be counted
	$sql="select * from jobs where status=1 and item_id='$parent' and quantity_scheduled > coalesce(quantity_good,0) ";
	$sql.=" and quantity_scheduled < 100000 ";
	$sql.=" and (line_id=0 or line_id in (select line_id from order_lines where line_status not in (3,4,5,6))) ";
	### these are laser jobs
	$sql.=" and job_id not in (select job_id from jobs_orders) ";
	$sql.=" and coalesce(laser_job,0) = 0 ";
	$jrs=mysqli_query($db,$sql);
	$jc=0;
	while ($jdata=mysqli_fetch_array($jrs)) {
		$jc++;
		$qtytogo=$jdata['quantity_scheduled']-$jdata['quantity_good'];
		## have to multiply out by quantity per before subtracting covered amounts.
		$job=$jdata['job_id'];
		## needs to look at production results for when item is consumed
		if ($usepr) {
			$sql="select routing_id from billofmaterial where child_item=? and parent_item=?";
			list($rrs,$err)=runIQuery($db,$sql,array("ss",$item,$parent));
			if (count($rrs)>0) {
				$rdata=$rrs[0];
				$routing=$rdata[0];
				$sql="select sum(quantity_good) from production_results where job_id=? and routing_id=?";
				list($rrs,$err)=runIQuery($db,$sql,array("ii",$job,$routing));
				if (count($rrs)>0) {
					$rdata=$rrs[0];
					$qtytogo-=$rdata[0];
				}
				$sql="select sum(quantity) from job_defects where job_id=? and routing_id=?";
				list($rrs,$err)=runIQuery($db,$sql,array("ii",$job,$routing));
				if (count($rrs)>0) {
					$rdata=$rrs[0];
					$qtytogo-=$rdata[0];
				}
			}
		}
		## needs to look at order status because if complete then ignore
		$sql="select line_status from jobs j, order_lines l where job_id=? and j.line_id=l.line_id and line_status in (3,4,5,6,8,9,10,13) ";
		list($rrs,$err)=runIQuery($db,$sql,array("i",$job));
		if (count($rrs)>0) {
			$qtytogo=0;
		}
		if ($qtytogo<0) {
			$qtytogo=0;
		}
		if ($qper==0) {
			$qper=1;
		}
		$qtytogo=$qtytogo*$qper;
		$newcovered=$covered-$qtytogo;
		if ($newcovered < 0) {
			$newcovered=0;
		}
		$qtytogo-=$covered;
		if ($qtytogo >= 0) {
			$alreadyThere=0;
			foreach ($txnlist as $txn) {
				if ($jdata['job_id'] == $txn['identifier']) {
					if ($txn['type']=="ALLOCATED" and $txn['part_number']==$item) {
						$alreadyThere=1;
					}
				}
			}
			if (! $alreadyThere) {
				$txn=array();
				$txn['part_number']=$item;
				$txn['parent_part']=$parent;
				$txn['txndate']=$jdata['start_date'];
				$txn['description']=$jdata['description'];
				$txn['qtytogo']=abs($qtytogo)*-1;
				$txn['identifier']=$jdata['job_id'];
				$txn['type']='ALLOCATED';
				$txnlist[]=$txn;
			}
		}
		$covered=$newcovered;
	}
	return $txnlist;
}

function addChildren($db,$parent,$qty,$due,$so,$txnlist) {
	$sql="select * from billofmaterial  where parent_item=?";
	list($rs,$err)=runIQuery($db,$sql,array("s",$parent));
	foreach ($rs as $data) {
		$item=$data['child_item'];
		$sql="select item_description from items where item_name=?";
		list($crs,$err)=runIQuery($db,$sql,array("s",$item));
		$cdata=$crs[0];
		$description=$cdata[0];
		$qtyper=$data['quantity_per'];
		$qtytogo=$qty*$qtyper;
		$txn=array();
		$txn['part_number']=$item;
		$txn['parent_part']=$parent;
		$txn['txndate']=$due;
		$txn['description']=$description;
		$txn['qtytogo']=abs($qtytogo)*-1;
		$txn['identifier']=$so;
		$txn['type']='NEED FOR SO';
		$txnlist[]=$txn;
		$txnlist=addChildren($db,$item,$qtytogo,$due,$so,$txnlist);
	}
	return $txnlist;
}

function updateDocumentStatus($dbI,$docType,$docID) {
	if ($docType == "PO") {
		date_default_timezone_set('America/Detroit');
		$sql="SET time_zone = '" .date('P') . "'";
		list($rs,$err)=runIQuery($dbI,$sql);
		$sql="update purchase_orders set status = 5, date_sent=now() where po_id=? and status=1";
		list($rs,$err)=runIQuery($dbI,$sql,array("i",$docID));

		// PO ACTIVITY set status to sent to vendor
		updatePOActivity($dbI,$docID,5,"Set status to Sent to Vendor");

		$sql="update orders set status=11 where status in (1, 6) and order_id in (select order_id from order_lines ol, po_lines l where ol.line_id=l.order_line and l.po_id=?)  ";
		list($rs,$err)=runIQuery($dbI,$sql,array("i",$docID));
		$sql="select order_id from order_lines ol, po_lines l where ol.line_id=l.order_line and l.po_id=?";
		list($rs,$err)=runIQuery($dbI,$sql,array("i",$docID));
		foreach ($rs as $data) {
			$orderID=$data[0];
			if ($orderID) {
				$sql="update order_lines set line_status=11 where line_status in (1, 6) and order_id =?  ";
				list($rs,$err)=runIQuery($dbI,$sql,array("i",$orderID));
			}
		}
	}
}



function isNumericField($ftype) {
	$retval=false;
	$ftype=strtolower($ftype);
	if (($ftype == 'n')  or (substr($ftype,0,3)=='int') or (substr($ftype,0,6)=='bigint')) {
		$retval=true;
	}
	if ($ftype=='currency') {
		$retval=true;
	}
	return $retval;
}

function isDateField($ftype) {
	$retval=false;
	$ftype=strtolower($ftype);
	if ($ftype=='d') {
		$retval=true;
	}
	if ($ftype=='date') {
		$retval=true;
	}
	return $retval;
}

function dateDiff($start, $end) {

	$start_ts = strtotime($start);

	$end_ts = strtotime($end);

	$diff = $end_ts - $start_ts;

	return round($diff / 86400);

}

function time_diff_conv($start, $s) {
    $s = abs($s - $start);
	$days=floor($s/86400);
	$s -= ($days*86400);
	$hours=floor($s/3600);
	$s -= ($hours*3600);
	$minutes=floor($s/60);
	$s -= ($minutes*60);
	$seconds=$s;
	$string="";
	if ($days > 0) {
		if ($days > 1) {
			$string.=$days . " Days ";
		} else {
			$string.=$days . " Day ";
		}
	}
	if ($hours > 0) {
		if ($hours > 1) {
			$string.=$hours . " Hours ";
		} else {
			$string.=$hours . " Hour ";
		}
	}
	if ($minutes > 0) {
		if ($minutes > 1) {
			$string.=$minutes . " Minutes ";
		} else {
			$string.=$minutes . " Minute ";
		}
	}
	if ($seconds > 0) {
		if ($seconds > 1) {
			$string.=$seconds . " Seconds ";
		} else {
			$string.="1 Second";
		}
	}
    return $string;
}


function work_days_from_date($days, $date=NULL)
{
    if(!$date)
    {
        $date = date('Y-m-d'); // if no date given, use todays date
    }

    if ($days < 0) {
		$forward=0;
		$days=$days*-1;
	} else {
		$forward=1;
	}
    while ($days != 0)
    {
        $forward == 1 ? $day = strtotime($date.' +1 Weekday') : $day = strtotime($date.' -1 Weekday');
        $date = date('Y-m-d',$day);
	    ## todo: add holiday processing here
	    $days--;
    }
    return $date;
}

function formatDateWebtoDB($dval) {
	$tval="";
	$dval=trim($dval);
	if (strtotime($dval)) {
		if (count(explode(" ",$dval)) > 1) {
			list($dval,$tval)=explode(" ",$dval);
		}
		if (count(explode("/",$dval))>2) {
			list($mo,$dy,$yr)=explode("/",$dval);
			if (strstr($mo,"-")) {
				## we got a dash date
				list($mo,$dy,$yr)=explode("-",$dval);
				if (strlen($mo)==4) {
					## we got a yyyy-mm-dd date - just send it back
					return $dval . $tval;
				}
			}
			$dval=$yr . "-";
			if (strlen($mo)<2) {
				$dval.="0";
			}
			$dval.=$mo . "-";
			if (strlen($dy)<2) {
				$dval.="0";
			}
			$dval.=$dy;
			$dval.=" " . $tval;
		} else {
			$dval="0000-00-00";
		}
		return $dval;
	} else {
		return "0000-00-00";
	}
}
function formatDateOracletoDB($dval) {
	if (strtotime($dval)) {
		list($dy,$mo,$yr)=explode("-",$dval);
		$dval=$yr . "-";
		$mo=strtolower($mo);
		if ($mo=='jan') {
			$dval.="01";
		}
		if ($mo=='feb') {
			$dval.="02";
		}
		if ($mo=='mar') {
			$dval.="03";
		}
		if ($mo=='apr') {
			$dval.="04";
		}
		if ($mo=='may') {
			$dval.="05";
		}
		if ($mo=='jun') {
			$dval.="06";
		}
		if ($mo=='jul') {
			$dval.="07";
		}
		if ($mo=='aug') {
			$dval.="08";
		}
		if ($mo=='sep') {
			$dval.="09";
		}
		if ($mo=='oct') {
			$dval.="10";
		}
		if ($mo=='nov') {
			$dval.="11";
		}
		if ($mo=='dec') {
			$dval.="12";
		}
		$dval.="-";
		if (strlen($dy)<2) {
			$dval.="0";
		}
		$dval.=$dy;
		return $dval;
	} else {
		return "0000-00-00";
	}
}

function formatDateDBToWeb($dval) {
	if ($dval=='0000-00-00') {
		return "";
} else {
		if (strstr($dval,"-")) {
			list($yr,$mo,$dy)=explode("-",$dval);
			$tm="";
			if (strstr($dy," ")) {
				list($dy,$tm)=explode(" ",$dy);
			}
			$dval="$mo/$dy/$yr";
			if ($tm) {
				if ($tm != "00:00:00") {
					$dval.=" " . $tm;
				}
			}
			if ($dval=='//') { $dval=''; }
			if ($dval=='//0') { $dval=''; }
			return $dval;
		} else {
			return "";
		}
	}
}
function FormatTime($tval) {
	list($hours,$minutes,$seconds)=explode(":",$tval);
	if ($hours < 12) {
		$tval=$hours . ":" . $minutes . " am";
	} else {
		if ($hours > 12) {
			$hours-=12;
		}
		if (strlen($hours < 2)) {
			$hours="0" . $hours;
		}
		$tval=$hours . ":" . $minutes . " pm";
	}
	return $tval;
}


##
/* This function will convert line breaks or other tags passed in the $tags variable
to linebreaks.  Multiple $tags must be separated by spaces, and must consist of the
regular tag text.  Ie. $result = br2nl($text_to_filter, "br p blockquote") */
function br2nl($text, $tags = "br")
{
 $tags = explode(" ", $tags);

 foreach($tags as $tag)
 {
 	$tag=strtolower($tag);
 	str_replace("<".strtoupper($tag),$tag,$text);
   $text=preg_replace('=<' . $tag . ' */?>=i', "\n", $text);
 }

 return($text);
}


function html2text($document){
    $search = array('@<script[^>]*?>.*?</script>@si',  // Strip out javascript
                   '@<[\/\!]*?[^<>]*?>@si',            // Strip out HTML tags
                   '@<style[^>]*?>.*?</style>@siU',    // Strip style tags properly
                   '@<![\s\S]*?--[ \t\n\r]*>@'         // Strip multi-line comments including CDATA
    );
    $text = preg_replace($search, '', $document);
    return $text;
}

    function get_display_size(DomNode $img)
    {
        $width = -1;
        $height = -1;

        if ($img->nodeName !== 'img')
        {
            return array($width, $height);
        }

        // See if there is aheight or width attribute in the tag itself.
        if (isset($img->attr['width']))
        {
            $width = $img->attr['width'];
        }

        if (isset($img->attr['height']))
        {
            $height = $img->attr['height'];
        }

        // Now look for an inline style.
        if (isset($img->attr['style']))
        {
            // Thanks to user gnarf from stackoverflow for this regular expression.
            $attributes = array();
            preg_match_all("/([\w-]+)\s*:\s*([^;]+)\s*;?/", $img->attr['style'], $matches, PREG_SET_ORDER);
            foreach ($matches as $match) {
              $attributes[$match[1]] = $match[2];
            }

            // If there is a width in the style attributes:
            if (isset($attributes['width']) && $width == -1)
            {
                // check that the last two characters are px (pixels)
                if (strtolower(substr($attributes['width'], -2)) == 'px')
                {
                    $proposed_width = substr($attributes['width'], 0, -2);
                    // Now make sure that it's an integer and not something stupid.
                    if (filter_var($proposed_width, FILTER_VALIDATE_INT))
                    {
                        $width = $proposed_width;
                    }
                }
            }

            // If there is a height in the style attributes:
            if (isset($attributes['height']) && $height == -1)
            {
                // check that the last two characters are px (pixels)
                if (strtolower(substr($attributes['height'], -2)) == 'px')
                {
                    $proposed_height = substr($attributes['height'], 0, -2);
                    // Now make sure that it's an integer and not something stupid.
                    if (filter_var($proposed_height, FILTER_VALIDATE_INT))
                    {
                        $height = $proposed_height;
                    }
                }
            }

        }

        // Future enhancement:
        // Look in the tag to see if there is a class or id specified that has a height or width attribute to it.

        // Far future enhancement
        // Look at all the parent tags of this image to see if they specify a class or id that has an img selector that specifies a height or width
        // Note that in this case, the class or id will have the img subselector for it to apply to the image.

        // ridiculously far future development
        // If the class or id is specified in a SEPARATE css file thats not on the page, go get it and do what we were just doing for the ones on the page.

        $result = array('height' => $height,
                        'width' => $width);
        return $result;
    }

$firstPanelRendered = 0;
if (empty($bottomScript)) {
	$bottomScript = "";
}
function renderPanel($title="",$description="",$color="green",$width="span11",$icon="edit") {
	global $firstPanelRendered, $bottomScript, $db, $userEmployeeID;
	$retval="<div class='portlet box $color $width' >";
	$retval.="	<div class='portlet-title '>";
	$retval.="		<div class='caption'><i class='icon-$icon'></i>$title";

	if (!$firstPanelRendered) {
		$sql = "select change_id, change_description, change_elements, show_times from change_log where change_script=? and show_until >= now()";
		list($crs,$err) = runIQuery($db,$sql,["s",basename(strtok(preg_replace("#/+#","/",$_SERVER['REQUEST_URI']), "?"))]);
		if (count($crs)) {
			$sql = "select coalesce(count(*),0) as seen_times, change_id from change_seen where change_id in (";
			$vars = ["i"];
			foreach ($crs as $data) {
				if ($vars[0] != "i") {
					$sql .= ",";
				}
				$sql .= "?";
				$vars[] = $data["change_id"];
				$vars[0] .= "i";
			}

			$sql .= ") and employee_id=? group by change_id";
			$vars[] = $userEmployeeID;
			list($srs,$err)=runIQuery($db,$sql,$vars);

			$seen = [];
			foreach ($srs as $data) {
				$seen[$data["change_id"]] = $data["seen_times"];
			}
			reset($crs);

			$changeCount=0;
			$bottomScript .= "var changes = [];";
			$sql = "insert into change_seen (change_id, employee_id) values ";
			$firstTime = 0;
			foreach ($crs as $data) {
				$count = $seen[$data["change_id"]];
				$times = $data["show_times"];
				if ($count == 0) {
					$firstTime = 1;
				}

				if ($count >= $times) {
					continue;
				}

				$desc = str_replace("'", "\\'", $data["change_description"]);
				$elms = $data["change_elements"];
				$bottomScript .= "changes.push(['$desc','$elms']);";
				if ($changeCount != 0) {
					$sql .= ",";
				}
				$sql .= "(" . $data["change_id"] . ",$userEmployeeID)";
				$changeCount++;
			}
			if ($changeCount > 0) {
				$btnc = "blue";
				if ($color == "blue") {
					$btnc = "green";
				}
				$retval .= "<h4 id='changehighlight'>This page has recently changed. Click <div class='btn blue' onclick=\"$('#changes-modal').modal('show');\">HERE</div> for more information</h4>";
				$bottomScript.="$('#changehighlight').effect('highlight');
				var cmbody = '';
				changes.forEach(function(x) {
					cmbody += '<li>' + x[0].replace(/\\r\\n|\\r|\\n/g, '<br>') + '</li><br>';
					var elms = x[1].split(',');
					elms.forEach(function(e) {
						$(e).effect('shake');
					});
				});

				var modal = $(\"<div id='changes-modal' class='modal fade' role='dialog'><div class='modal-dialog'><div class='modal-content'><div class='modal-header'><h4 class='modal-title changes-title'>Recent Changes</h4></div><div class='modal-body'><span class='changes-body'>\" + cmbody + \"</span></div><div class='modal-footer'><button class='btn red' data-dismiss='modal'>Ok</button><button class='btn yellow' onclick='window.open(`changeLog.php`, `_blank`);'>Changelog</button></div></div></div></div>\");
				$('body').append(modal);";
				if ($firstTime) {
					$bottomScript .= "$('#changes-modal').modal('show');";
				}
				list($rs)=runIQuery($db,$sql);
			}
		}

	}

	$retval.= "</div>";
	$retval.="		<div style='display: none; float: right;' id='working'>&nbsp;&nbsp;&nbsp;<img src='img/loading.gif'></div>";


	$retval.="		<div class='tools'>";
	$retval.="			<a href='javascript:;' class='collapse'></a>";
	$retval.="		</div>";
	$retval.="	</div>";
	$retval.="	<div class='portlet-body form'>";
	$retval.="		<div class='tab-content'>";
	$retval.="			<div class='tab-pane active' id='portlet_tab1 '>";
	$firstPanelRendered = 1;
	return $retval;
}

function renderClosePanel($footer="") {
	$retval= "			</div>\n";
    $retval.="			<div class='panel-footer'>\n";
    $retval.=$footer;
    $retval.="			</div>\n";
    $retval.='		</div>';
    $retval.='	</div>';
    $retval.='</div>';
    return $retval;
}

function renderHTML($showLabel,$fieldName,$table,$key,$id) {
	$title=str_replace("_"," ",$fieldName);
	$title=strtolower($title);
	$title=ucwords($title);
	$retval=renderStartItem($showLabel,$fieldName,$title);
	$retval= "<button class='btn-success' onclick=\"window.open('showHTML.php?table=$table&field=$fieldName&key=$key&id=$id','preview');\" >Click To View</button>";
	$retval.=renderEndItem();
	return $retval;

}
function renderButton($label="Submit",$color="primary",$onclick="",$id="") {
	$retval="<button class='btn $color' ";
	if ($onclick) {
		$retval.=" type='button' ";
		$retval.="onclick=\"" . $onclick . "\"";
	}
	if ($id) {
		$retval.= " id='$id' ";
	}
	$retval.=">$label</button>";
	return $retval;
}
function renderTextArea($showLabel,$fieldName,$currentValue,$title,$width='200px',$readOnly=0) {
	$retval="";
	$retval.="<div style='clear: both;'></div>";
	$retval=renderStartItem($showLabel,$fieldName,$title);
	$retval.= "<textarea class='wysihtml5 m-wrap span12' style='background-color: white; width: $width;' name='$fieldName' id='$fieldName' rows='5' ";
	if ($readOnly) {
		$retval.=" disabled readonly ";
	}
	$retval.=" '>";
	$retval.= stripslashes($currentValue);
	$retval.= "</textarea>\n";
	$retval.=renderEndItem();
	return $retval;

}
function renderTextList($fieldName,$currentValue,$title,$itemlist,$readOnly=0) {
	$retval=renderStartItem(TRUE,$fieldName,$title);
	$itemcount=count($itemlist);
	$retval.="<input type='text' name='$fieldName' id='$fieldName' value='$currentValue' data-provide='typeahead' data-min-length='4' autocomplete='off' data-items='$itemcount' data-source=\"" . str_replace('"','&quot;',json_encode($itemlist)) . "\" ";
	if ($readOnly) {
		$retval.=" disabled readonly ";
	}
	$retval.=" >";
	$retval.=renderEndItem();
	return $retval;
}

function renderTextBox($showLabel,$fieldName,$currentValue,$title="",$align="left",$onchange="",$readOnly=0) {
	global $db;
	$retval=renderStartItem($showLabel,$fieldName,$title);
	$retval.= "<input type='text' style='background-color: white; ";
	if ($align == 'right') {
		$retval.="text-align: right; ";
	}
	$retval.="' ";
	if ($readOnly) {
		$retval.=" disabled readonly ";
	}
	if ($onchange) {
		$retval.=" onchange=\"$onchange\" ";
	}
	$retval.=" name='$fieldName' id='$fieldName' class='form-control'  value=\"";
	$retval.= htmlspecialchars(stripslashes($currentValue));
	if ($fieldName=='url')
	{
		$retval.= "\" onfocus=\"updateURL(this);";
	}
	$retval.= "\">";
	if ($fieldName=='email_address') {
		$retval.="<a href=\"javascript:testEmail($('#$fieldName').val(),'email');\"><button class='btn btn-primary' >Send Test</button></a>";
	}
	if ($fieldName=='text_address') {
		$retval.="<a href=\"javascript:testEmail($('#$fieldName').val(),'text');\"><button class='btn-primary' >Send Test</button></a>";
		$sql="select * from sms_domains order  by provider";
		$retval.="<select style=' background-color: white;' onchange='setTextAddress(this.value);'><option value=''>Select Cell Provider</option>";
		list($trs,$err)=runIQuery($db,$sql);
		foreach ($trs as $tdata) {
			$tdomain=$tdata['sms_domain'];
			$tname=$tdata['provider'];
			$retval.="<option value='$tdomain'>$tname</option>";
		}
		$retval.="</select>";
	}
	$retval.=renderEndItem();
	return $retval;
}

function renderNumbers($showLabel, $fieldName, $currentValue, $minValue, $maxValue, $title, $align = "left", $onchange = "",$readOnly=0) {
    $retval = renderStartItem($showLabel, $fieldName, $title);
    $val = htmlspecialchars(stripslashes($currentValue));
    $retval .= "<input type='number' class='form-control' min='$minValue' max='$maxValue' name='$fieldName' value='$val' onchange='$onchange' style='background-color: white; ";
    if ($align == 'right') {
        $retval.="text-align: right; ";
    }
    $retval .= "' ";
	if ($readOnly) {
		$retval.=" disabled readonly ";
	}
	if ($onchange) {
		$retval.=" onchange=\"$onchange\" ";
	}
	$retval.=" >";
    $retval .= renderEndItem();
    return $retval;
}

function renderPassword($showLabel,$fieldName,$currentValue,$title) {
	$retval=renderStartItem($showLabel,$fieldName,$title);
	$retval.= "<input class='form-control' style=' background-color: white;' type='text'  name='$fieldName' id='$fieldName' value='' placeholder='Password'>";
	$retval.= "<span class='help-block'>Enter new one to set, blank keeps existing.</span>";
	$retval.="<span onclick='document.getElementById('pwfield').style.display='inline'></span>";
	$retval.="<span id='pwfield' style='display: none;'>" . decrypt($currentValue,"4439448") . "</span>";
	$retval.=renderEndItem();
	return $retval;
}
function renderSelect($showLabel,$fieldName,$currentValue,$title,$fieldType,$optionList,$allowZero=0,$onchange="",$readOnly=0) {
	$retval=renderStartItem($showLabel,$fieldName,$title);
	$retval.= "<select class='form-control chosen-select'  id='$fieldName' name='$fieldName'   style='background-color: white;' ";
	if ($readOnly) {
		$retval.=" disabled readonly ";
	}
	if ($onchange) {
		$retval.=" onchange=\"$onchange\" ";
	} else {
		if ($fieldName=='item_id') {
			$retval.=" onchange='changeItem(this.value);' ";
		}
	}
	$retval.=">\n";
	if ($allowZero) {
		$retval.=renderOptions($optionList,$currentValue,TRUE,FALSE);
	} else {
		$retval.=renderOptions($optionList,$currentValue,FALSE,FALSE);
	}
	 $retval.="</select>";
	$retval.=renderEndItem();
	return $retval;
}

function renderStartItem($showLabel,$fieldName,$title,$width="span3") {
	if (! $showLabel) {
		$width="span1";
	}
	$retval="<div class='$width'>\n";
	$retval.="<div class='control-group span11'>\n";
	if ($showLabel) {
		$retval.="<label class='control-label' for='$fieldName'>";
		if ($showLabel) {
			$retval.= $title;
		}
		$retval.="</label>\n";
	}
	$retval.="<div class='controls'>\n";
	return $retval;
}

function renderEndItem() {
	$retval="\n</div>\n";
	$retval.="</div>\n";
	$retval.="</div>\n";
	return $retval;
}

function renderFile($showLabel,$fieldName,$currentValue,$title) {
	$retval=renderStartItem($showLabel,$fieldName,$title);
	$retval.= "<input type='file' name='$fieldName' id='$fieldName' >";
	$retval.=renderEndItem();
	return $retval;
}

function renderCheckBox($showLabel,$fieldName,$currentValue,$title,$readOnly=0,$onchange="") {
	$retval=renderStartItem($showLabel,$fieldName,$title);
	$retval.= "<input type=checkbox id='$fieldName' class='form-control' name='$fieldName'  value='1'  ";
	if ($currentValue) { $retval.= " checked "; }
	if ($readOnly) {
		$retval.=" disabled readonly ";
	}
	if ($onchange) {
		$retval.=" onchange='$onchange' ";
	}
	$retval.= ">";
	$retval.=renderEndItem();
	return $retval;
}

function renderDateBox($showLabel,$fieldName,$currentValue,$title,$readOnly=0) {
	$retval=renderStartItem($showLabel,$fieldName,$title);
	$retval.= "<input style='background-color: white;' type='text' class='form-control datepicker' name='$fieldName' id='$fieldName' value='";
	if (formatDateDBtoWeb($currentValue)=="") {
		$retval.=$currentValue;
	} else {
		$retval.= formatDateDBtoWeb($currentValue);
	}
	$retval.= "' ";
	if ($readOnly) {
		$retval.=" disabled readonly ";
	}
$retval.=">";
	$retval.=renderEndItem();
	return $retval;
}

function renderTimePickerRaw($fieldName,$currentValue) {
    $retval="<div class='bootstrap-timepicker'><input id='$fieldName' name='$fieldName' type='text' value='$currentValue' class='form-control timepicker'/></div>";
    return $retval;

}
function renderTimePicker($showLabel,$fieldName,$currentValue,$title) {
	$retval=renderStartItem($showLabel,$fieldName,$title);
	$retval.=renderTimePickerRaw($fieldName,$currentValue);
	$retval.=renderEndItem();
	return $retval;
}



function renderEdit($db,$table,$key,$id,$columns,$masterfield="",$masterkey="") {
	global $userID;
	$retval="";
	$sql="select * from $table where $key=$id";
	$rs=mysqli_query($db,$sql);
	$data=mysqli_fetch_array($rs);
	$usingimage=0;
	$usingdoc=0;
	$usingpublished=0;
	$margin="";
	$rowUsed=0;
	$gotItemList=0;
	foreach ($columns as $col)
	{
		$specialLookup="";
		$fnidx=$col['fn_idx'];
		$fieldName=$col['field_name'];
		if ($fieldName != $masterfield) {
			$default=$col['default_value'];
			if (substr($default,0,5)=='where') {
				$specialLookup=$default;
				$default="";
			}
			$default=str_replace("today()",Date('Y-m-d'),$default);
			$default=str_replace("now()",Date('Y-m-d H:i:s'),$default);
			$default=str_replace("startofmonth()",Date('Y') . "-" . Date("m") . "-01",$default);
			$default=str_replace("endofmonth()",Date('Y') . "-" . Date("m") . "-" . Date('t'),$default);
			$default=str_replace("currentUser()",$userID,$default);
			$size=$col['field_size'];
			$usingPX=false;
			if (strpos($size,"px")<0) {
				$fieldSetSize=$size*5;
				if ($fieldSetSize > 60) {
					$fieldSetSize=92;
				} else {
					if ($fieldSetSize > 48 ) {
						$fieldSetSize=48;
					}
				}
				$fieldSetSize.="%";
			} else {
				$usingPX=true;
				$fieldSetSize=$size;
			}
			if ( $col['field_type']=='B') {
				$fieldSetSize="80";
			}
	 		if ($id!=0)
			{
				$default=$data[$fieldName];
			}
			$special_field=0;
			$margin="";
			if ($col['field_type']=='text' or $col['field_type']=='T') {

				$retval.="<div class='span6 '>\n";
				$retval.="<div class='control-group'>\n";
				$retval.="<label class='control-label' for='$fieldName'>";
				$rowUsed=0;
			} else {
				if (! $usingPX) {
					if ($rowUsed + $fieldSetSize+2 > 99) {
						if ($rowUsed+$fieldSetSize < 100) {
							$margin="";
							$rowUsed+=$fieldSetSize;
						} else  {
							## new line
							$margin="margin-right: 2%;";
							$rowUsed=$fieldSetSize+2;
						}
					} else {
							$margin="margin-right: 2%;";
							$rowUsed+=$fieldSetSize+2;
					}
				} else {
					$margin="margin-right: 2%;";
				}
				$retval.="<div class='span3 '>\n";
				$retval.="<div class='control-group'>\n";
				$retval.="<label class='control-label' for='$fieldName'>";
			}
			$retval.= $col['title'];
			$retval.="</label>\n";
		    $retval.="<div class='controls'>\n";
			if ($col['field_type']=='file')
			{
				$usingdoc=1;
				if ($id > 0) {
					$retval.= "<div id='docpreview' style='display: inline; float: right;'>";
					$retval.= "<BR><a href='javascript:viewDocument();'>View</a>";
					$retval.= "<br>Link: /viewDocument.php?document=$id";
					$retval.= "</div>";
				} else {
					$retval.= "<div id='docpreview' style='display: none; float: right;'>";
					$retval.= "<BR><a href='javascript:viewDocument();'>View</a>";
					$retval.= "</div>";
				}
				$retval.= "<input style='float: right;' type=file name='doc_file' id='doc_file' style='width: 92%;'>";
				$special_field=1;
			}
			if ($col['field_type']=='text')
			{
				if ($fieldName == 'notes') {
					print"<div id='above_notes'></div>";
				}
				$retval.= "<div style='position: relative; top: 20px;'><textarea style='background-color: white;' id='$fieldName' name='$fieldName' class='wysihtml5 m-wrap span12' rows=20>";
				$retval.= stripslashes($data[$fieldName]);
				$retval.= "</textarea></div>";
				$special_field=1;
			}
			if ($fieldName=='child_item') {
				$itemlist=array();
				if (! $gotItemList) {
					$sql="select item_name from items where coalesce(under_review,0)=0 and status=1 order by item_name ";
					$irs=mysqli_query($db,$sql);
					while ($idata=mysqli_fetch_array($irs)) {
						$itemlist[]=$idata['item_name'];
					}
					$itemcount=count($itemlist);
				}
				$retval.="<input type='text' id='$fieldName' name='$fieldName' data-provide=	'typeahead' data-min-length='2' autocomplete='off' data-items='15' data-source=\"" . str_replace('"','&quot;',json_encode($itemlist)) . "\" value=\"" . htmlspecialchars($data[$fieldName]) . "\" onchange='checkChildPartChanged();'>";
				$special_field=1;
			}
			if ($fieldName=='display_sequence' or $fieldName=='runseq') {
				if (! isset($data[$fieldName])) {
					$sql="select max($fieldName) as maxseq from $table where  $key=$id";
					$irs=mysqli_query($db,$sql);
					$nextSeq=10;
					$idata=mysqli_fetch_array($irs);
					if ($idata['maxseq']) {
						$nextSeq=$idata['maxseq']+10;
					}
				} else {
					$nextSeq=$data[$fieldName];
				}
				$retval.="<input type='text' id='$fieldName' name='$fieldName'  value='$nextSeq'>";
				$special_field=1;
			}
			if ($col['lookup_table']!="" and ! $special_field)
			{
				if ($fieldName != 'lead_id') {
					$retval.= "<select id='$fieldName' name='$fieldName' style='width: 92%;' ";
					if ($fieldName=='item_id') {
						$retval.=" onchange='changeItem(this.value);' ";
					}
					$retval.=">\n";
					if ($col['allow_zero'])
					{
						if ($col['field_type']=='N') {
							$retval.= "<option value='0'>Not Selected</option>\n";
						} else {
							$retval.= "<option value=''>Not Selected</option>\n";
						}
					}
				}
				$lk=$col['lookup_table'];
				$rf=$col['return_field'];
				$lf=$col['lookup_field'];
				if ($lf==$rf) {
					$sql="select distinct $rf from $lk ";
					if ($lk=='employee_link') {
						$sql.=" where coalesce(inactive,0)=0 ";
					}
					if ($lk=='employees') {
						$sql.=" where coalesce(inactive,0)=0 ";
					}
					if ($lk=='site_admins') {
						$sql.=" where coalesce(inactive,0)=0 ";
					}
					$sql.=" order by $rf ";
					$crs=mysqli_query($db,$sql);
					if (mysqli_error($db)) {
						$retval.= "$sql<BR>" . mysqli_error($db);
					}
					while ($cdata=mysqli_fetch_array($crs))
					{
						$show=$cdata[0];
						$val=$cdata[0];
						if ($fieldName=='lead_id') {
							$retval.=$show;
						} else {
							if ($val==$default)
							{
								$retval.= "<option selected value='$val'>$show</option>";
							}
							else {
								$retval.= "<option value='$val'>$show</option>";
							}
						}
					}
				} else {
					$sql="select distinct $lf, $rf from $lk ";
					if ($specialLookup) {
						$sql.=str_replace("?","'" . $masterkey . "'",$specialLookup);
					}
					if ($lk=='employee_link') {
						$sql.=" where coalesce(inactive,0)=0 ";
					}
					if ($lk=='employees') {
						$sql.=" where coalesce(inactive,0)=0 ";
					}
					if ($lk=='site_admins') {
						$sql.=" where coalesce(inactive,0)=0 ";
					}

					$sql.=" order by $rf ";
					$crs=mysqli_query($db,$sql);
					if (mysqli_error($db)) {
						print mysqli_error($db);
						print $sql . "<BR>";
					}
					while ($cdata=mysqli_fetch_array($crs))
					{
						$show=$cdata[1];
						$val=$cdata[0];
						if ($fieldName=='lead_id') {
							$retval.=$show;
						} else {
							if ($val==$default)
							{
								$retval.= "<option selected value='$val'>$show</option>";
							}
							else {
								$retval.= "<option value='$val'>$show</option>";
							}
						}
					}
				}
				if ($fieldName!="lead_id") {
					$retval.= "</select>";
				}
				$special_field=1;
			}
			if ($col['field_type']=='N' and ! $special_field)
			{
				$retval.= "<input type='text'  style='text-align: right; width: 60%;' name='$fieldName' id='$fieldName' value='$default'>";
				$special_field=1;
			}
			if ($col['field_type']=='D' or $col['field_type']=='date')
			{
				$retval.= "<input type='text' name='$fieldName' id='$fieldName' style='width: 92%;' value='";
				$retval.= formatDateDBtoWeb($default);
				$retval.= "'>";
				$retval.= "<script>$('#$fieldName').datepicker();</script>\n";
				## add date picker
				$special_field=1;
			}
			if ($fieldName=='image_name' or $col['field_type']=='image')
			{
				$usingimage=1;
				$retval.= "<input type='text' style='display: inline;' name='$fieldName' id='$fieldName' onchange='removeSpaces(this);' value='";
				$retval.= $data[$fieldName];
				$retval.= "'>";
				$retval.= "<div id='preview' style='display: inline; float: right;'>";
				$testfile="../cms_images/" . $data[$fieldName] . ".png";
				$rand="?rand=" .rand();
				$retval.= "<a href='$testfile$rand' class='thumb'><img id='thumb' title='" . $data[$fieldName] . "' width='100px;' ";
				if (file_exists($testfile))
				{
					$retval.= "src='$testfile?rand=" . rand() . "'";
				}
				else {
					$retval.= "style='display: none;'";
				}
				$retval.= "></a></div>";
				$retval.= "<input style='float: right;' type=file name='image_file' id='image_file'>";
				$special_field=1;
			}
			if (! $special_field)
			{
				if ($fieldName=='published')
				{
					$usingpublished=1;
				}
				else {
					if ($col['field_type']=='T') {
						$retval.= "<textarea name='$fieldName' id='$fieldName' rows='15' class='wysihtml5 m-wrap span12' style='background-color: white; width: 92%;'>";
						$retval.= $data[$fieldName];
						$retval.= "</textarea>";
					} else {
						$retval.= "<input type='text' name='$fieldName' id='$fieldName' style='width: 92%;' value=\"";
						$retval.= htmlspecialchars(stripslashes($data[$fieldName]));
						if ($fieldName=='url')
						{
							$retval.= "\" onfocus=\"updateURL(this);";
						}
						$retval.= "\">";
					}
				}
			}
			$retval.="\n</div><!-- control -->";
			$retval.="</div><!-- control group -->\n";
			$retval.="</div><!-- span3 -->\n";
		}
	}
	return array($retval,$usingimage,$usingdoc,$usingpublished,$margin,$rowUsed);
}

function SendVendorEmail($db,$mail,$vendor,$subject,$message,$userName,$userEmail,$userGmailPassword) {
	$sql="select email, vendor_name from vendors where vendor_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$vendor));
	$data=$rs[0];
	$toemail=$data[0];
	$toname=$data[1];
	$toemail="callen@preferredmachinellc.com";
	$toname="Chris Allen";
	$mail->IsSMTP();
	$mail->SMTPDebug  = 0;
	$mail->Debugoutput = 'html';
	$mail->Host       = 'smtp.gmail.com';
	$mail->Port       = 465;
	$mail->SMTPSecure = 'ssl';
	$mail->SMTPAuth   = true;
	$mail->Username   = $userEmail;
	//Password to use for SMTP authentication
	$mail->Password   = $userGmailPassword;
	$mail->SetFrom($userEmail,$userName );
	$mail->AddReplyTo($userEmail,$userName);
	foreach (explode(",",$toemail) as $address) {
		if (strstr($address,"<")) {
			list($toname,$emailto)=explode("<",$address);
			$emailto=str_replace(">","",$emailto);
		} else {
			$emailto=$address;
		}
		$mail->AddAddress($emailto,$toname);
	}
	$mail->AddAddress("jsheridan@preferredmachinellc.com","Jeff Sheridan");
	$mail->Subject = $subject;
	$text=str_replace("<br>","\n",$message);
	$text=str_replace("<BR>","\n",$text);
	$text=str_replace("<p>","\n",$text);
	$text=str_replace("<P>","\n",$text);
	$text=str_replace("</p>","\n",$text);
	$text=str_replace("</P","\n",$text);
	$text=strip_tags($text);
	$mail->AltBody = $text;
	$mail->MsgHTML($message);
	if(!$mail->Send()) {
		if(!$mail->Send()) {
			if(!$mail->Send()) {
				print "Error";
			} else {
				print "Message Sent on 3rd try";
			}
		} else {
			print "Message Sent on 2nd try";
		}
	} else {
		print "Message Sent";
	}
}

function SendEmail($db,$mail,$subject,$message,$toemail,$userName,$userEmail,$userGmailPassword) {
	$mail->IsSMTP();
	$mail->SMTPDebug  = 0;
	$mail->Debugoutput = 'html';
	$mail->Host       = 'smtp.gmail.com';
	$mail->Port       = 465;
	$mail->SMTPSecure = 'ssl';
	$mail->SMTPAuth   = true;
	$mail->Username   = $userEmail;
	//Password to use for SMTP authentication
	$mail->Password   = $userGmailPassword;
	$mail->SetFrom($userEmail,$userName );
	$mail->AddReplyTo($userEmail,$userName);
	foreach (explode(",",$toemail) as $address) {
		if (strstr($address,"<")) {
			list($toname,$emailto)=explode("<",$address);
			$emailto=str_replace(">","",$emailto);
		} else {
			$emailto=$address;
		}
		$mail->AddAddress($emailto,$toname);
	}
	$mail->Subject = $subject;
	$text=str_replace("<br>","\n",$message);
	$text=str_replace("<BR>","\n",$text);
	$text=str_replace("<p>","\n",$text);
	$text=str_replace("<P>","\n",$text);
	$text=str_replace("</p>","\n",$text);
	$text=str_replace("</P","\n",$text);
	$text=strip_tags($text);
	$mail->AltBody = $text;
	$mail->MsgHTML($message);
	if(!$mail->Send()) {
		if(!$mail->Send()) {
			if(!$mail->Send()) {
				print "Error Sending Message";
			} else {
			}
		} else {
		}
	} else {
	}
}

function renderOptions($result,$selectedValue,$renderEmpty = false,$showKey=false) {
	global $scriptid, $debug;
	$retval="";
	if ($renderEmpty) {
		$retval="<option value=0>Not Selected</option>";
	}
	if (gettype($result)=="boolean") {
		error_log("This $result is boolean script is $scriptid");
	}
	if (gettype($result)=="array") {
		//error_log("This $result is array script is $scriptid");
	}

	// Allow mysqli results OR array for now until we get rid of all mysqli_query's
	if (gettype($result)=="array") {
		foreach ($result as $roData) {
			$key=$roData[0];
			$show=$roData[1];
			if ($key==$selectedValue) {
				$retval.="<option value='$key' selected>$show";
			} else {
				$retval.="<option value='$key'>$show";
			}
			if ($showKey) {
				$retval.="($key)";
			}
			$retval.="</option>";
		}
	} else {
		while ($roData=mysqli_fetch_array($result)) {
			$key=$roData[0];
			$show=$roData[1];
			if ($key==$selectedValue) {
				$retval.="<option value='$key' selected>$show";
			} else {
				$retval.="<option value='$key'>$show";
			}
			if ($showKey) {
				$retval.="($key)";
			}
			$retval.="</option>";
		}
	}

	return $retval;
}
function getSectionInfo($sectionName,$userID,$db) {
	$columns=array();
	$sql="select * from table_names where table_title='$sectionName'";
	$rs=mysqli_query($db,$sql);
	$data=mysqli_fetch_array($rs);
	$table=$data['table_name'];
	$key=$data['key_field'];
	$preview=$data['show_preview'];
	if (! $preview) {
		$preview=false;
	} else {
		$preview=true;
	}
	$order=$data['default_order'];
	$sql="select field_names.* from field_names left outer join user_display_sequence on user_id=1 and tn_idx=fn_idx and sequence_type='field' where table_name='$table' ";
	$sql.=" and key_field=0 ";
	$sql.=" order by coalesce(user_display_sequence.display_sequence,999), field_names.display_sequence";
	$i=1;
	$rs=mysqli_query($db,$sql);
	if (mysqli_error($db)) {
		print "$sql<BR>";
		print mysqli_error($db);
	}
	while ($data=mysqli_fetch_array($rs)) {
		if ($data['field_name'] == $order) {
			$columns[0]=$data;
		} else {
			$columns[$i]=$data;
			$i++;
		}
	}
	return array($key,$table,$order,$columns,$preview);
}

function getFieldTitle($db,$table,$field) {
	$sql="select title from field_names where table_name='$table' and field_name='$field' ";
	$rs=mysqli_query($db,$sql);
	$data=mysqli_fetch_array($rs);
	return $data['title'];
}
function renderList($sectionName,$userID,$db,$tablesql,$renderSearch,$inline=false) {
	list($key,$table,$order,$columns,$showPreview)=getSectionInfo($sectionName,$userID,$db);
	$sql="select * from admin_access where user_id=$userID and table_name='$table' and allow_view=1";
	$rs=mysqli_query($db,$sql);
	$data=mysqli_fetch_array($rs);
	$allow_edit=$data['allow_edit'];
	$allow_delete=$data['allow_delete'];
	$allow_view=$data['allow_view'];
	$sql="select * from agents where user_id=$userID";
	$rs=mysqli_query($db,$sql);
	$data=mysqli_fetch_array($rs);
	$isAdmin=$data['is_admin'];
	$sql="select * from table_names where table_name='$table' ";
	$rs=mysqli_query($db,$sql);
	$data=mysqli_fetch_array($rs);
	$editpage=$data['special_edit_page'];
	if (! $editpage) {
		$editpage='index.php';
	}
	$retval="";
	$dataRows=array();
	$hasSequence=0;
	$preview=0;
	$targetWindow="self";
	if (! $renderSearch) {
		$targetWindow="editRec";
	}
	foreach ($columns as $col)
	{
		if ($col['title']=='Display Sequence') {
			$hasSequence=1;
		}
		if ($col['field_type']=='text') {
			$preview=1;
		}
	}
	if (! $showPreview) {
		$preview=0;
	}
	if ($allow_view) {
		$retval.="<article class='module width_full'>\n";
		$retval.="<header><h3 class='tabs_involved'>$sectionName</h3>\n";
		$retval.="<ul class='tabs'>\n";
		if ($renderSearch) {
			$retval.="<li><a href='$editpage" . "?section=$sectionName&action=edit&id=0";
			if ($inline) {
				$retval.="&from=inline";
			} else {
				$retval.="&from=view";
			}
			$retval.="'>Add New</a></li>\n";
			if ($inline) {
				$retval.="<li><a href='index.php?section=$sectionName&action=view'>View List</a></li>\n";				} else {
				$retval.="<li><a href='index.php?section=$sectionName&action=inline'>Edit List</a></li>\n";							}
		} else {
			if ($inline) {
				$retval.="<li><a href='$editpage" . "?section=$sectionName&action=edit&id=0";
				if ($inline) {
					$retval.="&from=inline";
				} else {
					$retval.="&from=view";
				}
				$retval.="' target='_blank'>Add New</a></li>\n";
				if ($inline) {
					$retval.="<li><a href='index.php?section=$sectionName&action=view' target='_blank' rel='opener'>>View List</a></li>\n";
				} else {
					$retval.="<li><a href='index.php?section=$sectionName&action=inline' target='_blank' rel='opener'>>Edit List</a></li>\n";
				}
			}
		}
		if ($inline) {
			if ($hasSequence) {
				$retval.="<li><a href='reSequence.php?section=$sectionName&sql=$tablesql' target='_blank' rel='opener'>Sequence</a></li>\n";
			}
		}
		$retval.="</ul>\n";
		$retval.="</header>\n";
		$retval.="<div class='tab_container'>\n";
		$retval.="<div id='tab1' class='tab_content'>\n";
		$retval.="<table class='tablesorter' cellspacing='0'> \n";
		$retval.="<thead> \n";
		$retval.="<tr> \n";
		if ($preview) {
			$retval.="<th>Preview</th>\n";
		}
		$colcount=0;
		foreach ($columns as $col)
		{
			if ($colcount < 5 or $inline)
			{
				$retval.="<th>";
				$retval.=$col['title'];
				$retval.="</th>\n";
				$colcount++;
			}
		}
		if ($renderSearch or $inline) {
			$retval.="<th style='width: 120px;'>Actions</th> \n";
		}
		$retval.="</tr>\n";
		if ($renderSearch) {
			$retval.="<tr >\n";
			$colcount=0;
			foreach ($columns as $col)
			{
				if ($colcount < 5 or $inline)
				{
					$retval.="<td valign=top>";
					if ($col['field_type']!='text' and $col['field_type']!='file') {
						$fieldName=$col['field_name'];
						$sql="select distinct $fieldName, $fieldName as show_value from $table order by $fieldName ";
						if ($col['lookup_table']!="") {
							$lk=$col['lookup_table'];
							$rf=$col['return_field'];
							$lf=$col['lookup_field'];
							$sql="select distinct $lf, $rf from $lk ";
							$sql.=" order by $rf ";
						}
						$rs=mysqli_query($db,$sql);
						if (mysqli_error($db)) {
							print "$sql<BR>" . mysqli_error($db);
						}
						$retval.="<select name='search_$fieldName' id='search_$fieldName' onchange='filterList();'>";
						$retval.="<option value=''>All</option>";
						$retval.=renderOptions($rs,"",false,false);
						$retval.="</select>";
						$retval.="<script>if (parseInt(document.getElementById('search_$fieldName').style.width) > 200) { document.getElementById('search_$fieldName').style.width='200px'; }</script>\n";
					} else {
						$fieldName=$col['field_name'];
						$retval.="<select name='search_$fieldName' id='search_$fieldName' disabled>";
						$retval.="<option value=''>----</option>";
						$retval.="</select>";
					}
					$retval.="</td>\n";
					$colcount++;
				}
			}
			$retval.="<td>";
			if ($inline) {
				$retval.="<div onclick=\"addRecord('$table','$fieldName');\"><img src='images/icn_new_article.png' border='0' title='Add Record'></div>";
			}
			$retval.="&nbsp;</td>\n";
			$retval.="</tr>\n";
		}
		$retval.="</thead>\n";
		$retval.="<tbody>\n";
		$rs=mysqli_query($db,$tablesql);
		if (mysqli_error($db))
		{
			$retval.="$sql<BR>";
			$retval.=mysqli_error($db);
		}
		while ($data=mysqli_fetch_array($rs))
		{
			$dataRows[]=$data;
			$keyval=$data[$key];
			$colcount=0;
			$retval.="<tr class='datarow' id='datarow$keyval'>";
			if ($preview) {
				$previewHTML="";
				foreach ($columns as $col) {
					$fieldName=$col['field_name'];
					if ($col['field_type']=='text') {
						$previewHTML.=$data[$fieldName];
					}
				}
				$retval.="<td valign='top'>";
				$retval.="<a href='#$table$keyval' class='sidebar-fullview' style='color: black; text-decoration: none;'>";
				$retval.="<div class='sidebar-preview' >";
				$retval.=$previewHTML;
				$retval.="</div>";
				$retval.="</a>";
				$retval.="<div style='display: none;'><div id='$table$keyval'>$previewHTML</div></div>";
				$retval.="</td>";
			}
			foreach ($columns as $col)
			{
				$special_field=0;
				$fieldName=$col['field_name'];
				if ($colcount < 5 or $inline)
				{
					$retval.="<td valign=top ";
					if ($col['field_type']=='N' and $col['lookup_table']=="") {
						$retval.=" align='right' ";
					}
					if ($col['field_type']=='B') {
						$retval.=" align='center' ";
					}
					$retval.=">";
					if ($col['field_type']=='text')
					{
						$retval.=substr(strip_tags($data[$fieldName]),0,50) . "...";
						$special_field=1;
					}
					if ($col['lookup_table']!="")
					{
						$lk=$col['lookup_table'];
						$rf=$col['return_field'];
						$lf=$col['lookup_field'];
						if ($lf==$rf and ! $inline) {
							$retval.=$data[$fieldName];
						} else {
							if ($inline) {
								$retval.="<select onfocus=\"globalObj=this;oldvalue='" . $data[$fieldName] . "';\" onchange=\"updateRecord('$table','$fieldName','$key','$keyval',this.value);\">";
								$sql="select $lf, $rf from $lk order by $rf ";
								$lkrs=mysqli_query($db,$sql);
								if (mysqli_error($db)) {
									print "$sql<BR>" . mysqli_error($db);
								}
								$retval.=renderOptions($lkrs,$data[$fieldName]);
								$retval.="</select>";
								} else {
								$sql="select $lf, $rf from $lk where $lf='" . $data[$fieldName] . "' ";
								$crs=mysqli_query($db,$sql);
								$cdata=mysqli_fetch_array($crs);
								$retval.=$cdata[1];
								$lkpreview="";
								$sql="select table_title from table_names where table_name='$lk'";
								$lkrs=mysqli_query($db,$sql);
								$lkdata=mysqli_fetch_array($lkrs);
								list($lkkey,$lktable,$lkorder,$lkcolumns,$lkshowPreview)=getSectionInfo($lkdata['table_title'],$userID,$db);
								if ($lkshowPreview) {
									$sql="select * from $lk where $lf='" . $data[$fieldName] . "' ";
									$lkrs=mysqli_query($db,$sql);
									$lkdata=mysqli_fetch_array($lkrs);
									foreach ($lkcolumns as $lkcol) {
										$lkfieldName=$lkcol['field_name'];
										if ($lkcol['field_type']=='text') {
											$lkpreview.=$lkdata[$lkfieldName];
										}
									}
								}
								if ($lkpreview) {
									$retval.="<BR>";
									$retval.="<a href='#$table$keyval-$colcount' class='sidebar-fullview' style='color: black; text-decoration: none;'>";
									$retval.="<div class='sidebar-preview'  >";
									$retval.=$lkpreview;
									$retval.="</div>";
									$retval.="</a>";
									$retval.="<div style='display: none;'><div id='$table$keyval-$colcount'>$lkpreview</div></div>";
								}
							}
						}
						$special_field=1;
					}
					if ($col['field_type']=='B')
					{

						if ($inline) {
							$retval.="<div class='switch' data-on='success' data-off='danger'>";
							$retval.="<input class='toggle' type=checkbox ";
							if ($data[$fieldName]) {
								$retval.= " checked ";
							}
							$retval.= " onclick=\"updateRecord('$table','$fieldName','$key','$keyval',this.checked);\">";
							$retval.="</div>\n";
						} else {
							if ($data[$fieldName])
							{
								$retval.="Y";
							}
							else {
								$retval.="N";
							}
						}
						$special_field=1;
					}
					if ($col['field_type']=='D' or $col['field_type']=='date')
					{
						if ($inline) {
							$retval.="<input type='text'  onfocus=\"globalObj=this;oldvalue='" . $data[$fieldName] . "';\" value='" . formatDateDBToWeb($data[$fieldName]) . "' size='10' class='date-picker' onchange=\"updateRecord('$table','$fieldName','$key','$keyval',this.value);\">";
						} else {
							$retval.=formatDateDBToWeb($data[$fieldName]);
						}
						$special_field=1;
					}
					if (! $special_field)
					{
						if ($col['field_type']!='file') {
							if ($inline) {
							$size=$col['field_size'];
							if ($size > 15) {
								$size=15;
							}
								$retval.="<input type='text' value='" . $data[$fieldName] . "' size='$size' onfocus=\"globalObj=this;oldvalue='" . $data[$fieldName] . "';\" onchange=\"updateRecord('$table','$fieldName','$key','$keyval',this.value);\">";
							} else {
								$retval.=$data[$fieldName];
							}
						}
					}
					$retval.="</td>";
					$colcount++;
				}
			}
			$icon="icn_edit";
			$alt="Edit";
			if (! $allow_edit)
			{
				$icon="icn_search";
				$alt="View";
			}
			if ($renderSearch or $inline) {
				$retval.="<td valign='top'><div style='cursor: pointer; display: inline;' onclick=\"editRecord('$sectionName','$keyval','$targetWindow');\"><input border='0' type='image' src='images/$icon.png' title='$alt' alt='$alt'></div>";
				if ($inline and $allow_edit) {
					$retval.="<div style='cursor: pointer; display: inline;' onclick=\"copyRecord('$sectionName','$key','$keyval');\"><img src='images/icon_copy.png' border='0' title='Copy Record'> </div>";
				}
				if ($allow_delete)
				{
					$retval.="<div style='cursor: pointer; display: inline;' onclick=\"deleteRecord('$key','$table','$keyval');\"><input type='image' src='images/icn_trash.png' title='Delete' border='0'>";
				}
			}
			$retval.="</td></tr>\n";
		}
		$retval.="</tbody></table></div></div></article>\n";
	}
	return array($retval,$dataRows);
}


## this expects to return one record matching the key (uses default key field if nothing passed)

function getRecordData($db,$id,$table,$key="") {
	if ($key=="") {
		$sql="select key_field from table_names where table_name=?";
		list($rs,$err)=runIQuery($db,$sql,array("s",$table));
		$data=$rs[0];
		$key=$data[0];
	}
	$sql="select * from " . cleanText($table) . " where $key=?";
	list($rs,$err)=runIQuery($db,$sql,array("s",$id));
	return $rs[0];
}

function getTableInfo($db,$table) {
	$sql="select * from table_names where table_name=?";
	list($rs,$err)=runIQuery($db,$sql,array("s",$table));
	return $rs[0];
}


function getOpenOrders($db,$forShipping=false,$startdate="",$enddate="",$customerID=0) {
	$sql="select * from orders where 1 > 0";
	if ($forShipping) {
		## shipped and cancelled
		$sql.=" and status not in (4,5) ";
	} else {
		## complete, shipped, cancelled
		$sql.=" and status not in (3,4,5) ";
	}
	if ($startdate) {
		$sql.=" and date_due >= '$startdate' ";
	}
	if ($enddate) {
		$sql.=" and date_due <= '$enddate' ";
	}
	if ($customerID) {
		$sql.=" and customer_id=$customerID";
	}
	$sql.=" order by date_due=curdate() desc, date_due desc, customer_id";
	list($rs,$err)=runIQuery($db,$sql);
	return $rs;
}

function showOneValue($sql,$db) {
	$rs=mysqli_query($db,$sql);
	$viewdata=mysqli_fetch_array($rs);
	return $viewdata[0];
}

function getItemData($db,$itemID,$vendor=0) {
	$sql="select items.*, uom_name from items left outer join units_of_measure on unit_of_measure=uom_id where item_id=? or item_name=? order by item_name=? desc";
	list($girs,$err)=runIQuery($db,$sql,array("sss",$itemID,$itemID,$itemID));
	$gidata=$girs[0];
	if ($vendor and $vendor != $gidata['vendor_id']) {
		## get from vendor
		$sql="select vendor_description from items_vendors where item_id=? and vendor_id=?";
		$itemID=$gidata['item_id'];
		list($givrs,$err)=runIQuery($db,$sql,array("ii",$itemID,$vendor));
		if (count($givrs)>0) {
			$givdata=$givrs[0];
			$gidata['vendor_part_number']=$givdata['vendor_description'];
		}
	}
	return $gidata;
}

function getCustomerData($db,$customerID) {
	$sql="select * from customers where customer_id=?";
	list($girs,$err)=runIQuery($db,$sql,array("i",$customerID));
	$gidata=$girs[0];
	return $gidata;
}

function calculateDuration($db,$job) {
	$retval=1;
	## take all operations and add up their durations
	return $retval;
}

function addParents($db,$joblist,$jplist) {
	$newplist=array();
	foreach ($jplist as $child) {
		$sql="select parent_item, quantity_per from billofmaterial where child_item='$child'";
		$rs=mysqli_query($db,$sql);
		print mysqli_error($db);
		while ($data=mysqli_fetch_array($rs)) {
			$pid=$data['parent_item'];
			if (! in_array($pid,$joblist)) {
				$newplist[]=$pid;
			}
		}
	}
	return $newplist;
}
function addToList($db,$itemlist,$processlist) {
	$newplist=array();
	$newqtylist=array();
	foreach ($processlist as $child) {
		$sql="select child_item, quantity_per from billofmaterial where parent_item='$child'";
		$rs=mysqli_query($db,$sql);
		while ($data=mysqli_fetch_array($rs)) {
			$pid=$data['child_item'];
			if (! in_array($pid,$itemlist) and ! in_array($pid,$newplist))
				$newqtylist[$pid]=$data['quantity_per'];
				$newplist[]=$pid;
		}
	}
	return array($newqtylist,$newplist);
}

## bdoss 10/12/22 send an automated email when a specific order is updated to a specific status (called in updateOrderStatus())
function sendReminderEmail($order,$status) {
	global $db, $smtpUser, $smtpPassword, $userEmail;
	require_once 'Mail/class.phpmailer.php';
	$sql="SELECT order_reminders.*, order_status.status_name, customers.name FROM order_reminders
	INNER JOIN order_status ON order_reminders.order_status=order_status.status_id
	INNER JOIN customers ON customers.customer_id=order_reminders.customer
	WHERE sent_on IS NULL AND order_id=? and order_status=?";
	list($rs,$err)=runIQuery($db,$sql,array("ii",$order,$status));

	if ($rs) {
		foreach($rs as $data) { // in case there is more than one automated message for that order and status, prep emails for each
			$customer=$data['name'];
			$reminder=$data['reminder_message'];
			$statusName=$data['status_name'];
			$reminderID=$data['reminder_id'];

			$sql="UPDATE order_reminders SET sent_on=now() WHERE reminder_id=?";
			list($rs,$err)=runIQuery($db,$sql,array("i",$reminderID));

			$sql="SELECT CONCAT(first_name, ' ', last_name) AS full_name, employee_email FROM employees
				INNER JOIN employee_reminders ON employees.employee_id=employee_reminders.employee_id
				WHERE employee_reminders.reminder_id=?";
			list($employees, $err)=runIQuery($db,$sql,array("i",$reminderID));

					$mail = new PHPMailer();
					$mail->IsSMTP();
					$mail->SMTPDebug  = 0;
					$mail->Debugoutput = 'html';
					$mail->Host = "email-smtp.us-east-1.amazonaws.com";
					$mail->Port       =587;
					$mail->SMTPSecure = 'tls';
					$mail->SMTPAuth   = true;
					$mail->Username = $smtpUser;
					$mail->Password   = $smtpPassword;
					$mail->SetFrom($userEmail,"Preferred Machine");
					foreach($employees as $employee) { // send an email to each person listed as a recipient for the automated reminder
						$employeeName=$employee['full_name'];
						$employeeEmail=$employee['employee_email'];
						$mail->AddAddress($employeeEmail,$employeeName);
						// $mail->AddAddress($userEmail,"Test User"); // for TESTING
					}
					$mail->Subject = "Automated Reminder for Order $order and Customer $customer";
					$mail->isHTML(true);
					$message="Order $order for Customer $customer has been updated to the following status: $statusName<br><br>";
					$message.="Automated message:<br>";
					$message.=$reminder;
					$mail->Body = $message;
						if(!$mail->Send()) {
							if(!$mail->Send()) {
								if(!$mail->Send()) {
								echo "Mailer Error: " . $mail->ErrorInfo;
								}
							}
						}
		}
	}
}

// order status activity logging - Josh 02-14-2023
// $onlylog set to 1 if status is updated elsewhere, function MUST be run before the actual update if so
function updateOrderStatusBasic($db,$order,$newStatus,$debug=0,$onlylog=0) {
	global $userEmail;
	if (!isset($userEmail)) {
		$userEmail=0;
	}
	$logfailed=0;
	try { // try/catch for worst case scenario, order update takes priority over order activity log (we have the transaction log anyway)
		$sql="select status from orders where order_id=?";
		list($rs,$err)=runIQuery($db,$sql,["i",$order]);
		if ($debug) {
			print "$err<br>\n";
			print renderQuery($sql,["i",$order]);
			print "<br>\n";
		}
		if (!count($rs)) {
			if ($debug) {
				print "order not found<br>\n";
			}
			return;
		}
		$oldStatus=$rs[0]["status"];
		if ($oldStatus==$newStatus) {
			if ($debug) {
				print "status is the same, no change<br>\n";
			}
			return; // less resource usage
		}
	} catch (Exception $ex) {
		if ($debug) {
			print $ex->getMessage();
			print "<br>\n";
		}
		$logfailed=1;
	}

	// now update the actual status
	$sql = "update orders set status=? where order_id=?";
	if (!$onlylog) {
		list($rs,$err)=runIQuery($db,$sql,["ii",$newStatus,$order]);
		if ($debug) {
			print "$err<br>\n";
			print renderQuery($sql,["ii",$newStatus,$order]);
		}
	}
	//

	try {
		if ($logfailed) { // can't continue without previous information
			return;
		}
		$sql="select status_id, status_name from order_status";
		$status_names = [];
		list($rs,$err)=runIQuery($db,$sql);
		if ($debug) {
			print $err;
			print "<br>\n";
		}
		foreach($rs as $status) {
			$status_names[$status["status_id"]] = $status["status_name"];
		}
		$newStatusName = $status_names[$newStatus];
		$oldStatusName = $status_names[$oldStatus];

		$forwarded=0;
		if (isset($_SERVER["REMOTE_ADDR"])) {
			$forwarded=$_SERVER["REMOTE_ADDR"];
		}
		if(isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
			$forwarded=$_SERVER['HTTP_X_FORWARDED_FOR'];
		}

		$sql="insert into order_activity (order_id, status, activity_date, ip_address, who, activity) ";
		$sql.=" values (?, ?, now(), ?, ?, ?) ";
		list($rs,$err)=runIQuery($db,$sql,["iisss",$order,$oldStatus,$forwarded, $userEmail, "Changed Status from $oldStatusName to $newStatusName"]);
		if ($debug) {
			print "$err<br>\n";
			print renderQuery($sql,["iisss",$order,$oldStatus,$forwarded, $userEmail, "Changed Status from $oldStatusName to $newStatusName"]);
			print "<br>\n";
		}
	} catch (Exception $ex) {
		if ($debug) {
			print $ex->getMessage();
			print "<br>\n";
		}
	}
}

function updateOrderStatus($db,$order,$newStatus) {
	global $forwarded, $userEmail, $isAdmin, $scriptid, $userID;
	$sql="select status_name, status_id from orders, order_status where order_id=? and status=status_id";
	list($rs,$err)=runIQuery($db,$sql,array("i",$order));
	$oldStatusName=$rs[0][0];
	$oldStatus=$rs[0][1];
	$sql="select status_name from order_status where status_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$newStatus));
	$newStatusName=$rs[0][0];
	### status values as of 5/26/22
		// 1	Open
		// 2	On Job
		// 3	Complete
		// 4	Shipped
		// 5	Cancelled
		// 6	Quote
		// 7	At Weld
		// 8	At Processor
		// 9	Back From Processor
		// 10	At Assembly
		// 11	Ordered
		// 12	Partial Back From Processor
		// 13	Staged At Assembly
		// 14	At Laser
		// 15	At Bend
		// 16 	Pending Review
		// 17	Pending Purchase
		// 18 	Staging
		// 19	Preliminary Quote
		// 20	In Shipping
	$ok=0;
	if ($newStatus == 1) {
		$sql="select credit_hold from orders o, customers c where o.order_id=? and o.customer_id=c.customer_id";
		list($rs,$err)=runIQuery($db,$sql,array("i",$order));
		$creditHold=$rs[0][0];
		if (! $creditHold) {
			$ok=1;
		}
	}
	if ($newStatus == 2) {
		if ($oldStatus == 1) {
			$ok=1;
		}
	}

	if (in_array($newStatus,array(3,4,5,6))) {
		$ok=1;
		if (! $isAdmin) {
			if (in_array($oldStatus,array(3,4,5,6))) {
				$ok=0;
			}
		}
	}
	if ($newStatus == 7) {
		if ( in_array($oldStatus,array(1,2,14,15))) {
			$ok=1;
		}
	}
	if ($newStatus == 8) {
		if (in_array($oldStatus,array(1,2,7,14,15))) {
			$ok=1;
		}
	}
	if ($newStatus == 9) {
		if ( in_array($oldStatus,array(8,12))) {
			$ok=1;
		}
	}
	if ($newStatus == 10) {
		if ( in_array($oldStatus,array(9,13))) {
			$ok=1;
		}
	}
	if ($newStatus == 12) {
		if ( in_array($oldStatus,array(8))) {
			$ok=1;
		}
	}
	if ($newStatus == 13) {
		if ( in_array($oldStatus,array(9))) {
			$ok=1;
		}
	}
	if ($newStatus == 14) {
		$ok=0;
		if ( in_array($oldStatus,array(1,2))) {
			$ok=1;
		}
	}
	if ($newStatus == 15) {
		$ok=0;
		if ( in_array($oldStatus,array(1,2,14))) {
			$ok=1;
		}
	}
	## bdoss pending review/ pending purchase / prem quote additions
	if ($newStatus == 1) {
		if ( in_array($oldStatus,array(16,17,19))) {
			$ok=1;
		}
	}
	// 16 	Pending Review
	// 17	Pending Purchase
	// 18 	Staging
	// 19	Preliminary Quote
	// 20	In Shipping
	if (in_array($newStatus,array(16,17,18,19,20))) {
		$ok=1;
		if (! $isAdmin) {
			if (in_array($oldStatus,array(3,4))) {
				$ok=0;
			}
		}
	}


	if ($ok or $isAdmin) {
		updateOrderStatusBasic($db,$order,$newStatus); // add order activity -Josh 02-13-2023
		## bdoss see if there is an automated reminder attached to this order
		$sql="SELECT * FROM order_reminders WHERE order_id=? AND order_status=? AND sent_on IS NULL";
		list($rs,$err)=runIQuery($db,$sql,array("ii",$order,$newStatus));
		if ($rs) {
			sendReminderEmail($order,$newStatus); // function above this one
		}
		$sql="insert into order_status_update (order_id, old_status, new_status,date_changed, changed_by, script_id)
			values (?, ?, ?, now(), $userID, '$scriptid') ";
		list($rs,$err)=runIQuery($db,$sql,array("iii",$order,$oldStatus,$newStatus));
		if (in_array($newStatus,array(6,19))) {
		} else {
			if ($newStatus == 5) {
				## order cancelled
				$sql="update jobs set status=3 where line_id in (select line_id from order_lines where order_id=?) ";
				list($rs,$err)=runIQuery($db,$sql,array("i",$order));
			} else {
				## order anything but quote and cancelled
				$sql="update jobs set status=1 where status in (3,4) and line_id in (select line_id from order_lines where order_id=?) ";
				list($rs,$err)=runIQuery($db,$sql,array("i",$order));
			}
		}
	}
}

function updatePOActivity($db,$po,$status,$activity) {
	global $userID, $userEmail, $forwarded, $scriptid;
	$sql="insert into po_activity (`po_id`, `status`,`activity_date`, `ip_address`, `who`, `email_address`,`activity`,`scriptid`) ";
	$sql.=" values (?, ?, now(), ?, ?, ?, ? ,?) ";
	list($rs,$err)=runIQuery($db,$sql,array("iisssss",$po,$status,$forwarded,$userID,$userEmail,$activity,$scriptid));

	return $err;
}

// This function is ONLY called when you have received against as Purchase Order
// OR the At Processor Screen
// Because this only updates 2 statuses: Closed or Partially Received
function updatePOStatus($db,$po,$closeit=0,$debug=0) {
	if ($closeit) {
		## force close
		$sql="update purchase_orders set status=4 where po_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$po));

		// PO ACTIVITY set status to force closed
		updatePOActivity($db,$po,4,"Set status to Closed - Forced");
	} else {
		$sql="select coalesce(count(*),0) from po_lines where po_id=? and quantity_received > 0 ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$po));
		$data=$rs[0];
		$someReceived=$data[0];
		$sql="select coalesce(count(*),0) from po_lines where po_id=? and quantity_received < quantity ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$po));
		$data=$rs[0];
		$stillpartial=$data[0];
		if ($someReceived) {
			if (! $stillpartial) {
				## fully received
				$sql="update purchase_orders set status=4 where po_id=?";
				list($rs,$err)=runIQuery($db,$sql,array("i",$po));

				// PO ACTIVITY set status to fully received
				updatePOActivity($db,$po,4,"Set status to Closed - Fully Received");
			} else {
				## partial received
				$sql="update purchase_orders set status=3 where po_id=?";
				list($rs,$err)=runIQuery($db,$sql,array("i",$po));

				// PO ACTIVITY set status to partially received
				updatePOActivity($db,$po,3,"Set status to Partially Received");
			}
		}
	}
	$sql="select v.vendor_id, paint_vendor from purchase_orders p, vendors v where po_id=? and p.vendor_id=v.vendor_id";
	list($rs,$err)=runIQuery($db,$sql,array("i",$po));
	$data=$rs[0];
	if ($data['paint_vendor']==1) {
		## see about updating the orders
		## check po lines just to adjust Sales Order status
		$sql="select distinct l.order_id from po_lines p, jobs j, order_lines l where po_id=? and quantity_received >= p.quantity and p.job_id=j.job_id and j.line_id=l.line_id ";
		$sql.=" and j.item_id not like 'C20470001%' ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$po));
		foreach ($rs as $data) {
			$order=$data['order_id'];
			$allback=0;
			$someback=0;
			$notonpo=0;
			## mark partial
			$sql="select * from po_lines pl, jobs j, order_lines l where pl.po_id=? and pl.quantity_received >= pl.quantity and pl.job_id=j.job_id and j.line_id=l.line_id and l.order_id=?";
			$sql.=" and j.item_id not like 'C20470001%' ";
			list($rs,$err)=runIQuery($db,$sql,array("ii",$po,$order));
			$allback=count($rs);
			$sql="select * from po_lines pl, jobs j, order_lines l where pl.po_id=? and pl.quantity_received > 0 and pl.job_id=j.job_id and j.line_id=l.line_id and l.order_id=?";
			$sql.=" and j.item_id not like 'C20470001%' ";
			list($rs,$err)=runIQuery($db,$sql,array("ii",$po,$order));
			$someback=count($rs);
			$sql="select * from jobs j inner join order_lines l on j.line_id=l.line_id and l.order_id=? inner join routing r on j.item_id=parent_part and operation_id=3106 ";
			$sql.=" left outer join po_lines pl on j.job_id=pl.job_id where j.item_id not like 'C20470001%' and pl.po_id is null ";
			list($rs,$err)=runIQuery($db,$sql,array("i",$order));
			$notonpo=count($rs);
			$sql="select * from po_lines pl, jobs j, order_lines l where pl.po_id=? and  pl.quantity_received < pl.quantity and pl.job_id=j.job_id and j.line_id=l.line_id and l.order_id=?";
			$sql.=" and j.item_id not like 'C20470001%' ";
			list($rs,$err)=runIQuery($db,$sql,array("ii",$po,$order));
			$shortreceive=count($rs);
			if ($shortreceive>0) {
				if ($someback > 0) {
					updateOrderStatus($db,$order,12);
				}
			} else {
				if ($allback)  {
					if ($notonpo) {
						updateOrderStatus($db,$order,12);
					} else {
						updateOrderStatus($db,$order,9);
					}
				} else {
					if ($someback > 0) {
						updateOrderStatus($db,$order,12);
					}
				}
			}
			$sql="select distinct l.line_id as order_line from po_lines pl, jobs j, order_lines l where pl.po_id=? and pl.job_id=j.job_id and j.line_id=l.line_id and l.order_id=?";
			list($rs,$err)=runIQuery($db,$sql,array("ii",$po,$order));
			foreach ($rs as $data) {
				$line=$data['line_id'];
				$allback=0;
				$someback=0;
				$notonpo=0;
				## mark partial
				$sql="select * from po_lines pl, jobs j, order_lines l where pl.po_id=? and pl.quantity_received >= pl.quantity and pl.job_id=j.job_id and j.line_id=l.line_id and l.line_id=?";
				$sql.=" and j.item_id not like 'C20470001%' ";
				list($rs,$err)=runIQuery($db,$sql,array("ii",$po,$line));
				$allback=count($rs);
				$sql="select * from po_lines pl, jobs j, order_lines l where pl.po_id=? and pl.quantity_received > 0 and pl.job_id=j.job_id and j.line_id=l.line_id and l.line_id=?";
				$sql.=" and j.item_id not like 'C20470001%' ";
				list($rs,$err)=runIQuery($db,$sql,array("ii",$po,$line));
				$someback=count($rs);
				$sql="select * from jobs j inner join order_lines l on j.line_id=l.line_id and l.line_id=? inner join routing r on j.item_id=parent_part and operation_id=3106 ";
				$sql.=" left outer join po_lines pl on j.job_id=pl.job_id where j.item_id not like 'C20470001%' and pl.po_id is null ";
				list($rs,$err)=runIQuery($db,$sql,array("i",$line));
				$notonpo=count($rs);
				$sql="select * from po_lines pl, jobs j, order_lines l where pl.po_id=? and  pl.quantity_received < pl.quantity and pl.job_id=j.job_id and j.line_id=l.line_id and l.line_id=?";
				$sql.=" and j.item_id not like 'C20470001%' ";
				list($rs,$err)=runIQuery($db,$sql,array("ii",$po,$line));
				$shortreceive=count($rs);
				if ($shortreceive>0) {
					if ($someback > 0) {
						$sql="update order_lines set line_status=12 where  status not in (3,4,5,10) and line_id=?";
						list($rs,$err)=runIQuery($db,$sql,array("i",$line));
					}
				} else {
					if ($allback)  {
						if ($notonpo) {
							$sql="update order_lines set line_status=12 where status not in (3,4,5,10) and line_id=?";
							list($rs,$err)=runIQuery($db,$sql,array("i",$line));
						} else {
							$sql="update orders set line_status=9 where status not in (3,4,5,10) and line_id=?";
							list($rs,$err)=runIQuery($db,$sql,array("i",$line));
						}
					} else {
						if ($someback > 0) {
							$sql="update orders set line_status=12 where  status not in (3,4,5,10) and line_id=?";
							list($rs,$err)=runIQuery($db,$sql,array("i",$line));
						}
					}
				}
			}
		}
	}
}

function completeJob($db,$job) {
	### This function will complete a job if all quantity good has been made for it
	### in the last step of the routing
	$sql="select routing_id  from jobs j, routing r where j.job_id=? and j.item_id=r.parent_part order by display_sequence desc  ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$job));
	$data=$rs[0];
	$routing=$data[0];
	$sql="select sum(quantity_good) from production_results where job_id=? and routing_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("ii",$job,$routing));
	$data=$rs[0];
	$good=$data[0];
	if ($good) {
		# close the job if quantity is enough
		$sql="update jobs set status=2 where ? >= quantity_scheduled and job_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("ii",$good,$job));
		print "Completed Job $job Quantity Good $good<br>";
	}
}

function openJob($db,$job) {
	### This function will open a job if all quantity good has not been made for it
	### in the last step of the routing
	$sql="select routing_id  from jobs j, routing r where j.job_id=? and j.item_id=r.parent_part order by display_sequence desc  ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$job));
	$data=$rs[0];
	$routing=$data[0];
	$sql="select sum(quantity_good) from production_results where job_id=? and routing_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("ii",$job,$routing));
	$data=$rs[0];
	$good=$data[0];
	if ($good) {
		# close the job if quantity is enough
		$sql="select quantity_scheduled from jobs where job_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$job));
		$data=$rs[0];
		$scheduled=$data[0];
		if ($scheduled > $good) {
			$sql="update jobs set status=1 where  job_id=?";
			list($rs,$err)=runIQuery($db,$sql,array("i",$job));
		}
	}
}

function inventoryUpdate($db,$itemID,$quantity,$scriptid,$reference,$userID,$location="",$bulk=FALSE,$job=0,$replace=FALSE) {
	## if this is a service, we do not receive inventory for it.
	$sql="select item_type from items where item_id=?";
	list($trs,$terr)=runIQuery($db,$sql,array("i",$itemID));
	$tdata=$trs[0];
	## if job sent, then update quantity good.
	if ($job) {
		$sql="update jobs set quantity_good=coalesce(quantity_good,0)+$quantity where job_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$job));
	}
	if ($tdata['item_type']!='Service') {
		$sql="select item_name, default_location from items where item_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$itemID));
		$data=$rs[0];
		$item_name=$data['item_name'];
		if (! $location) {
			$location=$data['default_location'];
		}
		if (! $location) {
			$location="1";
		}
		$beforeQuantity=0;
		$sql="select location_id, quantity from item_locations where item_id=? and location_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("ii",$itemID,$location));
		$hasrec=0;
		if (count($rs)>0) {
			$data=$rs[0];
			if ($data['location_id']) {
				$hasrec=1;
			}
			$beforeQuantity=$data['quantity'];
		}
		if (! $beforeQuantity) {
			$beforeQuantity=0;
		}
		if (! $hasrec ) {
			$sql="select location_id, quantity from item_locations where item_id=? ";
			list($rs,$err)=runIQuery($db,$sql,array("i",$itemID));
			if (count($rs)>0) {
				$data=$rs[0];
				if ($data['location_id']) {
					$hasrec=1;
					$location=$data['location_id'];
					$beforeQuantity=$data['quantity'];
				}
			}
		}
		if (! $replace or ! $hasrec ) {
			if ($quantity <> 0 ) {
				$sql="insert into inventory_transactions (tx_date, script_name, user_id, location, prior_quantity, quantity, reference,item_name) values (sysdate(), ?, ?, ?, ?, ?, ?, ?) ";
				list($rs,$err)=runIQuery($db,$sql,array("siiddss",$scriptid,$userID,$location,$beforeQuantity,$quantity,$reference,$item_name));
			}
		}
		if (! $quantity) {
			$quantity=0;
		}
		if ($hasrec) {
			if ($replace) {
				$sql="update item_locations set quantity=$quantity where item_id=? and location_id=?";
				list($rs,$err)=runIQuery($db,$sql,array("ii",$itemID,$location));
				$diff=$quantity - $beforeQuantity;
				if ($diff <> 0) {
					$sql="insert into inventory_transactions (tx_date, script_name, user_id, location, prior_quantity, quantity, reference,item_name) values (sysdate(), ?, ?, ?, ?, ?, ?, ?) ";
					list($rs,$err)=runIQuery($db,$sql,array("siiddss",$scriptid,$userID,$location,$beforeQuantity,$diff,$reference,$item_name));
				}
			} else {
				if ($quantity < 0) {
					$sql="update item_locations set quantity = quantity  $quantity where item_id=? and location_id=?";
				} else {
					$sql="update item_locations set quantity = quantity + $quantity where item_id=? and location_id=?";
				}
				list($rs,$err)=runIQuery($db,$sql,array("ii",$itemID,$location));
			}
		} else {
			## create entry even if negative
			$sql="insert into item_locations (item_id, location_id, quantity, available) values (?,?,?,1)";
			list($rs,$err)=runIQuery($db,$sql,array("iid",$itemID,$location,$quantity));
		}
		## update quantity on hand for part master now
		## for now, update all qoh - skinny down to just this item if performance is an issue.
		if (! $bulk) {
			$sql="update items i inner join (select item_id, sum(quantity) 'qoh' from item_locations group by item_id) l on i.item_id=l.item_id set i.quantity_on_hand=l.qoh ";
			list($rs,$err)=runIQuery($db,$sql);
		}
	}
}

function inventoryTransfer($db,$itemID,$fromLocation,$toLocation,$quantity,$scriptid,$reference,$userID) {
	$fromQuantity=$quantity * -1;
	inventoryUpdate($db,$itemID,$fromQuantity,$scriptid,$reference,$userID,$fromLocation);
	inventoryUpdate($db,$itemID,$quantity,$scriptid,$reference,$userID,$toLocation);
}

function renderReportRow($fieldList,$i,$db,$table="",$field="",$operation="",$condition="") {
	global $isAdmin;
	print "<tr>";
	print "<td valign='top'>";
	print "<i class='icon-trash' onclick=\"deleteCondition('$i');\"></i>";
	print "</td>";
	print "<td valign='top'>";
	print "<select id='crit$i' name='crit$i' onchange=\"setValueType('$i');\" style='width: 200px;'>";
	print "<option value=''></option>";
	reset($fieldList);
	$holdTable="";
	foreach ($fieldList as $data) {
		$fname=$data['field_name'];
		$tbl=$data['table_name'];
		if ($tbl != $holdTable) {
			print "<option value=''>-- Fields from Module " . ucwords($tbl) . " --</option>";
			$holdTable=$tbl;
		}
		$ttl=$data['title'];
		if ($fname==$field and $tbl==$table) {
			print "<option selected value='$tbl.$fname'>$ttl</option>";
		} else {
			print "<option value='$tbl.$fname'>$ttl</option>";
		}
	}
	$sql="select *  from custom_fields where table_name =? or field_name=? order by title";
	list($fieldList,$err)=runIQuery($db,$sql,array("ss",$table,$field));
	$written=0;
	foreach ($fieldList as $data) {
		if (! $written) {
			print "<option value=''>-- Calculated Fields --</option>";
			$written=1;
		}
		$fname=$data['field_name'];
		$ttl=$data['title'];
		if ($fname==$field) {
			print "<option value='custom.$fname' selected >$ttl</option>";
		} else {
			print "<option value='custom.$fname'>$ttl</option>";
		}
	}
	print "</select>";
	print "</td>";
	print "<td valign='top'>";
	print "<select name='operation$i' id='operation$i'>";
	print "<option value='eq' ";
	if ($operation=='eq') {
	print " selected ";
	}
	print ">Equal</option>";
	print "<option value='ne' ";
	if ($operation=='ne') {
	print " selected ";
	}
	print ">Not Equal</option>";
	print "<option value='contains' ";
	if ($operation=='contains') {
		print " selected ";
	}
	print ">Contains</option>";
	print "<option value='ge' ";
	if ($operation=='ge') {
		print " selected ";
	}
	print ">Greater Than or Equal</option>";
	print "<option value='le' ";
	if ($operation=='le') {
		print " selected ";
	}
	print ">Less Than or Equal</option>";
	print "<option value='starts' ";
	if ($operation=='starts') {
		print " selected ";
	}
	print ">Starts With</option>";
	print "<option value='ends' ";
	if ($operation=='ends') {
		print " selected ";
	}
	print ">Ends With</option>";
	print "</select>";
	print "</td>";
	print "<td valign='top'><div id='conditionWrapper$i'>";
	$sql="select field_type, title from field_names where table_name=? and field_name=?";
	list($frs,$err)=runIQuery($db,$sql,array("ss",$table,$field));
	$fdata=$frs[0];
	$ftype=$fdata['field_type'];
	$ttl=$fdata['title'];
	print renderField($db,$i,$table,$ttl,$condition,$isAdmin);
	print "</div></td>";
	print "</td>";
	print "</tr>\n";
}


# if search text, render the search
function renderSearch($db,$searchText,$table,$exact=0) {
	$sql="select * from field_names where table_name=?";
	list($frs,$err)=runIQuery($db,$sql,array("s",$table));
	$retval=" ( ";
	$comma="";
	foreach ($frs as $fdata) {
		$fname=$fdata['field_name'];
		$ftype=$fdata['field_type'];
		$lkup=$fdata['lookup_table'];
		$lfld=$fdata['lookup_field'];
		$rfld=$fdata['return_field'];
		if (strstr(strtolower($rfld)," as ")) {
			list($rfld, $alias) = explode(" as ",strtolower($rfld));
		}
		if ($ftype != 'B' and $ftype!='blob') {
			if ($lkup) {
				$retval.=$comma;
				if ($exact) {
					$retval.=" $table.$fname in (select $lfld from $lkup where $rfld = '$searchText') ";
				} else {
					$retval.=" $table.$fname in (select $lfld from $lkup where $rfld like '%$searchText%') ";
				}
				$comma=" or ";
			} else {
				if (isNumericField($ftype)) {
					if (is_numeric($searchText)) {
						$retval.=$comma;
						$retval.=" ($table.$fname = $searchText and $table.$fname > 0)  ";
						$comma=" or ";
					}
				} else {
					if ($ftype=='D' or $ftype=='date') {
						if (formatDateWebToDB($searchText)!='0000-00-00') {
							$retval.=$comma;
							$retval.=" DATE_FORMAT($table.$fname,'%Y-%m-%d') =  '" . formatDateWebToDB($searchText) . "' ";
							$comma=" or ";
						}
					} else {
						$retval.=$comma;
						if ($exact) {
							$retval.=" $table.$fname =  '$searchText' ";
						} else {
							$retval.=" $table.$fname like  '%$searchText%' ";
						}
						$comma=" or ";
					}
				}
			}
		}
	}
	if ($table == 'orders') {
		$retval .= $comma;
		$retval.=" orders.order_id in (select order_id from order_lines where item_id like '%$searchText%' or item_description like '%$searchText%') ";
	}
	if ($table == 'transfers') {
		$retval.= $comma;
		$retval.= " transfers.packing_slip in (select packing_slip from transfer_lines where part_number like '%$searchText%' ) ";
	}
	$retval.=") ";
	return $retval;
}

## render the conditions to display only the records that match this filter
## calling program is expected to know to put the where or and in front of the returned string

function renderFilter($db,$filterID) {
	$retval=" 1 > 0 "; ## no conditions, match all;
	$sql="select * from filters where filter_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$filterID));
	$data=$rs[0];
	$matchAll=$data['match_all'];
	$table=$data['table_name'];
	$sql="select * from filter_conditions where filter_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$filterID));
	if (count($rs)) {
		$retval=" ( ";
		$sep="";
		foreach ($rs as $data) {
			$title=$data['field_name'];
			$op=$data['operation'];
			$condition=$data['condition'];
			$sql="select field_name, field_type from field_names where table_name=? and title=?";
			list($frs,$ferr)=runIQuery($db,$sql,array("ss",$table,$title));
			$fdata=$frs[0];
			$retval.=$sep;
			if ($matchAll) {
				$sep=" and ";
			} else {
				$sep = " or ";
			}
			$retval.="`" . $fdata[0] . "`";
			$ftype=strtoupper($fdata[1]);
			if ($op == "eq") {
				$retval.=" = ";
				if ($ftype != "N") {
					$retval.="'";
				}
			}
			if ($op == "ne") {
				$retval.=" != ";
				if ($ftype != "N") {
					$retval.="'";
				}
			}
			if ($op == "contains") {
				$retval.=" like '%";
			}
			if ($op == "ge") {
				$retval.=" >= ";
				if ($ftype != "N") {
					$retval.="'";
				}
			}
			if ($op == "le") {
				$retval.=" <= ";
				if ($ftype != "N") {
					$retval.="'";
				}
			}
			if ($op == "starts") {
				$retval.=" like '";
			}
			if ($op == "ends") {
				$retval.=" like '%";
			}
			if (strtolower($fdata[1]) == "d" or strtolower($fdata[1])=="date") {
				$condition=formatDateWebToDB($condition);
			}
			$retval.=$condition;
			if ($op == "eq" or $op == "ge" or $op == "le" or $op == "ends" or $op == "ne") {
				if ($ftype != "N") {
				$retval.="' ";
			}
			}
			if ($op == "contains" or $op == "starts") {
				$retval.="%' ";
			}
		}
		$retval.=" )";
	}
	return $retval;
}

function renderFilterRow($fieldList,$i,$table,$db,$field="",$operation="",$condition="",$isAdmin=0) {
	print "<tr>";
	print "<td valign='top'>";
	print "<i class='icon-trash' onclick=\"deleteCondition('$i');\"></i>";
	print "</td>";
	print "<td valign='top'>";
	print "<select id='crit$i' name='crit$i' onchange=\"setValueType('$i');\">";
	print "<option value=''></option>";
	reset($fieldList);
	foreach ($fieldList as $data) {
		$fname=$data['field_name'];
		$ttl=$data['title'];
		if ($ttl==$field) {
			print "<option selected value='$ttl'>$ttl</option>";
		} else {
			print "<option value='$ttl'>$ttl</option>";
		}
	}
	print "</select>";
	print "</td>";
	print "<td valign='top'>";
	print "<select name='operation$i' id='operation$i'>";
	print "<option value='eq' ";
	if ($operation=='eq') {
	print " selected ";
	}
	print ">Equal</option>";
	print "<option value='ne' ";
	if ($operation=='ne') {
	print " selected ";
	}
	print ">Not Equal</option>";
	print "<option value='contains' ";
	if ($operation=='contains') {
		print " selected ";
	}
	print ">Contains</option>";
	print "<option value='ge' ";
	if ($operation=='ge') {
		print " selected ";
	}
	print ">Greater Than or Equal</option>";
	print "<option value='le' ";
	if ($operation=='le') {
		print " selected ";
	}
	print ">Less Than or Equal</option>";
	print "<option value='starts' ";
	if ($operation=='starts') {
		print " selected ";
	}
	print ">Starts With</option>";
	print "<option value='ends' ";
	if ($operation=='ends') {
		print " selected ";
	}
	print ">Ends With</option>";
	print "</select>";
	print "</td>";
	print "<td valign='top'><div id='conditionWrapper$i'>";
	print renderField($db,$i,$table,$field,$condition,$isAdmin);
	print "</div></td>";
	$sql="select field_type from field_names where table_name=? and title=?";
	list($frs,$err)=runIQuery($db,$sql,array("ss",$table,$field));
	$fdata=$frs[0];
	print "</div>";
	print "</td>";
	print "</tr>\n";
}

function renderOperation($op,$cond) {
	$retval="";
	if ($op=="eq") {
		$retval.="='$cond'";
	}
	if ($op=="ne") {
		$retval.="!='$cond'";
	}
	#ends contains le ge eq
	if ($op=="starts") {
		$retval.=" like '$cond%' ";
	}
	if ($op=="ends") {
		$retval.=" like '%$cond' ";
	}
	if ($op=="contains") {
		$retval.=" like '%$cond%' ";
	}
	if ($op=="le") {
		$retval.=" <= '$cond' ";
	}
	if ($op=="ge") {
		$retval.=" >= '$cond' ";
	}
	return $retval;
}
function renderEditForm($db,$fieldList,$recordData,$cols=2,$isAdmin=0,$userID=0,$key="",$id=0,$otherfield="",$tabList=array()) {
	$retval="";
	$coloridx=0;
	$colors=array("green","blue","red","yellow","purple","grey","black");
	if (count($tabList)) {
		foreach ($tabList as $tab) {
			$retval.=renderEditFields($db,$fieldList,$recordData,$cols,$isAdmin,$userID,$key,$id,$otherfield,$tab,$colors[$coloridx]);
			$coloridx++;
			if ($coloridx  > 6) {
				$coloridx=0;
			}
		}
	} else {
		$retval.=renderEditFields($db,$fieldList,$recordData,$cols,$isAdmin,$userID,$key,$id,$otherfield);
	}
	return $retval;
}

function renderEditFields($db,$fieldList,$recordData,$cols=2,$isAdmin=0,$userID=0,$key="",$id=0,$otherfield="",$tab="",$color="green") {
	$toggle=0;
	$retval="";
	$retval.="<div class='row-fluid' >\n<div class='span12' >\n";
	$retval.="<div class='portlet box $color' >\n";
	$retval.="<div class='portlet-title'>\n";
	$retval.="<div class='caption'>";
	if ($tab) {
		$retval.=ucwords(strtolower($tab));
	}
	$retval.="</div>\n";
	$retval.="<div class='tools'><a href='javascript:;' class='collapse'></a></div>\n";
	$retval.="</div>\n";
	$retval.="<div class='portlet-body' style='background-color: #dddddd;'>\n";
	foreach ($fieldList as $data) {
		$title=$data['title'];
		$table=$data['table_name'];
		$fieldName=$data['field_name'];
		$tooltip=$data['tooltip'];
		$readOnly=$data['readonly'];
		if ($tab) {
			$okToUse=0;
			$sql="select * from field_tabs, table_tabs, field_names where tab_name=? and table_tabs.tt_idx=field_tabs.tt_idx and field_tabs.fn_idx=field_names.fn_idx and field_names.field_name=? ";
			list($rs,$err)=runIQuery($db,$sql,array("ss",$tab,$fieldName));
			$okToUse=count($rs);
		} else {
			$okToUse=1;
		}
		if ($fieldName=='is_admin' and ! $isAdmin) {
			$okToUse=0;
		}
		if ($fieldName=='lead_admin' and ! $isAdmin) {
			$okToUse=0;
		}
		if ($fieldName=='disabled' and ! $isAdmin) {
			$okToUse=0;
		}
		if ($okToUse) {
			$fieldType=$data['field_type'];
			$fieldSize=$data['field_size'];
			$lookupTable=$data['lookup_table'];
			$lookupField=$data['lookup_field'];
			$returnField=$data['return_field'];
			$default=$data['default_value'];
			$readOnly=$data['readonly'];
			$default=str_replace("today()",Date('Y-m-d'),$default);
			$default=str_replace("now()",Date('Y-m-d H:i:s'),$default);
			$default=str_replace("startofmonth()",Date('Y') . "-" . Date("m") . "-01",$default);
			$default=str_replace("endofmonth()",Date('Y') . "-" . Date("m") . "-" . Date('t'),$default);
			$defaultValue=str_replace("currentUser()",$userID,$default);
			$readOnly=$data['readonly'];
			$allowZero=$data['allow_zero'];
			$readOnly=$data['readonly'];
			$autoComplete=$data['autocomplete'];
			if ($fieldName != $key and $fieldName != $otherfield ) {
				if ($toggle==0) {
					$retval.= "<div class='row-fluid' >";
				}
				if ($fieldType=='text') {
					$retval.="<div class='span8'>";
				} else {
					$retval.="<div class='span4'>";
				}
				$retval.= "<div class='control-group'><label class='control-label' for='$fieldName' ";
				if ($tooltip) {
					$retval.=" title=\"$tooltip\" ";
				}
				$retval.= ">$title:</label>";
				$retval.= "<div class='controls'>";
				if (substr($defaultValue,0,5)=='where') {
					$specialLookup=$defaultValue;
					$defaultValue="";
				}
				$defaultValue=str_replace("today()",Date('Y-m-d'),$default);
				$defaultValue=str_replace("today()",Date('Y-m-d'),$defaultValue);
				$defaultValue=str_replace("startofmonth()",Date('Y') . "-" . Date("m") . "-01",$defaultValue);
				$defaultValue=str_replace("endofmonth()",Date('Y') . "-" . Date("m") . "-" . Date('t'),$defaultValue);
				$defaultValue=str_replace("currentUser()",$userID,$defaultValue);
				if (! $id) {
					$recordData[$fieldName]=$defaultValue;
				}
				$special_field=0;
				if ($fieldType=='file')
				{
					$usingdoc=1;
					if ($id > 0) {
						$retval.= "<div id='docpreview' style='display: inline; float: right;'>";
						$retval.= "<BR><a href='javascript:viewDocument();'>View</a>";
						$retval.= "<br>Link: /viewDocument.php?document=$id";
						$retval.= "</div>";
					} else {
						$retval.= "<div id='docpreview' style='display: none; float: right;'>";
						$retval.= "<BR><a href='javascript:viewDocument();'>View</a>";
						$retval.= "</div>";
					}
					$retval.= "<input  float: right;' type=file name='doc_file' id='doc_file' style='width: 92%;'>";
					$special_field=1;
				}
				if ($fieldType=='text') {
					$retval.= "<textarea class='m-wrap span12 wysihtml5 ' name='$fieldName' id='$fieldName' rows='5' style='background-color: white;'  ";
					if ($readOnly) {
						$retval.=" disabled readonly ";
					}
					$retval.=" >";
					$retval.= stripslashes($recordData[$fieldName]);
					$retval.= "</textarea>\n";
				}
				if ($lookupTable!="") {
					if ($autoComplete)  {

					} else {
						if (strstr($returnField," as ")) {
							list($seq,$rest)=explode(" as ",$returnField);
						} else {
							$seq=$returnField;
						}
						$sql="select distinct $lookupField, $returnField from $lookupTable ";
						if ($lookupTable=='status_types') {
							if (! $isAdmin ) {
								$sql.=" where coalesce(admin_only,0)=0 ";
							}
						}
						if ($lookupTable == 'agents') {
							if (! $isAdmin) {
								$sql.=" where agent_id=$userID";
							}
						}
						$sql.=" order by $seq ";
						$rs=mysqli_query($db,$sql);
						if (mysqli_error($db)) {
							$retval.= "$sql<BR>";
							$retval.= mysqli_error($db);
						}
						if ($fieldName == 'lead_id' or $fieldName=='client_id') {
							while ($rdata=mysqli_fetch_array($rs)) {
								if ($rdata[$fieldName]==$recordData[$fieldName]) {
									$retval.= $rdata[$returnField];
								}
							}
						} else {
							$retval.= "<select class='m-wrap span12'  id='$fieldName' name='$fieldName' ";
							if ($readOnly) {
								$retval.=" disabled ";
							}
							$retval.=" style='background-color: white;' >";
							$retval.= renderOptions($rs,$recordData[$fieldName],$allowZero,false);
							$retval.= "</select>";
						}
					}
				} else {
					if ($fieldType=="D" or $fieldType=="date") {
						$datePickers[]=$fieldName;
						$retval.= "<input style=' background-color: white;' class='datepicker m-wrap' type='text' name='$fieldName' id='$fieldName' value='" . formatDateDBToWeb($recordData[$fieldName]);
						$retval.="' ";
						if ($readOnly) {
							$retval.=" disabled readonly ";
						}
						$retval.=" >";
					}
					if ($fieldType=='B')
					{
						$retval.= "<div class='switch'  data-on='success' data-off='danger' style='width: 200px;'>";
						$retval.= "<input type=checkbox id='$fieldName'  name='$fieldName' class='toggle' value='1'  ";
						if ($recordData[$fieldName]) { $retval.= " checked "; }
						if ($readOnly) {
							$retval.=" disabled readonly ";
						}
						$retval.= ">";
						$retval.= "</div>";
					}
					if ($fieldType=="N" or $fieldType=="C") {
						if ($fieldName=="password") {
							$retval.= "Password:<BR><input class='m-wrap' style=' background-color: white;' type='text'  name='$fieldName' id='$fieldName' value='' placeholder='Password'>";
							$retval.= "<span class='help-block'>Enter new one to set, blank keeps existing.</span>";
						} else {
							$retval.= "<input style=' background-color: white;' class='m-wrap' type='text'  name='$fieldName' id='$fieldName' value='" . $recordData[$fieldName] . "' ";
							if ($readOnly) {
								$retval.=" disabled readonly ";
							}
							$retval.=" >";
							if ($fieldName=='email_address') {
								$retval.="<a href=\"javascript:testEmail($('#$fieldName').val(),'email');\"><button class='btn blue' >Send Test</button></a>";
							}
							if ($fieldName=='text_address') {
								$retval.="<a href=\"javascript:testEmail($('#$fieldName').val(),'text');\"><button class='btn blue' >Send Test</button></a>";
								$sql="select * from sms_domains order  by provider";
								$retval.="<select style=' background-color: white;' onchange='setTextAddress(this.value);'><option value=''>Select Cell Provider</option>";
								list($trs,$err)=runIQuery($db,$sql);
								foreach ($trs as $tdata) {
									$tdomain=$tdata['sms_domain'];
									$tname=$tdata['provider'];
									$retval.="<option value='$tdomain'>$tname</option>";
								}
								$retval.="</select>";
							}
						}
					}
					if ($fieldType=="html") {
						$retval.= "<button class='btn green' onclick=\"window.open('showHTML.php?table=$table&field=$fieldName&key=$key&id=$id','preview');\" >Click To View</button>";

					}
				}
				$retval.= "</div></div></div>";
				$toggle++;
				if ($toggle==$cols) {
					$retval.= "</div>\n";
					$toggle=0;
				}
			}
		}
	}
	if ($toggle) {
		$retval.="</div>\n";
	}
	$retval.="</div>\n";
	$retval.="</div>\n";
	$retval.="</div>\n";
	return $retval;
}
function renderField($db,$idx,$table,$field,$currentValue="",$isAdmin=0) {
	$retval="";
	$written=false;
	if ($field!="") {
		$sql="select * from field_names where table_name=? and title=?";
		list($frs,$err)=runIQuery($db,$sql,array("ss",$table,$field));
		$fdata=$frs[0];
		$ftype=$fdata['field_type'];
		$lookupTable=$fdata['lookup_table'];
		$lookupField=$fdata['lookup_field'];
		$returnField=$fdata['return_field'];
		$autoComplete=$fdata['autocomplete'];
		$readOnly=$fdata['readonly'];
		if ($ftype=='B') {
			$retval.="<div class='switch'  data-on='success' data-off='danger'><input class='toggle' type='checkbox'  id='condition$idx' value=1 ";
			if ($currentValue) {
				$retval.=" checked ";
			}
			if ($readOnly) {
				$retval.=" disabled readonly ";
			}
			$retval.="></div>";
			$written=true;
		}
		if ($lookupTable!= "") {
			if ($autoComplete) {

			} else {
				if (strstr($returnField," as ")) {
					list($seq,$rest)=explode(" as ",$returnField);
				} else {
					$seq=$returnField;
				}
				$sql="select distinct $lookupField, $returnField from $lookupTable ";
				if ($lookupTable=='status_types') {
					if (! $isAdmin ) {
						$sql.=" where coalesce(admin_only,0)=0 ";
					}
				}
				if ($lookupTable=='employee_link') {
					$sql.=" where coalesce(inactive,0)=0 ";
				}
				if ($lookupTable=='employees') {
					$sql.=" where coalesce(inactive,0)=0 ";
				}
				if ($lookupTable=='site_admins') {
					$sql.=" where coalesce(inactive,0)=0 ";
				}
				$sql.=" order by $seq ";
				$rs=mysqli_query($db,$sql);

				if (mysqli_error($db)) {
					print "$sql<BR>";
					print mysqli_error($db);
				}
				//$sql="select key_field from table_names where table_name=?";
				//list($rs,$err)=runIQuery($db,$sql,array("s",$table));
				//$key=$rs[0][0];
				$retval.="<select id='condition$idx' name='condition$idx' style='border: 0px solid black;' onclick=\"this.style.border='1px solid black;';\"  onchange=\"this.style.border='1px solid black;';\" ";
				if ($readOnly) {
					$retval.=" disabled readonly ";
				}
				$retval.=" >";
				$retval.=renderOptions($rs,$currentValue,true,false);
				$retval.="</select>";
				$written=true;
			}
		}
	}
	if (! $written) {
		if ($ftype=='D' or $ftype=='date') {
			$retval.="<input id='condition$idx' name='condition$idx' class='m-wrap m-ctrl-medium date-picker' readonly size='16' type='text' value='$currentValue' /><span class='add-on'><i class='icon-calendar'></i></span>";
			$retval.="\n<script>$('#condition$idx').datepicker();</script>\n";
		} else {
			$retval.="<input type='text' id='condition$idx' size=20 name='condition$idx' value='$currentValue'>";			}

	}
	return $retval;
}

function postChangeMessage($db,$table,$id,$user,$assignTo) {
	if ($table=='customers') {
		$sql="select name from customers where customer_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$id));
		$data=$rs[0];
		$id=$data[0];
		$table="Customer ";
	}
	if ($table=='items') {
		$sql="select item_name from items where customer_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$id));
		$data=$rs[0];
		$id=$data[0];
		$table="Item ";
	}
	if ($table=='orders') {
		$table="Sales Order ";
	}
	if ($table=='purchase_orders') {
		$table="Purchase Order";
	}
	if ($table=='jobs') {
		$table="Work Order";
	}
	$message="$table $id changed by $user";
	$sql="select email from salespeople where salesperson_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$assignTo));
	$data=$rs[0];
	if ($data['email']) {
		## find their user ID
		$em=$data['email'];
		$sql="select user_id from site_admins where email=? ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$em));
		$data=$rs[0];
		$assignTo=$data[0];
	}
	if ($assignTo != $user) {
		if (! $assignTo) {
			$assignTo=0;
		}
		$sql="insert into messages (message_type, message, viewed, assigned_to, message_date) values (1, '$message', 0, $assignTo, sysdate())";
		// disable for now
		// list($rs,$err)=runIQuery($db,$sql);
	}
}

function getVendorPrice($db,$vendorID,$itemID,$quantity) {
	$sql="select cost from items where item_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$itemID));
	$data=$rs[0];
	$price=$data[0];
	$sql="select price from vendor_pricing where vendor_id=? and item_id=? and quantity <= ? order by quantity desc LIMIT 1";
	list($rs,$err)=runIQuery($db,$sql,array("iii",$vendorID,$itemID,$quantity));
	if (count($rs)>0) {
		$data=$rs[0];
		$price=$data[0];
	}
	return $price;
}

function getVendorSuffix($db,$vendorID,$itemID,$quantity) {
	$suffix="";
	$sql="select suffix from vendor_pricing where vendor_id=? and item_id=? and quantity < ? order by quantity desc LIMIT 1";
	list($rs,$err)=runIQuery($db,$sql,array("iii",$vendorID,$itemID,$quantity));
	if (count($rs)>0) {
		$data=$rs[0];
		$suffix=$data[0];
	}
	return $suffix;
}


function postMessage($assignTo, $message) {
	global $db;
	$sql="insert into messages (message_type, message, viewed, assigned_to, message_date) values (1, '$message', 0, $assignTo, sysdate())";
	list($rs,$err)=runIQuery($db,$sql);
}

function getMRPInfo($db,$item,$start_date="") {
	global $partlist;
	$retval=array();
	$item=strtoupper($item);
	$sql="select quantity_on_hand, item_description, vendor_name from items left outer join vendors on items.vendor_id=vendors.vendor_id where item_name=?";
	list($rs,$err)=runIQuery($db,$sql,array("s",$item));
	$data=$rs[0];
	$retval['item_description']=$data['item_description'];
	$retval['vendor_name']=$data['vendor_name'];
	$retval['quantity_on_hand']=$data['quantity_on_hand'];
	if (! $start_date) {
		$start_date=Date("Y-m-d");
	}
	set_time_limit(120);
	## get all jobs building this part before date sent
	## for now do not provide this
	#$sql="select coalesce(sum(quantity_scheduled-coalesce(quantity_good,0)),0) as building from jobs where item_id=? and status =1 and coalesce(quantity_good,0) < quantity_scheduled and start_date <= ? ";
	#$sql.=" and job_id not in (select job_id from inventory_jobs) ";
	#list($rs,$err)=runIQuery($db,$sql,array("ss",$item,$start_date));
	#$data=$rs[0];
	#$retval['building']=$data['building'];
	## get all on PO not received yet due before date sent
	## only status partial receive and sent to vendor
	$sql="select coalesce(sum(quantity - coalesce(quantity_received,0)),0) as onpo from po_lines, items, purchase_orders where po_lines.date_expected <= ? and po_lines.po_id=purchase_orders.po_id and purchase_orders.status in (3,5) and po_lines.item_id=items.item_id and item_name=? and coalesce(quantity_received,0) < quantity ";
	list($rs,$err)=runIQuery($db,$sql,array("ss",$start_date,$item));
	$data=$rs[0];
	$retval['onpo']=$data['onpo'];
	$sql="select parent_item, quantity_per from billofmaterial where child_item='$item'";
	$rs=mysqli_query($db,$sql);
	$txnlist=array();
	while ($data=mysqli_fetch_array($rs)) {
		set_time_limit(120);
		$parent=$data['parent_item'];
		$qper=$data['quantity_per'];
		$txnlist=addToAllocated($db,$parent,$qper,$item,$txnlist,0);
		## up levels
		$sql="select coalesce(sum(quantity_scheduled-coalesce(quantity_good,0)),0) as covered from jobs where status=1 and item_id='$parent' ";
		$sql.=" and job_id not in (select job_id from inventory_jobs) ";
		$jrs=mysqli_query($db,$sql);
		$jdata=mysqli_fetch_array($jrs);
		$covered=$jdata['covered'];
		## seems like covered should include qoh of these items
		$sql="select quantity_on_hand from items where item_name='$parent'";
		$jrs=mysqli_query($db,$sql);
		if (mysqli_num_rows($jrs)>0) {
			$jdata=mysqli_fetch_array($jrs);
			$covered+=$jdata['quantity_on_hand'];
			if ($covered < 0) {
				$covered=0;
			}
		}
		$trueParent=$parent;
		$sql="select parent_item, quantity_per from billofmaterial inner join jobs j on j.item_id=parent_item and j.status = 1 where child_item='$trueParent' ";
		$brs=mysqli_query($db,$sql);
		while ($bdata=mysqli_fetch_array($brs)) {
			$parent=$bdata['parent_item'];
			$qper=$bdata['quantity_per'];
			//$txnlist=addToAllocated($db,$parent,$qper,$item,$txnlist,$covered);
			## up one more level
			## get quantity on jobs that are to be built.
			$sql="select coalesce(sum(quantity_scheduled-coalesce(quantity_good,0)),0) as covered from jobs where status=1 and item_id='$parent' ";
			$sql.=" and job_id not in (select job_id from inventory_jobs) ";
			$jrs=mysqli_query($db,$sql);
			$jdata=mysqli_fetch_array($jrs);
			$covered=$jdata['covered'];
			## seems like covered should include qoh of these items
			$sql="select quantity_on_hand from items where item_name='$parent'";
			$jrs=mysqli_query($db,$sql);
			if (mysqli_num_rows($jrs)>0) {
				$jdata=mysqli_fetch_array($jrs);
				$covered+=$jdata['quantity_on_hand'];
			}
			if ($covered < 0) {
				$covered=0;
			}
			## this would be double counting them
			#$sql="select parent_item, quantity_per from billofmaterial where child_item='$parent'";
			#$lrs=mysqli_query($db,$sql);
			#while ($ldata=mysqli_fetch_array($lrs)) {
			#		$parent=$ldata['parent_item'];
			#	$qper=$ldata['quantity_per'];
			#	$txnlist=addToAllocated($db,$parent,$qper,$item,$txnlist,$covered);
			#}
		}
		$sql="select parent_item, quantity_per from billofmaterial left outer join jobs j on j.item_id=parent_item  where child_item='$trueParent' and j.job_id is null ";
		$brs=mysqli_query($db,$sql);
		while ($bdata=mysqli_fetch_array($brs)) {
			$parent=$bdata['parent_item'];
			$qper=$bdata['quantity_per'];
			//$txnlist=addToAllocated($db,$parent,$qper,$item,$txnlist,$covered);\
			## up one more level
			## get quantity on jobs that are to be built.
			$sql="select coalesce(sum(quantity_scheduled-coalesce(quantity_good,0)),0) as covered from jobs where status=1 and item_id='$parent' ";
			$sql.=" and job_id not in (select job_id from inventory_jobs) ";
			$jrs=mysqli_query($db,$sql);
			$jdata=mysqli_fetch_array($jrs);
			$covered=$jdata['covered'];
			## seems like covered should include qoh of these items
			$sql="select quantity_on_hand from items where item_name='$parent'";
			$jrs=mysqli_query($db,$sql);
			if (mysqli_num_rows($jrs)>0) {
				$jdata=mysqli_fetch_array($jrs);
				$covered+=$jdata['quantity_on_hand'];
			}
			if ($covered < 0) {
				$covered=0;
			}
		}
	}
	## build the list of order lines to skip because they are already on a job
	$olist=array();
	foreach ($txnlist as $txn) {
		if ($txn['type']=="ALLOCATED") {
			$job=$txn['identifier'];
			$sql="select line_id from jobs where job_id=?";
			list($rs,$err)=runIQuery($db,$sql,array("i",$job));
			if (count($rs)>0) {
				$olist[]=$rs[0][0];
			}
		}
	}
	reset($txnlist);
	## get all on SO not shipped due up to end date
	$onso=0;
	$onEDI=0;
	$soedilist=array();
	$soedilist=getOnSOAndEDIDetail($db,$item,$olist,$start_date);
	foreach( $soedilist as $txn) {
		if ($txn['type']=='ON SALES ORDER') {
			$onso+=abs($txn['qtytogo']);
		}
		if ($txn['type']=="ON EDI ORDER") {
			$onEDI+=abs($txn['qtytogo']);
		}
	}
	$retval['onso']=$onso;
	$retval['onedi']=$onEDI;
	$allocated=0;
	foreach ($txnlist as $txn) {
		$allocated=$allocated + abs($txn['qtytogo']);
	}
	## get all allocated to jobs not complete to up to the date
	$retval['allocated']=$allocated;
	return $retval;
}

function addPaintLoadUnload($db,$itemName,$max=0) {
	if ($max == 0) {
		$sql="select max(display_sequence) from routing where parent_part=?";
		list($rs,$err)=runIQuery($db,$sql,array("s",$itemName));
		if (count($rs)) {
			$max=$rs[0][0];
		}
	}
	$sql="select display_sequence from routing where parent_part=? and operation_id=3113 ";
	list($rs,$err)=runIQuery($db,$sql,array("s",$itemName));
	if (count($rs)>0) {
		switchFromBatchToLine($db,$itemName);
	} else {
		## 3119 - 179 Plug/Mask (used if plugs or masking on item )
		## 3138  328 186 is load
		## 3139 329 187 is unload
		$mlist=array();
		$wclist=array();
		$dlist=array();
		$pphlist=array();
		$mlist[3119]=0;
		$wclist[3119]=179;
		$dlist[3119]="PLUGGING/MASKING";
		$pphlist[3119]=98;
		$mlist[3138]=328;
		$wclist[3138]=186;
		$dlist[3138]="LOAD";
		$pphlist[3138]=1000;
		$mlist[3139]=329;
		$wclist[3139]=187;
		$dlist[3139]="UNLOAD";
		$pphlist[3139]=1000;
		$notes="";
		$plugs=0;
		$masking=0;
		$sql="select * from items i, vendor_colors c, vendors v where item_name=? and i.powder_color=c.vc_id and c.vendor_id=v.vendor_id ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$itemName));
		if (count($rs)>0) {
			$data=$rs[0];
			$notes="PLEASE APPLY " . $data['vendor_part'] . " " . $data['color_code'] . " " . $data['color_description'] . " " . $data['vendor_name'];
			$plugs=$data['plugs'];
			$masking=$data['masking'];
		}
		if ($plugs > 0 or $masking > 0) {
			$oplist=array(3119, 3138, 3139);
		} else {
			$oplist=array(3138, 3139);
		}
		foreach ($oplist as $op) {
			$sql="select * from routing where operation_id=$op and parent_part=?";
			list($rs,$err)=runIQuery($db,$sql,array("s",$itemName));
			if (count($rs)==0) {
				$max+=10;
				$wc=$wclist[$op];
				$machine=$mlist[$op];
				$desc=$dlist[$op];
				$rnotes="";
				## put notes in racking and powder application
				if (in_array($op,array(3139))) {
					$rnotes=$notes;
				}
				$pph=$pphlist[$op];
				$sql="insert into routing (description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, vendor_id, display_sequence, calculate) ";
				$sql.=" values ('$desc', '$itemName', $op, 0, $wc, $pph, 1, 1, '$rnotes', 0, $max, 0) ";
				$updrs=runIQuery($db,$sql);
			} else {
				## if this is plugs/masking, add after it
				$max=$rs[0]['display_sequence'];
			}
		}

	}
}


function addPaintSteps($db,$itemName,$max=0) {
	if ($max == 0) {
		$sql="select max(display_sequence) from routing where parent_part=?";
		list($rs,$err)=runIQuery($db,$sql,array("s",$itemName));
		if (count($rs)) {
			$max=$rs[0][0];
		}
	}
	$sql="select display_sequence from routing where parent_part=? and operation_id=3138 ";
	list($rs,$err)=runIQuery($db,$sql,array("s",$itemName));
	if (count($rs)>0) {
		switchFromLineToBatch($db,$itemName);
	} else {

		## 3113 - 176 racking
		## 3109 - 171 pretreat
		## 3110 - 172 dry off
		## 3119 - 179 Plug/Mask
		## 3116 - 173 powder application
		## 3112 - 174 cure
		## 3090 - 163 material handling

		$wclist=array();
		$wclist[3113]=176;
		$wclist[3109]=171;
		$wclist[3110]=172;
		$wclist[3116]=173;
		$wclist[3119]=179;
		$wclist[3112]=174;
		$wclist[3090]=163;

		$dlist=array();
		$dlist[3113]="RACKING";
		$dlist[3109]="PRE-TREAT";
		$dlist[3110]="DRY OFF";
		$dlist[3116]="APPLY POWDER";
		$dlist[3119]="PLUG/MASK";
		$dlist[3112]="CURE";
		$dlist[3090]="UNLOAD/PACKAGE";

		$pphlist=array();
		$pphlist[3113]=16;
		$pphlist[3109]=30;
		$pphlist[3110]=29;
		$pphlist[3116]=18;
		$pphlist[3119]=98;
		$pphlist[3112]=402;
		$pphlist[3090]=34;

		$oplist=array(3113, 3109, 3110, 3119, 3116, 3112, 3090);

		$notes="";
		$sql="select * from items i, vendor_colors c, vendors v where item_name=? and i.powder_color=c.vc_id and c.vendor_id=v.vendor_id ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$itemName));
		if (count($rs)>0) {
			$data=$rs[0];
			$notes="PLEASE PAINT " . $data['vendor_part'] . " " . $data['color_code'] . " " . $data['color_description'] . " " . $data['vendor_name'];
		}

		foreach ($oplist as $op) {
			$sql="select * from routing where operation_id=$op and parent_part=?";
			list($rs,$err)=runIQuery($db,$sql,array("s",$itemName));
			if (count($rs)==0) {
				$max+=10;
				$wc=$wclist[$op];
				$desc=$dlist[$op];
				$rnotes="";
				## put notes in racking and powder application
				if (in_array($op,array(3113, 3116))) {
					$rnotes=$notes;
				}
				$pph=$pphlist[$op];
				$sql="insert into routing (description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, vendor_id, display_sequence, calculate) ";
				$sql.=" values ('$desc', '$itemName', $op, 0, $wc, $pph, 1, 1, '$rnotes', 0, $max, 0) ";
				$updrs=runIQuery($db,$sql);
			}
		}
	}

}

function addPaintStepsLine($db,$itemName,$max=0) {
	if ($max == 0) {
		$sql="select max(display_sequence) from routing where parent_part=?";
		list($rs,$err)=runIQuery($db,$sql,array("s",$itemName));
		if (count($rs)) {
			$max=$rs[0][0];
		}
	}
	$sql="select display_sequence from routing where parent_part=? and operation_id in (3138,3113) ";
	list($rs,$err)=runIQuery($db,$sql,array("s",$itemName));
	if (count($rs)>0) {
		## nothing to do
	} else {
		$sql="select plugs, masking from items where item_name=?";
		list($rs,$err)=runIQuery($db,$sql,array('s',$itemName));
		$data=$rs[0];
		$plugs=$data[0];
		$mask=$data[1];
		if ($plugs > 0  or $mask > 0) {
			## if plugging or masking, then get the display sequence for that and add 10 so our load and unload happen after it
			$sql="select display_sequence from routing where parent_part=? and operation_id=3119";
			list($rs,$err)=runIQuery($db,$sql,array("s",$itemName));
			if (count($rs)>0) {
				$data=$rs[0];
				$seq=$data[0];
				$seq+=10;
			} else {
				$seq=$max+10;
				$sql="insert into routing (description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, vendor_id,
				display_sequence, opname, machine, workcenter, calculate, step_cost) values ('Plug/Mask', ?, 3119, 0, 179, 0, 1, 1, '', 0, ?, '','','',0,0)  ";
				list($updrs,$err)=runIQuery($db,$sql,array("si",$itemName,$seq));
				$seq+=10;
			}
		}
		$sql="select * from routing where parent_part=? and operation_id=3138";
		list($rs,$err)=runIQuery($db,$sql,array("s",$itemName));
		if (count($rs)==0) {
			$sql="insert into routing (description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, vendor_id,
				display_sequence, opname, machine, workcenter, calculate, step_cost) values ('Load', ?, 3138, 328, 186, 0, 2, 1, '', 0, ?, '','','',0,0)  ";
			list($updrs,$err)=runIQuery($db,$sql,array("si",$itemName,$seq));
			$seq+=10;
		}
		$sql="select * from routing where parent_part=? and operation_id=3139";
		list($rs,$err)=runIQuery($db,$sql,array("s",$itemName));
		if (count($rs)==0) {
			$sql="insert into routing (description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, vendor_id,
				display_sequence, opname, machine, workcenter, calculate, step_cost) values ('Unload', ?, 3139, 329, 187, 0, 2, 1, '', 0, ?, '','','',0,0)  ";
			list($updrs,$err)=runIQuery($db,$sql,array("si",$itemName,$seq));
		}
	}

}


function createItemIfNotExists() {

}

### cma 3/27/23 force =1 means it will force  a new job as this is the behavior we want when coming from CreateJobsForOrder
function CreateJob($part,$qty,$ol,$due,$customer,$force=0) {
	global $db;
	global $userSalesPersonID;
	if (! $ol) {
		$ol=0;
	}
	## there can be no job without a step
	$sql="select * from routing where parent_part=? ";
	list($rs,$err)=runIQuery($db,$sql,array("s",$part));
	if (count($rs)==0) {
		return 0;
	}
	$sql="select item_description from items where item_name=?";
	list($rs,$err)=runIQuery($db,$sql,array("s",$part));
	$desc=$rs[0][0];
	$due=formatDateWebToDB($due);
	if ($due == "0000-00-00") {
		$sql="select due_date from order_lines where line_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$ol));
		$due=$rs[0][0];
		$olead=getOrderLeadTime($db,$ol);
		$due=SubtractBusinessDays($due,$olead);
	}

	$sql="select job_id from jobs where item_id=? and line_id=? and line_id > 0 ";
	list($rs,$err)=runIQuery($db,$sql,array("si",$part,$ol));
	if (count($rs)==0 or $force == 1) {
		$newStatus=1;
		$sql="select status from order_lines l, orders o where l.line_id=? and l.order_id=o.order_id and o.status=6";
		list($rs,$err)=runIQuery($db,$sql,array("i",$ol));
		if (count($rs)>0) {
			$newStatus=4;
			## quote
		}
		$sql="insert into jobs (item_id, description, sequence, start_date, quantity_scheduled, quantity_good, customer_id, shift, status, line_id, who, duration) ";
		$sql.=" values (?, ?, CURDATE(), ?, ?, 0, ?, 1, $newStatus, ?, ?,0) ";
		list($rs,$err)=runIQuery($db,$sql,array("sssiiii",$part,$desc,$due,$qty,$customer,$ol,$userSalesPersonID));
		$job=$rs[0][0];
		$sql="update po_lines set job_id=? where job_id=0 and order_line=?";
		list($updrs,$err)=runIQuery($db,$sql,array("ii",$job,$ol));
		## create the schedule for this job
		liveScheduling($db,$job);
	} else {
		$job=$rs[0][0];
	}
	return $job;
}


function isInBillofMaterial($db,$finishedGood,$part,$level=1) {
	$retval=FALSE;
	if ($level > 9) {
		print "hitting level 9<BR>";
		return FALSE;
	}
	$sql="select child_item from billofmaterial where parent_item=? ";
	list($rs,$err)=runIQuery($db,$sql,array("s",$finishedGood));
	foreach ($rs as $data) {
		$child=$data['child_item'];
		if ($child == $part) {
			$retval=TRUE;
		} else {
			$level++;
			if (isInBillofMaterial($db,$child,$part,$level)) {
				$retval=TRUE;
			}
		}
	}
	return $retval;
}

function getAppropriateParent($db,$finishedGood,$part) {
	$retval="";
	$sql="select parent_item from billofmaterial where child_item=?";
	list($rs,$err)=runIQuery($db,$sql,array("s",$part));
	foreach ($rs as $data) {
		$parent=$data['parent_item'];
		if (isInBillofMaterial($db,$finishedGood,$parent)) {
			$retval=$parent;
		}
	}
	return $retval;
}

function checkIfLegWeldment($db,$parent) {
	$sql="select * from leg_weldments where part_number=? LIMIT 1";
	list($rs,$err)=runIQuery($db,$sql,array("s",$parent));
	return count($rs);
}

function CreatePO($part,$qty,$ol,$due,$polist,$finishedGood,$job=0) {
	global $db;
	global $userID;
	global $userSalesPersonID;
	if (! $ol) {
		$ol=0;
	} else {
		$sql="select item_id from order_lines where line_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$ol));
		$finishedGood=$rs[0][0];
	}
	$parent=getAppropriateParent($db,$finishedGood,$part);
	$isLegs=checkIfLegWeldment($db,$parent);
	$sql="select item_description, lead_time,cost,item_id, vendor_id from items where item_name=? ";
	list($ors,$err)=runIQuery($db,$sql,array("s",$part));
	$data=$ors[0];
	$description=$data['item_description'];
	$leadTime=$data['lead_time'];
	$price=$data['cost'];
	$vendor=$data['vendor_id'];
	if (! $vendor) {
		$vendor=0;
	}
	$itemID=$data['item_id'];
	$poNumber=0;
	foreach ($polist as $po) {
		if ($po > 0) {
			$sql="select order_id from po_lines pl, order_lines l where pl.po_id=? and pl.order_line=l.line_id ";
			list($ors,$err)=runIQuery($db,$sql,array("i",$po));
			$poOrder=0;
			if (count($ors)>0) {
				$poOrder=$ors[0][0];
			}
			$orderID=0;
			$sql="select order_id from order_lines where line_id=?";
			list($rs,$err)=runIQuery($db,$sql,array("i",$ol));
			$orderID=0;
			if (count($rs)>0) {
				$data=$rs[0];
				$orderID = $data[0];
			}
			if ($orderID == $poOrder) {
				$sql="select p.vendor_id, p.ship_city, coalesce(b.parent_item,'') as po_parent from purchase_orders p left outer join po_lines l on p.po_id=l.po_id  left outer join items i on l.item_id=i.item_id ";
				$sql.=" left outer join billofmaterial b on i.item_name=b.child_item where p.po_id=?";
				list($ors,$err)=runIQuery($db,$sql,array("i",$po));
				$data=$ors[0];
				if ($data['vendor_id']==$vendor) {
					if ($vendor != 0) {
						$poParent=$data['po_parent'];
						$il=checkIfLegWeldment($db,$data['po_parent']);
						if ($isLegs == $il) {
							$poNumber=$po;
						}
					}
				}
			}
		}
	}
	if ($poNumber == 0) {
		## create new po
		$sql="select order_id from order_lines where line_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$ol));
		$orderID=0;
		if (count($rs)>0) {
			$data=$rs[0];
			$orderID = $data[0];
		}
		$sql="select * from company_shiptos order by shipto_id LIMIT 1";
		list($rs,$err)=runIQuery($db,$sql);
		$data=$rs[0];
		$shipName=$data['ship_name'];
		$shipAddress=$data['ship_address'];
		$shipCity=$data['ship_city'];
		$shipState=$data['ship_state'];
		$shipZip=$data['ship_zip'];
		$shipPhone=$data['ship_phone'];
		$who=$userID;
		$sql="insert into purchase_orders (po_date, status, vendor_id, who, ship_name, ship_address, ship_city, ship_state, ship_zip, job_id, phone, date_due, reference) values (curdate(), 1, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?) ";
		list($rs,$err)=runIQuery($db,$sql,array("iisssssisss",$vendor,$who,$shipName,$shipAddress, $shipCity, $shipState, $shipZip, $job, $shipPhone,$due,$orderID));
		$poNumber=$rs[0][0];

		// PO ACTIVITY insert new PO
		updatePOActivity($db,$poNumber,1,"PO Created for SO $orderID - Open");
	}
	$opid=0;
	$sql="select line_id from po_lines where po_id=? and item_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("ii",$poNumber,$itemID));
	if ($qty < 1) {
		$qty=1;
	} else {
		$qty=round($qty);
	}
	if (count($rs)>0) {
		$lineID=$rs[0][0];
		$sql="update po_lines set quantity = quantity + $qty where line_id=?";
		list($urs,$err)=runIQuery($db,$sql,array("i",$lineID));
	} else {
		$price=getVendorPrice($db,$vendor,$itemID,$qty);
		$sql="insert into po_lines (po_id, item_id, description, quantity, price, date_expected, job_id, operation_id, order_line) values (?, ?, ?, ?, ?, ?, ?,?,?) ";
		list($urs,$err)=runIQuery($db,$sql,array("iissssiii",$poNumber,$itemID,$description,$qty,$price,$due,$job,$opid,$ol));

	}

	$sql="update order_lines set inhouse_decision='PURCHASE' where line_id=?";
	list($updrs,$err)=runIQuery($db,$sql,array("i",$ol));
	$sql="update orders set inhouse_decision='PURCHASE', inhouse_when=now(), inhouse_who=? ";
	$sql.=" where order_id in (select order_id from order_lines where  line_id=?) and coalesce(inhouse_decision,'')='' ";
	list($rs,$err)=runIQuery($db,$sql,array("ii",$userID,$ol));
	return $poNumber;
}


function consumeComponents($db,$routing,$qty,$job,$script,$good,$step) {
	global $userID;
	$sql="select child_item, quantity_per, runseq from billofmaterial where routing_id = ?  and routing_id > 0 ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$routing));
	foreach ($rs as $data) {
		$child=$data['child_item'];
		$newq=$qty * $data['quantity_per'];
		if ($newq==0) {
			$newq=1;
		}
		$newq=$newq*-1;
		$sql="select item_id, item_category from items where item_name=?";
		list($irs,$ierr)=runIQuery($db,$sql,array("s",$child));
		$idata=$irs[0];
		$item_id=$idata[0];
		$category=$idata[1];
		if ($good) {
			inventoryUpdate($db,$item_id,$newq,$script,"Job <a href='editJob.php?id=$job' target='_blank'>$job</a> Step $step Consumed",$userID);
		} else {
			inventoryUpdate($db,$item_id,$newq,$script,"Job <a href='editJob.php?id=$job' target='_blank'>$job</a> Step $step Consumed - Defects",$userID);
		}
	}
}

function createMaintenanceTasks($db,$month) {
	## Create any tasks from standard operations that are necessary
	$sd=date("Y-$month-01");
	$today=date("Y-m-d");
	while(date("m",strtotime($sd)) == $month) {
		if ($today <= $sd) {
			$sql="select * from maintenance_operations where operation_id not in (select operation_id from maintenance_tasks where date_due=?) ";
			list($rs,$err)=runIQuery($db,$sql,array("s",$sd));
			foreach ($rs as $data) {
				$target=$data['target_id'];
				$name=$data['operation_name'];
				$description=$data['operation_description'];
				$frequency=$data['operation_frequency'];
				$type=$data['operation_type'];
				$day=$data['day_of_week'];
				$mday=$data['day_of_month'];
				$saturday=$data['saturdays'];
				$operationID=$data['operation_id'];
				$units=$data['units'];
				$assignedTo=0;
				$sql="select assigned_to from maintenance_tasks where operation_id=? order by task_id desc limit 1";
				list($trs,$err)=runIQuery($db,$sql,array("i",$operationID));
				if (count($trs)>0) {
					$assignedTo=$trs[0][0];
				}
				$dayOfWeek = date("l", strtotime($sd));
				## Daily Tasks
				if ($frequency == 1) {
					if ($dayOfWeek != "Sunday") {
						if ($dayOfWeek != "Saturday" or $saturday) {
							$sql="insert into maintenance_tasks (task_name, task_description, target_id, date_due, assigned_to, task_type, operation_id) values (?, ?, ?, ?, ?, ?, ?) ";
							list($updrs,$err)=runIQuery($db,$sql,array("ssisiii",$name,$description,$target,$sd,$assignedTo,$type,$operationID));
						}
					}
				}
				## Weekly Tasks
				if ($frequency == 2) {
					if ($dayOfWeek == $day) {
						$testDate=SubtractBusinessDays($sd,5*$units,$db);
						$sql="select * from maintenance_tasks where operation_id=? and date_due > ? ";
						list($trs,$err)=runIQuery($db,$sql,array("is",$operationID,$testDate));
						$alreadyExists=count($trs);
						if (! $alreadyExists) {
							$sql="insert into maintenance_tasks (task_name, task_description, target_id, date_due, assigned_to, task_type, operation_id) values (?, ?, ?, ?, ?, ?, ?) ";
							list($updrs,$err)=runIQuery($db,$sql,array("ssisiii",$name,$description,$target,$sd,$assignedTo,$type,$operationID));
						}
					}
				}
				## Monthly Tasks
				if ($frequency == 3) {
					$dayOfMonth=substr($sd,-2);
					if ($dayOfWeek != "Sunday") {
						if ($dayOfWeek != "Saturday" or $saturday) {
							if ($mday <= $dayOfMonth) {
								$td=DateTime::createFromFormat("Y-m-d",$sd);
								$td->modify("-$units months");
								$testDate=$td->format("Y-m-d");
								$sql="select * from maintenance_tasks where operation_id=? and date_due > ? ";
								list($trs,$err)=runIQuery($db,$sql,array("is",$operationID,$testDate));
								$alreadyExists=count($trs);
								if (! $alreadyExists) {
									$sql="insert into maintenance_tasks (task_name, task_description, target_id, date_due, assigned_to, task_type, operation_id) values (?, ?, ?, ?, ?, ?, ?) ";
									list($updrs,$err)=runIQuery($db,$sql,array("ssisiii",$name,$description,$target,$sd,$assignedTo,$type,$operationID));
								}
							}
						}
					}
				}
			}
		}
		$sd=date("Y-m-d",strtotime("+1 day",strtotime($sd)));
	}
}

function processTables($table="") {
	global $db;
	$sql="show tables";
	if ($table) {
		$sql.=" like '$table'";
	}
	$rs=mysqli_query($db,$sql);
	while ($data=mysqli_fetch_array($rs)) {
		$tn=$data[0];
		$id=0;
		$sql="select * from table_names where table_name='$tn'";
		$trs=mysqli_query($db,$sql);
		if (! mysqli_num_rows($trs)) {
			$sql="insert into table_names (table_name, table_title) values ('$tn','" . ucwords(strtolower(str_replace("_"," ",$tn))) . "')";
			$trs=mysqli_query($db,$sql);
			$id=mysqli_insert_id($db);
			$sql="insert into admin_access (user_id, table_name, allow_view, allow_edit, allow_delete) values (1, '$tn', 1,1,1) ";
			$trs=mysqli_query($db,$sql);
		}
		$sql="show fields in $tn";
		$trs=mysqli_query($db,$sql);
		$seq=10;
		while ($tdata=mysqli_fetch_array($trs)) {
			$field=$tdata[0];
			if ($seq==10) {
				if ($id > 0) {
					$sql="update table_names set key_field='$field' where tn_idx=$id";
					$urs=mysqli_query($db,$sql);
				}
			}
			$type=$tdata[1];
			if ($type=='datetime') {
				$type='date';
			}
			$size=20;
			if (substr($type,0,6)=='bigint') {
				$type="N";
				$size=4;
			}
			if (substr($type,0,6)=='decima') {
				$type="N";
				$size=4;
			}
			if (substr($type,0,3)=='int') {
				$type="N";
				$size=2;
			}
			if (substr($type,0,5)=='float') {
				$type="N";
				$size=2;
			}
			if (substr($type,0,7)=='tinyint') {
				$type="B";
				$size=1;
			}
			if (substr($type,0,7)=='varchar') {
				$type="C";
			}
			$ai=$tdata[5];
			$default=$tdata[4];
			$key=0;
			if ($tdata[3]=="PRI") {
				$key=1;
			}
			$title=ucwords(strtolower(str_replace("_"," ",$field)));
			$title=str_replace(" Id","",$title);
			$sql="select * from field_names where table_name='$tn' and field_name='$field'";
			$urs=mysqli_query($db,$sql);
			if (! mysqli_num_rows($urs)) {
				$sql="insert into field_names (table_name, field_name, title, field_type, field_size, default_value, display_sequence, key_field) ";
				$sql.=" values ('$tn','$field','$title','$type','$size','$default',$seq,$key) ";
				$updrs=mysqli_query($db,$sql);
				$id=mysqli_insert_id($db);
				if ($field=='state') {
					$sql="update field_names set lookup_table='states', lookup_field='abbreviation', return_field='name' where fn_idx=$id";
					$rs=mysqli_query($db,$sql);
				}
			}
			$seq+=10;
		}
	}
}
function getVendorLeadTime($db,$ol) {
	$sql="select p.vendor_id, count(*) from order_lines l, items i, po_lines pl, purchase_orders p where l.line_id=? and l.item_id=i.item_name and i.item_id=pl.item_id and pl.po_id=p.po_id ";
	$sql.=" order by count(*) desc ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$ol));
	$useVendor=$rs[0][0];
	if (! $useVendor) {
		return 7;
	} else {
		$sql="select lead_time from vendors where vendor_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$useVendor));
		$lead=$rs[0][0];
		if (! $lead) {
			return 7;
		} else {
			return $lead;
		}
	}
}
function getOrderLeadTime($db,$ol) {
	$lead=2;
	$sql="select customer_id, ship_address, ship_city, ship_state, ship_zip from order_lines l, orders o where line_id=? and l.order_id=o.order_id ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$ol));
	$data=$rs[0];
	$customer=$data['customer_id'];
	$sql="select customer_lead_time from customers where customer_id=?";
	list($lrs,$err)=runIQuery($db,$sql,array("i",$customer));
	if (count($lrs)>0) {
		foreach ($lrs as $ldata) {
			$lead=$ldata['customer_lead_time'];
		}
	}
	$address=$data['ship_address'];
	$city=$data['ship_city'];
	$state=$data['ship_state'];
	$sql="select ship_lead_time from customer_shiptos where customer_id=? and ship_address=? and ship_city=? and ship_state=?";
	list($rs,$err)=runIQuery($db,$sql,array("isss",$customer,$address,$city,$state));
	$olead=$lead;
	if (count($rs)>0) {
		$data=$rs[0];
		$olead=$data['ship_lead_time'];
	}
	return $olead;
}

function GetLeadTimeForOperation($db,$job) {
			## need to get the number of days to back off due to what step the job is doing
			## assembly - 5 business days
			## fab - 5 business days - (unless there was assembly, then 3)
			## powder coat - 3
			## welding - 3
			## bend  - 3
			## laser - 3

	$sql="select operation_name from jobs j, routing r, operations o where j.job_id=? and j.item_id=r.parent_part and r.operation_id=o.operation_id";
	list($rs,$err)=runIQuery($db,$sql,array("i",$job));
	$lead=0;
	$ops=array();
	foreach ($rs as $data) {
		$op=$data['operation_name'];
		if (! in_array($op,$ops)) {
			if ($op == "Asssembly") {
				$lead+=5;
			}
			if ($op == "Production Fab") {
				$lead+=5;
			}
			if ($op == "Fabrication") {
				$lead+=5;
			}
			if ($op == "Production Weld") {
				$lead+=3;
			}
			if ($op == "Weld") {
				$lead+=3;
			}
			if ($op == "Racking") {
				$lead+=3;
			}
			if ($op == "Bend") {
				$lead+=3;
			}
			if ($op == "Laser") {
				$lead+=3;
			}
		}
	}

}
## create all necessary jobs for this sales order
function CreateJobsForOrder($db,$id) {
	global $scriptid;
	$sql="select * from orders where order_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));

	$data=$rs[0];
	$customer=$data['customer_id'];
	$status=$data['status'];
	$sql="select l.*, quantity_on_hand from order_lines l, items i where order_id=? and l.item_id=i.item_name order by line_id  ";
	$pitext="";
	if ($scriptid == "fixSchedule.php") {
		print "checking so $id<Br>";
	}
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	foreach($rs as $ldata) {
		$ol=$ldata['line_id'];
		$part=$ldata['item_id'];
		if ($scriptid == "fixSchedule.php") {
			print "part $part<BR>";
		}
		$desc=$ldata['item_description'];
		$desc=str_replace("'","",$desc);
		$desc=str_replace('"','',$desc);
		$qty=$ldata['quantity'];
		$oqty=$ldata['quantity'];
		$ldue=$ldata['due_date'];
		$due=formatDateDBToWeb($ldata['due_date']);
		$sql="select * from jobs where line_id=? and item_id=?  ";
		list($wrs,$err)=runIQuery($db,$sql,array("is",$ol,$part));
		if (count($wrs) > 0) {
			## already on  a job
			$wdata=$wrs[0];
			$qs=$wdata['quantity_scheduled'];
			$job=$wdata['job_id'];
			if ($scriptid == "fixSchedule.php") {
				print "on job $job<BR>";
			}
			if ($qs <> $qty) {
				$sql="update jobs set quantity_scheduled=? where line_id=? and item_id=?";
				list($updrs,$err)=runIQuery($db,$sql,array("iis",$qty,$ol,$part));
			}
			if ($wdata['status'] == 7 or $wdata['status'] == 9) {
				## system deleted, now re-open it
				$sql="update jobs set status=1 where line_id=? and item_id=?";
				list($wrs,$err)=runIQuery($db,$sql,array("is",$ol,$part));
			}
			## need to adjust the due date for the job and if the customer changed
			$olead=getOrderLeadTime($db,$ol);
			$due=SubtractBusinessDays($ldue,$olead);
			$sql="update jobs set start_date=?, customer_id=? where job_id=?";
			list($updrs,$err)=runIQuery($db,$sql,array("sii",$due,$customer,$job));
				## now adjust the schedule_items table
			liveScheduling($db,$job,1);

		} else {
			## create for the so line item
			## check if it is a purchased part
			$sql="select vendor_id from items where item_name=?";
			list($rs,$err)=runIQuery($db,$sql,array("s",$part));
			$idata=$rs[0];
			$iv = $idata['vendor_id'];
			if ($scriptid == "fixSchedule.php") {
				print "vendor is $iv<BR>";
			}
		if (! $iv) {
				$olead=getOrderLeadTime($db,$ol);
				$due=SubtractBusinessDays($ldue,$olead);
				$job=CreateJob($part,$qty,$ol,formatDateDBToWeb($due),$customer);
			}
		}
		createJobsForChildren($db,$part,1,1,$qty,$firstDue,$customer,$ol);
		reset($wolist);
	}
}

function createJobsForChildren($db,$parent,$level,$qtyper,$qty,$ldue,$customer,$ol) {
	$sql="select b.*, vendor_id from billofmaterial b, items i where parent_item=? and child_item=item_name order by bom_id";
	list($brs,$berr)=runIQuery($db,$sql,array("s",$parent));
	foreach ($brs as $bdata) {
		$child=$bdata['child_item'];
		$qtyperThisPart=$bdata['quantity_per'];
		$routingID=$bdata['routing_id'];
		## find the first date that this child is consumed by a routing.
		$sql="select min(due_date) from jobs j, schedule_items si where  j.line_id=$ol and j.item_id='$parent' and j.job_id=si.job_id and routing_id=$routingID";
		list($rs,$err)=runIQuery($db,$sql);
		if (count($rs)>0) {
			$firstDue=$rs[0][0];
		} else {
			$firstDue=$ldue;
		}

		$bqty=$qtyper*$qtyperThisPart;
		if ($bdata['vendor_id']) {
		} else {
			$sql="select * from routing where parent_part='$child' ";
			list($rs,$err)=runIQuery($db,$sql);
			if (count($rs)>0) {
				## use last parameter to force individual jobs				
				$job=CreateJob($child,$bqty,$ol,formatDateDBToWeb($firstDue),$customer,1);
				liveScheduling($db,$job,1);
				if ($level < 15) {
					createJobsForChildren($db,$child,$level+1,$qtyper,$qty,$firstDue,$customer,$ol);
				}
			}
		}
	}
	return;
}



function makeQuantityFromJob($db,$job,$qty,$script) {
	global $userID;
	$sql="select * from jobs where job_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$job));
	$data=$rs[0];
	$item_name=$data['item_id'];
	$customer_id=$data['customer_id'];
	$sql="select item_id, item_description, default_location, raw_item_name from items where item_name=?";
	list($rs,$err)=runIQuery($db,$sql,array("s",$item_name));
	$data=$rs[0];
	$item_id=$data['item_id'];
	$loc=$data['default_location'];
	$raw=trim($data['raw_item_name']);
	if (! $loc) {
		$loc=1;
	}
	if (! $customer_id) {
		$customer_id=0; ## must be building to stock
	}
	$sql="update jobs set quantity_good=quantity_good+$qty where job_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$job));
	# close the job if quantity is enough
	$sql="update jobs set status=2 where quantity_good >= quantity_scheduled and job_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$job));
	if ($raw) {
		## make the raw inventory for this painted part - the painted is created when we receive the PO
		$sql="select item_id from items where item_name=?";
		list($$rs,$err)=runIQuery($db,$sql,array("s",$raw));
		if (count($rs)) {
			$rawID=$rs[0][0];
			inventoryUpdate($db,$rawID,$qty,$script,"Job $job Built - Unpainted",$userID,$loc);
		} else {
			inventoryUpdate($db,$item_id,$qty,$script,"Job $job Built",$userID,$loc);
		}
	} else {
		# make the built inventory
		inventoryUpdate($db,$item_id,$qty,$script,"Job $job Built",$userID,$loc);
	}
}
function createPieceWorkResults($db,$card,$job,$minutes,$qtygood,$notes,$lastPunch,$newPunch,$complete) {
	$sql="select employee_id from employees where card_number=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$card));
	$data=$rs[0];
	if ($data[0]) {
		$employee=$data[0];
	}
	if (! $employee)  {
		$employee=$card;
	}
	if (! $employee) {
		$employee=0;
	}
	date_default_timezone_set('America/Detroit');
	$sql="SET time_zone = '" .date('P') . "'";
	list($rs,$err)=runIQuery($db,$sql);
    $sql="select * from piece_work where job_id=? and employee_id=? and result_date=curdate() and start_time=? and end_time=? ";
	list($rs,$err)=runIQuery($db,$sql,array("iiss",$job,$employee,$lastPunch,$newPunch));
	if (count($rs)==0) {
		$sql="insert into piece_work (job_id,  employee_id, result_date,  duration_minutes, quantity_good,  notes, start_time, end_time, complete) values (?, ?,  now(), ?, ?, ?, ?, ?, ?) ";
		list($rs,$err)=runIQuery($db,$sql,array("iiiisssi",$job,$employee,$minutes,$qtygood,$notes,$lastPunch,$newPunch,$complete));
	}
}

// added by Brittany 6/24/22
//takes parent part and finds materials used by child(ren); must be provided with an array $materialList to push found materials into
function findMaterials($parent,$maxdepth=10,$depth=1) {
	if ($depth > $maxdepth) {
		return;
	}
	global $db,$materialList;
	$sql="select i.material from items i, items ii where i.item_name=? and i.material=ii.item_name and ii.item_category=24 ";
	list($brs,$err)=runIQuery($db,$sql,array("s",$parent));
	if (count($brs)) {
		if ($brs[0][0]) {
			$materialList[0]=$brs[0][0];
			return;
		}
	}
	$sql="select child_item, item_category from billofmaterial  b, items i where parent_item=? and child_item=item_name ";
	list($brs,$err)=runIQuery($db,$sql,array("s",$parent));
	foreach ($brs as $bdata) {
		$child=$bdata['child_item'];
		$category=$bdata['item_category'];
		if ($category == 24) {
			if (! in_array($child,$materialList)) {
				$materialList[]=$child;
				return;
			}
		} else {
			findMaterials($child,$maxdepth,$depth+1);
		}
	}
	return;
}

function containsLaser($job) {
	global $db, $operationList;

	$sql="SELECT DISTINCT operation_name from jobs left outer join routing on routing.parent_part=jobs.item_id
	left outer join operations on routing.operation_id=operations.operation_id
	left outer join production_results r on routing.routing_id=r.routing_id and jobs.job_id=r.job_id
	where jobs.job_id=?";
	list($lrs,$err)=runIQuery($db,$sql,array('i',$job));
	foreach ($lrs as $ldata) {
		$operation=$ldata['operation_name'];
		$operationList[]=$operation;
	}
	if (in_array('Laser',$operationList)) {
		return true;
	} else {
		return false;
	}
}

function renderPartLink($customer,$item,$dxfOnly=0,$message=0) {
	$customer=str_replace(" ","",$customer);
	$idItem=str_replace("'","",$item);
	$idItem=str_replace(" ","",$idItem);
	$idItem=str_replace("-","",$idItem);
	$idItem=str_replace("_","",$idItem);
	$idItem=str_replace(".","",$idItem);
	$rnd=random_int(1,10000);
	$retval="<span id='partlinkwrapper$idItem'>";
	$retval.= "DXF: <a href='http://pwncell22.pm.local/$customer/DXF/$item.dxf?rand=$rnd' target='_blank' id='partlink$idItem'>$item</a>";
	$retval.="</span>";
	$retval.="\n<script>\nvar url=document.getElementById('partlink$idItem').href;\nvar httppl$idItem = new XMLHttpRequest();\nhttppl$idItem.open('HEAD', url, true);\n
	httppl$idItem.onload = (e) => { \n
		if (httppl$idItem.readyState == 4) { \n
			if (httppl$idItem.status == 404) {
				document.getElementById('partlinkwrapper$idItem').innerHTML=\"<font color='red'>$item NO DXF</font>\";
			}\n
		}\n
	}\n
	httppl$idItem.onerror = (e) => {\n
	}
	httppl$idItem.send(null);
	</script>\n";
	if (! $dxfOnly) {
		$retval.="<span id='pdflinkwrapper$idItem'>";
		$retval.= " PDF: <a href='http://pwncell22.pm.local/$customer/PDF/$item.pdf?rand=$rnd' target='_blank' id='pdflink$idItem' >$item</a>";
		$retval.="</span>";
		$retval.="\n<script>\nvar url=document.getElementById('pdflink$idItem').href;\n";
		$retval.="console.log(url);\n";
		$retval.="var httpdl$idItem = new XMLHttpRequest();\n
			httpdl$idItem.open('HEAD', url, true);\n
			httpdl$idItem.onload = () => {\n
				if (httpdl$idItem.readyState == 4) {\n
					console.log('status: ' + httpdl$idItem.status);
					if (httpdl$idItem.status == 404) {
						document.getElementById('pdflinkwrapper$idItem').style.display='none';
					} \n
				}
			}
			httpdl$idItem.onerror = (e) => {\n
			}
			httpdl$idItem.send(null); \n";

		$retval.="</script>\n";
	}
	return $retval;
}

function renderPartLinkOpen($customer,$item) {
	$customer=str_replace(" ","",$customer);
	$rnd=random_int(1,10000);
	$retval="\n<script>\nvar url='http://pwncell22.pm.local/$customer/DXF/$item.dxf?rand=$rnd';\nvar httppl = new XMLHttpRequest();\nhttppl.open('HEAD', url, false);\nhttppl.send();\nif (httppl.status != 404) {\nwindow.open(url,'_blank');\n;}\nurl='http://pwncell22.pm.local/$customer/PDF/$item.pdf?rand=$rnd';httppl.open('HEAD', url, false);\nhttppl.send();\nif (httppl.status != 404) {\nwindow.open(url,'_blank');\n;}\n</script>\n";
	return $retval;

}
function getColorCode($db,$item,$job,$level=1) {
	$sql="select color_code from items i, vendor_colors vc where i.item_name=? and powder_color > 0 and powder_color=vc_id";
	list($crs,$err)=runIQuery($db,$sql,array("s",$item));
	if (count($crs)>0) {
		return $crs[0][0];
	} else {
		$level++;
		if ($level > 9) {
			return "L10";
		} else {
			if ($job) {
				$sql="select parent_item from billofmaterial b, jobs j where child_item=? and b.parent_item=j.item_id and j.job_id=?";
				list($crs,$err)=runIQuery($db,$sql,array("si",$item,$job));
			} else {
				$sql="select parent_item from billofmaterial b where child_item=? ";
				list($crs,$err)=runIQuery($db,$sql,array("s",$item));
			}
			foreach ($crs as $cdata) {
				## do not send job
				return getColorCode($db,$cdata[0],0,$level);
			}
		}
	}
}


function setOptionForPowder($db,$order,$bu) {
	if ($bu == 1) {
		## check for Powder
		$sql="select * from order_lines l, routing r where order_id=? and l.item_id=r.parent_part and operation_id in (3138, 3109, 3113, 3139, 3106)
			and r.notes not like 'PURCHASE To Print' 
			and order_id not in (select so_number from transfer_lines) ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$order));
		if (count($rs)>0) {
			return "transfer";
		}
		$sql="select * from order_lines l, billofmaterial b, routing r where order_id=? and l.item_id=b.parent_item 
			and b.child_item=r.parent_part and operation_id in (3138, 3109, 3113, 3139, 3106) and r.notes not like 'PURCHASE%' ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$order));
		if (count($rs)>0) {
			return "transfer";
		}
		return "ship";

	} else {
		return "ship";
	}

}

function getEmployeeCardNumber($db,$id,$isEmpId) {
	if ($isEmpId) {
		$sql = "SELECT card_number FROM employees WHERE employee_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	} else {
		$sql = "SELECT card_number FROM employees INNER JOIN site_admins ON employees.employee_id=site_admins.employee_link WHERE site_admins.user_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	}
	$cardNumber = $rs[0][0];
	return $cardNumber;
}



// Pending Review/Purchase Functions

// example output
/*
{
    "SS-WELD-NUT": { // item name is here
		"item_name": "SS-WELD-NUT", // and here so you can do either foreach ($bom as $item => $data) or foreach ($bom as $data)
        "parent": "C09116",
        "total_qty_per": 20,
        "quantity_per": 20,
        "item_category": 19,
        "vendor_id": 0,
        "operation_id": 3106,
        "routing_description": "PURCHASE",
        "children": []
    },
    "C09116-1": {
		"item_name": "C09116-1",
        "parent": "C09116",
        "total_qty_per": 1,
        "quantity_per": 1,
        "item_category": 17,
        "vendor_id": 0,
        "operation_id": 3123,
        "routing_description": "Laser",
        "children": [] // the children would be an array of objects with the same structure as it is recursive
    }
}
*/
// Keeping this function separate from getPurchasedPartsFromBOMList so we can potentially use it elsewhere, gets the entire BOM for an item
function getFullBOMForPart($db,$parent,$maxdepth=10,$parenttotalqtyper=1,$depth=1) {
    $boms=[];
    if ($depth > $maxdepth) {
        return $boms;
    }

    $sql = "SELECT bom.child_item, bom.quantity_per, coalesce(i.vendor_id,0) AS vendor_id, r.operation_id, r.description, item_category FROM billofmaterial bom, items i, routing r WHERE bom.child_item=i.item_name AND bom.parent_item=? AND r.parent_part=bom.child_item";
    list($rs,$err)=runIQuery($db,$sql,["s",$parent],0);
    foreach ($rs as $data) {
        $item = $data["child_item"];

        $total_qty_per = $data["quantity_per"] * $parenttotalqtyper;
        $boms[$item] = [
			"item" => $item,
			"parent" => $parent,
			"total_qty_per" => $total_qty_per,
			"quantity_per" => +$data["quantity_per"],
			"item_category" => $data["item_category"],
			"item_vendor" => $data["vendor_id"],
			"operation_id" => $data["operation_id"],
			"routing_description" => $data["description"],
		];
        $boms[$item]["children"] = getFullBOMForPart($db,$item,$maxdepth,$total_qty_per,$depth+1);
    }

    return $boms;
}

// Get all purchased part from a given parsed BOM list
function getPurchasedPartsFromBOMList($parent,$bomlist,$purchased=[]) {
    foreach ($bomlist["children"] as $child => $bom) {
        // item category 24 is sheet stock
        if (strtolower($bom["routing_description"]) == "purchase" && $bom["item_category"] != 24) { // if it has a vendor id it is purchased
            $purchased[$child] = $bom;
        }

        if (count($bom["children"])) {
            $purchased = getPurchasedPartsFromBOMList($child,$bom,$purchased);
        }
    }
	return $purchased;
}


// example output
/*
[
    {
        "order_id": 142360,
        "status": "Pending Review",
        "date_due": "2023-03-20",
        "customer_po": "677-1-7",
        "pending_items": [
			"SS-WELD-NUT": {
				"item_category": 19,
				"item_name": "SS-WELD-NUT",
				"qty_needed": 100,
				"existing_pos": []
			}
        ]
    },
    {} // more orders
]
*/
function getPendingPurchasedParts($db,$order_id=0,$onlyWITHpos=0) {
    // order status 16=Pending Review 17=Pending Purchase
    $sql = "SELECT o.order_id, o.po_number, os.status_name, o.date_due FROM orders o, order_status os WHERE os.status_id=o.status and o.status IN (16,17)";
    $vars = [];
    if ($order_id) {
        $sql .= " and order_id=?";
        $vars = ["i",$order_id];
    }
    list($rs,$err)=runIQuery($db,$sql,$vars);

    $orders = [];
    $order_lines = [];
    $purchase_orders = [];
    foreach ($rs as $data) {
        $orders[$data["order_id"]]=$data;
        $orders[$data["order_id"]]["order_lines"] = [];
    }

    // order status 16=Pending Review 17=Pending Purchase
    $sql = "SELECT DISTINCT
        ol.line_id,
        ol.order_id,
        ol.due_date,
        ol.item_id,
        ol.quantity,
        i.item_category,
        i.vendor_id,
        bom.parent_item,
		r.description as routing_description
    FROM
        order_lines ol
        LEFT OUTER JOIN items i ON ol.item_id=i.item_name /* left outer join in case the line's item_id is not valid, item_category on order_line parts is not crucial */
        LEFT OUTER JOIN billofmaterial bom ON ol.item_id=bom.parent_item
		LEFT OUTER JOIN routing r ON ol.item_id=r.parent_part AND LOWER(r.description)='purchase'
    WHERE ";
        if ($order_id) {
            $sql .= "order_id=? ";
        } else {
            $sql .= "order_id in (SELECT order_id FROM orders WHERE status in (16,17)) ";
        }
    $sql .= "GROUP BY ol.line_id";
    list($rs,$err)=runIQuery($db,$sql,$vars);
    foreach ($rs as $data) {
        $data["purchase_orders"] = [];
        $orders[$data["order_id"]]["order_lines"][] = $data;
    }

    // Separate po_lines query as two left outer joins are VERY inefficient and could hault production
    // order status 16=Pending Review 17=Pending Purchase
    $sql = "SELECT po_id, item_name, order_line FROM po_lines pol, items i WHERE pol.item_id=i.item_id AND order_line IN (SELECT line_id FROM order_lines WHERE order_id in (select order_id from orders where status in (16,17)))";
    list($rs,$err)=runIQuery($db,$sql);
    foreach ($rs as $data) {
        $ol = $data["order_line"];
        $item = $data["item_name"];
        if (!isset($purchase_orders[$ol])) {
            $purchase_orders[$ol] = [];
        }

        if (!isset($purchase_orders[$ol][$item])) {
            $purchase_orders[$ol][$item] = [];
        }
        $purchase_orders[$ol][$item][] = $data["po_id"];
    }

    $allboms = [];
    $pending_orders = [];
    foreach ($orders as $order) {
        $oid=$order["order_id"];
        $customer_po=$order["po_number"];
        $status=$order["status_name"];
        $date_due=$order["date_due"];
        $pending_order = [
            "order_id" => $oid,
            "status" => $status,
            "date_due" => $date_due,
            "customer_po" => $customer_po,
            "pending_items" => []
        ];

        foreach ($order["order_lines"] as $line) {
            $line_id = $line["line_id"];
            $item = $line["item_id"];
            $due_date = $line["due_date"];

            // process item's BOM
            if (!isset($allboms[$item])) {
                $allboms[$item]=["total_qty_per" => 1, "quantity_per" => 1, "item_category" => $line["item_category"], "item_vendor" => $line["vendor_id"], "children" => []]; // add the parent in case it is purchased for some reason
                if ($line["parent_item"] != NULL) { // item has no BOM, no need to check
                    $allboms[$item]["children"] = getFullBOMForPart($db,$line["item_id"]);
                }
            }

            $bom = $allboms[$item];
            $purchased_parts = [];

            if (count($bom["children"])) { // if there are any children, if not we can skip
				$newparts = getPurchasedPartsFromBOMList($item, $bom);
				foreach ($newparts as $np => $ndata) {
					if (!isset($purchased_parts[$np])) {
						$purchased_parts[$np] = $ndata;
					} else {
						$purchased_parts[$np]["total_qty_per"] += $ndata["total_qty_per"];
					}
				}
            }
			if (strtolower($line["routing_description"]) == "purchase") {
				$purchased_parts[$item] = $bom;
			}
            if (count($purchased_parts)) {
				// storing the order_line data in case we ever need to access it
                //$pending_line = ["line_item" => $item, "due_date" => $due_date, "line_id" => $line_id, "pending_children" => []];

				$these_pending_items = [];
                $haspos=0;
                foreach ($purchased_parts as $item_name => $data) {
                    $qty_needed = $data["total_qty_per"] * $line["quantity"]; // calculate the final qty needed based on total_qty_per

                    // get our po IF exists on the order line AND item name matches
                    $pos = [];
                    if (!empty($purchase_orders[$line_id][$item_name])) {
                        $pos = $purchase_orders[$line_id][$item_name];
                        $haspos=1;
                    }
                    $item_category = $data["item_category"];

					if (!isset($these_pending_items[$item_name])) {
						$these_pending_items[$item_name] = [
							"item_category" => $item_category,
							"item_name" => $item_name,
							"qty_needed" => $qty_needed,
							"existing_pos" => $pos,
						];
					} else {
						$these_pending_items[$item_name]["qty_needed"] += $qty_needed;
						$these_pending_items[$item_name]["existing_pos"] = array_merge($these_pending_items[$item_name]["existing_pos"],$pos);
					}
                }

                if (($order_id && !$haspos) || ($onlyWITHpos && $haspos) || (!$onlyWITHpos && !$order_id)) {
					foreach ($these_pending_items as $pending_item) {
						$item_name = $pending_item["item_name"];
						$pos = $pending_item["existing_pos"];

						if (!isset($pending_order["pending_items"][$item_name])) {
							$pending_order["pending_items"][$item_name] = $pending_item;
						} else {
							$pending_order["pending_items"][$item_name]["qty_needed"] += $pending_item["qty_needed"];
							$pending_order["pending_items"][$item_name]["existing_pos"] = array_merge($pending_order["pending_items"][$item_name]["existing_pos"], $pending_item["existing_pos"]);
						}
					}
                }
            }
        }

        if (count($pending_order["pending_items"])) {
            $pending_orders[] = $pending_order;
        }
    }

    return $pending_orders;
}

function updateOrderLineActivity($line,$activity) {
	global $db,$userID,$scriptid;
	$sql="INSERT INTO `order_line_activity` (`line_id`,`order_id`,`item_id`,`item_description`,`quantity`,`cost`,`document_id`,`po_line`,
		`shipped_quantity`,`due_date`,`revision`,`price`,`powder_color`,`primer_color`,`xdimension`,`ydimension`,`plugs`,`masking`,`line_status`,
		`inhouse_decision`,`operator_notes`,`business_unit_assigned`,`line_reviewed`, `user_id`, `date_changed`, `scriptid`, `activity`)
	select  
	`line_id`,`order_id`,`item_id`,`item_description`,`quantity`,`cost`,`document_id`,`po_line`,
		`shipped_quantity`,`due_date`,`revision`,`price`,`powder_color`,`primer_color`,`xdimension`,`ydimension`,`plugs`,`masking`,`line_status`,
		`inhouse_decision`,`operator_notes`,`business_unit_assigned`,`line_reviewed`, $userID, now(), '$scriptid' as scriptid, ? as activity
	from order_lines where line_id=? ";
	list($rs,$err)=runIQuery($db,$sql,array("si",$activity,$line));
}