<?php
$polist=array();
$materialList=array();
$operationList=array();

if ($line) {
	$sql="select distinct job_id from jobs where line_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$line));
	if (count($rs)==0) {
		$sql="select ship_name, order_lines.item_id, due_date, item_description, quantity 
		from orders 
		left outer join order_lines on orders.order_id=order_lines.order_id  where line_id=?";
		list($vrs,$err)=runIQuery($db,$sql,array("i",$line));
		foreach ($vrs as $vdata) {
			$ship=$vdata['ship_name'];
			$part=$vdata['item_id'];
			$due=formatDateDBToWeb($vdata['due_date']);
			$description=$vdata['item_description'];
			$sch=$vdata['quantity'];
			print "<tr><td>Not Scheduled</td><td>$part</td><td>$due</td><td>$ship</td><td>$sch</td>";
			$sql="select item_id from items where item_name=?";
			list($irs,$err)=runIQuery($db,$sql,array("s",$part));
			$itemID=$irs[0][0];
			print "</tr>\n";
		}
	}
	foreach ($rs as $data) {
		$job=$data['job_id'];
		//sql query for defects
		$dsql="SELECT DISTINCT job_defects.quantity, job_defects.date_reported, CONCAT(employees.first_name,' ',employees.last_name) AS employee_name, 
		operations.operation_name
		FROM job_defects 
		LEFT OUTER JOIN routing ON routing.routing_id=job_defects.routing_id
		LEFT OUTER JOIN operations ON routing.operation_id=operations.operation_id
		LEFT OUTER JOIN employees ON job_defects.user_id=employees.employee_id
		LEFT OUTER JOIN jobs ON job_defects.job_id =jobs.job_id 
		WHERE job_defects.job_id=jobs.job_id and jobs.job_id=?";
		list($drs,$err)=runIQuery($db,$dsql,array("i",$job));
		if (count($drs)) {
			$defects="<td><table><tr><th>Quantity</th><th>Who</th><th>When</th><th>Reason</th></tr>";
			foreach ($drs as $ddata) {
				$def_quan=$ddata['quantity'];
				$def_date=formatDateDBToWeb($ddata['date_reported']);
				$def_name=$ddata['employee_name'];
				$def_reason=$ddata['operation_name'];
			} 
			$defects.="<tr><td>$def_quan</td><td>$def_name</td><td>$def_date</td><td>$def_reason</td></tr>";
			$defects.="</table></td>";
		} else {
				$defects="<td></td>";
		}
		$sql="select distinct ship_name, j.item_id as part,  start_date, description, quantity_scheduled, j.quantity_good, j.status, c.name, l.shipped_quantity, l.item_id AS line_item
		 from orders o inner join order_lines l on o.order_id=l.order_id
		 	inner join jobs j on l.line_id=j.line_id 
			INNER JOIN customers c ON c.customer_id=o.customer_id
			 where o.order_id=? and j.job_id=? ";
		list($vrs,$err)=runIQuery($db,$sql,array("ii",$id,$job));
		foreach ($vrs as $vdata) {
			$ship=$vdata['ship_name'];
			$part=$vdata['part'];
			$due=formatDateDBToWeb($vdata['start_date']);
			$description=$vdata['description'];
			$sch=$vdata['quantity_scheduled'];
			$good=$vdata['quantity_good'];
			$shipQty=$vdata['shipped_quantity'];
			$lineItem=$vdata['line_item'];
			$s=$vdata['status'];
			$status=$jstat[$s];
			$customer=$vdata['name'];

			$isLineItem = 0;
			if ($part == $lineItem) {
				$isLineItem = 1;
			}

			//finding the material
			unset($operationList);
			unset($materialList);
			$materialList=array();
			$operationList=array();
			if (containsLaser($job)) {
				findMaterials($part);
			} else {
				$materialList=array();
				$material = "N/A";
			}
	
			if (is_array($materialList)) {
				if (count($materialList)) {
					foreach ($materialList as $listItem) {
						$material=$listItem;
					}
				} else {
					$materialList = "N/A";
				}
			}

			print "<tr>";
			print "<td>$due</td><td>$ship</td></td><td>";			
			print "<a href='editJob.php?id=$job' target='_blank'>$job</a>";
			print "<td>$status</td>";
				// find qty in bay
				$sql="select bay_name, sum(quantity)  from staging_bay_contents c, staging_bays b where c.line_id=? and c.item_id=? and c.bay_id=b.bay_id";
				list($brs,$err)=runIQuery($db,$sql,array("is",$line,$part));
				$bayQuantity=0;
				foreach ($brs as $bdata) {
					$bayQuantity+=$bdata[1];
				}
				if ($bayQuantity >= $sch) {
					print "<td style='color: green; font-weight: bold;'>";
				} elseif (($bayQuantity == 0) && ($shipQty > 0) && ($shipQty == $sch)) {
					print "<td style='font-weight: bold;'>";
				} else {
					print "<td style='color: red;'>";
				}
				if ($bayQuantity > 0) {
					$comma="";
					foreach ($brs as $bdata) {
						print $comma;
						print $bdata[0];
						if ($bdata[1]) {
							print " (" . $bdata[1] . ") ";
						}
						$comma=", ";
					}
				} elseif (($shipQty > 0) && ($shipQty == $sch)) {
					print "SHIPPED";
				}
				
			print "</td>"; // BAYS
			if ($isLineItem) {
				if ($shipQty > 0) {
					print "<td>$shipQty</td>";
				} else {
					print "<td>0</td>";
				}
				
			} else {
				print "<td>--</td>";
			}
			print "<td>";
			## DXF Only
			$partLink = renderPartLink($customer,$part,1); 
			$partLink = str_replace('DXF: ','',$partLink);
			print $partLink;
			print "</td>";
			print "<td>$description</td>";
			print $defects; // added defects here
			print "<td align='center'>$sch</td>";
			if ($material) {
				print "<td>$material</td>"; //added material here
			} else {
				print "<td>N/A</td>";
			}
			reset($oplist);
			foreach ($oplist as $o) {
				$alt="";
				if ($o == "Laser") {
					$sql="select nesting_name, nesting_date, nested_quantity from nesting where job_id=? order by nesting_id ";
					list($nrs,$err)=runIQuery($db,$sql,array("i",$job));
					$comma="";
					foreach ($nrs as $ndata) {
						$ndt=formatDateDBToWeb($ndata['nesting_date']);
						$nest=$ndata['nesting_name'];
						$nqty=$ndata['nested_quantity'];
						$alt.=$comma;
						$alt.="$ndt Nest: $nest Qty: $nqty";
						$comma="&#10;";
					}
				}
				print "<td align='center' title='$alt'>";
				$sql="select operation_name, coalesce(sum(r.quantity_good),0) as qty, sum(duration_hours) as hours, sum(duration_minutes) as minutes from jobs
				 left outer join routing on routing.parent_part=jobs.item_id 
				 left outer join operations on routing.operation_id=operations.operation_id 
				 left outer join production_results r on routing.routing_id=r.routing_id and jobs.job_id=r.job_id 
				 	where jobs.job_id=? and operation_name=? and r.notes <> 'SORT'
				 group by operation_name order by routing.display_sequence";
				list($ors,$err)=runIQuery($db,$sql,array("is",$job,$o));
				if (count($ors)) {
					$odata=$ors[0];
					$op=$odata['operation_name'];
					$qty=$odata['qty'];
					$color="red";
					if ($sch <= $qty) {
						$color="green";
					}
					$minutes=($odata['hours'] * 60) + $odata['minutes'];
					if ($op == 'Outside Process') {
						$sql="select distinct po_lines.*, item_name, vendor_name, transfer_lines.packing_slip from po_lines left outer join items on po_lines.item_id=items.item_id left outer join purchase_orders on po_lines.po_id=purchase_orders.po_id left outer join vendors on purchase_orders.vendor_id=vendors.vendor_id left outer join transfer_lines on po_lines.po_id=transfer_lines.po_number and item_name=part_number  where po_lines.job_id=? ";
						list($jrs,$err)=runIQuery($db,$sql,array("i",$job));
						if (count($jrs) > 0) {
							print "<table><tr><td>Vendor</td><td>PO</td><td>MT</td><td>Part</td><td>Qty</td><td>Received</td><td>Due</td></tr>";
						}
						foreach ($jrs as $jdata) {
							$po=$jdata['po_id'];
							$polist[]=$po;
							$v=$jdata['vendor_name'];
							$mt=$jdata['packing_slip'];
							$item=$jdata['item_name'];
							$q=$jdata['quantity'];
							$r=$jdata['quantity_received'];
							$exp=formatDateDBToWeb($jdata['date_expected']);
							print "<tr><td>$v</td><td>";
							print "<a href='editPO.php?id=$po' target='_blank'>$po</a></td><td>";
							print "<a href='editTransfer.php?id=$mt' target='_blank'>$mt</a></td><td>$item</td><td>$q</td><td>$r</td><td>$exp</td></tr>";
						}
						if (count($jrs) > 0) {
							print "</table>";
						}
					} else {
						if ($minutes > 0) {
							print "<span style='color: $color'>$minutes <a href='productionResults.php?job=$job' target='_blank' style='color: $color'>($qty)</a></span>";
						}
					}
					print "</td>";
				} else {
					$sql = "SELECT operation_name FROM operations 
					INNER JOIN routing ON routing.operation_id=operations.operation_id 
					INNER JOIN jobs ON jobs.item_id=routing.parent_part
					WHERE jobs.job_id=? AND operation_name=?";
					list($rs,$err)=runIQuery($db,$sql,array("is",$job,$o));
					if (!count($rs)) {
						print "N/A";
					}
				}
			}
			print "</tr>\n";
		}
	}
	## get any POs not in the list that are tied to the SO
}
