<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
header("Content-type: application/octet-stream");
header("Content-Disposition: attachment; filename=DematicAR.xls");
header("Pragma: no-cache");
header("Expires: 0");
$start=$_GET['start'];
$end=$_GET['end'];
$vendor=$_GET['vendor'];
$sql="select vendor_name from vendors where vendor_id=?";
list($rs,$err)=runIQuery($db,$sql,array("i",$vendor));
$data=$rs[0];
$vendorName=$data['vendor_name'];
print "Vendor On Time Delivery\t$vendorName\t$start\t$end\n";
$st=formatDateWebtoDB($start);
$et=formatDateWebtoDB($end);
$sql="select distinct o.po_id, coalesce(email_date, po_date) as date_sent, r.date_received, v.lead_time, l.date_expected from purchase_orders o left outer join email_log on document_number=po_id and email_type='PO' ";
$sql.=" inner join po_lines l on o.po_id=l.po_id left outer join receipt_lines rl on l.line_id=rl.line_id left outer join receipts r on rl.receipt_id=r.receipt_id ";
$sql.=" inner join vendors v on o.vendor_id=v.vendor_id  ";
$sql.=" WHERE  po_date >= ? and po_date <= ? ";
$sql.=" and o.vendor_id=? ";
list($rs,$err)=runIQuery($db,$sql,array("ssi",$st,$et,$vendor));
print "PO#\tDate Sent\tDate Received\tDate Due\tLead Time\tLate?\n";
$totc=0;
$totlate=0;
foreach ($rs as $data) {
    $totc++;
    $po=$data['po_id'];
    $dtsent=$data['date_sent'];
    $dtr=$data['date_received'];
    if (strstr($dtr," ")) {
        list($dtr,$time)=explode(" ",$dtr);
    }
    $lead=$data['lead_time'];
    $due=$data['date_expected'];
    $dtck=AddBusinessDays($dtsent,$lead);
    $late="";
    if ($dtr) {
        if ($dtck < $dtr) {
            if ($due < $dtr) {
                $late="YES";
                $totlate++;
            }
        }
    } else {
        if ($dtck < Date("Y-m-d")) {
            if ($due < Date("Y-m-d")) {
                $late="YES";
                $totlate++;
            }
        }
    }
    print "$po\t";
    print formatDateDBToWeb($dtsent);
    print "\t";
    print formatDateDBToWeb($dtr);
    print "\t";
    print formatDateDBToWeb($due);
    print "\t$lead\t$late\n";
}
if ($totc > 0) {
    $pct=$totlate/$totc * 100;
    $pct=round($pct,1);
    print "\t";
    print "Total POs: $totc, Total Late: $totlate, Pct: $pct%";
}
