<?php

include('dbConnection.php');

header("Content-type: application/octet-stream");

header("Content-Disposition: attachment; filename=$filename");

header("Pragma: no-cache");

header("Expires: 0");

include('functions.php');

$reportID=$_GET['report'];

$sql="select * from reports where report_id=?";

list($rs,$err)=runIQuery($db,$sql,array("i",$reportID));

$data=$rs[0];

$reportName=$data['report_name'];

$agentID=$data['agent_id'];

if ($agentID) {

	if ($agentID != $userID) {

		exit;

	}

}

$delimiter = "\t";



print "$reportName";

print $delimiter;

print $delimiter;

print Date("m/d/Y h:i") . "\n";

$filename=$reportName . "-Export.xls";



$filename=str_replace(" ","",$filename);




$table1=$data['table_name'];

$table2=$data['table_name2'];

$table3=$data['table_name3'];

$matchAll=$data['match_all'];

$sql="select * from report_fields where report_id=? order by display_sequence";

list($rs,$err)=runIQuery($db,$sql,array("i",$reportID));

$columnCount=0;

$reportSQL="select ";

$reportComma="";

$hasCustom=0;

foreach ($rs as $data) {

	$tableName=$data['table_name'];

	$fieldName=$data['field_name'];

	if ($tableName=='custom') {

		$sql="select table_name, field_calculation, title from custom_fields where field_name=?";

		list($frs,$ferr)=runIQuery($db,$sql,array("s",$fieldName));

		$fdata=$frs[0];

		$reportSQL.=$reportComma;

		$reportSQL.=$fdata['field_calculation'] . " as $fieldName";

		$reportComma=", ";

		$hasCustom=1;

	} else {

		$reportSQL.=$reportComma;

		$reportSQL.="$tableName.$fieldName";

		$reportComma=", ";

	}

}

$reportSQL.=" from $table1 ";

if ($table2)  {

	$sql="select * from table_relations where (table1=? and table2=?) or (table1=? and table2=?) ";

	list($rrs,$rerr)=runIQuery($db,$sql,array("ssss",$table1,$table2,$table2,$table1));

	$rdata=$rrs[0];

	if ($rdata['table1']==$table1) {

		$reportSQL.=" left outer join $table2 on $table1.";

		$reportSQL.=$rdata['field1']. " = $table2." . $rdata['field2'];

	} else {

		if ($rdata['table1']==$table2) {

			$reportSQL.=" left outer join $table2 on $table1.";

			$reportSQL.=$rdata['field2']. " = $table2." . $rdata['field1'];

		}

	}

}

if ($table3)  {

	$sql="select * from table_relations where (table1=? and table2=?) or (table1=? and table2=?) ";

	list($rrs,$rerr)=runIQuery($db,$sql,array("ssss",$table2,$table3,$table3,$table2));

	$rdata=$rrs[0];

	if ($rdata['table1']==$table2) {

		$reportSQL.=" left outer join $table3 on $table2.";

		$reportSQL.=$rdata['field1']. " = $table3." . $rdata['field2'];

	} else {

		if ($rdata['table1']==$table3) {

			$reportSQL.=" left outer join $table3 on $table2.";

			$reportSQL.=$rdata['field2']. " = $table3." . $rdata['field1'];

		}

	}

}



$sql="select report_conditions.*,  field_type from report_conditions, field_names where report_conditions.field_name=field_names.field_name and report_conditions.table_name=field_names.table_name  and report_id=? and report_conditions.table_name<>'custom'";

list($rs,$err)=runIQuery($db,$sql,array("i",$reportID));

$whereand="where ";

$glue=" and ";

if (! $matchAll) {

	$glue=" or ";

}

$having="";

foreach ($rs as $data) {

	$tableName=$data['table_name'];

	$fieldName=$data['field_name'];

	$fieldType=strtolower($data['field_type']);

	$op=$data['operation'];

	$cond=$data['condition'];

	if ($fieldType=="d" or $fieldType=="date") {

		$cond=formatDateWebtoDB($cond);

	}

	if ($tableName!='custom') {

		if ($whereand=="where ") {

			$reportSQL .= " where ";

			$whereand="";

		} else {

			$reportSQL .= $glue;

		}	

		$reportSQL.="$tableName.$fieldName ";

		$reportSQL.=renderOperation($op,$cond);

	}

}

if ($hasCustom) {

	## need to group by all the other fields

	$sql="select * from report_fields where report_id=? and table_name <> 'custom' order by display_sequence";

	list($rs,$err)=runIQuery($db,$sql,array("i",$reportID));

	$columnCount=0;

	$reportSQL.=" group by  ";

	$reportComma="";

	foreach ($rs as $data) {

		$tableName=$data['table_name'];

		$fieldName=$data['field_name'];

		$reportSQL.=$reportComma;

		$reportSQL.="$tableName.$fieldName";

		$reportComma=", ";

	}

	

	## if any custom fields used in criteria, generate the having clause	

	$sql="select * from report_conditions where  report_id=? and report_conditions.table_name='custom'";

	list($rs,$err)=runIQuery($db,$sql,array("i",$reportID));

	$whereand="having ";

	$glue=" and ";

	if (! $matchAll) {

		$glue=" or ";

	}

	foreach ($rs as $data) {

		$tableName=$data['table_name'];

		$fieldName=$data['field_name'];

		$fieldType=strtolower($data['field_type']);

		$op=$data['operation'];

		$cond=$data['condition'];

		if ($fieldType=="d" or $fieldType=="date") {

			$cond=formatDateWebtoDB($cond);

		}

		if ($whereand=="having ") {

			$reportSQL .= " having ";

			$whereand="";

		} else {

			$reportSQL .= $glue;

		}

		$sql="select field_calculation from custom_fields where field_name=?";

		list($crs,$cerr)=runIQuery($db,$sql,array("s",$fieldName));

		$cdata=$crs[0];

		$reportSQL.= $cdata[0] . " ";

		$reportSQL.=renderOperation($op,$cond);

	}

}

$sql="select * from report_fields where report_id=? order by display_sequence";

list($rs,$err)=runIQuery($db,$sql,array("i",$reportID));

$fieldResult=array();

$firstField=1;

foreach ($rs as $data) {

	$tableName=$data['table_name'];

	$fieldName=$data['field_name'];

	if ($tableName=='custom') {

		$sql="select field_calculation, title, field_name from custom_fields where field_name=?";

		list($frs,$ferr)=runIQuery($db,$sql,array("s",$fieldName));

		$fdata=$frs[0];

		$fdata['field_type']="N";

		$fdata['lookup_table']="";

		$fdata['table_name']='custom';

		$fieldResult[]=$fdata;

		if (! $firstField) {

			print $delimiter;

		}

		$firstField=0;

		print  $fdata['title'];

	} else {

		$sql="select * from field_names where table_name=? and field_name=?";

		list($frs,$ferr)=runIQuery($db,$sql,array("ss",$tableName,$fieldName));

		$fdata=$frs[0];

		$fieldResult[]=$fdata;

		if (! $firstField) {

			print $delimiter;

		}

		$firstField=0;

		print $fdata['title'];

	}

}

print "\n";

if ($_GET['debug']) {

	print "$reportSQL\n";

}

list($rs,$err)=runIQuery($db,$reportSQL);

foreach ($rs as $data) {

	reset($fieldResult);

	$firstField=1;

	foreach ($fieldResult as $fieldData) {

		$fieldName=$fieldData['field_name'];

		if ($fieldName  != "password") {

			if (! $firstField) {

				print $delimiter;				

			}

			$firstField=0;

			$fieldType=$fieldData['field_type'];

			$lookupTable=$fieldData['lookup_table'];

			$lookupField=$fieldData['lookup_field'];

			$returnField=$fieldData['return_field'];

			$allowZero=$fieldData['allow_zero'];		

			if ($fieldType=='text') {

				print stripslashes($data[$fieldName]);

			}

			if ($lookupTable!="") {

				$sql="select $returnField from $lookupTable where $lookupField='" . $data[$fieldName] . "' ";

				$lrs=mysqli_query($db,$sql);

				$ldata=mysqli_fetch_array($lrs);

				print $ldata[$returnField];

					

			} else {

				if ($fieldType=="D" or $fieldType=="date") {

					print formatDateDBToWeb($data[$fieldName]);

				}

				if ($fieldType=='B')

				{

					if ($data[$fieldName]) {

						print "YES";

					}

				}

				if ($fieldType=="N" or $fieldType=="C") {

					print $data[$fieldName];

				}

			}

		}

	}

	print "\n";

}

?>