<?php

include('dbConnection.php');

include('functions.php');

$table = cleanText($_GET['table']);

$seq = cleanText($_GET['seq']);

$filter=cleanText($_GET['filter']);

$searchText=cleanText($_GET['search']);

$singular = $table;

if(substr($singular, - 1) == "s")

{

	$singular = substr($singular,0,strlen($singular) - 1);

}

$sql = "select * from field_names where table_name=? and coalesce(key_field,0) = 0 order by display_sequence ";

list($fieldResult,$err) = runIQuery($db,$sql,array("s",$table));

if($filter)

{

	$sql = "select field_names.* from field_names,  filter_fields where table_name=? and filter_id=? and field_names.title=filter_fields.field_name order by filter_fields.display_sequence ";

	list($fieldResult,$err) = runIQuery($db,$sql,array("si",$table,$filter));

}



$delimiter = "\t";



$filename=$singular . "-Export.xls";



header("Content-type: application/octet-stream");

header("Content-Disposition: attachment; filename=$filename");

header("Pragma: no-cache");

header("Expires: 0");



if ($filter) {

	$sql="select filter_name from filters where filter_id=?";

	list($rs,$err)=runIQuery($db,$sql,array("i",$filter));

	$data=$rs[0];

	print $data[0];

	print "\n\n";

}



$col=0;



foreach($fieldResult as $data)

{

	$key=$data['title'];

	if ($col > 0) {

		print $delimiter;

	}

	print ucwords(strtolower($key));

	$col++;

}

print "\r\n";







$sql = "select * from $table where 1 > 0 ";

if($filter)

{

	$sql .= " and " . renderFilter($db,$filter);

}

if ($searchText) {

		$sql.=" and " . renderSearch($db,$searchText,$table);

}

if($seq)

{

	$sql .= " order by $seq";

}



list($rs,$err) = runIQuery($db,$sql);



foreach($rs as $data)

{

	reset($fieldResult);

	$col=0;

	foreach($fieldResult as $fieldData)

	{

		$fieldName = $fieldData['field_name'];

		if($fieldName != $key  and $fieldName != "password" and ! strstr($fieldName,"password"))

		{

			$fieldType   = $fieldData['field_type'];

			$lookupTable = $fieldData['lookup_table'];

			$lookupField = $fieldData['lookup_field'];

			$returnField = $fieldData['return_field'];

			$val=$data[$fieldName];

			if($lookupTable != "")

			{

				$sql   = "select $returnField from $lookupTable where $lookupField='" . $data[$fieldName] . "' ";

				$lrs   = mysqli_query($db,$sql);

				$ldata = mysqli_fetch_array($lrs);

				if(strstr($returnField," as "))

				{

					list($seq,$returnField) = explode(" as ",$returnField);

				}

				$val=$ldata[$returnField];

			}

			else

			{

				if($fieldType == "D" or $fieldType == "date")

				{

					$val=formatDateDBToWeb($data[$fieldName]);						$export .= formatDateDBToWeb($data[$fieldName]);

				}

				if($fieldType == 'B')

				{

					if($data[$fieldName])

					{

						$val="YES";

					} else {

						$val="NO";

					}

				}

			}

			$val=str_replace("\r","",$val);

			$val=str_replace("\n","",$val);

			$val=str_replace($delimiter,"",$val);

			if ($col > 0) {

				print $delimiter;

			}

			print $val;

			$col++;

		}

	}

	print "\r\n";

}

?>