<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
$filename="MaterialPricePercent1.xls";
header("Content-type: application/octet-stream");
header("Content-Disposition: attachment; filename=$filename");
header("Pragma: no-cache");
header("Expires: 0");

if (! $isAdmin) {
    exit;
}
function getMaterials($db,$part,$quantityPer) {
    global $machineDB;
    $price=0;
    $sql="select * from billofmaterial where parent_item=?";
    list($mrs,$err)=runIQuery($db,$sql,array("s",$part));
    foreach ($mrs as $mdata) {
        $child=$mdata['child_item'];
        $qper=$mdata['quantity_per'];
        $sql="select * from  items where item_name=?";
        list($crs,$err)=runIQuery($db,$sql,array("s",$child));
        $cdata=$crs[0];
        $cprice=$cdata['price'];
        $length=$cdata['length'];
        $width=$cdata['width'];
        if ($cdata['item_category']==24) {
            $price+=($cprice * $qper * $quantityPer);
        } else {
            if (strstr($child,"-PURCHASE" and ($length >= 120 or $width >= 120) )) {
                list($base,$purchase)=explode("-",$child);
                print "looking for $base<BR>";
                if (! in_array($base,$parts)) {
                    $sql="select mi.length, mi.width, mi.price from items i, materials m, items mi where i.item_name=? and i.material_id=m.material_id and m.material_name=mi.item_name ";
                    list($machiners,$err)=runIQuery($machineDB,$sql,array("s",$base));
                    if (count($machiners)) {
                        $machinedata=$machiners[0];
                        $mlength=$machinedata['length'];
                        $mwidth=$machinedata['width'];
                        $mprice=$machinedata['price'];
                        $marea=$mlength * $mwdith;
                        if ($marea > 0) {
                            $area=$length * $width;
                            $price+= ($area / $marea) * $mprice;
                        }
                        $parts[]=$base;
                        $lengths[$base]=$mlength;
                        $widths[$base]=$mwidth;
                        $prices[$base]=$mprice;
                    }   
                } else {
                    $mlength=$lengths[$base];
                    $mwidth=$widths[$base];
                    $mprice=$prices[$base];
                    $marea=$mlength * $mwdith;
                    if ($marea > 0) {
                        $area=$length * $width;
                        $price+= ($area / $marea) * $mprice;
                    }
                }
            } else {
                $price+=getMaterials($db,$child,$qper*$quantityPer);
            }
        }
    }
    return $price;
}

print "Material Price Percent " . Date("m/d/Y");
print "\n";
print "Finished Good\tPrice\tMaterial Price\tPercentage\n";
## get all finished goods for dematic.   Then get the sum of all sheet  stock in the BOM (category 24)
$sql="select * from items where customer_id=693 and item_category = 20 order by item_name";
list($rs,$err)=runIQuery($db,$sql);
foreach ($rs as $data) {
    $fg=$data['item_name'];
    $fgPrice=$data['price'];
    print "$fg\t$fgPrice\t";
    if ($fgPrice > 0) {
        $materialPrice=getMaterials($db,$fg,1);
        $pct=round($materialPrice/$fgPrice*100,1);
        print "$materialPrice\t$pct";
    }
    print "\n";
}
