<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
header("Content-type: application/octet-stream");
header("Content-Disposition: attachment; filename=WIPInventory.xls");
header("Pragma: no-cache");
header("Expires: 0");
print "Part\tCost\tQuantity On Hand\tValue\n";
list($rs,$err)=runIQuery($db,$sql);
$sql="select item_name, item_category, cost, wip_cost, quantity_on_hand from items where item_category in (14,17, 18, 19, 21, 24) and vendor_id=0 and item_name in (select child_item from billofmaterial) ";
$sql.=" order by wip_cost * quantity_on_hand, item_name ";
list($rs,$err)=runIQuery($db,$sql);
$totalInventory=0;
foreach ($rs as $data) {
    $item=$data['item_name'];
    $cost=$data['cost'];
    $wipcost=$data['wip_cost'];
    $category=$data['item_category'];
    if ($wipcost == 0 ) {
        ## need to calculate the cost
        if (in_array($category, array(14, 17, 24))) {
            $wipcost=$cost;
            $sql="update items set wip_cost=? where item_name=?";
            list($updrs,$err)=runIQuery($db,$sql,array("ds",$wipcost,$item));
        } else {
            $wipcost=calculateCost($db,$item);
            $sql="update items set wip_cost=? where item_name=?";
            list($updrs,$err)=runIQuery($db,$sql,array("ds",$wipcost,$item));
        }
    }
    $qty=$data['quantity_on_hand'];
    if ($qty < 0) {
        $qty=0;
    }
    if ($qty > 0) {
        $ext=$wipcost*$qty;
        $totalInventory+=$ext;
        print "$item\t$wipcost\t$qty\t$ext\n";
    }
}
print "\t\t\t$totalInventory\n";
